// Copyright Bill Tracey 2005 
// 
using System;
using System.Windows.Forms; 

namespace PowerSDR
{
	/// <summary>
	/// Summary description for TypematicButton.
	/// </summary>
	public class TypematicButton : ButtonTS
	{

		public  int repeatInterval // repeat interval in msecs 
		{
			set 
			{
				repeat_interval = value; 
				if ( repeatTimer != null ) 
				{
					repeatTimer.Interval = repeat_interval; 
				}
			}
			get 
			{
				return repeat_interval; 
			}
		}

		private int repeat_interval = 250; 

		private System.Windows.Forms.Timer repeatTimer = null; 


		private void TimerEventProcessor(Object o, EventArgs e) 
		{ 
			base.PerformClick(); 
			repeatTimer.Enabled = true; 
		}
		
		protected override void OnMouseDown(MouseEventArgs e)
		{
			base.OnMouseDown(e); 
			base.PerformClick(); 
			repeatTimer = new System.Windows.Forms.Timer(); 
			repeatTimer.Interval = repeat_interval; 
			repeatTimer.Tick += new EventHandler(TimerEventProcessor); 
			repeatTimer.Start() ;
		}
		
		protected override void OnMouseUp(MouseEventArgs e)
		{			
			base.OnMouseUp( e );
			if ( repeatTimer != null ) 
			{ 
				repeatTimer.Stop();
				repeatTimer = null; 
			}			
		}		
	}
}
