//=================================================================
// setup.cs
//=================================================================
// PowerSDR is a C# implementation of a Software Defined Radio.
// Copyright (C) 2004, 2005  FlexRadio Systems
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// You may contact us via email at: sales@flex-radio.com.
// Paper mail may be sent to: 
//    FlexRadio Systems, 8900 Marybank Dr., Austin, TX  78750, USA.
//=================================================================

using System;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.ComponentModel;
using System.Threading;
using System.Windows.Forms;
using SDRSerialSupport; 

namespace PowerSDR
{
	public class Setup : System.Windows.Forms.Form
	{
		#region Variable Declaration
		
		private Console console;
		private Progress progress;
		private ArrayList KeyList;
		private int sound_card;
		private bool initializing;
		private System.Windows.Forms.TabPage tpDSP;
		private System.Windows.Forms.TabPage tpDisplay;
		private System.Windows.Forms.NumericUpDownTS udDisplayGridStep;
		private System.Windows.Forms.NumericUpDownTS udDisplayGridMin;
		private System.Windows.Forms.NumericUpDownTS udDisplayGridMax;
		private System.Windows.Forms.LabelTS lblDisplayGridStep;
		private System.Windows.Forms.LabelTS lblDisplayGridMin;
		private System.Windows.Forms.LabelTS lblDisplayGridMax;
		private System.Windows.Forms.TabPage tpGeneral;
		private System.Windows.Forms.ComboBoxTS comboGeneralLPTAddr;
		private System.Windows.Forms.GroupBoxTS grpDisplaySpectrumGrid;
		private System.Windows.Forms.ButtonTS btnOK;
		private System.Windows.Forms.ButtonTS btnCancel;
		private System.Windows.Forms.ButtonTS btnApply;
		private System.Windows.Forms.CheckBoxTS chkGeneralRFEPresent;
		public System.Windows.Forms.CheckBoxTS chkGeneralSpurRed;
		private System.Windows.Forms.GroupBoxTS grpGeneralHardwareSetup;
		private System.Windows.Forms.LabelTS lblGeneralLPTAddr;
		private System.Windows.Forms.NumericUpDownTS udGeneralLPTDelay;
		private System.Windows.Forms.LabelTS lblGeneralLPTDelay;
		public System.Windows.Forms.TabControl tcSetup;
		private System.Windows.Forms.TabPage tpKeyboard;
		private System.Windows.Forms.LabelTS lblKBTuneDown;
		private System.Windows.Forms.LabelTS lblKBTuneUp;
		private System.Windows.Forms.ComboBoxTS comboKBTuneDown1;
		private System.Windows.Forms.ComboBoxTS comboKBTuneDown3;
		private System.Windows.Forms.ComboBoxTS comboKBTuneDown2;
		private System.Windows.Forms.ComboBoxTS comboKBTuneUp1;
		private System.Windows.Forms.ComboBoxTS comboKBTuneUp2;
		private System.Windows.Forms.ComboBoxTS comboKBTuneUp3;
		private System.Windows.Forms.ComboBoxTS comboKBTuneUp4;
		private System.Windows.Forms.ComboBoxTS comboKBTuneDown4;
		private System.Windows.Forms.ComboBoxTS comboKBTuneUp5;
		private System.Windows.Forms.ComboBoxTS comboKBTuneDown5;
		private System.Windows.Forms.ComboBoxTS comboKBTuneDown6;
		private System.Windows.Forms.ComboBoxTS comboKBTuneUp7;
		private System.Windows.Forms.ComboBoxTS comboKBTuneDown7;
		private System.Windows.Forms.ComboBoxTS comboKBTuneUp6;
		private System.Windows.Forms.GroupBoxTS grpKBTune;
		private System.Windows.Forms.LabelTS lblKBTuneDigit;
		private System.Windows.Forms.LabelTS lblKBTune7;
		private System.Windows.Forms.LabelTS lblKBTune6;
		private System.Windows.Forms.LabelTS lblKBTune5;
		private System.Windows.Forms.LabelTS lblKBTune4;
		private System.Windows.Forms.LabelTS lblKBTune3;
		private System.Windows.Forms.LabelTS lblKBTune2;
		private System.Windows.Forms.LabelTS lblKBTune1;
		private System.Windows.Forms.GroupBoxTS grpKBBand;
		private System.Windows.Forms.LabelTS lblKBBandUp;
		private System.Windows.Forms.LabelTS lblKBBandDown;
		private System.Windows.Forms.GroupBoxTS grpKBFilter;
		private System.Windows.Forms.LabelTS lblKBFilterUp;
		private System.Windows.Forms.LabelTS lblKBFilterDown;
		private System.Windows.Forms.GroupBoxTS grpKBMode;
		private System.Windows.Forms.LabelTS lblKBModeUp;
		private System.Windows.Forms.LabelTS lblKBModeDown;
		private System.Windows.Forms.ComboBoxTS comboKBBandUp;
		private System.Windows.Forms.ComboBoxTS comboKBBandDown;
		private System.Windows.Forms.ComboBoxTS comboKBFilterUp;
		private System.Windows.Forms.ComboBoxTS comboKBFilterDown;
		private System.Windows.Forms.ComboBoxTS comboKBModeUp;
		private System.Windows.Forms.ComboBoxTS comboKBModeDown;
		private System.Windows.Forms.LabelTS lblDisplayFPS;
		private System.Windows.Forms.NumericUpDownTS udDisplayFPS;
		private System.Windows.Forms.NumericUpDownTS udLMSANFtaps;
		private System.Windows.Forms.NumericUpDownTS udLMSANFdelay;
		private System.Windows.Forms.LabelTS lblLMSNRtaps;
		private System.Windows.Forms.LabelTS lblLMSANFdelay;
		private System.Windows.Forms.LabelTS lblLMSANFTaps;
		private System.Windows.Forms.NumericUpDownTS udLMSNRtaps;
		private System.Windows.Forms.LabelTS lblLMSNRdelay;
		private System.Windows.Forms.NumericUpDownTS udLMSNRdelay;
		private System.Windows.Forms.NumericUpDownTS udLMSANFgain;
		private System.Windows.Forms.NumericUpDownTS udLMSNRgain;
		private System.Windows.Forms.LabelTS lblLMSANFgain;
		private System.Windows.Forms.LabelTS lblLMSNRgain;
		private System.Windows.Forms.CheckBoxTS chkGeneralXVTRPresent;
		private System.Windows.Forms.GroupBoxTS grpGeneralDDS;
		private System.Windows.Forms.LabelTS lblPLLMult;
		private System.Windows.Forms.NumericUpDownTS udDDSPLLMult;
		private System.Windows.Forms.LabelTS lblIFFrequency;
		private System.Windows.Forms.NumericUpDownTS udDDSIFFreq;
		private System.Windows.Forms.LabelTS lblClockCorrection;
		private System.Windows.Forms.NumericUpDownTS udDDSCorrection;
		private System.Windows.Forms.ComboBoxTS comboDSPWindow;
		private System.Windows.Forms.GroupBoxTS grpAudioSampleRate;
		public System.Windows.Forms.TabPage tpAudio;
		private System.Windows.Forms.TabPage tpTransmit;
		private System.Windows.Forms.NumericUpDownTS udTXFilterHigh;
		private System.Windows.Forms.LabelTS lblTXFilterLow;
		private System.Windows.Forms.LabelTS lblTXFilterHigh;
		private System.Windows.Forms.NumericUpDownTS udTXFilterLow;
		private System.Windows.Forms.GroupBoxTS grpTXEqualizer;
		private System.Windows.Forms.GroupBoxTS grpTXFilter;
		private System.Windows.Forms.GroupBoxTS grpTXCompression;
		private System.Windows.Forms.GroupBoxTS grpDisplayPhase;
		private System.Windows.Forms.NumericUpDownTS udDisplayPhasePts;
		private System.Windows.Forms.GroupBoxTS grpDisplayAverage;
		private System.Windows.Forms.GroupBoxTS grpAudioBufferSize;
		private System.Windows.Forms.LabelTS lblDisplayPhasePts;
		private System.Windows.Forms.LabelTS lblTransmitFeedForward;
		private System.Windows.Forms.GroupBoxTS grpGeneralCalibration;
		private System.Windows.Forms.LabelTS lblGeneralCalFrequency;
		private System.Windows.Forms.LabelTS lblGeneralCalLevel;
		private System.Windows.Forms.NumericUpDownTS udGeneralCalLevel;
		private System.Windows.Forms.NumericUpDownTS udGeneralCalFreq;
		private System.Windows.Forms.GroupBoxTS grpDisplayRefreshRates;
		private System.Windows.Forms.LabelTS lblDisplayMeterDelay;
		private System.Windows.Forms.NumericUpDownTS udDisplayMeterDelay;
		private System.Windows.Forms.TabPage tpAppearance;
		private System.Windows.Forms.LabelTS lblDisplayFilterColor;
		private System.Windows.Forms.LabelTS lblDisplayLineWidth;
		private System.Windows.Forms.NumericUpDownTS udDisplayLineWidth;
		private System.Windows.Forms.LabelTS lblDisplayDataLineColor;
		private System.Windows.Forms.LabelTS lblDisplayTextColor;
		private System.Windows.Forms.LabelTS lblDisplayZeroLineColor;
		private System.Windows.Forms.LabelTS lblDisplayGridColor;
		private System.Windows.Forms.LabelTS lblDisplayBackgroundColor;
		private System.Windows.Forms.GroupBoxTS grpAppearanceDisplay;
		private System.Windows.Forms.GroupBoxTS grpAppearanceMeter;
		private System.Windows.Forms.LabelTS lblAppearanceMeterRight;
		private System.Windows.Forms.LabelTS lblAppearanceMeterLeft;
		private System.Windows.Forms.GroupBoxTS grpAppearanceGeneral;
		private System.Windows.Forms.LabelTS lblAppearanceGenBtnSel;
		private System.Windows.Forms.GroupBoxTS grpGeneralOptions;
		private System.Windows.Forms.CheckBoxTS chkGeneralDisablePTT;
		private System.Windows.Forms.LabelTS lblDisplayPeakText;
		private System.Windows.Forms.NumericUpDownTS udDisplayPeakText;
		private System.Windows.Forms.NumericUpDownTS udDisplayCPUMeter;
		private System.Windows.Forms.LabelTS lblDisplayCPUMeter;
		private System.Windows.Forms.TrackBarTS tbTXFFCompression;
		private System.Windows.Forms.NumericUpDownTS udTXFFCompression;
		private System.Windows.Forms.GroupBoxTS grpDSPNB;
		private System.Windows.Forms.NumericUpDownTS udDSPNB;
		private System.Windows.Forms.ComboBoxTS comboGeneralXVTR;
		private System.Windows.Forms.GroupBoxTS grpDisplayWaterfall;
		private System.Windows.Forms.NumericUpDownTS udDisplayWaterfallHighLevel;
		private System.Windows.Forms.LabelTS lblDisplayWaterfallHighLevel;
		private System.Windows.Forms.LabelTS lblDisplayWaterfallLowLevel;
		private System.Windows.Forms.NumericUpDownTS udDisplayWaterfallLowLevel;
		private System.Windows.Forms.LabelTS lblDisplayWaterfallLowColor;
		private System.Windows.Forms.LabelTS lblDisplayWaterfallHighColor;
		private System.Windows.Forms.LabelTS lblDisplayWaterfallMidColor;
		private System.Windows.Forms.CheckBoxTS chkGeneralPAPresent;
		private System.Windows.Forms.ButtonTS btnGeneralCalLevelStart;
		private System.Windows.Forms.ButtonTS btnGeneralCalFreqStart;
		private System.Windows.Forms.ButtonTS btnGeneralCalImageStart;
		private System.Windows.Forms.CheckBoxTS chkGeneralSoftwareGainCorr;
		private System.Windows.Forms.LabelTS lblVFODark;
		private System.Windows.Forms.LabelTS lblVFOLight;
		private System.Windows.Forms.LabelTS lblBandLight;
		private System.Windows.Forms.LabelTS lblBandDark;
		private System.Windows.Forms.LabelTS lblPeakText;
		private System.Windows.Forms.ButtonTS btnWizard;
		private System.Windows.Forms.ButtonTS btnImportDB;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.TrackBarTS tbTXEQ3000;
		private System.Windows.Forms.TrackBarTS tbTXEQ2600;
		private System.Windows.Forms.TrackBarTS tbTXEQ2300;
		private System.Windows.Forms.TrackBarTS tbTXEQ2000;
		private System.Windows.Forms.TrackBarTS tbTXEQ1600;
		private System.Windows.Forms.TrackBarTS tbTXEQ1300;
		private System.Windows.Forms.TrackBarTS tbTXEQ1000;
		private System.Windows.Forms.TrackBarTS tbTXEQ600;
		private System.Windows.Forms.TrackBarTS tbTXEQ300;
		private System.Windows.Forms.LabelTS lblEQminus15db;
		private System.Windows.Forms.LabelTS lblEQ0dB;
		private System.Windows.Forms.LabelTS lblEQ15db;
		private System.Windows.Forms.GroupBoxTS grpAudioCard;
		private System.Windows.Forms.ComboBoxTS comboAudioSoundCard;
		private System.Windows.Forms.TabPage tpTests;
		private System.Windows.Forms.ButtonTS btnTXEQReset;
		private System.Windows.Forms.CheckBoxTS chkTXEQEnabled;
		private System.Windows.Forms.LabelTS lblPAGainByBand160;
		private System.Windows.Forms.LabelTS lblPAGainByBand80;
		private System.Windows.Forms.LabelTS lblPAGainByBand60;
		private System.Windows.Forms.LabelTS lblPAGainByBand40;
		private System.Windows.Forms.LabelTS lblPAGainByBand30;
		private System.Windows.Forms.LabelTS lblPAGainByBand10;
		private System.Windows.Forms.LabelTS lblPAGainByBand12;
		private System.Windows.Forms.LabelTS lblPAGainByBand15;
		private System.Windows.Forms.LabelTS lblPAGainByBand17;
		private System.Windows.Forms.LabelTS lblPAGainByBand20;
		private System.Windows.Forms.TabPage tpPowerAmplifier;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.NumericUpDownTS udPAGain10;
		private System.Windows.Forms.NumericUpDownTS udPAGain12;
		private System.Windows.Forms.NumericUpDownTS udPAGain15;
		private System.Windows.Forms.NumericUpDownTS udPAGain17;
		private System.Windows.Forms.NumericUpDownTS udPAGain20;
		private System.Windows.Forms.NumericUpDownTS udPAGain30;
		private System.Windows.Forms.NumericUpDownTS udPAGain40;
		private System.Windows.Forms.NumericUpDownTS udPAGain60;
		private System.Windows.Forms.NumericUpDownTS udPAGain80;
		private System.Windows.Forms.NumericUpDownTS udPAGain160;
		private System.Windows.Forms.GroupBoxTS grpPAGainByBand;
		private System.Windows.Forms.ButtonTS btnPAGainCalibration;
		private System.Windows.Forms.CheckBoxTS chkGeneralEnableX2;
		private System.Windows.Forms.LabelTS lblGeneralX2Delay;
		private System.Windows.Forms.NumericUpDownTS udGeneralX2Delay;
		private System.Windows.Forms.GroupBoxTS grpPABandOffset;
		private System.Windows.Forms.LabelTS lblPABandOffset30;
		private System.Windows.Forms.LabelTS lblPABandOffset40;
		private System.Windows.Forms.LabelTS lblPABandOffset60;
		private System.Windows.Forms.LabelTS lblPABandOffset80;
		private System.Windows.Forms.LabelTS lblPABandOffset160;
		private System.Windows.Forms.LabelTS lblPABandOffset10;
		private System.Windows.Forms.LabelTS lblPABandOffset12;
		private System.Windows.Forms.LabelTS lblPABandOffset15;
		private System.Windows.Forms.LabelTS lblPABandOffset17;
		private System.Windows.Forms.LabelTS lblPABandOffset20;
		private System.Windows.Forms.CheckBoxTS chkTestIMD;
		private System.Windows.Forms.CheckBoxTS chkGeneralATUPresent;
		private System.Windows.Forms.ButtonTS btnPAGainReset;
		private System.Windows.Forms.ComboBoxTS comboGeneralProcessPriority;
		private System.Windows.Forms.GroupBoxTS grpGeneralProcessPriority;
		private System.Windows.Forms.GroupBoxTS grpDSPWindow;
		private System.Windows.Forms.GroupBoxTS grpTestTXIMD;
		private System.Windows.Forms.LabelTS lblGeneralImageNull;
		private System.Windows.Forms.LabelTS lblTXFFVal;
		private System.Windows.Forms.LabelTS lblTXEQ2000;
		private System.Windows.Forms.LabelTS lblTXEQ2300;
		private System.Windows.Forms.LabelTS lblTXEQ2600;
		private System.Windows.Forms.LabelTS lblTXEQ3000;
		private System.Windows.Forms.LabelTS lblTXEQ1600;
		private System.Windows.Forms.LabelTS lblTXEQ1300;
		private System.Windows.Forms.LabelTS lblTXEQ1000;
		private System.Windows.Forms.LabelTS lblTXEQ600;
		private System.Windows.Forms.LabelTS lblTXEQ300;
		private ColorButton clrbtnBtnSel;
		private ColorButton clrbtnVFODark;
		private ColorButton clrbtnVFOLight;
		private ColorButton clrbtnBandDark;
		private ColorButton clrbtnBandLight;
		private ColorButton clrbtnPeakText;
		private ColorButton clrbtnBackground;
		private ColorButton clrbtnGrid;
		private ColorButton clrbtnZeroLine;
		private ColorButton clrbtnFilter;
		private ColorButton clrbtnText;
		private ColorButton clrbtnDataLine;
		private ColorButton clrbtnMeterLeft;
		private ColorButton clrbtnMeterRight;
		private ColorButton clrbtnWaterfallLow;
		private ColorButton clrbtnWaterfallHigh;
		private ColorButton clrbtnWaterfallMid;
		private System.Windows.Forms.LabelTS lblTestIMDPower;
		private System.Windows.Forms.NumericUpDownTS udTestIMDPower;
		private System.Windows.Forms.ButtonTS btnResetAll;
		private System.Windows.Forms.CheckBoxTS chkGeneralCustomFilter;
		private System.Windows.Forms.LabelTS lblAudioMixer2;
		private System.Windows.Forms.ComboBoxTS comboAudioMixer2;
		public System.Windows.Forms.CheckBoxTS chkAudioEnableSoundCard2;
		private System.Windows.Forms.ComboBoxTS comboAudioTransmit1;
		private System.Windows.Forms.ComboBoxTS comboAudioOutput1;
		private System.Windows.Forms.ComboBoxTS comboAudioInput1;
		private System.Windows.Forms.ComboBoxTS comboAudioDriver1;
		private System.Windows.Forms.ComboBoxTS comboAudioMixer1;
		private System.Windows.Forms.ComboBoxTS comboAudioReceive1;
		private System.Windows.Forms.ComboBoxTS comboAudioTransmit2;
		private System.Windows.Forms.ComboBoxTS comboAudioOutput2;
		private System.Windows.Forms.ComboBoxTS comboAudioInput2;
		private System.Windows.Forms.ComboBoxTS comboAudioDriver2;
		private System.Windows.Forms.ComboBoxTS comboAudioReceive2;
		private System.Windows.Forms.ComboBoxTS comboAudioBuffer1;
		private System.Windows.Forms.ComboBoxTS comboAudioBuffer2;
		private System.Windows.Forms.ComboBoxTS comboAudioSampleRate2;
		private System.Windows.Forms.ComboBoxTS comboAudioSampleRate1;
		private System.Windows.Forms.NumericUpDownTS udDSPMNB;
		private System.Windows.Forms.NumericUpDownTS udTestIMDFreq1;
		private System.Windows.Forms.NumericUpDownTS udTestIMDFreq2;
		private System.Windows.Forms.ButtonTS btnTestAudioBalStart;
		private System.Windows.Forms.CheckBoxTS chkTestX2Pin1;
		private System.Windows.Forms.CheckBoxTS chkTestX2Pin2;
		private System.Windows.Forms.CheckBoxTS chkTestX2Pin3;
		private System.Windows.Forms.CheckBoxTS chkTestX2Pin4;
		private System.Windows.Forms.CheckBoxTS chkTestX2Pin5;
		private System.Windows.Forms.CheckBoxTS chkTestX2Pin6;
		private System.Windows.Forms.NumericUpDownTS udDisplayAVGTime;
		private System.Windows.Forms.LabelTS lblDisplayAVGTime;
		private System.Windows.Forms.TrackBarTS tbTXEQ160;
		private System.Windows.Forms.TrackBarTS tbTXEQ80;
		private System.Windows.Forms.LabelTS lblTXEQ160;
		private System.Windows.Forms.LabelTS lblTXEQ80;
		private System.Windows.Forms.LabelTS lblTXEQ3500;
		private System.Windows.Forms.TrackBarTS tbTXEQ3500;
		private System.Windows.Forms.NumericUpDownTS udAudioLatency1;
		private System.Windows.Forms.NumericUpDownTS udAudioLatency2;
		private System.Windows.Forms.GroupBoxTS grpAudioDetails2;
		public System.Windows.Forms.GroupBoxTS grpAudioDetails1;
		private System.Windows.Forms.ComboBoxTS comboAudioDetailSel;
		private System.Windows.Forms.GroupBoxTS grpAudioLatency;
		private System.Windows.Forms.GroupBoxTS grpTestX2;
		private System.Windows.Forms.GroupBoxTS grpTestAudioBalance;
		private System.Windows.Forms.ButtonTS btnAudioVoltTest1;
		private System.Windows.Forms.NumericUpDownTS udAudioVoltage1;
		private System.Windows.Forms.LabelTS lblAudioVoltage1;
		private System.Windows.Forms.ButtonTS btnAudioVoltTest2;
		private System.Windows.Forms.NumericUpDownTS udAudioVoltage2;
		private System.Windows.Forms.LabelTS lblAudioVoltage2;
		private System.Windows.Forms.GroupBoxTS grpAudioVoltage;
		private System.Windows.Forms.NumericUpDownTS udPAADC17;
		private System.Windows.Forms.NumericUpDownTS udPAADC15;
		private System.Windows.Forms.NumericUpDownTS udPAADC20;
		private System.Windows.Forms.NumericUpDownTS udPAADC12;
		private System.Windows.Forms.NumericUpDownTS udPAADC10;
		private System.Windows.Forms.NumericUpDownTS udPAADC160;
		private System.Windows.Forms.NumericUpDownTS udPAADC80;
		private System.Windows.Forms.NumericUpDownTS udPAADC60;
		private System.Windows.Forms.NumericUpDownTS udPAADC40;
		private System.Windows.Forms.NumericUpDownTS udPAADC30;
		private System.Windows.Forms.CheckBoxTS chkAudioLatencyManual;
		private System.Windows.Forms.CheckBoxTS chkGeneralUSBPresent;
		private System.Windows.Forms.GroupBoxTS grpPATune;
		private System.Windows.Forms.LabelTS lblTransmitTunePower;
		private System.Windows.Forms.NumericUpDownTS udTXTunePower;
		private System.Windows.Forms.LabelTS lblPACalPower;
		private System.Windows.Forms.NumericUpDownTS udPACalPower;
		private System.Windows.Forms.GroupBoxTS grpDisplayMultimeter;
		private System.Windows.Forms.LabelTS lblDisplayMultiPeakHoldTime;
		private System.Windows.Forms.NumericUpDownTS udDisplayMultiPeakHoldTime;
		private System.Windows.Forms.NumericUpDownTS udDisplayMultiTextHoldTime;
		private System.Windows.Forms.LabelTS lblDisplayMeterTextHoldTime;
		private System.Windows.Forms.GroupBoxTS grpGeneralUpdates;
		private System.Windows.Forms.CheckBoxTS chkGeneralUpdateRelease;
		private System.Windows.Forms.CheckBoxTS chkGeneralUpdateBeta;
		private System.Windows.Forms.NumericUpDownTS udTXPreGain;
		private System.Windows.Forms.LabelTS lblAudioLatency2;
		private System.Windows.Forms.LabelTS lblAudioLatency1;
		private System.Windows.Forms.LabelTS lblAudioBuffer2;
		private System.Windows.Forms.LabelTS lblAudioBuffer1;
		private System.Windows.Forms.LabelTS lblAudioSample2;
		private System.Windows.Forms.LabelTS lblAudioSample1;
		private System.Windows.Forms.NumericUpDownTS udAudioLineIn1;
		private System.Windows.Forms.LabelTS lblAudioLineIn1;
		private System.Windows.Forms.LabelTS lblAudioLineIn2;
		private System.Windows.Forms.NumericUpDownTS udAudioLineIn2;
		private System.Windows.Forms.NumericUpDownTS udDSPCWPitch;
		private System.Windows.Forms.CheckBoxTS chkGeneralRXOnly;
		private System.Windows.Forms.LabelTS lblDSPAGCMaxGain;
		private System.Windows.Forms.NumericUpDownTS udDSPAGCMaxGaindB;
		private System.Windows.Forms.NumericUpDownTS udDSPAGCFixedGaindB;
		private System.Windows.Forms.LabelTS lblDSPAGCFixed;
		private System.Windows.Forms.GroupBoxTS grpDSPAGC;
		private System.Windows.Forms.GroupBoxTS grpTXMicPreamp;
		private System.Windows.Forms.GroupBoxTS grpDSPNB2;
		private System.Windows.Forms.LabelTS lblDSPCWPitchFreq;
		private System.Windows.Forms.LabelTS lblDSPNBThreshold;
		private System.Windows.Forms.LabelTS lblDSPNB2Threshold;
		private System.Windows.Forms.ComboBoxTS comboImageReject;
		private System.Windows.Forms.GroupBoxTS grpDSPImageRejectRX;
		private System.Windows.Forms.GroupBoxTS grpDSPImageRejectTX;
		private System.Windows.Forms.GroupBoxTS grpAudioLineInGain;
		private System.Windows.Forms.GroupBoxTS grpDSPCWPitch;
		private System.Windows.Forms.GroupBoxTS grpDSPLMSNR;
		private System.Windows.Forms.GroupBoxTS grpDSPLMSANF;
		private System.Windows.Forms.LabelTS lblDSPGainValRX;
		private System.Windows.Forms.NumericUpDownTS udDSPImageGainRX;
		private System.Windows.Forms.NumericUpDownTS udDSPImagePhaseRX;
		private System.Windows.Forms.LabelTS lblDSPImageGainRX;
		private System.Windows.Forms.TrackBarTS tbDSPImagePhaseRX;
		private System.Windows.Forms.LabelTS lblDSPImagePhaseRX;
		private System.Windows.Forms.TrackBarTS tbDSPImageGainRX;
		private System.Windows.Forms.LabelTS lblDSPGainValTX;
		private System.Windows.Forms.LabelTS lblDSPImagePhaseTX;
		private System.Windows.Forms.LabelTS lblDSPPhaseValRX;
		private System.Windows.Forms.LabelTS lblDSPPhaseValTX;
		private System.Windows.Forms.NumericUpDownTS udDSPImageGainTX;
		private System.Windows.Forms.NumericUpDownTS udDSPImagePhaseTX;
		private System.Windows.Forms.LabelTS lblDSPImageGainTX;
		private System.Windows.Forms.TrackBarTS tbDSPImagePhaseTX;
		private System.Windows.Forms.TrackBarTS tbDSPImageGainTX;
		private System.Windows.Forms.LabelTS lblAudioMixer1;
		public System.Windows.Forms.LabelTS lblAudioOutput1;
		public System.Windows.Forms.LabelTS lblAudioInput1;
		public System.Windows.Forms.LabelTS lblAudioDriver1;
		private System.Windows.Forms.LabelTS lblAudioTransmit1;
		private System.Windows.Forms.LabelTS lblAudioReceive1;
		private System.Windows.Forms.LabelTS lblAudioShowDetails;
		public System.Windows.Forms.LabelTS lblAudioOutput2;
		public System.Windows.Forms.LabelTS lblAudioInput2;
		public System.Windows.Forms.LabelTS lblAudioDriver2;
		private System.Windows.Forms.LabelTS lblAudioTransmit2;
		private System.Windows.Forms.LabelTS lblAudioReceive2;
		private System.Windows.Forms.LabelTS lblTXMicPreampGain;
		private System.Windows.Forms.LabelTS lblTestX2;
		private System.Windows.Forms.LabelTS lblTestToneFreq2;
		private System.Windows.Forms.LabelTS lblTestToneFreq1;
		private System.Windows.Forms.ButtonTS btnAudioCalSecondSoundCard;
		private System.Windows.Forms.TabPage tpCAT;
		private System.Windows.Forms.GroupBoxTS grpPTTBitBang;
		private System.Windows.Forms.LabelTS lblCATPTTPort;
		private System.Windows.Forms.NumericUpDownTS udCATBitBangPTTPort;
		private System.Windows.Forms.CheckBoxTS chkCATPTT_RTS;
		private System.Windows.Forms.CheckBoxTS chkCATPTT_DTR;
		private System.Windows.Forms.CheckBoxTS chkCATBitBangPTT;
		private System.Windows.Forms.GroupBoxTS grpCatControlBox;
		private System.Windows.Forms.ComboBoxTS comboCATbaud;
		private System.Windows.Forms.Label lblCATBaud;
		private System.Windows.Forms.LabelTS lblCATComPort;
		private System.Windows.Forms.NumericUpDownTS udCATPort;
		private System.Windows.Forms.CheckBoxTS chkCATEnable;
		private System.Windows.Forms.Label lblCATParity;
		private System.Windows.Forms.Label lblCATData;
		private System.Windows.Forms.Label lblCATStop;
		private System.Windows.Forms.ComboBoxTS comboCATparity;
		private System.Windows.Forms.ComboBoxTS comboCATdatabits;
		private System.Windows.Forms.ComboBoxTS comboCATstopbits;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ComboBoxTS comboDisplaydBAlign;
		private System.Windows.Forms.CheckBoxTS chkCATMixWVirtual;
		private System.Windows.Forms.GroupBoxTS grpKBCW;
		private System.Windows.Forms.LabelTS lblKBCWDot;
		private System.Windows.Forms.LabelTS lblKBCWDash;
		private System.Windows.Forms.ComboBoxTS comboKBCWDot;
		private System.Windows.Forms.ComboBoxTS comboKBCWDash;
		private System.Windows.Forms.GroupBoxTS grpKBRIT;
		private System.Windows.Forms.LabelTS lblKBRitUp;
		private System.Windows.Forms.LabelTS lblKBRITDown;
		private System.Windows.Forms.ComboBoxTS comboKBRITUp;
		private System.Windows.Forms.ComboBoxTS comboKBRITDown;
		private System.Windows.Forms.GroupBoxTS grpKBXIT;
		private System.Windows.Forms.LabelTS lblKBXITUp;
		private System.Windows.Forms.LabelTS lblKBXITDown;
		private System.Windows.Forms.ComboBoxTS comboKBXITUp;
		private System.Windows.Forms.ComboBoxTS comboKBXITDown;
		private System.Windows.Forms.CheckBoxTS chkDCBlock;
		private System.Windows.Forms.GroupBox grpKB9YIG_QRP_Rig;
		private System.Windows.Forms.CheckBoxTS checkBoxKB9YIG_NoDDS;
		private System.Windows.Forms.TextBox textFixedOscFreq;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.RichTextBox dbgBox;
		private System.Windows.Forms.Button dbgCopy;
		private System.Windows.Forms.Button dbgClear;
		private System.Windows.Forms.CheckBoxTS chkLeftOnly;
		private System.ComponentModel.IContainer components;

		#endregion


		public void dbgMsg(String s) 
		{
			dbgBox.AppendText(s); 
		}

		#region Constructor and Destructor

		public Setup(Console c)
		{
			InitializeComponent();
			console = c;

			initializing = true;

			InitWindowTypes();
			GetMixerDevices();
			GetHosts();			
			
			KeyList = new ArrayList();
			SetupKeyMap();

			comboGeneralLPTAddr.SelectedIndex = -1;
			comboGeneralProcessPriority.SelectedIndex = 0;
			comboAudioSoundCard.SelectedIndex = (int)SoundCard.UNSUPPORTED_CARD;
			comboAudioSampleRate1.SelectedIndex = 0;
			comboAudioSampleRate2.SelectedIndex = 0;
			comboAudioBuffer1.Text = "2048";
			comboAudioBuffer2.Text = "2048";
			comboAudioDetailSel.SelectedIndex = 0;
			comboImageReject.Text = "RX";
			comboDSPWindow.SelectedIndex = (int)DttSP.Window.HANNING;
			comboCATbaud.Text = "1200";
			comboCATparity.Text = "none";
			comboCATdatabits.Text = "8";
			comboCATstopbits.Text = "1";

			GetOptions();

			if(comboAudioDriver1.SelectedIndex < 0 &&
				comboAudioDriver1.Items.Count > 0)
				comboAudioDriver1.SelectedIndex = 0;

			if(comboAudioMixer1.SelectedIndex < 0 &&
				comboAudioMixer1.Items.Count > 0)
				comboAudioMixer1.SelectedIndex = 0;

			initializing = false;

			//ForceAllEvents();
			EventArgs e = EventArgs.Empty;
			comboGeneralLPTAddr_LostFocus(this, e);
			chkGeneralSpurRed_CheckedChanged(this, e);
			chkGeneralRFEPresent_CheckedChanged(this, e);
			udDDSCorrection_ValueChanged(this, e);
			chkAudioLatencyManual_CheckedChanged(this, e);
			udAudioLineIn1_ValueChanged(this, e);
			comboAudioReceive1_SelectedIndexChanged(this, e);
			udLMSANF_ValueChanged(this, e);
			udLMSNR_ValueChanged(this, e);			
			udDSPImagePhaseRX_ValueChanged(this, e);
			udDSPImageGainRX_ValueChanged(this, e);
			udDSPImagePhaseTX_ValueChanged(this, e);
			udDSPImageGainTX_ValueChanged(this, e);
			udDSPCWPitch_ValueChanged(this, e);
			tbTXFFCompression_Scroll(this, e);
			tbTXEQ_Scroll(this, EventArgs.Empty);			
			udTXFilterHigh_ValueChanged(this, e);
			udTXFilterLow_ValueChanged(this, e);
			chkTXEQEnabled_CheckedChanged(this, e);
			
			openFileDialog1.Filter = "PowerSDR Database Files (*.mdb) | *.mdb";

			if(comboAudioSoundCard.SelectedIndex == (int)SoundCard.UNSUPPORTED_CARD &&
				comboAudioMixer1.SelectedIndex < Mixer.mixerGetNumDevs())
				Mixer.InitUnsupportedCard(comboAudioMixer1.SelectedIndex);
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Windows Form Designer generated code

		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Setup));
			this.tcSetup = new System.Windows.Forms.TabControl();
			this.tpGeneral = new System.Windows.Forms.TabPage();
			this.grpGeneralUpdates = new System.Windows.Forms.GroupBoxTS();
			this.chkGeneralUpdateBeta = new System.Windows.Forms.CheckBoxTS();
			this.chkGeneralUpdateRelease = new System.Windows.Forms.CheckBoxTS();
			this.grpGeneralProcessPriority = new System.Windows.Forms.GroupBoxTS();
			this.comboGeneralProcessPriority = new System.Windows.Forms.ComboBoxTS();
			this.btnWizard = new System.Windows.Forms.ButtonTS();
			this.grpGeneralOptions = new System.Windows.Forms.GroupBoxTS();
			this.chkGeneralCustomFilter = new System.Windows.Forms.CheckBoxTS();
			this.lblGeneralX2Delay = new System.Windows.Forms.LabelTS();
			this.udGeneralX2Delay = new System.Windows.Forms.NumericUpDownTS();
			this.chkGeneralEnableX2 = new System.Windows.Forms.CheckBoxTS();
			this.chkGeneralSoftwareGainCorr = new System.Windows.Forms.CheckBoxTS();
			this.chkGeneralDisablePTT = new System.Windows.Forms.CheckBoxTS();
			this.chkGeneralSpurRed = new System.Windows.Forms.CheckBoxTS();
			this.grpGeneralCalibration = new System.Windows.Forms.GroupBoxTS();
			this.btnGeneralCalImageStart = new System.Windows.Forms.ButtonTS();
			this.lblGeneralImageNull = new System.Windows.Forms.LabelTS();
			this.btnGeneralCalFreqStart = new System.Windows.Forms.ButtonTS();
			this.btnGeneralCalLevelStart = new System.Windows.Forms.ButtonTS();
			this.udGeneralCalLevel = new System.Windows.Forms.NumericUpDownTS();
			this.lblGeneralCalLevel = new System.Windows.Forms.LabelTS();
			this.udGeneralCalFreq = new System.Windows.Forms.NumericUpDownTS();
			this.lblGeneralCalFrequency = new System.Windows.Forms.LabelTS();
			this.grpGeneralDDS = new System.Windows.Forms.GroupBoxTS();
			this.udDDSCorrection = new System.Windows.Forms.NumericUpDownTS();
			this.lblClockCorrection = new System.Windows.Forms.LabelTS();
			this.udDDSIFFreq = new System.Windows.Forms.NumericUpDownTS();
			this.lblIFFrequency = new System.Windows.Forms.LabelTS();
			this.udDDSPLLMult = new System.Windows.Forms.NumericUpDownTS();
			this.lblPLLMult = new System.Windows.Forms.LabelTS();
			this.grpGeneralHardwareSetup = new System.Windows.Forms.GroupBoxTS();
			this.chkGeneralRXOnly = new System.Windows.Forms.CheckBoxTS();
			this.chkGeneralUSBPresent = new System.Windows.Forms.CheckBoxTS();
			this.chkGeneralATUPresent = new System.Windows.Forms.CheckBoxTS();
			this.chkGeneralPAPresent = new System.Windows.Forms.CheckBoxTS();
			this.chkGeneralXVTRPresent = new System.Windows.Forms.CheckBoxTS();
			this.lblGeneralLPTDelay = new System.Windows.Forms.LabelTS();
			this.udGeneralLPTDelay = new System.Windows.Forms.NumericUpDownTS();
			this.lblGeneralLPTAddr = new System.Windows.Forms.LabelTS();
			this.comboGeneralLPTAddr = new System.Windows.Forms.ComboBoxTS();
			this.chkGeneralRFEPresent = new System.Windows.Forms.CheckBoxTS();
			this.comboGeneralXVTR = new System.Windows.Forms.ComboBoxTS();
			this.tpAudio = new System.Windows.Forms.TabPage();
			this.btnAudioCalSecondSoundCard = new System.Windows.Forms.ButtonTS();
			this.grpAudioLineInGain = new System.Windows.Forms.GroupBoxTS();
			this.udAudioLineIn2 = new System.Windows.Forms.NumericUpDownTS();
			this.lblAudioLineIn2 = new System.Windows.Forms.LabelTS();
			this.lblAudioLineIn1 = new System.Windows.Forms.LabelTS();
			this.udAudioLineIn1 = new System.Windows.Forms.NumericUpDownTS();
			this.grpAudioVoltage = new System.Windows.Forms.GroupBoxTS();
			this.btnAudioVoltTest2 = new System.Windows.Forms.ButtonTS();
			this.udAudioVoltage2 = new System.Windows.Forms.NumericUpDownTS();
			this.lblAudioVoltage2 = new System.Windows.Forms.LabelTS();
			this.btnAudioVoltTest1 = new System.Windows.Forms.ButtonTS();
			this.udAudioVoltage1 = new System.Windows.Forms.NumericUpDownTS();
			this.lblAudioVoltage1 = new System.Windows.Forms.LabelTS();
			this.grpAudioDetails1 = new System.Windows.Forms.GroupBoxTS();
			this.comboAudioTransmit1 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioMixer1 = new System.Windows.Forms.LabelTS();
			this.lblAudioOutput1 = new System.Windows.Forms.LabelTS();
			this.comboAudioOutput1 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioInput1 = new System.Windows.Forms.LabelTS();
			this.lblAudioDriver1 = new System.Windows.Forms.LabelTS();
			this.comboAudioInput1 = new System.Windows.Forms.ComboBoxTS();
			this.comboAudioDriver1 = new System.Windows.Forms.ComboBoxTS();
			this.comboAudioMixer1 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioTransmit1 = new System.Windows.Forms.LabelTS();
			this.lblAudioReceive1 = new System.Windows.Forms.LabelTS();
			this.comboAudioReceive1 = new System.Windows.Forms.ComboBoxTS();
			this.comboAudioDetailSel = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioShowDetails = new System.Windows.Forms.LabelTS();
			this.grpAudioLatency = new System.Windows.Forms.GroupBoxTS();
			this.chkAudioLatencyManual = new System.Windows.Forms.CheckBoxTS();
			this.lblAudioLatency2 = new System.Windows.Forms.LabelTS();
			this.lblAudioLatency1 = new System.Windows.Forms.LabelTS();
			this.udAudioLatency2 = new System.Windows.Forms.NumericUpDownTS();
			this.udAudioLatency1 = new System.Windows.Forms.NumericUpDownTS();
			this.grpAudioDetails2 = new System.Windows.Forms.GroupBoxTS();
			this.comboAudioTransmit2 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioOutput2 = new System.Windows.Forms.LabelTS();
			this.comboAudioOutput2 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioInput2 = new System.Windows.Forms.LabelTS();
			this.lblAudioDriver2 = new System.Windows.Forms.LabelTS();
			this.comboAudioInput2 = new System.Windows.Forms.ComboBoxTS();
			this.comboAudioDriver2 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioTransmit2 = new System.Windows.Forms.LabelTS();
			this.lblAudioReceive2 = new System.Windows.Forms.LabelTS();
			this.comboAudioReceive2 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioMixer2 = new System.Windows.Forms.LabelTS();
			this.comboAudioMixer2 = new System.Windows.Forms.ComboBoxTS();
			this.grpAudioCard = new System.Windows.Forms.GroupBoxTS();
			this.comboAudioSoundCard = new System.Windows.Forms.ComboBoxTS();
			this.grpAudioBufferSize = new System.Windows.Forms.GroupBoxTS();
			this.comboAudioBuffer2 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioBuffer2 = new System.Windows.Forms.LabelTS();
			this.comboAudioBuffer1 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioBuffer1 = new System.Windows.Forms.LabelTS();
			this.grpAudioSampleRate = new System.Windows.Forms.GroupBoxTS();
			this.comboAudioSampleRate2 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioSample2 = new System.Windows.Forms.LabelTS();
			this.comboAudioSampleRate1 = new System.Windows.Forms.ComboBoxTS();
			this.lblAudioSample1 = new System.Windows.Forms.LabelTS();
			this.chkAudioEnableSoundCard2 = new System.Windows.Forms.CheckBoxTS();
			this.tpDisplay = new System.Windows.Forms.TabPage();
			this.grpDisplayMultimeter = new System.Windows.Forms.GroupBoxTS();
			this.udDisplayMultiTextHoldTime = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayMeterTextHoldTime = new System.Windows.Forms.LabelTS();
			this.udDisplayMultiPeakHoldTime = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayMultiPeakHoldTime = new System.Windows.Forms.LabelTS();
			this.grpDisplayWaterfall = new System.Windows.Forms.GroupBoxTS();
			this.clrbtnWaterfallMid = new PowerSDR.ColorButton();
			this.clrbtnWaterfallHigh = new PowerSDR.ColorButton();
			this.clrbtnWaterfallLow = new PowerSDR.ColorButton();
			this.lblDisplayWaterfallMidColor = new System.Windows.Forms.LabelTS();
			this.lblDisplayWaterfallHighColor = new System.Windows.Forms.LabelTS();
			this.lblDisplayWaterfallLowColor = new System.Windows.Forms.LabelTS();
			this.lblDisplayWaterfallLowLevel = new System.Windows.Forms.LabelTS();
			this.udDisplayWaterfallLowLevel = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayWaterfallHighLevel = new System.Windows.Forms.LabelTS();
			this.udDisplayWaterfallHighLevel = new System.Windows.Forms.NumericUpDownTS();
			this.grpDisplayRefreshRates = new System.Windows.Forms.GroupBoxTS();
			this.udDisplayCPUMeter = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayCPUMeter = new System.Windows.Forms.LabelTS();
			this.udDisplayPeakText = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayPeakText = new System.Windows.Forms.LabelTS();
			this.udDisplayMeterDelay = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayMeterDelay = new System.Windows.Forms.LabelTS();
			this.udDisplayFPS = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayFPS = new System.Windows.Forms.LabelTS();
			this.grpDisplayAverage = new System.Windows.Forms.GroupBoxTS();
			this.udDisplayAVGTime = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayAVGTime = new System.Windows.Forms.LabelTS();
			this.grpDisplayPhase = new System.Windows.Forms.GroupBoxTS();
			this.lblDisplayPhasePts = new System.Windows.Forms.LabelTS();
			this.udDisplayPhasePts = new System.Windows.Forms.NumericUpDownTS();
			this.grpDisplaySpectrumGrid = new System.Windows.Forms.GroupBoxTS();
			this.comboDisplaydBAlign = new System.Windows.Forms.ComboBoxTS();
			this.label1 = new System.Windows.Forms.Label();
			this.udDisplayGridStep = new System.Windows.Forms.NumericUpDownTS();
			this.udDisplayGridMin = new System.Windows.Forms.NumericUpDownTS();
			this.udDisplayGridMax = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayGridStep = new System.Windows.Forms.LabelTS();
			this.lblDisplayGridMin = new System.Windows.Forms.LabelTS();
			this.lblDisplayGridMax = new System.Windows.Forms.LabelTS();
			this.tpDSP = new System.Windows.Forms.TabPage();
			this.comboImageReject = new System.Windows.Forms.ComboBoxTS();
			this.grpDSPNB = new System.Windows.Forms.GroupBoxTS();
			this.udDSPNB = new System.Windows.Forms.NumericUpDownTS();
			this.lblDSPNBThreshold = new System.Windows.Forms.LabelTS();
			this.grpDSPCWPitch = new System.Windows.Forms.GroupBoxTS();
			this.lblDSPCWPitchFreq = new System.Windows.Forms.LabelTS();
			this.udDSPCWPitch = new System.Windows.Forms.NumericUpDownTS();
			this.grpDSPNB2 = new System.Windows.Forms.GroupBoxTS();
			this.udDSPMNB = new System.Windows.Forms.NumericUpDownTS();
			this.lblDSPNB2Threshold = new System.Windows.Forms.LabelTS();
			this.grpDSPLMSNR = new System.Windows.Forms.GroupBoxTS();
			this.lblLMSNRgain = new System.Windows.Forms.LabelTS();
			this.udLMSNRgain = new System.Windows.Forms.NumericUpDownTS();
			this.udLMSNRdelay = new System.Windows.Forms.NumericUpDownTS();
			this.lblLMSNRdelay = new System.Windows.Forms.LabelTS();
			this.udLMSNRtaps = new System.Windows.Forms.NumericUpDownTS();
			this.lblLMSNRtaps = new System.Windows.Forms.LabelTS();
			this.grpDSPLMSANF = new System.Windows.Forms.GroupBoxTS();
			this.lblLMSANFgain = new System.Windows.Forms.LabelTS();
			this.udLMSANFgain = new System.Windows.Forms.NumericUpDownTS();
			this.lblLMSANFdelay = new System.Windows.Forms.LabelTS();
			this.udLMSANFdelay = new System.Windows.Forms.NumericUpDownTS();
			this.lblLMSANFTaps = new System.Windows.Forms.LabelTS();
			this.udLMSANFtaps = new System.Windows.Forms.NumericUpDownTS();
			this.grpDSPImageRejectRX = new System.Windows.Forms.GroupBoxTS();
			this.lblDSPGainValRX = new System.Windows.Forms.LabelTS();
			this.lblDSPPhaseValRX = new System.Windows.Forms.LabelTS();
			this.udDSPImageGainRX = new System.Windows.Forms.NumericUpDownTS();
			this.udDSPImagePhaseRX = new System.Windows.Forms.NumericUpDownTS();
			this.lblDSPImageGainRX = new System.Windows.Forms.LabelTS();
			this.tbDSPImagePhaseRX = new System.Windows.Forms.TrackBarTS();
			this.lblDSPImagePhaseRX = new System.Windows.Forms.LabelTS();
			this.tbDSPImageGainRX = new System.Windows.Forms.TrackBarTS();
			this.grpDSPAGC = new System.Windows.Forms.GroupBoxTS();
			this.lblDSPAGCMaxGain = new System.Windows.Forms.LabelTS();
			this.udDSPAGCMaxGaindB = new System.Windows.Forms.NumericUpDownTS();
			this.udDSPAGCFixedGaindB = new System.Windows.Forms.NumericUpDownTS();
			this.lblDSPAGCFixed = new System.Windows.Forms.LabelTS();
			this.grpDSPWindow = new System.Windows.Forms.GroupBoxTS();
			this.comboDSPWindow = new System.Windows.Forms.ComboBoxTS();
			this.grpDSPImageRejectTX = new System.Windows.Forms.GroupBoxTS();
			this.lblDSPGainValTX = new System.Windows.Forms.LabelTS();
			this.lblDSPPhaseValTX = new System.Windows.Forms.LabelTS();
			this.udDSPImageGainTX = new System.Windows.Forms.NumericUpDownTS();
			this.udDSPImagePhaseTX = new System.Windows.Forms.NumericUpDownTS();
			this.lblDSPImageGainTX = new System.Windows.Forms.LabelTS();
			this.tbDSPImagePhaseTX = new System.Windows.Forms.TrackBarTS();
			this.lblDSPImagePhaseTX = new System.Windows.Forms.LabelTS();
			this.tbDSPImageGainTX = new System.Windows.Forms.TrackBarTS();
			this.tpTransmit = new System.Windows.Forms.TabPage();
			this.grpTXMicPreamp = new System.Windows.Forms.GroupBoxTS();
			this.lblTXMicPreampGain = new System.Windows.Forms.LabelTS();
			this.udTXPreGain = new System.Windows.Forms.NumericUpDownTS();
			this.grpPATune = new System.Windows.Forms.GroupBoxTS();
			this.lblTransmitTunePower = new System.Windows.Forms.LabelTS();
			this.udTXTunePower = new System.Windows.Forms.NumericUpDownTS();
			this.grpTXCompression = new System.Windows.Forms.GroupBoxTS();
			this.udTXFFCompression = new System.Windows.Forms.NumericUpDownTS();
			this.lblTXFFVal = new System.Windows.Forms.LabelTS();
			this.lblTransmitFeedForward = new System.Windows.Forms.LabelTS();
			this.tbTXFFCompression = new System.Windows.Forms.TrackBarTS();
			this.grpTXFilter = new System.Windows.Forms.GroupBoxTS();
			this.lblTXFilterHigh = new System.Windows.Forms.LabelTS();
			this.udTXFilterLow = new System.Windows.Forms.NumericUpDownTS();
			this.lblTXFilterLow = new System.Windows.Forms.LabelTS();
			this.udTXFilterHigh = new System.Windows.Forms.NumericUpDownTS();
			this.grpTXEqualizer = new System.Windows.Forms.GroupBoxTS();
			this.chkDCBlock = new System.Windows.Forms.CheckBoxTS();
			this.lblTXEQ3500 = new System.Windows.Forms.LabelTS();
			this.tbTXEQ3500 = new System.Windows.Forms.TrackBarTS();
			this.lblTXEQ80 = new System.Windows.Forms.LabelTS();
			this.lblTXEQ160 = new System.Windows.Forms.LabelTS();
			this.tbTXEQ80 = new System.Windows.Forms.TrackBarTS();
			this.tbTXEQ160 = new System.Windows.Forms.TrackBarTS();
			this.lblEQ15db = new System.Windows.Forms.LabelTS();
			this.btnTXEQReset = new System.Windows.Forms.ButtonTS();
			this.chkTXEQEnabled = new System.Windows.Forms.CheckBoxTS();
			this.lblTXEQ2000 = new System.Windows.Forms.LabelTS();
			this.lblTXEQ2300 = new System.Windows.Forms.LabelTS();
			this.lblTXEQ2600 = new System.Windows.Forms.LabelTS();
			this.lblTXEQ3000 = new System.Windows.Forms.LabelTS();
			this.lblTXEQ1600 = new System.Windows.Forms.LabelTS();
			this.lblEQminus15db = new System.Windows.Forms.LabelTS();
			this.lblEQ0dB = new System.Windows.Forms.LabelTS();
			this.tbTXEQ3000 = new System.Windows.Forms.TrackBarTS();
			this.tbTXEQ2600 = new System.Windows.Forms.TrackBarTS();
			this.tbTXEQ2300 = new System.Windows.Forms.TrackBarTS();
			this.tbTXEQ2000 = new System.Windows.Forms.TrackBarTS();
			this.tbTXEQ1600 = new System.Windows.Forms.TrackBarTS();
			this.lblTXEQ1300 = new System.Windows.Forms.LabelTS();
			this.lblTXEQ1000 = new System.Windows.Forms.LabelTS();
			this.lblTXEQ600 = new System.Windows.Forms.LabelTS();
			this.lblTXEQ300 = new System.Windows.Forms.LabelTS();
			this.tbTXEQ1300 = new System.Windows.Forms.TrackBarTS();
			this.tbTXEQ1000 = new System.Windows.Forms.TrackBarTS();
			this.tbTXEQ600 = new System.Windows.Forms.TrackBarTS();
			this.tbTXEQ300 = new System.Windows.Forms.TrackBarTS();
			this.tpPowerAmplifier = new System.Windows.Forms.TabPage();
			this.grpPABandOffset = new System.Windows.Forms.GroupBoxTS();
			this.lblPABandOffset10 = new System.Windows.Forms.LabelTS();
			this.lblPABandOffset12 = new System.Windows.Forms.LabelTS();
			this.lblPABandOffset15 = new System.Windows.Forms.LabelTS();
			this.lblPABandOffset17 = new System.Windows.Forms.LabelTS();
			this.lblPABandOffset20 = new System.Windows.Forms.LabelTS();
			this.lblPABandOffset30 = new System.Windows.Forms.LabelTS();
			this.lblPABandOffset40 = new System.Windows.Forms.LabelTS();
			this.lblPABandOffset60 = new System.Windows.Forms.LabelTS();
			this.lblPABandOffset80 = new System.Windows.Forms.LabelTS();
			this.lblPABandOffset160 = new System.Windows.Forms.LabelTS();
			this.udPAADC17 = new System.Windows.Forms.NumericUpDownTS();
			this.udPAADC15 = new System.Windows.Forms.NumericUpDownTS();
			this.udPAADC20 = new System.Windows.Forms.NumericUpDownTS();
			this.udPAADC12 = new System.Windows.Forms.NumericUpDownTS();
			this.udPAADC10 = new System.Windows.Forms.NumericUpDownTS();
			this.udPAADC160 = new System.Windows.Forms.NumericUpDownTS();
			this.udPAADC80 = new System.Windows.Forms.NumericUpDownTS();
			this.udPAADC60 = new System.Windows.Forms.NumericUpDownTS();
			this.udPAADC40 = new System.Windows.Forms.NumericUpDownTS();
			this.udPAADC30 = new System.Windows.Forms.NumericUpDownTS();
			this.grpPAGainByBand = new System.Windows.Forms.GroupBoxTS();
			this.lblPACalPower = new System.Windows.Forms.LabelTS();
			this.udPACalPower = new System.Windows.Forms.NumericUpDownTS();
			this.btnPAGainReset = new System.Windows.Forms.ButtonTS();
			this.btnPAGainCalibration = new System.Windows.Forms.ButtonTS();
			this.lblPAGainByBand10 = new System.Windows.Forms.LabelTS();
			this.udPAGain10 = new System.Windows.Forms.NumericUpDownTS();
			this.lblPAGainByBand12 = new System.Windows.Forms.LabelTS();
			this.udPAGain12 = new System.Windows.Forms.NumericUpDownTS();
			this.lblPAGainByBand15 = new System.Windows.Forms.LabelTS();
			this.udPAGain15 = new System.Windows.Forms.NumericUpDownTS();
			this.lblPAGainByBand17 = new System.Windows.Forms.LabelTS();
			this.udPAGain17 = new System.Windows.Forms.NumericUpDownTS();
			this.lblPAGainByBand20 = new System.Windows.Forms.LabelTS();
			this.udPAGain20 = new System.Windows.Forms.NumericUpDownTS();
			this.lblPAGainByBand30 = new System.Windows.Forms.LabelTS();
			this.udPAGain30 = new System.Windows.Forms.NumericUpDownTS();
			this.lblPAGainByBand40 = new System.Windows.Forms.LabelTS();
			this.udPAGain40 = new System.Windows.Forms.NumericUpDownTS();
			this.lblPAGainByBand60 = new System.Windows.Forms.LabelTS();
			this.udPAGain60 = new System.Windows.Forms.NumericUpDownTS();
			this.lblPAGainByBand80 = new System.Windows.Forms.LabelTS();
			this.udPAGain80 = new System.Windows.Forms.NumericUpDownTS();
			this.lblPAGainByBand160 = new System.Windows.Forms.LabelTS();
			this.udPAGain160 = new System.Windows.Forms.NumericUpDownTS();
			this.tpAppearance = new System.Windows.Forms.TabPage();
			this.grpAppearanceGeneral = new System.Windows.Forms.GroupBoxTS();
			this.clrbtnPeakText = new PowerSDR.ColorButton();
			this.clrbtnBandLight = new PowerSDR.ColorButton();
			this.clrbtnBandDark = new PowerSDR.ColorButton();
			this.clrbtnVFOLight = new PowerSDR.ColorButton();
			this.clrbtnVFODark = new PowerSDR.ColorButton();
			this.clrbtnBtnSel = new PowerSDR.ColorButton();
			this.lblPeakText = new System.Windows.Forms.LabelTS();
			this.lblBandLight = new System.Windows.Forms.LabelTS();
			this.lblBandDark = new System.Windows.Forms.LabelTS();
			this.lblVFOLight = new System.Windows.Forms.LabelTS();
			this.lblVFODark = new System.Windows.Forms.LabelTS();
			this.lblAppearanceGenBtnSel = new System.Windows.Forms.LabelTS();
			this.grpAppearanceMeter = new System.Windows.Forms.GroupBoxTS();
			this.clrbtnMeterRight = new PowerSDR.ColorButton();
			this.lblAppearanceMeterRight = new System.Windows.Forms.LabelTS();
			this.lblAppearanceMeterLeft = new System.Windows.Forms.LabelTS();
			this.clrbtnMeterLeft = new PowerSDR.ColorButton();
			this.grpAppearanceDisplay = new System.Windows.Forms.GroupBoxTS();
			this.clrbtnDataLine = new PowerSDR.ColorButton();
			this.clrbtnText = new PowerSDR.ColorButton();
			this.clrbtnFilter = new PowerSDR.ColorButton();
			this.clrbtnZeroLine = new PowerSDR.ColorButton();
			this.clrbtnGrid = new PowerSDR.ColorButton();
			this.clrbtnBackground = new PowerSDR.ColorButton();
			this.lblDisplayFilterColor = new System.Windows.Forms.LabelTS();
			this.lblDisplayLineWidth = new System.Windows.Forms.LabelTS();
			this.udDisplayLineWidth = new System.Windows.Forms.NumericUpDownTS();
			this.lblDisplayDataLineColor = new System.Windows.Forms.LabelTS();
			this.lblDisplayTextColor = new System.Windows.Forms.LabelTS();
			this.lblDisplayZeroLineColor = new System.Windows.Forms.LabelTS();
			this.lblDisplayGridColor = new System.Windows.Forms.LabelTS();
			this.lblDisplayBackgroundColor = new System.Windows.Forms.LabelTS();
			this.tpKeyboard = new System.Windows.Forms.TabPage();
			this.grpKBXIT = new System.Windows.Forms.GroupBoxTS();
			this.lblKBXITUp = new System.Windows.Forms.LabelTS();
			this.lblKBXITDown = new System.Windows.Forms.LabelTS();
			this.comboKBXITUp = new System.Windows.Forms.ComboBoxTS();
			this.comboKBXITDown = new System.Windows.Forms.ComboBoxTS();
			this.grpKBRIT = new System.Windows.Forms.GroupBoxTS();
			this.lblKBRitUp = new System.Windows.Forms.LabelTS();
			this.lblKBRITDown = new System.Windows.Forms.LabelTS();
			this.comboKBRITUp = new System.Windows.Forms.ComboBoxTS();
			this.comboKBRITDown = new System.Windows.Forms.ComboBoxTS();
			this.grpKBMode = new System.Windows.Forms.GroupBoxTS();
			this.lblKBModeUp = new System.Windows.Forms.LabelTS();
			this.lblKBModeDown = new System.Windows.Forms.LabelTS();
			this.comboKBModeUp = new System.Windows.Forms.ComboBoxTS();
			this.comboKBModeDown = new System.Windows.Forms.ComboBoxTS();
			this.grpKBBand = new System.Windows.Forms.GroupBoxTS();
			this.lblKBBandUp = new System.Windows.Forms.LabelTS();
			this.lblKBBandDown = new System.Windows.Forms.LabelTS();
			this.comboKBBandUp = new System.Windows.Forms.ComboBoxTS();
			this.comboKBBandDown = new System.Windows.Forms.ComboBoxTS();
			this.grpKBTune = new System.Windows.Forms.GroupBoxTS();
			this.lblKBTuneDigit = new System.Windows.Forms.LabelTS();
			this.lblKBTune7 = new System.Windows.Forms.LabelTS();
			this.lblKBTune6 = new System.Windows.Forms.LabelTS();
			this.lblKBTune5 = new System.Windows.Forms.LabelTS();
			this.lblKBTune4 = new System.Windows.Forms.LabelTS();
			this.lblKBTune3 = new System.Windows.Forms.LabelTS();
			this.lblKBTune2 = new System.Windows.Forms.LabelTS();
			this.comboKBTuneUp7 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneDown7 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneUp6 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneDown6 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneUp5 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneDown5 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneUp4 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneDown4 = new System.Windows.Forms.ComboBoxTS();
			this.lblKBTune1 = new System.Windows.Forms.LabelTS();
			this.lblKBTuneUp = new System.Windows.Forms.LabelTS();
			this.lblKBTuneDown = new System.Windows.Forms.LabelTS();
			this.comboKBTuneUp3 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneDown3 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneUp1 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneUp2 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneDown1 = new System.Windows.Forms.ComboBoxTS();
			this.comboKBTuneDown2 = new System.Windows.Forms.ComboBoxTS();
			this.grpKBFilter = new System.Windows.Forms.GroupBoxTS();
			this.lblKBFilterUp = new System.Windows.Forms.LabelTS();
			this.lblKBFilterDown = new System.Windows.Forms.LabelTS();
			this.comboKBFilterUp = new System.Windows.Forms.ComboBoxTS();
			this.comboKBFilterDown = new System.Windows.Forms.ComboBoxTS();
			this.grpKBCW = new System.Windows.Forms.GroupBoxTS();
			this.lblKBCWDot = new System.Windows.Forms.LabelTS();
			this.lblKBCWDash = new System.Windows.Forms.LabelTS();
			this.comboKBCWDot = new System.Windows.Forms.ComboBoxTS();
			this.comboKBCWDash = new System.Windows.Forms.ComboBoxTS();
			this.tpCAT = new System.Windows.Forms.TabPage();
			this.grpPTTBitBang = new System.Windows.Forms.GroupBoxTS();
			this.lblCATPTTPort = new System.Windows.Forms.LabelTS();
			this.udCATBitBangPTTPort = new System.Windows.Forms.NumericUpDownTS();
			this.chkCATPTT_RTS = new System.Windows.Forms.CheckBoxTS();
			this.chkCATPTT_DTR = new System.Windows.Forms.CheckBoxTS();
			this.chkCATBitBangPTT = new System.Windows.Forms.CheckBoxTS();
			this.grpCatControlBox = new System.Windows.Forms.GroupBoxTS();
			this.chkCATMixWVirtual = new System.Windows.Forms.CheckBoxTS();
			this.comboCATbaud = new System.Windows.Forms.ComboBoxTS();
			this.lblCATBaud = new System.Windows.Forms.Label();
			this.lblCATComPort = new System.Windows.Forms.LabelTS();
			this.udCATPort = new System.Windows.Forms.NumericUpDownTS();
			this.chkCATEnable = new System.Windows.Forms.CheckBoxTS();
			this.lblCATParity = new System.Windows.Forms.Label();
			this.lblCATData = new System.Windows.Forms.Label();
			this.lblCATStop = new System.Windows.Forms.Label();
			this.comboCATparity = new System.Windows.Forms.ComboBoxTS();
			this.comboCATdatabits = new System.Windows.Forms.ComboBoxTS();
			this.comboCATstopbits = new System.Windows.Forms.ComboBoxTS();
			this.tpTests = new System.Windows.Forms.TabPage();
			this.dbgClear = new System.Windows.Forms.Button();
			this.dbgCopy = new System.Windows.Forms.Button();
			this.dbgBox = new System.Windows.Forms.RichTextBox();
			this.grpKB9YIG_QRP_Rig = new System.Windows.Forms.GroupBox();
			this.textFixedOscFreq = new System.Windows.Forms.TextBox();
			this.checkBoxKB9YIG_NoDDS = new System.Windows.Forms.CheckBoxTS();
			this.label2 = new System.Windows.Forms.Label();
			this.grpTestX2 = new System.Windows.Forms.GroupBoxTS();
			this.lblTestX2 = new System.Windows.Forms.LabelTS();
			this.chkTestX2Pin6 = new System.Windows.Forms.CheckBoxTS();
			this.chkTestX2Pin5 = new System.Windows.Forms.CheckBoxTS();
			this.chkTestX2Pin4 = new System.Windows.Forms.CheckBoxTS();
			this.chkTestX2Pin3 = new System.Windows.Forms.CheckBoxTS();
			this.chkTestX2Pin2 = new System.Windows.Forms.CheckBoxTS();
			this.chkTestX2Pin1 = new System.Windows.Forms.CheckBoxTS();
			this.grpTestAudioBalance = new System.Windows.Forms.GroupBoxTS();
			this.btnTestAudioBalStart = new System.Windows.Forms.ButtonTS();
			this.grpTestTXIMD = new System.Windows.Forms.GroupBoxTS();
			this.lblTestToneFreq2 = new System.Windows.Forms.LabelTS();
			this.udTestIMDFreq2 = new System.Windows.Forms.NumericUpDownTS();
			this.lblTestIMDPower = new System.Windows.Forms.LabelTS();
			this.udTestIMDPower = new System.Windows.Forms.NumericUpDownTS();
			this.chkTestIMD = new System.Windows.Forms.CheckBoxTS();
			this.lblTestToneFreq1 = new System.Windows.Forms.LabelTS();
			this.udTestIMDFreq1 = new System.Windows.Forms.NumericUpDownTS();
			this.btnOK = new System.Windows.Forms.ButtonTS();
			this.btnCancel = new System.Windows.Forms.ButtonTS();
			this.btnApply = new System.Windows.Forms.ButtonTS();
			this.btnResetAll = new System.Windows.Forms.ButtonTS();
			this.btnImportDB = new System.Windows.Forms.ButtonTS();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.chkLeftOnly = new System.Windows.Forms.CheckBoxTS();
			this.tcSetup.SuspendLayout();
			this.tpGeneral.SuspendLayout();
			this.grpGeneralUpdates.SuspendLayout();
			this.grpGeneralProcessPriority.SuspendLayout();
			this.grpGeneralOptions.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udGeneralX2Delay)).BeginInit();
			this.grpGeneralCalibration.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udGeneralCalLevel)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udGeneralCalFreq)).BeginInit();
			this.grpGeneralDDS.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDDSCorrection)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDDSIFFreq)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDDSPLLMult)).BeginInit();
			this.grpGeneralHardwareSetup.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udGeneralLPTDelay)).BeginInit();
			this.tpAudio.SuspendLayout();
			this.grpAudioLineInGain.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udAudioLineIn2)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udAudioLineIn1)).BeginInit();
			this.grpAudioVoltage.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udAudioVoltage2)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udAudioVoltage1)).BeginInit();
			this.grpAudioDetails1.SuspendLayout();
			this.grpAudioLatency.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udAudioLatency2)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udAudioLatency1)).BeginInit();
			this.grpAudioDetails2.SuspendLayout();
			this.grpAudioCard.SuspendLayout();
			this.grpAudioBufferSize.SuspendLayout();
			this.grpAudioSampleRate.SuspendLayout();
			this.tpDisplay.SuspendLayout();
			this.grpDisplayMultimeter.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayMultiTextHoldTime)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayMultiPeakHoldTime)).BeginInit();
			this.grpDisplayWaterfall.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallLowLevel)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallHighLevel)).BeginInit();
			this.grpDisplayRefreshRates.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayCPUMeter)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayPeakText)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayMeterDelay)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayFPS)).BeginInit();
			this.grpDisplayAverage.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayAVGTime)).BeginInit();
			this.grpDisplayPhase.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayPhasePts)).BeginInit();
			this.grpDisplaySpectrumGrid.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayGridStep)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayGridMin)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayGridMax)).BeginInit();
			this.tpDSP.SuspendLayout();
			this.grpDSPNB.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDSPNB)).BeginInit();
			this.grpDSPCWPitch.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDSPCWPitch)).BeginInit();
			this.grpDSPNB2.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDSPMNB)).BeginInit();
			this.grpDSPLMSNR.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udLMSNRgain)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udLMSNRdelay)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udLMSNRtaps)).BeginInit();
			this.grpDSPLMSANF.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udLMSANFgain)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udLMSANFdelay)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udLMSANFtaps)).BeginInit();
			this.grpDSPImageRejectRX.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDSPImageGainRX)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDSPImagePhaseRX)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbDSPImagePhaseRX)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbDSPImageGainRX)).BeginInit();
			this.grpDSPAGC.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDSPAGCMaxGaindB)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDSPAGCFixedGaindB)).BeginInit();
			this.grpDSPWindow.SuspendLayout();
			this.grpDSPImageRejectTX.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDSPImageGainTX)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udDSPImagePhaseTX)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbDSPImagePhaseTX)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbDSPImageGainTX)).BeginInit();
			this.tpTransmit.SuspendLayout();
			this.grpTXMicPreamp.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udTXPreGain)).BeginInit();
			this.grpPATune.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udTXTunePower)).BeginInit();
			this.grpTXCompression.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udTXFFCompression)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXFFCompression)).BeginInit();
			this.grpTXFilter.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udTXFilterLow)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udTXFilterHigh)).BeginInit();
			this.grpTXEqualizer.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ3500)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ80)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ160)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ3000)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ2600)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ2300)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ2000)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ1600)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ1300)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ1000)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ600)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ300)).BeginInit();
			this.tpPowerAmplifier.SuspendLayout();
			this.grpPABandOffset.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC17)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC15)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC20)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC12)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC10)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC160)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC80)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC60)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC40)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC30)).BeginInit();
			this.grpPAGainByBand.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udPACalPower)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain10)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain12)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain15)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain17)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain20)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain30)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain40)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain60)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain80)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain160)).BeginInit();
			this.tpAppearance.SuspendLayout();
			this.grpAppearanceGeneral.SuspendLayout();
			this.grpAppearanceMeter.SuspendLayout();
			this.grpAppearanceDisplay.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayLineWidth)).BeginInit();
			this.tpKeyboard.SuspendLayout();
			this.grpKBXIT.SuspendLayout();
			this.grpKBRIT.SuspendLayout();
			this.grpKBMode.SuspendLayout();
			this.grpKBBand.SuspendLayout();
			this.grpKBTune.SuspendLayout();
			this.grpKBFilter.SuspendLayout();
			this.grpKBCW.SuspendLayout();
			this.tpCAT.SuspendLayout();
			this.grpPTTBitBang.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udCATBitBangPTTPort)).BeginInit();
			this.grpCatControlBox.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udCATPort)).BeginInit();
			this.tpTests.SuspendLayout();
			this.grpKB9YIG_QRP_Rig.SuspendLayout();
			this.grpTestX2.SuspendLayout();
			this.grpTestAudioBalance.SuspendLayout();
			this.grpTestTXIMD.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.udTestIMDFreq2)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udTestIMDPower)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.udTestIMDFreq1)).BeginInit();
			this.SuspendLayout();
			// 
			// tcSetup
			// 
			this.tcSetup.Controls.Add(this.tpGeneral);
			this.tcSetup.Controls.Add(this.tpAudio);
			this.tcSetup.Controls.Add(this.tpDisplay);
			this.tcSetup.Controls.Add(this.tpDSP);
			this.tcSetup.Controls.Add(this.tpTransmit);
			this.tcSetup.Controls.Add(this.tpPowerAmplifier);
			this.tcSetup.Controls.Add(this.tpAppearance);
			this.tcSetup.Controls.Add(this.tpKeyboard);
			this.tcSetup.Controls.Add(this.tpCAT);
			this.tcSetup.Controls.Add(this.tpTests);
			this.tcSetup.Location = new System.Drawing.Point(8, 8);
			this.tcSetup.Name = "tcSetup";
			this.tcSetup.SelectedIndex = 0;
			this.tcSetup.Size = new System.Drawing.Size(592, 312);
			this.tcSetup.TabIndex = 16;
			// 
			// tpGeneral
			// 
			this.tpGeneral.Controls.Add(this.grpGeneralUpdates);
			this.tpGeneral.Controls.Add(this.grpGeneralProcessPriority);
			this.tpGeneral.Controls.Add(this.btnWizard);
			this.tpGeneral.Controls.Add(this.grpGeneralOptions);
			this.tpGeneral.Controls.Add(this.grpGeneralCalibration);
			this.tpGeneral.Controls.Add(this.grpGeneralDDS);
			this.tpGeneral.Controls.Add(this.grpGeneralHardwareSetup);
			this.tpGeneral.Location = new System.Drawing.Point(4, 22);
			this.tpGeneral.Name = "tpGeneral";
			this.tpGeneral.Size = new System.Drawing.Size(584, 286);
			this.tpGeneral.TabIndex = 3;
			this.tpGeneral.Text = "General";
			// 
			// grpGeneralUpdates
			// 
			this.grpGeneralUpdates.Controls.Add(this.chkGeneralUpdateBeta);
			this.grpGeneralUpdates.Controls.Add(this.chkGeneralUpdateRelease);
			this.grpGeneralUpdates.Location = new System.Drawing.Point(432, 208);
			this.grpGeneralUpdates.Name = "grpGeneralUpdates";
			this.grpGeneralUpdates.Size = new System.Drawing.Size(144, 64);
			this.grpGeneralUpdates.TabIndex = 24;
			this.grpGeneralUpdates.TabStop = false;
			this.grpGeneralUpdates.Text = "Update Notification";
			// 
			// chkGeneralUpdateBeta
			// 
			this.chkGeneralUpdateBeta.Checked = true;
			this.chkGeneralUpdateBeta.CheckState = System.Windows.Forms.CheckState.Checked;
			this.chkGeneralUpdateBeta.Image = null;
			this.chkGeneralUpdateBeta.Location = new System.Drawing.Point(16, 40);
			this.chkGeneralUpdateBeta.Name = "chkGeneralUpdateBeta";
			this.chkGeneralUpdateBeta.Size = new System.Drawing.Size(104, 16);
			this.chkGeneralUpdateBeta.TabIndex = 1;
			this.chkGeneralUpdateBeta.Text = "Beta";
			this.chkGeneralUpdateBeta.CheckedChanged += new System.EventHandler(this.chkGeneralUpdateBeta_CheckedChanged);
			// 
			// chkGeneralUpdateRelease
			// 
			this.chkGeneralUpdateRelease.Checked = true;
			this.chkGeneralUpdateRelease.CheckState = System.Windows.Forms.CheckState.Checked;
			this.chkGeneralUpdateRelease.Image = null;
			this.chkGeneralUpdateRelease.Location = new System.Drawing.Point(16, 24);
			this.chkGeneralUpdateRelease.Name = "chkGeneralUpdateRelease";
			this.chkGeneralUpdateRelease.Size = new System.Drawing.Size(104, 16);
			this.chkGeneralUpdateRelease.TabIndex = 0;
			this.chkGeneralUpdateRelease.Text = "Release";
			this.chkGeneralUpdateRelease.CheckedChanged += new System.EventHandler(this.chkGeneralUpdateRelease_CheckedChanged);
			// 
			// grpGeneralProcessPriority
			// 
			this.grpGeneralProcessPriority.Controls.Add(this.comboGeneralProcessPriority);
			this.grpGeneralProcessPriority.Location = new System.Drawing.Point(432, 152);
			this.grpGeneralProcessPriority.Name = "grpGeneralProcessPriority";
			this.grpGeneralProcessPriority.Size = new System.Drawing.Size(144, 56);
			this.grpGeneralProcessPriority.TabIndex = 23;
			this.grpGeneralProcessPriority.TabStop = false;
			this.grpGeneralProcessPriority.Text = "Process Priority";
			// 
			// comboGeneralProcessPriority
			// 
			this.comboGeneralProcessPriority.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboGeneralProcessPriority.DropDownWidth = 112;
			this.comboGeneralProcessPriority.Items.AddRange(new object[] {
																			 "Normal",
																			 "AboveNormal",
																			 "High",
																			 "RealTime"});
			this.comboGeneralProcessPriority.Location = new System.Drawing.Point(16, 24);
			this.comboGeneralProcessPriority.Name = "comboGeneralProcessPriority";
			this.comboGeneralProcessPriority.Size = new System.Drawing.Size(112, 21);
			this.comboGeneralProcessPriority.TabIndex = 0;
			this.comboGeneralProcessPriority.SelectedIndexChanged += new System.EventHandler(this.comboGeneralProcessPriority_SelectedIndexChanged);
			// 
			// btnWizard
			// 
			this.btnWizard.Image = null;
			this.btnWizard.Location = new System.Drawing.Point(40, 240);
			this.btnWizard.Name = "btnWizard";
			this.btnWizard.TabIndex = 22;
			this.btnWizard.Text = "Wizard...";
			this.toolTip1.SetToolTip(this.btnWizard, "Run the Startup Wizard.");
			this.btnWizard.Click += new System.EventHandler(this.btnWizard_Click);
			// 
			// grpGeneralOptions
			// 
			this.grpGeneralOptions.Controls.Add(this.chkGeneralCustomFilter);
			this.grpGeneralOptions.Controls.Add(this.lblGeneralX2Delay);
			this.grpGeneralOptions.Controls.Add(this.udGeneralX2Delay);
			this.grpGeneralOptions.Controls.Add(this.chkGeneralEnableX2);
			this.grpGeneralOptions.Controls.Add(this.chkGeneralSoftwareGainCorr);
			this.grpGeneralOptions.Controls.Add(this.chkGeneralDisablePTT);
			this.grpGeneralOptions.Controls.Add(this.chkGeneralSpurRed);
			this.grpGeneralOptions.Location = new System.Drawing.Point(176, 152);
			this.grpGeneralOptions.Name = "grpGeneralOptions";
			this.grpGeneralOptions.Size = new System.Drawing.Size(248, 120);
			this.grpGeneralOptions.TabIndex = 6;
			this.grpGeneralOptions.TabStop = false;
			this.grpGeneralOptions.Text = "Options";
			// 
			// chkGeneralCustomFilter
			// 
			this.chkGeneralCustomFilter.Image = null;
			this.chkGeneralCustomFilter.Location = new System.Drawing.Point(128, 80);
			this.chkGeneralCustomFilter.Name = "chkGeneralCustomFilter";
			this.chkGeneralCustomFilter.Size = new System.Drawing.Size(104, 32);
			this.chkGeneralCustomFilter.TabIndex = 10;
			this.chkGeneralCustomFilter.Text = "Enable 300KHz Filter";
			this.chkGeneralCustomFilter.CheckedChanged += new System.EventHandler(this.chkGeneralCustomFilter_CheckedChanged);
			// 
			// lblGeneralX2Delay
			// 
			this.lblGeneralX2Delay.Image = null;
			this.lblGeneralX2Delay.Location = new System.Drawing.Point(128, 56);
			this.lblGeneralX2Delay.Name = "lblGeneralX2Delay";
			this.lblGeneralX2Delay.Size = new System.Drawing.Size(56, 23);
			this.lblGeneralX2Delay.TabIndex = 9;
			this.lblGeneralX2Delay.Text = "X2 Delay:";
			// 
			// udGeneralX2Delay
			// 
			this.udGeneralX2Delay.Enabled = false;
			this.udGeneralX2Delay.Increment = new System.Decimal(new int[] {
																			   1,
																			   0,
																			   0,
																			   0});
			this.udGeneralX2Delay.Location = new System.Drawing.Point(184, 56);
			this.udGeneralX2Delay.Maximum = new System.Decimal(new int[] {
																			 1000,
																			 0,
																			 0,
																			 0});
			this.udGeneralX2Delay.Minimum = new System.Decimal(new int[] {
																			 0,
																			 0,
																			 0,
																			 0});
			this.udGeneralX2Delay.Name = "udGeneralX2Delay";
			this.udGeneralX2Delay.Size = new System.Drawing.Size(48, 20);
			this.udGeneralX2Delay.TabIndex = 8;
			this.udGeneralX2Delay.Value = new System.Decimal(new int[] {
																		   500,
																		   0,
																		   0,
																		   0});
			this.udGeneralX2Delay.ValueChanged += new System.EventHandler(this.udGeneralX2Delay_ValueChanged);
			// 
			// chkGeneralEnableX2
			// 
			this.chkGeneralEnableX2.Image = null;
			this.chkGeneralEnableX2.Location = new System.Drawing.Point(128, 20);
			this.chkGeneralEnableX2.Name = "chkGeneralEnableX2";
			this.chkGeneralEnableX2.Size = new System.Drawing.Size(96, 32);
			this.chkGeneralEnableX2.TabIndex = 7;
			this.chkGeneralEnableX2.Text = "Enable X2 TR Sequencing";
			this.chkGeneralEnableX2.CheckedChanged += new System.EventHandler(this.chkGeneralEnableX2_CheckedChanged);
			// 
			// chkGeneralSoftwareGainCorr
			// 
			this.chkGeneralSoftwareGainCorr.Image = null;
			this.chkGeneralSoftwareGainCorr.Location = new System.Drawing.Point(16, 72);
			this.chkGeneralSoftwareGainCorr.Name = "chkGeneralSoftwareGainCorr";
			this.chkGeneralSoftwareGainCorr.Size = new System.Drawing.Size(112, 32);
			this.chkGeneralSoftwareGainCorr.TabIndex = 6;
			this.chkGeneralSoftwareGainCorr.Text = "Disable Software Gain Correction";
			this.toolTip1.SetToolTip(this.chkGeneralSoftwareGainCorr, "Don\'t compensate in software for hardware gain or attenuation.");
			this.chkGeneralSoftwareGainCorr.CheckedChanged += new System.EventHandler(this.chkGeneralSoftwareGainCorr_CheckedChanged);
			// 
			// chkGeneralDisablePTT
			// 
			this.chkGeneralDisablePTT.Image = null;
			this.chkGeneralDisablePTT.Location = new System.Drawing.Point(16, 48);
			this.chkGeneralDisablePTT.Name = "chkGeneralDisablePTT";
			this.chkGeneralDisablePTT.TabIndex = 4;
			this.chkGeneralDisablePTT.Text = "Disable PTT";
			this.toolTip1.SetToolTip(this.chkGeneralDisablePTT, "Disable Push To Talk detection.");
			this.chkGeneralDisablePTT.CheckedChanged += new System.EventHandler(this.chkGeneralDisablePTT_CheckedChanged);
			// 
			// chkGeneralSpurRed
			// 
			this.chkGeneralSpurRed.Checked = true;
			this.chkGeneralSpurRed.CheckState = System.Windows.Forms.CheckState.Checked;
			this.chkGeneralSpurRed.Image = null;
			this.chkGeneralSpurRed.Location = new System.Drawing.Point(16, 24);
			this.chkGeneralSpurRed.Name = "chkGeneralSpurRed";
			this.chkGeneralSpurRed.TabIndex = 3;
			this.chkGeneralSpurRed.Text = "Spur Reduction";
			this.toolTip1.SetToolTip(this.chkGeneralSpurRed, "Enable Spur Reduction/Avoidance Routine");
			this.chkGeneralSpurRed.CheckedChanged += new System.EventHandler(this.chkGeneralSpurRed_CheckedChanged);
			// 
			// grpGeneralCalibration
			// 
			this.grpGeneralCalibration.Controls.Add(this.btnGeneralCalImageStart);
			this.grpGeneralCalibration.Controls.Add(this.lblGeneralImageNull);
			this.grpGeneralCalibration.Controls.Add(this.btnGeneralCalFreqStart);
			this.grpGeneralCalibration.Controls.Add(this.btnGeneralCalLevelStart);
			this.grpGeneralCalibration.Controls.Add(this.udGeneralCalLevel);
			this.grpGeneralCalibration.Controls.Add(this.lblGeneralCalLevel);
			this.grpGeneralCalibration.Controls.Add(this.udGeneralCalFreq);
			this.grpGeneralCalibration.Controls.Add(this.lblGeneralCalFrequency);
			this.grpGeneralCalibration.Location = new System.Drawing.Point(360, 8);
			this.grpGeneralCalibration.Name = "grpGeneralCalibration";
			this.grpGeneralCalibration.Size = new System.Drawing.Size(216, 136);
			this.grpGeneralCalibration.TabIndex = 5;
			this.grpGeneralCalibration.TabStop = false;
			this.grpGeneralCalibration.Text = "Calibration";
			// 
			// btnGeneralCalImageStart
			// 
			this.btnGeneralCalImageStart.Image = null;
			this.btnGeneralCalImageStart.Location = new System.Drawing.Point(160, 72);
			this.btnGeneralCalImageStart.Name = "btnGeneralCalImageStart";
			this.btnGeneralCalImageStart.Size = new System.Drawing.Size(40, 20);
			this.btnGeneralCalImageStart.TabIndex = 7;
			this.btnGeneralCalImageStart.Text = "Start";
			this.toolTip1.SetToolTip(this.btnGeneralCalImageStart, "Enter the frequency of the signal source above and then click to Start Image Null" +
				" Calibration");
			this.btnGeneralCalImageStart.Click += new System.EventHandler(this.btnGeneralCalImageStart_Click);
			// 
			// lblGeneralImageNull
			// 
			this.lblGeneralImageNull.Image = null;
			this.lblGeneralImageNull.Location = new System.Drawing.Point(16, 72);
			this.lblGeneralImageNull.Name = "lblGeneralImageNull";
			this.lblGeneralImageNull.Size = new System.Drawing.Size(136, 16);
			this.lblGeneralImageNull.TabIndex = 6;
			this.lblGeneralImageNull.Text = "Image Null (above values)";
			// 
			// btnGeneralCalFreqStart
			// 
			this.btnGeneralCalFreqStart.Image = null;
			this.btnGeneralCalFreqStart.Location = new System.Drawing.Point(160, 24);
			this.btnGeneralCalFreqStart.Name = "btnGeneralCalFreqStart";
			this.btnGeneralCalFreqStart.Size = new System.Drawing.Size(40, 20);
			this.btnGeneralCalFreqStart.TabIndex = 5;
			this.btnGeneralCalFreqStart.Text = "Start";
			this.toolTip1.SetToolTip(this.btnGeneralCalFreqStart, "Enter the frequency of your signal source and then click to Start Frequency Calib" +
				"ration");
			this.btnGeneralCalFreqStart.Click += new System.EventHandler(this.btnGeneralCalFreqStart_Click);
			// 
			// btnGeneralCalLevelStart
			// 
			this.btnGeneralCalLevelStart.Image = null;
			this.btnGeneralCalLevelStart.Location = new System.Drawing.Point(160, 48);
			this.btnGeneralCalLevelStart.Name = "btnGeneralCalLevelStart";
			this.btnGeneralCalLevelStart.Size = new System.Drawing.Size(40, 20);
			this.btnGeneralCalLevelStart.TabIndex = 4;
			this.btnGeneralCalLevelStart.Text = "Start";
			this.toolTip1.SetToolTip(this.btnGeneralCalLevelStart, "Tune the signal into the passband, enter the signal level, and then click to Star" +
				"t Signal Level Calibration");
			this.btnGeneralCalLevelStart.Click += new System.EventHandler(this.btnGeneralCalLevelStart_Click);
			// 
			// udGeneralCalLevel
			// 
			this.udGeneralCalLevel.Increment = new System.Decimal(new int[] {
																				10,
																				0,
																				0,
																				0});
			this.udGeneralCalLevel.Location = new System.Drawing.Point(80, 48);
			this.udGeneralCalLevel.Maximum = new System.Decimal(new int[] {
																			  0,
																			  0,
																			  0,
																			  0});
			this.udGeneralCalLevel.Minimum = new System.Decimal(new int[] {
																			  150,
																			  0,
																			  0,
																			  -2147483648});
			this.udGeneralCalLevel.Name = "udGeneralCalLevel";
			this.udGeneralCalLevel.Size = new System.Drawing.Size(72, 20);
			this.udGeneralCalLevel.TabIndex = 3;
			this.toolTip1.SetToolTip(this.udGeneralCalLevel, "Calibration Signal Level");
			this.udGeneralCalLevel.Value = new System.Decimal(new int[] {
																			70,
																			0,
																			0,
																			-2147483648});
			// 
			// lblGeneralCalLevel
			// 
			this.lblGeneralCalLevel.Image = null;
			this.lblGeneralCalLevel.Location = new System.Drawing.Point(16, 48);
			this.lblGeneralCalLevel.Name = "lblGeneralCalLevel";
			this.lblGeneralCalLevel.Size = new System.Drawing.Size(64, 23);
			this.lblGeneralCalLevel.TabIndex = 2;
			this.lblGeneralCalLevel.Text = "Level (dB):";
			// 
			// udGeneralCalFreq
			// 
			this.udGeneralCalFreq.DecimalPlaces = 6;
			this.udGeneralCalFreq.Increment = new System.Decimal(new int[] {
																			   1,
																			   0,
																			   0,
																			   0});
			this.udGeneralCalFreq.Location = new System.Drawing.Point(80, 24);
			this.udGeneralCalFreq.Maximum = new System.Decimal(new int[] {
																			 100,
																			 0,
																			 0,
																			 0});
			this.udGeneralCalFreq.Minimum = new System.Decimal(new int[] {
																			 0,
																			 0,
																			 0,
																			 0});
			this.udGeneralCalFreq.Name = "udGeneralCalFreq";
			this.udGeneralCalFreq.Size = new System.Drawing.Size(72, 20);
			this.udGeneralCalFreq.TabIndex = 1;
			this.toolTip1.SetToolTip(this.udGeneralCalFreq, "Calibration Frequency");
			this.udGeneralCalFreq.Value = new System.Decimal(new int[] {
																		   7,
																		   0,
																		   0,
																		   0});
			// 
			// lblGeneralCalFrequency
			// 
			this.lblGeneralCalFrequency.Image = null;
			this.lblGeneralCalFrequency.Location = new System.Drawing.Point(16, 24);
			this.lblGeneralCalFrequency.Name = "lblGeneralCalFrequency";
			this.lblGeneralCalFrequency.Size = new System.Drawing.Size(64, 23);
			this.lblGeneralCalFrequency.TabIndex = 0;
			this.lblGeneralCalFrequency.Text = "Frequency:";
			// 
			// grpGeneralDDS
			// 
			this.grpGeneralDDS.Controls.Add(this.udDDSCorrection);
			this.grpGeneralDDS.Controls.Add(this.lblClockCorrection);
			this.grpGeneralDDS.Controls.Add(this.udDDSIFFreq);
			this.grpGeneralDDS.Controls.Add(this.lblIFFrequency);
			this.grpGeneralDDS.Controls.Add(this.udDDSPLLMult);
			this.grpGeneralDDS.Controls.Add(this.lblPLLMult);
			this.grpGeneralDDS.Location = new System.Drawing.Point(176, 8);
			this.grpGeneralDDS.Name = "grpGeneralDDS";
			this.grpGeneralDDS.Size = new System.Drawing.Size(176, 136);
			this.grpGeneralDDS.TabIndex = 4;
			this.grpGeneralDDS.TabStop = false;
			this.grpGeneralDDS.Text = "DDS";
			// 
			// udDDSCorrection
			// 
			this.udDDSCorrection.Increment = new System.Decimal(new int[] {
																			  10,
																			  0,
																			  0,
																			  0});
			this.udDDSCorrection.Location = new System.Drawing.Point(104, 24);
			this.udDDSCorrection.Maximum = new System.Decimal(new int[] {
																			1000000,
																			0,
																			0,
																			0});
			this.udDDSCorrection.Minimum = new System.Decimal(new int[] {
																			1000000,
																			0,
																			0,
																			-2147483648});
			this.udDDSCorrection.Name = "udDDSCorrection";
			this.udDDSCorrection.Size = new System.Drawing.Size(64, 20);
			this.udDDSCorrection.TabIndex = 7;
			this.toolTip1.SetToolTip(this.udDDSCorrection, "Correction for DDS frequency");
			this.udDDSCorrection.Value = new System.Decimal(new int[] {
																		  0,
																		  0,
																		  0,
																		  0});
			this.udDDSCorrection.ValueChanged += new System.EventHandler(this.udDDSCorrection_ValueChanged);
			// 
			// lblClockCorrection
			// 
			this.lblClockCorrection.Image = null;
			this.lblClockCorrection.Location = new System.Drawing.Point(16, 24);
			this.lblClockCorrection.Name = "lblClockCorrection";
			this.lblClockCorrection.Size = new System.Drawing.Size(88, 23);
			this.lblClockCorrection.TabIndex = 6;
			this.lblClockCorrection.Text = "Clock Offset:";
			// 
			// udDDSIFFreq
			// 
			this.udDDSIFFreq.Enabled = false;
			this.udDDSIFFreq.Increment = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.udDDSIFFreq.Location = new System.Drawing.Point(112, 72);
			this.udDDSIFFreq.Maximum = new System.Decimal(new int[] {
																		20000,
																		0,
																		0,
																		0});
			this.udDDSIFFreq.Minimum = new System.Decimal(new int[] {
																		0,
																		0,
																		0,
																		0});
			this.udDDSIFFreq.Name = "udDDSIFFreq";
			this.udDDSIFFreq.Size = new System.Drawing.Size(56, 20);
			this.udDDSIFFreq.TabIndex = 5;
			this.toolTip1.SetToolTip(this.udDDSIFFreq, "Intermediate Frequency");
			this.udDDSIFFreq.Value = new System.Decimal(new int[] {
																	  11025,
																	  0,
																	  0,
																	  0});
			this.udDDSIFFreq.ValueChanged += new System.EventHandler(this.udDDSIFFreq_ValueChanged);
			// 
			// lblIFFrequency
			// 
			this.lblIFFrequency.Image = null;
			this.lblIFFrequency.Location = new System.Drawing.Point(16, 72);
			this.lblIFFrequency.Name = "lblIFFrequency";
			this.lblIFFrequency.Size = new System.Drawing.Size(98, 23);
			this.lblIFFrequency.TabIndex = 4;
			this.lblIFFrequency.Text = "IF (Hz):";
			// 
			// udDDSPLLMult
			// 
			this.udDDSPLLMult.Increment = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.udDDSPLLMult.Location = new System.Drawing.Point(120, 48);
			this.udDDSPLLMult.Maximum = new System.Decimal(new int[] {
																		 20,
																		 0,
																		 0,
																		 0});
			this.udDDSPLLMult.Minimum = new System.Decimal(new int[] {
																		 0,
																		 0,
																		 0,
																		 0});
			this.udDDSPLLMult.Name = "udDDSPLLMult";
			this.udDDSPLLMult.Size = new System.Drawing.Size(48, 20);
			this.udDDSPLLMult.TabIndex = 3;
			this.toolTip1.SetToolTip(this.udDDSPLLMult, "Multiplier for external clock (1 if using internal clock)");
			this.udDDSPLLMult.Value = new System.Decimal(new int[] {
																	   1,
																	   0,
																	   0,
																	   0});
			this.udDDSPLLMult.ValueChanged += new System.EventHandler(this.udDDSPLLMult_ValueChanged);
			// 
			// lblPLLMult
			// 
			this.lblPLLMult.Image = null;
			this.lblPLLMult.Location = new System.Drawing.Point(16, 48);
			this.lblPLLMult.Name = "lblPLLMult";
			this.lblPLLMult.Size = new System.Drawing.Size(80, 23);
			this.lblPLLMult.TabIndex = 2;
			this.lblPLLMult.Text = "PLL Multiplier:";
			// 
			// grpGeneralHardwareSetup
			// 
			this.grpGeneralHardwareSetup.Controls.Add(this.chkGeneralRXOnly);
			this.grpGeneralHardwareSetup.Controls.Add(this.chkGeneralUSBPresent);
			this.grpGeneralHardwareSetup.Controls.Add(this.chkGeneralATUPresent);
			this.grpGeneralHardwareSetup.Controls.Add(this.chkGeneralPAPresent);
			this.grpGeneralHardwareSetup.Controls.Add(this.chkGeneralXVTRPresent);
			this.grpGeneralHardwareSetup.Controls.Add(this.lblGeneralLPTDelay);
			this.grpGeneralHardwareSetup.Controls.Add(this.udGeneralLPTDelay);
			this.grpGeneralHardwareSetup.Controls.Add(this.lblGeneralLPTAddr);
			this.grpGeneralHardwareSetup.Controls.Add(this.comboGeneralLPTAddr);
			this.grpGeneralHardwareSetup.Controls.Add(this.chkGeneralRFEPresent);
			this.grpGeneralHardwareSetup.Controls.Add(this.comboGeneralXVTR);
			this.grpGeneralHardwareSetup.Location = new System.Drawing.Point(8, 8);
			this.grpGeneralHardwareSetup.Name = "grpGeneralHardwareSetup";
			this.grpGeneralHardwareSetup.Size = new System.Drawing.Size(160, 224);
			this.grpGeneralHardwareSetup.TabIndex = 1;
			this.grpGeneralHardwareSetup.TabStop = false;
			this.grpGeneralHardwareSetup.Text = "Hardware Setup";
			// 
			// chkGeneralRXOnly
			// 
			this.chkGeneralRXOnly.Image = null;
			this.chkGeneralRXOnly.Location = new System.Drawing.Point(16, 88);
			this.chkGeneralRXOnly.Name = "chkGeneralRXOnly";
			this.chkGeneralRXOnly.Size = new System.Drawing.Size(96, 16);
			this.chkGeneralRXOnly.TabIndex = 11;
			this.chkGeneralRXOnly.Text = "Receive Only";
			this.toolTip1.SetToolTip(this.chkGeneralRXOnly, "Check to disable transmit functionality.");
			this.chkGeneralRXOnly.CheckedChanged += new System.EventHandler(this.chkGeneralRXOnly_CheckedChanged);
			// 
			// chkGeneralUSBPresent
			// 
			this.chkGeneralUSBPresent.Image = null;
			this.chkGeneralUSBPresent.Location = new System.Drawing.Point(16, 104);
			this.chkGeneralUSBPresent.Name = "chkGeneralUSBPresent";
			this.chkGeneralUSBPresent.Size = new System.Drawing.Size(96, 16);
			this.chkGeneralUSBPresent.TabIndex = 10;
			this.chkGeneralUSBPresent.Text = "USB Adapter";
			this.toolTip1.SetToolTip(this.chkGeneralUSBPresent, "Check if the USB adapter is being used.");
			this.chkGeneralUSBPresent.CheckedChanged += new System.EventHandler(this.chkGeneralUSBPresent_CheckedChanged);
			// 
			// chkGeneralATUPresent
			// 
			this.chkGeneralATUPresent.Image = null;
			this.chkGeneralATUPresent.Location = new System.Drawing.Point(16, 152);
			this.chkGeneralATUPresent.Name = "chkGeneralATUPresent";
			this.chkGeneralATUPresent.Size = new System.Drawing.Size(88, 16);
			this.chkGeneralATUPresent.TabIndex = 9;
			this.chkGeneralATUPresent.Text = "ATU Present";
			this.toolTip1.SetToolTip(this.chkGeneralATUPresent, "Check if integrated LDG Z-100 is installed.");
			this.chkGeneralATUPresent.Visible = false;
			this.chkGeneralATUPresent.CheckedChanged += new System.EventHandler(this.chkGeneralATUPresent_CheckedChanged);
			// 
			// chkGeneralPAPresent
			// 
			this.chkGeneralPAPresent.Image = null;
			this.chkGeneralPAPresent.Location = new System.Drawing.Point(16, 136);
			this.chkGeneralPAPresent.Name = "chkGeneralPAPresent";
			this.chkGeneralPAPresent.Size = new System.Drawing.Size(88, 16);
			this.chkGeneralPAPresent.TabIndex = 8;
			this.chkGeneralPAPresent.Text = "PA Present";
			this.toolTip1.SetToolTip(this.chkGeneralPAPresent, "Check if FlexRadio Systems 100W PA is installed.");
			this.chkGeneralPAPresent.Visible = false;
			this.chkGeneralPAPresent.CheckedChanged += new System.EventHandler(this.chkGeneralPAPresent_CheckedChanged);
			// 
			// chkGeneralXVTRPresent
			// 
			this.chkGeneralXVTRPresent.Image = null;
			this.chkGeneralXVTRPresent.Location = new System.Drawing.Point(16, 168);
			this.chkGeneralXVTRPresent.Name = "chkGeneralXVTRPresent";
			this.chkGeneralXVTRPresent.Size = new System.Drawing.Size(104, 16);
			this.chkGeneralXVTRPresent.TabIndex = 7;
			this.chkGeneralXVTRPresent.Text = "XVTR Present";
			this.toolTip1.SetToolTip(this.chkGeneralXVTRPresent, "Check if DEMI XVTR is installed.");
			this.chkGeneralXVTRPresent.Visible = false;
			this.chkGeneralXVTRPresent.CheckedChanged += new System.EventHandler(this.chkXVTRPresent_CheckedChanged);
			// 
			// lblGeneralLPTDelay
			// 
			this.lblGeneralLPTDelay.Image = null;
			this.lblGeneralLPTDelay.Location = new System.Drawing.Point(16, 56);
			this.lblGeneralLPTDelay.Name = "lblGeneralLPTDelay";
			this.lblGeneralLPTDelay.Size = new System.Drawing.Size(80, 16);
			this.lblGeneralLPTDelay.TabIndex = 6;
			this.lblGeneralLPTDelay.Text = "LPT Delay:";
			// 
			// udGeneralLPTDelay
			// 
			this.udGeneralLPTDelay.Increment = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.udGeneralLPTDelay.Location = new System.Drawing.Point(96, 56);
			this.udGeneralLPTDelay.Maximum = new System.Decimal(new int[] {
																			  100,
																			  0,
																			  0,
																			  0});
			this.udGeneralLPTDelay.Minimum = new System.Decimal(new int[] {
																			  0,
																			  0,
																			  0,
																			  0});
			this.udGeneralLPTDelay.Name = "udGeneralLPTDelay";
			this.udGeneralLPTDelay.Size = new System.Drawing.Size(56, 20);
			this.udGeneralLPTDelay.TabIndex = 5;
			this.toolTip1.SetToolTip(this.udGeneralLPTDelay, "Delay to compensate for longer Parallel cables.");
			this.udGeneralLPTDelay.Value = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
			this.udGeneralLPTDelay.ValueChanged += new System.EventHandler(this.udGeneralLPTDelay_ValueChanged);
			// 
			// lblGeneralLPTAddr
			// 
			this.lblGeneralLPTAddr.Image = null;
			this.lblGeneralLPTAddr.Location = new System.Drawing.Point(16, 24);
			this.lblGeneralLPTAddr.Name = "lblGeneralLPTAddr";
			this.lblGeneralLPTAddr.Size = new System.Drawing.Size(80, 16);
			this.lblGeneralLPTAddr.TabIndex = 3;
			this.lblGeneralLPTAddr.Text = "LPT Address:";
			// 
			// comboGeneralLPTAddr
			// 
			this.comboGeneralLPTAddr.DropDownWidth = 56;
			this.comboGeneralLPTAddr.Items.AddRange(new object[] {
																	 "278",
																	 "378",
																	 "3BC",
																	 "B800",
																	 "BC00"});
			this.comboGeneralLPTAddr.Location = new System.Drawing.Point(96, 24);
			this.comboGeneralLPTAddr.Name = "comboGeneralLPTAddr";
			this.comboGeneralLPTAddr.Size = new System.Drawing.Size(56, 21);
			this.comboGeneralLPTAddr.TabIndex = 0;
			this.comboGeneralLPTAddr.Text = "378";
			this.toolTip1.SetToolTip(this.comboGeneralLPTAddr, "Parallel Port Address");
			this.comboGeneralLPTAddr.KeyDown += new System.Windows.Forms.KeyEventHandler(this.comboGeneralLPTAddr_KeyDown);
			this.comboGeneralLPTAddr.LostFocus += new System.EventHandler(this.comboGeneralLPTAddr_LostFocus);
			this.comboGeneralLPTAddr.SelectedIndexChanged += new System.EventHandler(this.comboGeneralLPTAddr_SelectedIndexChanged);
			// 
			// chkGeneralRFEPresent
			// 
			this.chkGeneralRFEPresent.Image = null;
			this.chkGeneralRFEPresent.Location = new System.Drawing.Point(16, 120);
			this.chkGeneralRFEPresent.Name = "chkGeneralRFEPresent";
			this.chkGeneralRFEPresent.Size = new System.Drawing.Size(88, 16);
			this.chkGeneralRFEPresent.TabIndex = 2;
			this.chkGeneralRFEPresent.Text = "RFE Present";
			this.toolTip1.SetToolTip(this.chkGeneralRFEPresent, "Check if the RFE board is installed.");
			this.chkGeneralRFEPresent.CheckedChanged += new System.EventHandler(this.chkGeneralRFEPresent_CheckedChanged);
			// 
			// comboGeneralXVTR
			// 
			this.comboGeneralXVTR.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboGeneralXVTR.DropDownWidth = 136;
			this.comboGeneralXVTR.Items.AddRange(new object[] {
																  "Negative TR Logic",
																  "Positive TR Logic",
																  "No TR Logic"});
			this.comboGeneralXVTR.Location = new System.Drawing.Point(16, 192);
			this.comboGeneralXVTR.Name = "comboGeneralXVTR";
			this.comboGeneralXVTR.Size = new System.Drawing.Size(136, 21);
			this.comboGeneralXVTR.TabIndex = 5;
			this.toolTip1.SetToolTip(this.comboGeneralXVTR, "XVTR TR Logic Selection -- Negative for XVTR FlexRadio Systems provides.  Positiv" +
				"e for 25W version.  No TR logic for other XVTRs.");
			this.comboGeneralXVTR.Visible = false;
			this.comboGeneralXVTR.SelectedIndexChanged += new System.EventHandler(this.comboGeneralXVTR_SelectedIndexChanged);
			// 
			// tpAudio
			// 
			this.tpAudio.Controls.Add(this.btnAudioCalSecondSoundCard);
			this.tpAudio.Controls.Add(this.grpAudioLineInGain);
			this.tpAudio.Controls.Add(this.grpAudioVoltage);
			this.tpAudio.Controls.Add(this.grpAudioDetails1);
			this.tpAudio.Controls.Add(this.comboAudioDetailSel);
			this.tpAudio.Controls.Add(this.lblAudioShowDetails);
			this.tpAudio.Controls.Add(this.grpAudioLatency);
			this.tpAudio.Controls.Add(this.grpAudioDetails2);
			this.tpAudio.Controls.Add(this.grpAudioCard);
			this.tpAudio.Controls.Add(this.grpAudioBufferSize);
			this.tpAudio.Controls.Add(this.grpAudioSampleRate);
			this.tpAudio.Controls.Add(this.chkAudioEnableSoundCard2);
			this.tpAudio.Location = new System.Drawing.Point(4, 22);
			this.tpAudio.Name = "tpAudio";
			this.tpAudio.Size = new System.Drawing.Size(584, 286);
			this.tpAudio.TabIndex = 0;
			this.tpAudio.Text = "Audio";
			// 
			// btnAudioCalSecondSoundCard
			// 
			this.btnAudioCalSecondSoundCard.Enabled = false;
			this.btnAudioCalSecondSoundCard.Image = null;
			this.btnAudioCalSecondSoundCard.Location = new System.Drawing.Point(392, 8);
			this.btnAudioCalSecondSoundCard.Name = "btnAudioCalSecondSoundCard";
			this.btnAudioCalSecondSoundCard.Size = new System.Drawing.Size(64, 23);
			this.btnAudioCalSecondSoundCard.TabIndex = 34;
			this.btnAudioCalSecondSoundCard.Text = "Calibrate";
			this.toolTip1.SetToolTip(this.btnAudioCalSecondSoundCard, "Outputs a full scale sinewave at the CW pitch for determining the RMS Voltage of " +
				"the sound card.");
			this.btnAudioCalSecondSoundCard.Click += new System.EventHandler(this.btnAudioCalSecondSoundCard_Click);
			// 
			// grpAudioLineInGain
			// 
			this.grpAudioLineInGain.Controls.Add(this.udAudioLineIn2);
			this.grpAudioLineInGain.Controls.Add(this.lblAudioLineIn2);
			this.grpAudioLineInGain.Controls.Add(this.lblAudioLineIn1);
			this.grpAudioLineInGain.Controls.Add(this.udAudioLineIn1);
			this.grpAudioLineInGain.Location = new System.Drawing.Point(440, 40);
			this.grpAudioLineInGain.Name = "grpAudioLineInGain";
			this.grpAudioLineInGain.Size = new System.Drawing.Size(88, 112);
			this.grpAudioLineInGain.TabIndex = 33;
			this.grpAudioLineInGain.TabStop = false;
			this.grpAudioLineInGain.Text = "Line In Gain";
			// 
			// udAudioLineIn2
			// 
			this.udAudioLineIn2.Enabled = false;
			this.udAudioLineIn2.Increment = new System.Decimal(new int[] {
																			 1,
																			 0,
																			 0,
																			 0});
			this.udAudioLineIn2.Location = new System.Drawing.Point(16, 80);
			this.udAudioLineIn2.Maximum = new System.Decimal(new int[] {
																		   100,
																		   0,
																		   0,
																		   0});
			this.udAudioLineIn2.Minimum = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.udAudioLineIn2.Name = "udAudioLineIn2";
			this.udAudioLineIn2.Size = new System.Drawing.Size(40, 20);
			this.udAudioLineIn2.TabIndex = 55;
			this.toolTip1.SetToolTip(this.udAudioLineIn2, "IF Gain - Input Volume");
			this.udAudioLineIn2.Value = new System.Decimal(new int[] {
																		 20,
																		 0,
																		 0,
																		 0});
			this.udAudioLineIn2.ValueChanged += new System.EventHandler(this.udAudioLineIn2_ValueChanged);
			// 
			// lblAudioLineIn2
			// 
			this.lblAudioLineIn2.Image = null;
			this.lblAudioLineIn2.Location = new System.Drawing.Point(16, 64);
			this.lblAudioLineIn2.Name = "lblAudioLineIn2";
			this.lblAudioLineIn2.Size = new System.Drawing.Size(48, 16);
			this.lblAudioLineIn2.TabIndex = 54;
			this.lblAudioLineIn2.Text = "Card 2:";
			// 
			// lblAudioLineIn1
			// 
			this.lblAudioLineIn1.Image = null;
			this.lblAudioLineIn1.Location = new System.Drawing.Point(16, 24);
			this.lblAudioLineIn1.Name = "lblAudioLineIn1";
			this.lblAudioLineIn1.Size = new System.Drawing.Size(48, 16);
			this.lblAudioLineIn1.TabIndex = 53;
			this.lblAudioLineIn1.Text = "Card 1:";
			// 
			// udAudioLineIn1
			// 
			this.udAudioLineIn1.Increment = new System.Decimal(new int[] {
																			 1,
																			 0,
																			 0,
																			 0});
			this.udAudioLineIn1.Location = new System.Drawing.Point(16, 40);
			this.udAudioLineIn1.Maximum = new System.Decimal(new int[] {
																		   100,
																		   0,
																		   0,
																		   0});
			this.udAudioLineIn1.Minimum = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.udAudioLineIn1.Name = "udAudioLineIn1";
			this.udAudioLineIn1.Size = new System.Drawing.Size(40, 20);
			this.udAudioLineIn1.TabIndex = 51;
			this.toolTip1.SetToolTip(this.udAudioLineIn1, "IF Gain - Input Volume");
			this.udAudioLineIn1.Value = new System.Decimal(new int[] {
																		 20,
																		 0,
																		 0,
																		 0});
			this.udAudioLineIn1.ValueChanged += new System.EventHandler(this.udAudioLineIn1_ValueChanged);
			// 
			// grpAudioVoltage
			// 
			this.grpAudioVoltage.Controls.Add(this.btnAudioVoltTest2);
			this.grpAudioVoltage.Controls.Add(this.udAudioVoltage2);
			this.grpAudioVoltage.Controls.Add(this.lblAudioVoltage2);
			this.grpAudioVoltage.Controls.Add(this.btnAudioVoltTest1);
			this.grpAudioVoltage.Controls.Add(this.udAudioVoltage1);
			this.grpAudioVoltage.Controls.Add(this.lblAudioVoltage1);
			this.grpAudioVoltage.Location = new System.Drawing.Point(344, 176);
			this.grpAudioVoltage.Name = "grpAudioVoltage";
			this.grpAudioVoltage.Size = new System.Drawing.Size(216, 96);
			this.grpAudioVoltage.TabIndex = 32;
			this.grpAudioVoltage.TabStop = false;
			this.grpAudioVoltage.Text = "Sound Card Output Voltage";
			// 
			// btnAudioVoltTest2
			// 
			this.btnAudioVoltTest2.Enabled = false;
			this.btnAudioVoltTest2.Image = null;
			this.btnAudioVoltTest2.Location = new System.Drawing.Point(120, 56);
			this.btnAudioVoltTest2.Name = "btnAudioVoltTest2";
			this.btnAudioVoltTest2.Size = new System.Drawing.Size(56, 23);
			this.btnAudioVoltTest2.TabIndex = 5;
			this.btnAudioVoltTest2.Text = "Test";
			this.toolTip1.SetToolTip(this.btnAudioVoltTest2, "Outputs a full scale sinewave at the CW pitch for determining the RMS Voltage of " +
				"the second sound card.");
			this.btnAudioVoltTest2.Click += new System.EventHandler(this.btnAudioVoltTest2_Click);
			// 
			// udAudioVoltage2
			// 
			this.udAudioVoltage2.DecimalPlaces = 2;
			this.udAudioVoltage2.Enabled = false;
			this.udAudioVoltage2.Increment = new System.Decimal(new int[] {
																			  1,
																			  0,
																			  0,
																			  131072});
			this.udAudioVoltage2.Location = new System.Drawing.Point(64, 56);
			this.udAudioVoltage2.Maximum = new System.Decimal(new int[] {
																			100,
																			0,
																			0,
																			0});
			this.udAudioVoltage2.Minimum = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
			this.udAudioVoltage2.Name = "udAudioVoltage2";
			this.udAudioVoltage2.Size = new System.Drawing.Size(48, 20);
			this.udAudioVoltage2.TabIndex = 4;
			this.udAudioVoltage2.Value = new System.Decimal(new int[] {
																		  223,
																		  0,
																		  0,
																		  131072});
			this.udAudioVoltage2.ValueChanged += new System.EventHandler(this.udAudioVoltage2_ValueChanged);
			// 
			// lblAudioVoltage2
			// 
			this.lblAudioVoltage2.Image = null;
			this.lblAudioVoltage2.Location = new System.Drawing.Point(16, 56);
			this.lblAudioVoltage2.Name = "lblAudioVoltage2";
			this.lblAudioVoltage2.Size = new System.Drawing.Size(48, 16);
			this.lblAudioVoltage2.TabIndex = 3;
			this.lblAudioVoltage2.Text = "Card 2:";
			// 
			// btnAudioVoltTest1
			// 
			this.btnAudioVoltTest1.Image = null;
			this.btnAudioVoltTest1.Location = new System.Drawing.Point(120, 24);
			this.btnAudioVoltTest1.Name = "btnAudioVoltTest1";
			this.btnAudioVoltTest1.Size = new System.Drawing.Size(56, 23);
			this.btnAudioVoltTest1.TabIndex = 2;
			this.btnAudioVoltTest1.Text = "Test";
			this.toolTip1.SetToolTip(this.btnAudioVoltTest1, "Outputs a full scale sinewave at the CW pitch for determining the RMS Voltage of " +
				"the sound card.");
			this.btnAudioVoltTest1.Click += new System.EventHandler(this.btnAudioVoltTest1_Click);
			// 
			// udAudioVoltage1
			// 
			this.udAudioVoltage1.DecimalPlaces = 2;
			this.udAudioVoltage1.Increment = new System.Decimal(new int[] {
																			  1,
																			  0,
																			  0,
																			  131072});
			this.udAudioVoltage1.Location = new System.Drawing.Point(64, 24);
			this.udAudioVoltage1.Maximum = new System.Decimal(new int[] {
																			100,
																			0,
																			0,
																			0});
			this.udAudioVoltage1.Minimum = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
			this.udAudioVoltage1.Name = "udAudioVoltage1";
			this.udAudioVoltage1.Size = new System.Drawing.Size(48, 20);
			this.udAudioVoltage1.TabIndex = 1;
			this.toolTip1.SetToolTip(this.udAudioVoltage1, "The measured VRMS on the sound card output when outputting a full range tone.");
			this.udAudioVoltage1.Value = new System.Decimal(new int[] {
																		  223,
																		  0,
																		  0,
																		  131072});
			this.udAudioVoltage1.ValueChanged += new System.EventHandler(this.udAudioVoltage1_ValueChanged);
			// 
			// lblAudioVoltage1
			// 
			this.lblAudioVoltage1.Image = null;
			this.lblAudioVoltage1.Location = new System.Drawing.Point(16, 24);
			this.lblAudioVoltage1.Name = "lblAudioVoltage1";
			this.lblAudioVoltage1.Size = new System.Drawing.Size(48, 16);
			this.lblAudioVoltage1.TabIndex = 0;
			this.lblAudioVoltage1.Text = "Card 1:";
			// 
			// grpAudioDetails1
			// 
			this.grpAudioDetails1.Controls.Add(this.comboAudioTransmit1);
			this.grpAudioDetails1.Controls.Add(this.lblAudioMixer1);
			this.grpAudioDetails1.Controls.Add(this.lblAudioOutput1);
			this.grpAudioDetails1.Controls.Add(this.comboAudioOutput1);
			this.grpAudioDetails1.Controls.Add(this.lblAudioInput1);
			this.grpAudioDetails1.Controls.Add(this.lblAudioDriver1);
			this.grpAudioDetails1.Controls.Add(this.comboAudioInput1);
			this.grpAudioDetails1.Controls.Add(this.comboAudioDriver1);
			this.grpAudioDetails1.Controls.Add(this.comboAudioMixer1);
			this.grpAudioDetails1.Controls.Add(this.lblAudioTransmit1);
			this.grpAudioDetails1.Controls.Add(this.lblAudioReceive1);
			this.grpAudioDetails1.Controls.Add(this.comboAudioReceive1);
			this.grpAudioDetails1.Location = new System.Drawing.Point(8, 64);
			this.grpAudioDetails1.Name = "grpAudioDetails1";
			this.grpAudioDetails1.Size = new System.Drawing.Size(224, 216);
			this.grpAudioDetails1.TabIndex = 15;
			this.grpAudioDetails1.TabStop = false;
			this.grpAudioDetails1.Text = "Primary Sound Card Setup Details";
			// 
			// comboAudioTransmit1
			// 
			this.comboAudioTransmit1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioTransmit1.DropDownWidth = 160;
			this.comboAudioTransmit1.ItemHeight = 13;
			this.comboAudioTransmit1.Location = new System.Drawing.Point(56, 184);
			this.comboAudioTransmit1.Name = "comboAudioTransmit1";
			this.comboAudioTransmit1.Size = new System.Drawing.Size(160, 21);
			this.comboAudioTransmit1.TabIndex = 2;
			this.toolTip1.SetToolTip(this.comboAudioTransmit1, "Transmit mode mixer MUX setting.");
			this.comboAudioTransmit1.SelectedIndexChanged += new System.EventHandler(this.comboAudioTransmit1_SelectedIndexChanged);
			// 
			// lblAudioMixer1
			// 
			this.lblAudioMixer1.Image = null;
			this.lblAudioMixer1.Location = new System.Drawing.Point(8, 120);
			this.lblAudioMixer1.Name = "lblAudioMixer1";
			this.lblAudioMixer1.Size = new System.Drawing.Size(48, 23);
			this.lblAudioMixer1.TabIndex = 22;
			this.lblAudioMixer1.Text = "Mixer:";
			// 
			// lblAudioOutput1
			// 
			this.lblAudioOutput1.Image = null;
			this.lblAudioOutput1.Location = new System.Drawing.Point(8, 88);
			this.lblAudioOutput1.Name = "lblAudioOutput1";
			this.lblAudioOutput1.Size = new System.Drawing.Size(48, 16);
			this.lblAudioOutput1.TabIndex = 6;
			this.lblAudioOutput1.Text = "Output:";
			// 
			// comboAudioOutput1
			// 
			this.comboAudioOutput1.DisplayMember = "sdfg";
			this.comboAudioOutput1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioOutput1.DropDownWidth = 160;
			this.comboAudioOutput1.ItemHeight = 13;
			this.comboAudioOutput1.Location = new System.Drawing.Point(56, 88);
			this.comboAudioOutput1.Name = "comboAudioOutput1";
			this.comboAudioOutput1.Size = new System.Drawing.Size(160, 21);
			this.comboAudioOutput1.TabIndex = 5;
			this.toolTip1.SetToolTip(this.comboAudioOutput1, "Output Audio Device");
			this.comboAudioOutput1.SelectedIndexChanged += new System.EventHandler(this.comboAudioOutput1_SelectedIndexChanged);
			// 
			// lblAudioInput1
			// 
			this.lblAudioInput1.Image = null;
			this.lblAudioInput1.Location = new System.Drawing.Point(8, 56);
			this.lblAudioInput1.Name = "lblAudioInput1";
			this.lblAudioInput1.Size = new System.Drawing.Size(48, 16);
			this.lblAudioInput1.TabIndex = 4;
			this.lblAudioInput1.Text = "Input:";
			// 
			// lblAudioDriver1
			// 
			this.lblAudioDriver1.Image = null;
			this.lblAudioDriver1.Location = new System.Drawing.Point(8, 24);
			this.lblAudioDriver1.Name = "lblAudioDriver1";
			this.lblAudioDriver1.Size = new System.Drawing.Size(48, 16);
			this.lblAudioDriver1.TabIndex = 3;
			this.lblAudioDriver1.Text = "Driver:";
			// 
			// comboAudioInput1
			// 
			this.comboAudioInput1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioInput1.DropDownWidth = 160;
			this.comboAudioInput1.ItemHeight = 13;
			this.comboAudioInput1.Location = new System.Drawing.Point(56, 56);
			this.comboAudioInput1.Name = "comboAudioInput1";
			this.comboAudioInput1.Size = new System.Drawing.Size(160, 21);
			this.comboAudioInput1.TabIndex = 1;
			this.toolTip1.SetToolTip(this.comboAudioInput1, "Input Audio Device");
			this.comboAudioInput1.SelectedIndexChanged += new System.EventHandler(this.comboAudioInput1_SelectedIndexChanged);
			// 
			// comboAudioDriver1
			// 
			this.comboAudioDriver1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioDriver1.DropDownWidth = 160;
			this.comboAudioDriver1.ItemHeight = 13;
			this.comboAudioDriver1.Location = new System.Drawing.Point(56, 24);
			this.comboAudioDriver1.Name = "comboAudioDriver1";
			this.comboAudioDriver1.Size = new System.Drawing.Size(160, 21);
			this.comboAudioDriver1.TabIndex = 0;
			this.toolTip1.SetToolTip(this.comboAudioDriver1, "Sound Card Driver Selection");
			this.comboAudioDriver1.SelectedIndexChanged += new System.EventHandler(this.comboAudioDriver1_SelectedIndexChanged);
			// 
			// comboAudioMixer1
			// 
			this.comboAudioMixer1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioMixer1.DropDownWidth = 160;
			this.comboAudioMixer1.ItemHeight = 13;
			this.comboAudioMixer1.Location = new System.Drawing.Point(56, 120);
			this.comboAudioMixer1.Name = "comboAudioMixer1";
			this.comboAudioMixer1.Size = new System.Drawing.Size(160, 21);
			this.comboAudioMixer1.TabIndex = 21;
			this.toolTip1.SetToolTip(this.comboAudioMixer1, "Audio Mixer Device ");
			this.comboAudioMixer1.SelectedIndexChanged += new System.EventHandler(this.comboAudioMixer1_SelectedIndexChanged);
			// 
			// lblAudioTransmit1
			// 
			this.lblAudioTransmit1.Image = null;
			this.lblAudioTransmit1.Location = new System.Drawing.Point(8, 184);
			this.lblAudioTransmit1.Name = "lblAudioTransmit1";
			this.lblAudioTransmit1.Size = new System.Drawing.Size(56, 16);
			this.lblAudioTransmit1.TabIndex = 3;
			this.lblAudioTransmit1.Text = "Transmit:";
			// 
			// lblAudioReceive1
			// 
			this.lblAudioReceive1.Image = null;
			this.lblAudioReceive1.Location = new System.Drawing.Point(8, 152);
			this.lblAudioReceive1.Name = "lblAudioReceive1";
			this.lblAudioReceive1.Size = new System.Drawing.Size(48, 16);
			this.lblAudioReceive1.TabIndex = 1;
			this.lblAudioReceive1.Text = "Receive:";
			// 
			// comboAudioReceive1
			// 
			this.comboAudioReceive1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioReceive1.DropDownWidth = 160;
			this.comboAudioReceive1.ItemHeight = 13;
			this.comboAudioReceive1.Location = new System.Drawing.Point(56, 152);
			this.comboAudioReceive1.Name = "comboAudioReceive1";
			this.comboAudioReceive1.Size = new System.Drawing.Size(160, 21);
			this.comboAudioReceive1.TabIndex = 0;
			this.toolTip1.SetToolTip(this.comboAudioReceive1, "Receive mode Mixer MUX setting");
			this.comboAudioReceive1.SelectedIndexChanged += new System.EventHandler(this.comboAudioReceive1_SelectedIndexChanged);
			// 
			// comboAudioDetailSel
			// 
			this.comboAudioDetailSel.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioDetailSel.DropDownWidth = 80;
			this.comboAudioDetailSel.Enabled = false;
			this.comboAudioDetailSel.Items.AddRange(new object[] {
																	 "Card #1",
																	 "Card #2"});
			this.comboAudioDetailSel.Location = new System.Drawing.Point(248, 48);
			this.comboAudioDetailSel.Name = "comboAudioDetailSel";
			this.comboAudioDetailSel.Size = new System.Drawing.Size(80, 21);
			this.comboAudioDetailSel.TabIndex = 30;
			this.comboAudioDetailSel.SelectedIndexChanged += new System.EventHandler(this.comboAudioDetailSel_SelectedIndexChanged);
			// 
			// lblAudioShowDetails
			// 
			this.lblAudioShowDetails.Image = null;
			this.lblAudioShowDetails.Location = new System.Drawing.Point(248, 32);
			this.lblAudioShowDetails.Name = "lblAudioShowDetails";
			this.lblAudioShowDetails.Size = new System.Drawing.Size(88, 16);
			this.lblAudioShowDetails.TabIndex = 31;
			this.lblAudioShowDetails.Text = "Show details for:";
			// 
			// grpAudioLatency
			// 
			this.grpAudioLatency.Controls.Add(this.chkAudioLatencyManual);
			this.grpAudioLatency.Controls.Add(this.lblAudioLatency2);
			this.grpAudioLatency.Controls.Add(this.lblAudioLatency1);
			this.grpAudioLatency.Controls.Add(this.udAudioLatency2);
			this.grpAudioLatency.Controls.Add(this.udAudioLatency1);
			this.grpAudioLatency.Location = new System.Drawing.Point(344, 40);
			this.grpAudioLatency.Name = "grpAudioLatency";
			this.grpAudioLatency.Size = new System.Drawing.Size(88, 136);
			this.grpAudioLatency.TabIndex = 29;
			this.grpAudioLatency.TabStop = false;
			this.grpAudioLatency.Text = "Latency (ms)";
			// 
			// chkAudioLatencyManual
			// 
			this.chkAudioLatencyManual.Image = null;
			this.chkAudioLatencyManual.Location = new System.Drawing.Point(16, 24);
			this.chkAudioLatencyManual.Name = "chkAudioLatencyManual";
			this.chkAudioLatencyManual.Size = new System.Drawing.Size(64, 24);
			this.chkAudioLatencyManual.TabIndex = 5;
			this.chkAudioLatencyManual.Text = "Manual";
			this.chkAudioLatencyManual.CheckedChanged += new System.EventHandler(this.chkAudioLatencyManual_CheckedChanged);
			// 
			// lblAudioLatency2
			// 
			this.lblAudioLatency2.Image = null;
			this.lblAudioLatency2.Location = new System.Drawing.Point(16, 88);
			this.lblAudioLatency2.Name = "lblAudioLatency2";
			this.lblAudioLatency2.Size = new System.Drawing.Size(48, 16);
			this.lblAudioLatency2.TabIndex = 4;
			this.lblAudioLatency2.Text = "Card 2:";
			// 
			// lblAudioLatency1
			// 
			this.lblAudioLatency1.Image = null;
			this.lblAudioLatency1.Location = new System.Drawing.Point(16, 48);
			this.lblAudioLatency1.Name = "lblAudioLatency1";
			this.lblAudioLatency1.Size = new System.Drawing.Size(48, 16);
			this.lblAudioLatency1.TabIndex = 2;
			this.lblAudioLatency1.Text = "Card 1:";
			// 
			// udAudioLatency2
			// 
			this.udAudioLatency2.Enabled = false;
			this.udAudioLatency2.Increment = new System.Decimal(new int[] {
																			  1,
																			  0,
																			  0,
																			  0});
			this.udAudioLatency2.Location = new System.Drawing.Point(16, 104);
			this.udAudioLatency2.Maximum = new System.Decimal(new int[] {
																			240,
																			0,
																			0,
																			0});
			this.udAudioLatency2.Minimum = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
			this.udAudioLatency2.Name = "udAudioLatency2";
			this.udAudioLatency2.Size = new System.Drawing.Size(48, 20);
			this.udAudioLatency2.TabIndex = 1;
			this.udAudioLatency2.Value = new System.Decimal(new int[] {
																		  120,
																		  0,
																		  0,
																		  0});
			this.udAudioLatency2.ValueChanged += new System.EventHandler(this.udAudioLatency2_ValueChanged);
			// 
			// udAudioLatency1
			// 
			this.udAudioLatency1.Enabled = false;
			this.udAudioLatency1.Increment = new System.Decimal(new int[] {
																			  1,
																			  0,
																			  0,
																			  0});
			this.udAudioLatency1.Location = new System.Drawing.Point(16, 64);
			this.udAudioLatency1.Maximum = new System.Decimal(new int[] {
																			240,
																			0,
																			0,
																			0});
			this.udAudioLatency1.Minimum = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
			this.udAudioLatency1.Name = "udAudioLatency1";
			this.udAudioLatency1.Size = new System.Drawing.Size(48, 20);
			this.udAudioLatency1.TabIndex = 0;
			this.toolTip1.SetToolTip(this.udAudioLatency1, "Adds latency/stability to the audio subsystem.");
			this.udAudioLatency1.Value = new System.Decimal(new int[] {
																		  120,
																		  0,
																		  0,
																		  0});
			this.udAudioLatency1.ValueChanged += new System.EventHandler(this.udAudioLatency1_ValueChanged);
			// 
			// grpAudioDetails2
			// 
			this.grpAudioDetails2.Controls.Add(this.comboAudioTransmit2);
			this.grpAudioDetails2.Controls.Add(this.lblAudioOutput2);
			this.grpAudioDetails2.Controls.Add(this.comboAudioOutput2);
			this.grpAudioDetails2.Controls.Add(this.lblAudioInput2);
			this.grpAudioDetails2.Controls.Add(this.lblAudioDriver2);
			this.grpAudioDetails2.Controls.Add(this.comboAudioInput2);
			this.grpAudioDetails2.Controls.Add(this.comboAudioDriver2);
			this.grpAudioDetails2.Controls.Add(this.lblAudioTransmit2);
			this.grpAudioDetails2.Controls.Add(this.lblAudioReceive2);
			this.grpAudioDetails2.Controls.Add(this.comboAudioReceive2);
			this.grpAudioDetails2.Controls.Add(this.lblAudioMixer2);
			this.grpAudioDetails2.Controls.Add(this.comboAudioMixer2);
			this.grpAudioDetails2.Location = new System.Drawing.Point(8, 64);
			this.grpAudioDetails2.Name = "grpAudioDetails2";
			this.grpAudioDetails2.Size = new System.Drawing.Size(224, 216);
			this.grpAudioDetails2.TabIndex = 28;
			this.grpAudioDetails2.TabStop = false;
			this.grpAudioDetails2.Text = "Second Sound Card Setup";
			this.grpAudioDetails2.Visible = false;
			// 
			// comboAudioTransmit2
			// 
			this.comboAudioTransmit2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioTransmit2.DropDownWidth = 160;
			this.comboAudioTransmit2.Enabled = false;
			this.comboAudioTransmit2.ItemHeight = 13;
			this.comboAudioTransmit2.Location = new System.Drawing.Point(56, 184);
			this.comboAudioTransmit2.Name = "comboAudioTransmit2";
			this.comboAudioTransmit2.Size = new System.Drawing.Size(160, 21);
			this.comboAudioTransmit2.TabIndex = 30;
			this.toolTip1.SetToolTip(this.comboAudioTransmit2, "Transmit mode mixer MUX setting.");
			this.comboAudioTransmit2.SelectedIndexChanged += new System.EventHandler(this.comboAudioTransmit2_SelectedIndexChanged);
			// 
			// lblAudioOutput2
			// 
			this.lblAudioOutput2.Image = null;
			this.lblAudioOutput2.Location = new System.Drawing.Point(8, 88);
			this.lblAudioOutput2.Name = "lblAudioOutput2";
			this.lblAudioOutput2.Size = new System.Drawing.Size(48, 16);
			this.lblAudioOutput2.TabIndex = 35;
			this.lblAudioOutput2.Text = "Output:";
			// 
			// comboAudioOutput2
			// 
			this.comboAudioOutput2.DisplayMember = "sdfg";
			this.comboAudioOutput2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioOutput2.DropDownWidth = 160;
			this.comboAudioOutput2.Enabled = false;
			this.comboAudioOutput2.ItemHeight = 13;
			this.comboAudioOutput2.Location = new System.Drawing.Point(56, 88);
			this.comboAudioOutput2.Name = "comboAudioOutput2";
			this.comboAudioOutput2.Size = new System.Drawing.Size(160, 21);
			this.comboAudioOutput2.TabIndex = 34;
			this.toolTip1.SetToolTip(this.comboAudioOutput2, "Output Audio Device");
			this.comboAudioOutput2.SelectedIndexChanged += new System.EventHandler(this.comboAudioOutput2_SelectedIndexChanged);
			// 
			// lblAudioInput2
			// 
			this.lblAudioInput2.Image = null;
			this.lblAudioInput2.Location = new System.Drawing.Point(8, 56);
			this.lblAudioInput2.Name = "lblAudioInput2";
			this.lblAudioInput2.Size = new System.Drawing.Size(40, 16);
			this.lblAudioInput2.TabIndex = 33;
			this.lblAudioInput2.Text = "Input:";
			// 
			// lblAudioDriver2
			// 
			this.lblAudioDriver2.Image = null;
			this.lblAudioDriver2.Location = new System.Drawing.Point(8, 24);
			this.lblAudioDriver2.Name = "lblAudioDriver2";
			this.lblAudioDriver2.Size = new System.Drawing.Size(40, 16);
			this.lblAudioDriver2.TabIndex = 32;
			this.lblAudioDriver2.Text = "Driver:";
			// 
			// comboAudioInput2
			// 
			this.comboAudioInput2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioInput2.DropDownWidth = 160;
			this.comboAudioInput2.Enabled = false;
			this.comboAudioInput2.ItemHeight = 13;
			this.comboAudioInput2.Location = new System.Drawing.Point(56, 56);
			this.comboAudioInput2.Name = "comboAudioInput2";
			this.comboAudioInput2.Size = new System.Drawing.Size(160, 21);
			this.comboAudioInput2.TabIndex = 28;
			this.toolTip1.SetToolTip(this.comboAudioInput2, "Input Audio Device");
			this.comboAudioInput2.SelectedIndexChanged += new System.EventHandler(this.comboAudioInput2_SelectedIndexChanged);
			// 
			// comboAudioDriver2
			// 
			this.comboAudioDriver2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioDriver2.DropDownWidth = 160;
			this.comboAudioDriver2.Enabled = false;
			this.comboAudioDriver2.ItemHeight = 13;
			this.comboAudioDriver2.Location = new System.Drawing.Point(56, 24);
			this.comboAudioDriver2.Name = "comboAudioDriver2";
			this.comboAudioDriver2.Size = new System.Drawing.Size(160, 21);
			this.comboAudioDriver2.TabIndex = 26;
			this.toolTip1.SetToolTip(this.comboAudioDriver2, "Sound Card Driver Selection");
			this.comboAudioDriver2.SelectedIndexChanged += new System.EventHandler(this.comboAudioDriver2_SelectedIndexChanged);
			// 
			// lblAudioTransmit2
			// 
			this.lblAudioTransmit2.Image = null;
			this.lblAudioTransmit2.Location = new System.Drawing.Point(8, 184);
			this.lblAudioTransmit2.Name = "lblAudioTransmit2";
			this.lblAudioTransmit2.Size = new System.Drawing.Size(56, 16);
			this.lblAudioTransmit2.TabIndex = 31;
			this.lblAudioTransmit2.Text = "Transmit:";
			// 
			// lblAudioReceive2
			// 
			this.lblAudioReceive2.Image = null;
			this.lblAudioReceive2.Location = new System.Drawing.Point(8, 152);
			this.lblAudioReceive2.Name = "lblAudioReceive2";
			this.lblAudioReceive2.Size = new System.Drawing.Size(48, 16);
			this.lblAudioReceive2.TabIndex = 29;
			this.lblAudioReceive2.Text = "Receive:";
			// 
			// comboAudioReceive2
			// 
			this.comboAudioReceive2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioReceive2.DropDownWidth = 160;
			this.comboAudioReceive2.Enabled = false;
			this.comboAudioReceive2.ItemHeight = 13;
			this.comboAudioReceive2.Location = new System.Drawing.Point(56, 152);
			this.comboAudioReceive2.Name = "comboAudioReceive2";
			this.comboAudioReceive2.Size = new System.Drawing.Size(160, 21);
			this.comboAudioReceive2.TabIndex = 27;
			this.toolTip1.SetToolTip(this.comboAudioReceive2, "Receive mode Mixer MUX setting");
			this.comboAudioReceive2.SelectedIndexChanged += new System.EventHandler(this.comboAudioReceive2_SelectedIndexChanged);
			// 
			// lblAudioMixer2
			// 
			this.lblAudioMixer2.Image = null;
			this.lblAudioMixer2.Location = new System.Drawing.Point(8, 120);
			this.lblAudioMixer2.Name = "lblAudioMixer2";
			this.lblAudioMixer2.Size = new System.Drawing.Size(40, 23);
			this.lblAudioMixer2.TabIndex = 24;
			this.lblAudioMixer2.Text = "Mixer:";
			// 
			// comboAudioMixer2
			// 
			this.comboAudioMixer2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioMixer2.DropDownWidth = 160;
			this.comboAudioMixer2.Enabled = false;
			this.comboAudioMixer2.ItemHeight = 13;
			this.comboAudioMixer2.Location = new System.Drawing.Point(56, 120);
			this.comboAudioMixer2.Name = "comboAudioMixer2";
			this.comboAudioMixer2.Size = new System.Drawing.Size(160, 21);
			this.comboAudioMixer2.TabIndex = 23;
			this.toolTip1.SetToolTip(this.comboAudioMixer2, "Audio Mixer Device ");
			this.comboAudioMixer2.SelectedIndexChanged += new System.EventHandler(this.comboAudioMixer2_SelectedIndexChanged);
			// 
			// grpAudioCard
			// 
			this.grpAudioCard.Controls.Add(this.comboAudioSoundCard);
			this.grpAudioCard.Location = new System.Drawing.Point(8, 8);
			this.grpAudioCard.Name = "grpAudioCard";
			this.grpAudioCard.Size = new System.Drawing.Size(224, 56);
			this.grpAudioCard.TabIndex = 27;
			this.grpAudioCard.TabStop = false;
			this.grpAudioCard.Text = "Sound Card Selection";
			// 
			// comboAudioSoundCard
			// 
			this.comboAudioSoundCard.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioSoundCard.DropDownWidth = 184;
			this.comboAudioSoundCard.Items.AddRange(new object[] {
																	 "Turtle Beach Santa Cruz (PCI)",
																	 "SB Audigy (PCI)",
																	 "SB Audigy 2 (PCI)",
																	 "SB Audigy 2 ZS (PCI)",
																	 "Sound Blaster Extigy (USB)",
																	 "Sound Blaster MP3+ (USB)",
																	 "M-Audio Delta 44 (PCI)",
																	 "Unsupported Card"});
			this.comboAudioSoundCard.Location = new System.Drawing.Point(24, 24);
			this.comboAudioSoundCard.Name = "comboAudioSoundCard";
			this.comboAudioSoundCard.Size = new System.Drawing.Size(184, 21);
			this.comboAudioSoundCard.TabIndex = 0;
			this.toolTip1.SetToolTip(this.comboAudioSoundCard, "Sound Card Selection (use Unsupported Card if your card isn\'t in the list -- this" +
				" will require manual setup of the below controls).");
			this.comboAudioSoundCard.SelectedIndexChanged += new System.EventHandler(this.comboAudioCard_SelectedIndexChanged);
			// 
			// grpAudioBufferSize
			// 
			this.grpAudioBufferSize.Controls.Add(this.comboAudioBuffer2);
			this.grpAudioBufferSize.Controls.Add(this.lblAudioBuffer2);
			this.grpAudioBufferSize.Controls.Add(this.comboAudioBuffer1);
			this.grpAudioBufferSize.Controls.Add(this.lblAudioBuffer1);
			this.grpAudioBufferSize.Location = new System.Drawing.Point(240, 72);
			this.grpAudioBufferSize.Name = "grpAudioBufferSize";
			this.grpAudioBufferSize.Size = new System.Drawing.Size(96, 104);
			this.grpAudioBufferSize.TabIndex = 24;
			this.grpAudioBufferSize.TabStop = false;
			this.grpAudioBufferSize.Text = "Buffer Size";
			// 
			// comboAudioBuffer2
			// 
			this.comboAudioBuffer2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioBuffer2.DropDownWidth = 56;
			this.comboAudioBuffer2.Enabled = false;
			this.comboAudioBuffer2.Items.AddRange(new object[] {
																   "256",
																   "512",
																   "1024",
																   "2048"});
			this.comboAudioBuffer2.Location = new System.Drawing.Point(16, 72);
			this.comboAudioBuffer2.Name = "comboAudioBuffer2";
			this.comboAudioBuffer2.Size = new System.Drawing.Size(56, 21);
			this.comboAudioBuffer2.TabIndex = 2;
			this.toolTip1.SetToolTip(this.comboAudioBuffer2, "Samples per buffer (currently dsp accumulates until 2048).");
			this.comboAudioBuffer2.SelectedIndexChanged += new System.EventHandler(this.comboAudioBuffer2_SelectedIndexChanged);
			// 
			// lblAudioBuffer2
			// 
			this.lblAudioBuffer2.Image = null;
			this.lblAudioBuffer2.Location = new System.Drawing.Point(16, 56);
			this.lblAudioBuffer2.Name = "lblAudioBuffer2";
			this.lblAudioBuffer2.Size = new System.Drawing.Size(48, 16);
			this.lblAudioBuffer2.TabIndex = 3;
			this.lblAudioBuffer2.Text = "Card 2:";
			// 
			// comboAudioBuffer1
			// 
			this.comboAudioBuffer1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioBuffer1.DropDownWidth = 56;
			this.comboAudioBuffer1.Items.AddRange(new object[] {
																   "64",
																   "128",
																   "256",
																   "512",
																   "1024",
																   "2048"});
			this.comboAudioBuffer1.Location = new System.Drawing.Point(16, 32);
			this.comboAudioBuffer1.Name = "comboAudioBuffer1";
			this.comboAudioBuffer1.Size = new System.Drawing.Size(56, 21);
			this.comboAudioBuffer1.TabIndex = 0;
			this.toolTip1.SetToolTip(this.comboAudioBuffer1, "Samples per buffer (currently dsp accumulates until 2048).");
			this.comboAudioBuffer1.SelectedIndexChanged += new System.EventHandler(this.comboAudioBuffer1_SelectedIndexChanged);
			// 
			// lblAudioBuffer1
			// 
			this.lblAudioBuffer1.Image = null;
			this.lblAudioBuffer1.Location = new System.Drawing.Point(16, 16);
			this.lblAudioBuffer1.Name = "lblAudioBuffer1";
			this.lblAudioBuffer1.Size = new System.Drawing.Size(48, 16);
			this.lblAudioBuffer1.TabIndex = 1;
			this.lblAudioBuffer1.Text = "Card 1:";
			// 
			// grpAudioSampleRate
			// 
			this.grpAudioSampleRate.Controls.Add(this.comboAudioSampleRate2);
			this.grpAudioSampleRate.Controls.Add(this.lblAudioSample2);
			this.grpAudioSampleRate.Controls.Add(this.comboAudioSampleRate1);
			this.grpAudioSampleRate.Controls.Add(this.lblAudioSample1);
			this.grpAudioSampleRate.Location = new System.Drawing.Point(240, 176);
			this.grpAudioSampleRate.Name = "grpAudioSampleRate";
			this.grpAudioSampleRate.Size = new System.Drawing.Size(96, 104);
			this.grpAudioSampleRate.TabIndex = 18;
			this.grpAudioSampleRate.TabStop = false;
			this.grpAudioSampleRate.Text = "Sample Rate";
			// 
			// comboAudioSampleRate2
			// 
			this.comboAudioSampleRate2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioSampleRate2.DropDownWidth = 64;
			this.comboAudioSampleRate2.Enabled = false;
			this.comboAudioSampleRate2.Items.AddRange(new object[] {
																	   "48000"});
			this.comboAudioSampleRate2.Location = new System.Drawing.Point(16, 72);
			this.comboAudioSampleRate2.Name = "comboAudioSampleRate2";
			this.comboAudioSampleRate2.Size = new System.Drawing.Size(64, 21);
			this.comboAudioSampleRate2.TabIndex = 6;
			this.toolTip1.SetToolTip(this.comboAudioSampleRate2, "Samples per buffer (currently dsp accumulates until 2048).");
			this.comboAudioSampleRate2.SelectedIndexChanged += new System.EventHandler(this.comboAudioSampleRate2_SelectedIndexChanged);
			// 
			// lblAudioSample2
			// 
			this.lblAudioSample2.Image = null;
			this.lblAudioSample2.Location = new System.Drawing.Point(16, 56);
			this.lblAudioSample2.Name = "lblAudioSample2";
			this.lblAudioSample2.Size = new System.Drawing.Size(72, 16);
			this.lblAudioSample2.TabIndex = 7;
			this.lblAudioSample2.Text = "Card 2: (Hz)";
			// 
			// comboAudioSampleRate1
			// 
			this.comboAudioSampleRate1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboAudioSampleRate1.DropDownWidth = 64;
			this.comboAudioSampleRate1.Enabled = false;
			this.comboAudioSampleRate1.Items.AddRange(new object[] {
																	   "48000"});
			this.comboAudioSampleRate1.Location = new System.Drawing.Point(16, 32);
			this.comboAudioSampleRate1.Name = "comboAudioSampleRate1";
			this.comboAudioSampleRate1.Size = new System.Drawing.Size(64, 21);
			this.comboAudioSampleRate1.TabIndex = 4;
			this.toolTip1.SetToolTip(this.comboAudioSampleRate1, "Sample Rate -- Currently locked to 48KHz");
			this.comboAudioSampleRate1.SelectedIndexChanged += new System.EventHandler(this.comboAudioSampleRate1_SelectedIndexChanged);
			// 
			// lblAudioSample1
			// 
			this.lblAudioSample1.Image = null;
			this.lblAudioSample1.Location = new System.Drawing.Point(16, 16);
			this.lblAudioSample1.Name = "lblAudioSample1";
			this.lblAudioSample1.Size = new System.Drawing.Size(72, 16);
			this.lblAudioSample1.TabIndex = 5;
			this.lblAudioSample1.Text = "Card 1: (Hz)";
			// 
			// chkAudioEnableSoundCard2
			// 
			this.chkAudioEnableSoundCard2.Image = null;
			this.chkAudioEnableSoundCard2.Location = new System.Drawing.Point(248, 8);
			this.chkAudioEnableSoundCard2.Name = "chkAudioEnableSoundCard2";
			this.chkAudioEnableSoundCard2.Size = new System.Drawing.Size(144, 24);
			this.chkAudioEnableSoundCard2.TabIndex = 25;
			this.chkAudioEnableSoundCard2.Text = "Enable 2nd Sound Card";
			this.toolTip1.SetToolTip(this.chkAudioEnableSoundCard2, "Enable Spur Reduction/Avoidance Routine");
			this.chkAudioEnableSoundCard2.CheckedChanged += new System.EventHandler(this.chkAudioEnableSoundCard2_CheckedChanged);
			// 
			// tpDisplay
			// 
			this.tpDisplay.Controls.Add(this.grpDisplayMultimeter);
			this.tpDisplay.Controls.Add(this.grpDisplayWaterfall);
			this.tpDisplay.Controls.Add(this.grpDisplayRefreshRates);
			this.tpDisplay.Controls.Add(this.grpDisplayAverage);
			this.tpDisplay.Controls.Add(this.grpDisplayPhase);
			this.tpDisplay.Controls.Add(this.grpDisplaySpectrumGrid);
			this.tpDisplay.Location = new System.Drawing.Point(4, 22);
			this.tpDisplay.Name = "tpDisplay";
			this.tpDisplay.Size = new System.Drawing.Size(584, 286);
			this.tpDisplay.TabIndex = 2;
			this.tpDisplay.Text = "Display";
			// 
			// grpDisplayMultimeter
			// 
			this.grpDisplayMultimeter.Controls.Add(this.udDisplayMultiTextHoldTime);
			this.grpDisplayMultimeter.Controls.Add(this.lblDisplayMeterTextHoldTime);
			this.grpDisplayMultimeter.Controls.Add(this.udDisplayMultiPeakHoldTime);
			this.grpDisplayMultimeter.Controls.Add(this.lblDisplayMultiPeakHoldTime);
			this.grpDisplayMultimeter.Location = new System.Drawing.Point(272, 144);
			this.grpDisplayMultimeter.Name = "grpDisplayMultimeter";
			this.grpDisplayMultimeter.Size = new System.Drawing.Size(200, 136);
			this.grpDisplayMultimeter.TabIndex = 41;
			this.grpDisplayMultimeter.TabStop = false;
			this.grpDisplayMultimeter.Text = "Multimeter";
			// 
			// udDisplayMultiTextHoldTime
			// 
			this.udDisplayMultiTextHoldTime.Increment = new System.Decimal(new int[] {
																						 1,
																						 0,
																						 0,
																						 0});
			this.udDisplayMultiTextHoldTime.Location = new System.Drawing.Point(136, 48);
			this.udDisplayMultiTextHoldTime.Maximum = new System.Decimal(new int[] {
																					   99999,
																					   0,
																					   0,
																					   0});
			this.udDisplayMultiTextHoldTime.Minimum = new System.Decimal(new int[] {
																					   1,
																					   0,
																					   0,
																					   0});
			this.udDisplayMultiTextHoldTime.Name = "udDisplayMultiTextHoldTime";
			this.udDisplayMultiTextHoldTime.Size = new System.Drawing.Size(56, 20);
			this.udDisplayMultiTextHoldTime.TabIndex = 4;
			this.toolTip1.SetToolTip(this.udDisplayMultiTextHoldTime, "Controls how long the meter will hold the digital peak value when in the Peak Pow" +
				"er mode.");
			this.udDisplayMultiTextHoldTime.Value = new System.Decimal(new int[] {
																					 500,
																					 0,
																					 0,
																					 0});
			this.udDisplayMultiTextHoldTime.ValueChanged += new System.EventHandler(this.udDisplayMultiTextHoldTime_ValueChanged);
			// 
			// lblDisplayMeterTextHoldTime
			// 
			this.lblDisplayMeterTextHoldTime.Image = null;
			this.lblDisplayMeterTextHoldTime.Location = new System.Drawing.Point(16, 48);
			this.lblDisplayMeterTextHoldTime.Name = "lblDisplayMeterTextHoldTime";
			this.lblDisplayMeterTextHoldTime.Size = new System.Drawing.Size(120, 16);
			this.lblDisplayMeterTextHoldTime.TabIndex = 3;
			this.lblDisplayMeterTextHoldTime.Text = "Digital Peak Hold (ms):";
			// 
			// udDisplayMultiPeakHoldTime
			// 
			this.udDisplayMultiPeakHoldTime.Increment = new System.Decimal(new int[] {
																						 1,
																						 0,
																						 0,
																						 0});
			this.udDisplayMultiPeakHoldTime.Location = new System.Drawing.Point(136, 24);
			this.udDisplayMultiPeakHoldTime.Maximum = new System.Decimal(new int[] {
																					   99999,
																					   0,
																					   0,
																					   0});
			this.udDisplayMultiPeakHoldTime.Minimum = new System.Decimal(new int[] {
																					   0,
																					   0,
																					   0,
																					   0});
			this.udDisplayMultiPeakHoldTime.Name = "udDisplayMultiPeakHoldTime";
			this.udDisplayMultiPeakHoldTime.Size = new System.Drawing.Size(56, 20);
			this.udDisplayMultiPeakHoldTime.TabIndex = 1;
			this.toolTip1.SetToolTip(this.udDisplayMultiPeakHoldTime, "Controls how long the analog peak red line will be held on the multimeter.");
			this.udDisplayMultiPeakHoldTime.Value = new System.Decimal(new int[] {
																					 1000,
																					 0,
																					 0,
																					 0});
			this.udDisplayMultiPeakHoldTime.ValueChanged += new System.EventHandler(this.udDisplayMultiPeakHoldTime_ValueChanged);
			// 
			// lblDisplayMultiPeakHoldTime
			// 
			this.lblDisplayMultiPeakHoldTime.Image = null;
			this.lblDisplayMultiPeakHoldTime.Location = new System.Drawing.Point(16, 24);
			this.lblDisplayMultiPeakHoldTime.Name = "lblDisplayMultiPeakHoldTime";
			this.lblDisplayMultiPeakHoldTime.Size = new System.Drawing.Size(128, 16);
			this.lblDisplayMultiPeakHoldTime.TabIndex = 0;
			this.lblDisplayMultiPeakHoldTime.Text = "Analog Peak Hold (ms):";
			// 
			// grpDisplayWaterfall
			// 
			this.grpDisplayWaterfall.Controls.Add(this.clrbtnWaterfallMid);
			this.grpDisplayWaterfall.Controls.Add(this.clrbtnWaterfallHigh);
			this.grpDisplayWaterfall.Controls.Add(this.clrbtnWaterfallLow);
			this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallMidColor);
			this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallHighColor);
			this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallLowColor);
			this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallLowLevel);
			this.grpDisplayWaterfall.Controls.Add(this.udDisplayWaterfallLowLevel);
			this.grpDisplayWaterfall.Controls.Add(this.lblDisplayWaterfallHighLevel);
			this.grpDisplayWaterfall.Controls.Add(this.udDisplayWaterfallHighLevel);
			this.grpDisplayWaterfall.Location = new System.Drawing.Point(8, 144);
			this.grpDisplayWaterfall.Name = "grpDisplayWaterfall";
			this.grpDisplayWaterfall.Size = new System.Drawing.Size(256, 136);
			this.grpDisplayWaterfall.TabIndex = 40;
			this.grpDisplayWaterfall.TabStop = false;
			this.grpDisplayWaterfall.Text = "Waterfall";
			// 
			// clrbtnWaterfallMid
			// 
			this.clrbtnWaterfallMid.Automatic = "Automatic";
			this.clrbtnWaterfallMid.Color = System.Drawing.Color.Transparent;
			this.clrbtnWaterfallMid.Image = null;
			this.clrbtnWaterfallMid.Location = new System.Drawing.Point(72, 88);
			this.clrbtnWaterfallMid.MoreColors = "More Colors...";
			this.clrbtnWaterfallMid.Name = "clrbtnWaterfallMid";
			this.clrbtnWaterfallMid.Size = new System.Drawing.Size(40, 23);
			this.clrbtnWaterfallMid.TabIndex = 70;
			this.clrbtnWaterfallMid.Changed += new System.EventHandler(this.clrbtnWaterfallMid_Changed);
			// 
			// clrbtnWaterfallHigh
			// 
			this.clrbtnWaterfallHigh.Automatic = "Automatic";
			this.clrbtnWaterfallHigh.Color = System.Drawing.Color.Transparent;
			this.clrbtnWaterfallHigh.Image = null;
			this.clrbtnWaterfallHigh.Location = new System.Drawing.Point(192, 56);
			this.clrbtnWaterfallHigh.MoreColors = "More Colors...";
			this.clrbtnWaterfallHigh.Name = "clrbtnWaterfallHigh";
			this.clrbtnWaterfallHigh.Size = new System.Drawing.Size(40, 23);
			this.clrbtnWaterfallHigh.TabIndex = 69;
			this.clrbtnWaterfallHigh.Changed += new System.EventHandler(this.clrbtnWaterfallHigh_Changed);
			// 
			// clrbtnWaterfallLow
			// 
			this.clrbtnWaterfallLow.Automatic = "Automatic";
			this.clrbtnWaterfallLow.Color = System.Drawing.Color.Transparent;
			this.clrbtnWaterfallLow.Image = null;
			this.clrbtnWaterfallLow.Location = new System.Drawing.Point(72, 56);
			this.clrbtnWaterfallLow.MoreColors = "More Colors...";
			this.clrbtnWaterfallLow.Name = "clrbtnWaterfallLow";
			this.clrbtnWaterfallLow.Size = new System.Drawing.Size(40, 23);
			this.clrbtnWaterfallLow.TabIndex = 68;
			this.clrbtnWaterfallLow.Changed += new System.EventHandler(this.clrbtnWaterfallLow_Changed);
			// 
			// lblDisplayWaterfallMidColor
			// 
			this.lblDisplayWaterfallMidColor.Image = null;
			this.lblDisplayWaterfallMidColor.Location = new System.Drawing.Point(8, 88);
			this.lblDisplayWaterfallMidColor.Name = "lblDisplayWaterfallMidColor";
			this.lblDisplayWaterfallMidColor.Size = new System.Drawing.Size(64, 16);
			this.lblDisplayWaterfallMidColor.TabIndex = 61;
			this.lblDisplayWaterfallMidColor.Text = "Mid Color:";
			// 
			// lblDisplayWaterfallHighColor
			// 
			this.lblDisplayWaterfallHighColor.Image = null;
			this.lblDisplayWaterfallHighColor.Location = new System.Drawing.Point(128, 56);
			this.lblDisplayWaterfallHighColor.Name = "lblDisplayWaterfallHighColor";
			this.lblDisplayWaterfallHighColor.Size = new System.Drawing.Size(64, 16);
			this.lblDisplayWaterfallHighColor.TabIndex = 59;
			this.lblDisplayWaterfallHighColor.Text = "High Color:";
			// 
			// lblDisplayWaterfallLowColor
			// 
			this.lblDisplayWaterfallLowColor.Image = null;
			this.lblDisplayWaterfallLowColor.Location = new System.Drawing.Point(8, 56);
			this.lblDisplayWaterfallLowColor.Name = "lblDisplayWaterfallLowColor";
			this.lblDisplayWaterfallLowColor.Size = new System.Drawing.Size(64, 16);
			this.lblDisplayWaterfallLowColor.TabIndex = 57;
			this.lblDisplayWaterfallLowColor.Text = "Low Color:";
			// 
			// lblDisplayWaterfallLowLevel
			// 
			this.lblDisplayWaterfallLowLevel.Image = null;
			this.lblDisplayWaterfallLowLevel.Location = new System.Drawing.Point(8, 24);
			this.lblDisplayWaterfallLowLevel.Name = "lblDisplayWaterfallLowLevel";
			this.lblDisplayWaterfallLowLevel.Size = new System.Drawing.Size(64, 23);
			this.lblDisplayWaterfallLowLevel.TabIndex = 3;
			this.lblDisplayWaterfallLowLevel.Text = "Low Level";
			// 
			// udDisplayWaterfallLowLevel
			// 
			this.udDisplayWaterfallLowLevel.Increment = new System.Decimal(new int[] {
																						 10,
																						 0,
																						 0,
																						 0});
			this.udDisplayWaterfallLowLevel.Location = new System.Drawing.Point(72, 24);
			this.udDisplayWaterfallLowLevel.Maximum = new System.Decimal(new int[] {
																					   200,
																					   0,
																					   0,
																					   0});
			this.udDisplayWaterfallLowLevel.Minimum = new System.Decimal(new int[] {
																					   200,
																					   0,
																					   0,
																					   -2147483648});
			this.udDisplayWaterfallLowLevel.Name = "udDisplayWaterfallLowLevel";
			this.udDisplayWaterfallLowLevel.Size = new System.Drawing.Size(48, 20);
			this.udDisplayWaterfallLowLevel.TabIndex = 2;
			this.toolTip1.SetToolTip(this.udDisplayWaterfallLowLevel, "Waterfall Low Signal - Show Low Color below this value (gradient in between).");
			this.udDisplayWaterfallLowLevel.Value = new System.Decimal(new int[] {
																					 110,
																					 0,
																					 0,
																					 -2147483648});
			this.udDisplayWaterfallLowLevel.ValueChanged += new System.EventHandler(this.udDisplayWaterfallLowLevel_ValueChanged);
			// 
			// lblDisplayWaterfallHighLevel
			// 
			this.lblDisplayWaterfallHighLevel.Image = null;
			this.lblDisplayWaterfallHighLevel.Location = new System.Drawing.Point(128, 24);
			this.lblDisplayWaterfallHighLevel.Name = "lblDisplayWaterfallHighLevel";
			this.lblDisplayWaterfallHighLevel.Size = new System.Drawing.Size(64, 23);
			this.lblDisplayWaterfallHighLevel.TabIndex = 1;
			this.lblDisplayWaterfallHighLevel.Text = "High Level";
			// 
			// udDisplayWaterfallHighLevel
			// 
			this.udDisplayWaterfallHighLevel.Increment = new System.Decimal(new int[] {
																						  10,
																						  0,
																						  0,
																						  0});
			this.udDisplayWaterfallHighLevel.Location = new System.Drawing.Point(192, 24);
			this.udDisplayWaterfallHighLevel.Maximum = new System.Decimal(new int[] {
																						200,
																						0,
																						0,
																						0});
			this.udDisplayWaterfallHighLevel.Minimum = new System.Decimal(new int[] {
																						200,
																						0,
																						0,
																						-2147483648});
			this.udDisplayWaterfallHighLevel.Name = "udDisplayWaterfallHighLevel";
			this.udDisplayWaterfallHighLevel.Size = new System.Drawing.Size(48, 20);
			this.udDisplayWaterfallHighLevel.TabIndex = 0;
			this.toolTip1.SetToolTip(this.udDisplayWaterfallHighLevel, "Waterfall High Signal - Show High Color above this value (gradient in between).");
			this.udDisplayWaterfallHighLevel.Value = new System.Decimal(new int[] {
																					  70,
																					  0,
																					  0,
																					  -2147483648});
			this.udDisplayWaterfallHighLevel.ValueChanged += new System.EventHandler(this.udDisplayWaterfallHighLevel_ValueChanged);
			// 
			// grpDisplayRefreshRates
			// 
			this.grpDisplayRefreshRates.Controls.Add(this.udDisplayCPUMeter);
			this.grpDisplayRefreshRates.Controls.Add(this.lblDisplayCPUMeter);
			this.grpDisplayRefreshRates.Controls.Add(this.udDisplayPeakText);
			this.grpDisplayRefreshRates.Controls.Add(this.lblDisplayPeakText);
			this.grpDisplayRefreshRates.Controls.Add(this.udDisplayMeterDelay);
			this.grpDisplayRefreshRates.Controls.Add(this.lblDisplayMeterDelay);
			this.grpDisplayRefreshRates.Controls.Add(this.udDisplayFPS);
			this.grpDisplayRefreshRates.Controls.Add(this.lblDisplayFPS);
			this.grpDisplayRefreshRates.Location = new System.Drawing.Point(128, 8);
			this.grpDisplayRefreshRates.Name = "grpDisplayRefreshRates";
			this.grpDisplayRefreshRates.Size = new System.Drawing.Size(176, 128);
			this.grpDisplayRefreshRates.TabIndex = 39;
			this.grpDisplayRefreshRates.TabStop = false;
			this.grpDisplayRefreshRates.Text = "Refresh Rates";
			// 
			// udDisplayCPUMeter
			// 
			this.udDisplayCPUMeter.Increment = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.udDisplayCPUMeter.Location = new System.Drawing.Point(120, 96);
			this.udDisplayCPUMeter.Maximum = new System.Decimal(new int[] {
																			  9999,
																			  0,
																			  0,
																			  0});
			this.udDisplayCPUMeter.Minimum = new System.Decimal(new int[] {
																			  100,
																			  0,
																			  0,
																			  0});
			this.udDisplayCPUMeter.Name = "udDisplayCPUMeter";
			this.udDisplayCPUMeter.Size = new System.Drawing.Size(48, 20);
			this.udDisplayCPUMeter.TabIndex = 38;
			this.toolTip1.SetToolTip(this.udDisplayCPUMeter, "CPU Meter Refresh Rate.");
			this.udDisplayCPUMeter.Value = new System.Decimal(new int[] {
																			1000,
																			0,
																			0,
																			0});
			this.udDisplayCPUMeter.ValueChanged += new System.EventHandler(this.udDisplayCPUMeter_ValueChanged);
			// 
			// lblDisplayCPUMeter
			// 
			this.lblDisplayCPUMeter.Image = null;
			this.lblDisplayCPUMeter.Location = new System.Drawing.Point(16, 96);
			this.lblDisplayCPUMeter.Name = "lblDisplayCPUMeter";
			this.lblDisplayCPUMeter.TabIndex = 37;
			this.lblDisplayCPUMeter.Text = "CPU Meter (ms)";
			// 
			// udDisplayPeakText
			// 
			this.udDisplayPeakText.Increment = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.udDisplayPeakText.Location = new System.Drawing.Point(120, 72);
			this.udDisplayPeakText.Maximum = new System.Decimal(new int[] {
																			  9999,
																			  0,
																			  0,
																			  0});
			this.udDisplayPeakText.Minimum = new System.Decimal(new int[] {
																			  100,
																			  0,
																			  0,
																			  0});
			this.udDisplayPeakText.Name = "udDisplayPeakText";
			this.udDisplayPeakText.Size = new System.Drawing.Size(48, 20);
			this.udDisplayPeakText.TabIndex = 36;
			this.toolTip1.SetToolTip(this.udDisplayPeakText, "Peak Text Refresh Rate.");
			this.udDisplayPeakText.Value = new System.Decimal(new int[] {
																			500,
																			0,
																			0,
																			0});
			this.udDisplayPeakText.ValueChanged += new System.EventHandler(this.udDisplayPeakText_ValueChanged);
			// 
			// lblDisplayPeakText
			// 
			this.lblDisplayPeakText.Image = null;
			this.lblDisplayPeakText.Location = new System.Drawing.Point(16, 72);
			this.lblDisplayPeakText.Name = "lblDisplayPeakText";
			this.lblDisplayPeakText.TabIndex = 35;
			this.lblDisplayPeakText.Text = "Peak Text (ms)";
			// 
			// udDisplayMeterDelay
			// 
			this.udDisplayMeterDelay.Increment = new System.Decimal(new int[] {
																				  1,
																				  0,
																				  0,
																				  0});
			this.udDisplayMeterDelay.Location = new System.Drawing.Point(120, 48);
			this.udDisplayMeterDelay.Maximum = new System.Decimal(new int[] {
																				5000,
																				0,
																				0,
																				0});
			this.udDisplayMeterDelay.Minimum = new System.Decimal(new int[] {
																				50,
																				0,
																				0,
																				0});
			this.udDisplayMeterDelay.Name = "udDisplayMeterDelay";
			this.udDisplayMeterDelay.Size = new System.Drawing.Size(48, 20);
			this.udDisplayMeterDelay.TabIndex = 34;
			this.toolTip1.SetToolTip(this.udDisplayMeterDelay, "Multimeter Refresh Rate.");
			this.udDisplayMeterDelay.Value = new System.Decimal(new int[] {
																			  100,
																			  0,
																			  0,
																			  0});
			this.udDisplayMeterDelay.ValueChanged += new System.EventHandler(this.udDisplayMeterDelay_ValueChanged);
			// 
			// lblDisplayMeterDelay
			// 
			this.lblDisplayMeterDelay.Image = null;
			this.lblDisplayMeterDelay.Location = new System.Drawing.Point(16, 48);
			this.lblDisplayMeterDelay.Name = "lblDisplayMeterDelay";
			this.lblDisplayMeterDelay.Size = new System.Drawing.Size(96, 23);
			this.lblDisplayMeterDelay.TabIndex = 33;
			this.lblDisplayMeterDelay.Text = "Meter Delay (ms):";
			// 
			// udDisplayFPS
			// 
			this.udDisplayFPS.Increment = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.udDisplayFPS.Location = new System.Drawing.Point(120, 24);
			this.udDisplayFPS.Maximum = new System.Decimal(new int[] {
																		 50,
																		 0,
																		 0,
																		 0});
			this.udDisplayFPS.Minimum = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 0});
			this.udDisplayFPS.Name = "udDisplayFPS";
			this.udDisplayFPS.Size = new System.Drawing.Size(48, 20);
			this.udDisplayFPS.TabIndex = 32;
			this.toolTip1.SetToolTip(this.udDisplayFPS, "Frames Per Second (approximate)");
			this.udDisplayFPS.Value = new System.Decimal(new int[] {
																	   15,
																	   0,
																	   0,
																	   0});
			this.udDisplayFPS.ValueChanged += new System.EventHandler(this.udDisplayFPS_ValueChanged);
			// 
			// lblDisplayFPS
			// 
			this.lblDisplayFPS.Image = null;
			this.lblDisplayFPS.Location = new System.Drawing.Point(16, 24);
			this.lblDisplayFPS.Name = "lblDisplayFPS";
			this.lblDisplayFPS.Size = new System.Drawing.Size(104, 16);
			this.lblDisplayFPS.TabIndex = 31;
			this.lblDisplayFPS.Text = "Main Display FPS:";
			// 
			// grpDisplayAverage
			// 
			this.grpDisplayAverage.Controls.Add(this.udDisplayAVGTime);
			this.grpDisplayAverage.Controls.Add(this.lblDisplayAVGTime);
			this.grpDisplayAverage.Location = new System.Drawing.Point(312, 72);
			this.grpDisplayAverage.Name = "grpDisplayAverage";
			this.grpDisplayAverage.Size = new System.Drawing.Size(120, 56);
			this.grpDisplayAverage.TabIndex = 38;
			this.grpDisplayAverage.TabStop = false;
			this.grpDisplayAverage.Text = "Averaging";
			// 
			// udDisplayAVGTime
			// 
			this.udDisplayAVGTime.Increment = new System.Decimal(new int[] {
																			   1,
																			   0,
																			   0,
																			   0});
			this.udDisplayAVGTime.Location = new System.Drawing.Point(64, 24);
			this.udDisplayAVGTime.Maximum = new System.Decimal(new int[] {
																			 9999,
																			 0,
																			 0,
																			 0});
			this.udDisplayAVGTime.Minimum = new System.Decimal(new int[] {
																			 1,
																			 0,
																			 0,
																			 0});
			this.udDisplayAVGTime.Name = "udDisplayAVGTime";
			this.udDisplayAVGTime.Size = new System.Drawing.Size(48, 20);
			this.udDisplayAVGTime.TabIndex = 2;
			this.toolTip1.SetToolTip(this.udDisplayAVGTime, "When averaging, use this number of buffers to calculate the average.");
			this.udDisplayAVGTime.Value = new System.Decimal(new int[] {
																		   350,
																		   0,
																		   0,
																		   0});
			this.udDisplayAVGTime.ValueChanged += new System.EventHandler(this.udDisplayAVGTime_ValueChanged);
			// 
			// lblDisplayAVGTime
			// 
			this.lblDisplayAVGTime.Image = null;
			this.lblDisplayAVGTime.Location = new System.Drawing.Point(8, 24);
			this.lblDisplayAVGTime.Name = "lblDisplayAVGTime";
			this.lblDisplayAVGTime.Size = new System.Drawing.Size(64, 23);
			this.lblDisplayAVGTime.TabIndex = 3;
			this.lblDisplayAVGTime.Text = "Time (ms):";
			// 
			// grpDisplayPhase
			// 
			this.grpDisplayPhase.Controls.Add(this.lblDisplayPhasePts);
			this.grpDisplayPhase.Controls.Add(this.udDisplayPhasePts);
			this.grpDisplayPhase.Location = new System.Drawing.Point(312, 8);
			this.grpDisplayPhase.Name = "grpDisplayPhase";
			this.grpDisplayPhase.Size = new System.Drawing.Size(120, 56);
			this.grpDisplayPhase.TabIndex = 37;
			this.grpDisplayPhase.TabStop = false;
			this.grpDisplayPhase.Text = "Phase Mode";
			// 
			// lblDisplayPhasePts
			// 
			this.lblDisplayPhasePts.Image = null;
			this.lblDisplayPhasePts.Location = new System.Drawing.Point(8, 24);
			this.lblDisplayPhasePts.Name = "lblDisplayPhasePts";
			this.lblDisplayPhasePts.Size = new System.Drawing.Size(56, 23);
			this.lblDisplayPhasePts.TabIndex = 1;
			this.lblDisplayPhasePts.Text = "Num Pts:";
			// 
			// udDisplayPhasePts
			// 
			this.udDisplayPhasePts.Increment = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.udDisplayPhasePts.Location = new System.Drawing.Point(64, 24);
			this.udDisplayPhasePts.Maximum = new System.Decimal(new int[] {
																			  500,
																			  0,
																			  0,
																			  0});
			this.udDisplayPhasePts.Minimum = new System.Decimal(new int[] {
																			  25,
																			  0,
																			  0,
																			  0});
			this.udDisplayPhasePts.Name = "udDisplayPhasePts";
			this.udDisplayPhasePts.Size = new System.Drawing.Size(48, 20);
			this.udDisplayPhasePts.TabIndex = 0;
			this.toolTip1.SetToolTip(this.udDisplayPhasePts, "Number of points to display in Phase Mode.");
			this.udDisplayPhasePts.Value = new System.Decimal(new int[] {
																			100,
																			0,
																			0,
																			0});
			this.udDisplayPhasePts.ValueChanged += new System.EventHandler(this.udDisplayPhasePts_ValueChanged);
			// 
			// grpDisplaySpectrumGrid
			// 
			this.grpDisplaySpectrumGrid.Controls.Add(this.comboDisplaydBAlign);
			this.grpDisplaySpectrumGrid.Controls.Add(this.label1);
			this.grpDisplaySpectrumGrid.Controls.Add(this.udDisplayGridStep);
			this.grpDisplaySpectrumGrid.Controls.Add(this.udDisplayGridMin);
			this.grpDisplaySpectrumGrid.Controls.Add(this.udDisplayGridMax);
			this.grpDisplaySpectrumGrid.Controls.Add(this.lblDisplayGridStep);
			this.grpDisplaySpectrumGrid.Controls.Add(this.lblDisplayGridMin);
			this.grpDisplaySpectrumGrid.Controls.Add(this.lblDisplayGridMax);
			this.grpDisplaySpectrumGrid.Location = new System.Drawing.Point(8, 8);
			this.grpDisplaySpectrumGrid.Name = "grpDisplaySpectrumGrid";
			this.grpDisplaySpectrumGrid.Size = new System.Drawing.Size(112, 128);
			this.grpDisplaySpectrumGrid.TabIndex = 29;
			this.grpDisplaySpectrumGrid.TabStop = false;
			this.grpDisplaySpectrumGrid.Text = "Spectrum Grid";
			// 
			// comboDisplaydBAlign
			// 
			this.comboDisplaydBAlign.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboDisplaydBAlign.DropDownWidth = 48;
			this.comboDisplaydBAlign.Items.AddRange(new object[] {
																	 "Left",
																	 "Cntr",
																	 "Right"});
			this.comboDisplaydBAlign.Location = new System.Drawing.Point(56, 96);
			this.comboDisplaydBAlign.Name = "comboDisplaydBAlign";
			this.comboDisplaydBAlign.Size = new System.Drawing.Size(48, 21);
			this.comboDisplaydBAlign.TabIndex = 30;
			this.comboDisplaydBAlign.Visible = false;
			this.comboDisplaydBAlign.SelectedIndexChanged += new System.EventHandler(this.comboDisplaydBAlign_SelectedIndexChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 96);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(48, 16);
			this.label1.TabIndex = 29;
			this.label1.Text = "dB Align";
			this.label1.Visible = false;
			// 
			// udDisplayGridStep
			// 
			this.udDisplayGridStep.Increment = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.udDisplayGridStep.Location = new System.Drawing.Point(48, 72);
			this.udDisplayGridStep.Maximum = new System.Decimal(new int[] {
																			  40,
																			  0,
																			  0,
																			  0});
			this.udDisplayGridStep.Minimum = new System.Decimal(new int[] {
																			  1,
																			  0,
																			  0,
																			  0});
			this.udDisplayGridStep.Name = "udDisplayGridStep";
			this.udDisplayGridStep.Size = new System.Drawing.Size(56, 20);
			this.udDisplayGridStep.TabIndex = 25;
			this.toolTip1.SetToolTip(this.udDisplayGridStep, "Horizontal Grid Step Size in dB.");
			this.udDisplayGridStep.Value = new System.Decimal(new int[] {
																			10,
																			0,
																			0,
																			0});
			this.udDisplayGridStep.ValueChanged += new System.EventHandler(this.udDisplayGridStep_ValueChanged);
			// 
			// udDisplayGridMin
			// 
			this.udDisplayGridMin.Increment = new System.Decimal(new int[] {
																			   5,
																			   0,
																			   0,
																			   0});
			this.udDisplayGridMin.Location = new System.Drawing.Point(48, 48);
			this.udDisplayGridMin.Maximum = new System.Decimal(new int[] {
																			 200,
																			 0,
																			 0,
																			 0});
			this.udDisplayGridMin.Minimum = new System.Decimal(new int[] {
																			 200,
																			 0,
																			 0,
																			 -2147483648});
			this.udDisplayGridMin.Name = "udDisplayGridMin";
			this.udDisplayGridMin.Size = new System.Drawing.Size(56, 20);
			this.udDisplayGridMin.TabIndex = 24;
			this.toolTip1.SetToolTip(this.udDisplayGridMin, "Signal Level at bottom of display in dB.");
			this.udDisplayGridMin.Value = new System.Decimal(new int[] {
																		   150,
																		   0,
																		   0,
																		   -2147483648});
			this.udDisplayGridMin.ValueChanged += new System.EventHandler(this.udDisplayGridMin_ValueChanged);
			// 
			// udDisplayGridMax
			// 
			this.udDisplayGridMax.Increment = new System.Decimal(new int[] {
																			   5,
																			   0,
																			   0,
																			   0});
			this.udDisplayGridMax.Location = new System.Drawing.Point(48, 24);
			this.udDisplayGridMax.Maximum = new System.Decimal(new int[] {
																			 200,
																			 0,
																			 0,
																			 0});
			this.udDisplayGridMax.Minimum = new System.Decimal(new int[] {
																			 200,
																			 0,
																			 0,
																			 -2147483648});
			this.udDisplayGridMax.Name = "udDisplayGridMax";
			this.udDisplayGridMax.Size = new System.Drawing.Size(56, 20);
			this.udDisplayGridMax.TabIndex = 23;
			this.toolTip1.SetToolTip(this.udDisplayGridMax, "Signal level at top of display in dB.");
			this.udDisplayGridMax.Value = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.udDisplayGridMax.ValueChanged += new System.EventHandler(this.udDisplayGridMax_ValueChanged);
			// 
			// lblDisplayGridStep
			// 
			this.lblDisplayGridStep.Image = null;
			this.lblDisplayGridStep.Location = new System.Drawing.Point(8, 72);
			this.lblDisplayGridStep.Name = "lblDisplayGridStep";
			this.lblDisplayGridStep.Size = new System.Drawing.Size(32, 16);
			this.lblDisplayGridStep.TabIndex = 28;
			this.lblDisplayGridStep.Text = "Step:";
			// 
			// lblDisplayGridMin
			// 
			this.lblDisplayGridMin.Image = null;
			this.lblDisplayGridMin.Location = new System.Drawing.Point(8, 48);
			this.lblDisplayGridMin.Name = "lblDisplayGridMin";
			this.lblDisplayGridMin.Size = new System.Drawing.Size(32, 16);
			this.lblDisplayGridMin.TabIndex = 27;
			this.lblDisplayGridMin.Text = "Min:";
			// 
			// lblDisplayGridMax
			// 
			this.lblDisplayGridMax.Image = null;
			this.lblDisplayGridMax.Location = new System.Drawing.Point(8, 24);
			this.lblDisplayGridMax.Name = "lblDisplayGridMax";
			this.lblDisplayGridMax.Size = new System.Drawing.Size(32, 16);
			this.lblDisplayGridMax.TabIndex = 26;
			this.lblDisplayGridMax.Text = "Max:";
			// 
			// tpDSP
			// 
			this.tpDSP.Controls.Add(this.comboImageReject);
			this.tpDSP.Controls.Add(this.grpDSPNB);
			this.tpDSP.Controls.Add(this.grpDSPCWPitch);
			this.tpDSP.Controls.Add(this.grpDSPNB2);
			this.tpDSP.Controls.Add(this.grpDSPLMSNR);
			this.tpDSP.Controls.Add(this.grpDSPLMSANF);
			this.tpDSP.Controls.Add(this.grpDSPImageRejectRX);
			this.tpDSP.Controls.Add(this.grpDSPAGC);
			this.tpDSP.Controls.Add(this.grpDSPWindow);
			this.tpDSP.Controls.Add(this.grpDSPImageRejectTX);
			this.tpDSP.Location = new System.Drawing.Point(4, 22);
			this.tpDSP.Name = "tpDSP";
			this.tpDSP.Size = new System.Drawing.Size(584, 286);
			this.tpDSP.TabIndex = 1;
			this.tpDSP.Text = "DSP";
			// 
			// comboImageReject
			// 
			this.comboImageReject.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboImageReject.DropDownWidth = 48;
			this.comboImageReject.Items.AddRange(new object[] {
																  "RX",
																  "TX"});
			this.comboImageReject.Location = new System.Drawing.Point(504, 16);
			this.comboImageReject.Name = "comboImageReject";
			this.comboImageReject.Size = new System.Drawing.Size(48, 21);
			this.comboImageReject.TabIndex = 14;
			this.comboImageReject.SelectedIndexChanged += new System.EventHandler(this.comboImageReject_SelectedIndexChanged);
			// 
			// grpDSPNB
			// 
			this.grpDSPNB.Controls.Add(this.udDSPNB);
			this.grpDSPNB.Controls.Add(this.lblDSPNBThreshold);
			this.grpDSPNB.Location = new System.Drawing.Point(368, 144);
			this.grpDSPNB.Name = "grpDSPNB";
			this.grpDSPNB.Size = new System.Drawing.Size(128, 56);
			this.grpDSPNB.TabIndex = 12;
			this.grpDSPNB.TabStop = false;
			this.grpDSPNB.Text = "Noise Blanker";
			// 
			// udDSPNB
			// 
			this.udDSPNB.Increment = new System.Decimal(new int[] {
																	  1,
																	  0,
																	  0,
																	  0});
			this.udDSPNB.Location = new System.Drawing.Point(64, 24);
			this.udDSPNB.Maximum = new System.Decimal(new int[] {
																	200,
																	0,
																	0,
																	0});
			this.udDSPNB.Minimum = new System.Decimal(new int[] {
																	1,
																	0,
																	0,
																	0});
			this.udDSPNB.Name = "udDSPNB";
			this.udDSPNB.Size = new System.Drawing.Size(48, 20);
			this.udDSPNB.TabIndex = 0;
			this.toolTip1.SetToolTip(this.udDSPNB, "Controls the detection threshold for impulse noise.  ");
			this.udDSPNB.Value = new System.Decimal(new int[] {
																  20,
																  0,
																  0,
																  0});
			this.udDSPNB.ValueChanged += new System.EventHandler(this.udDSPNB_ValueChanged);
			// 
			// lblDSPNBThreshold
			// 
			this.lblDSPNBThreshold.Image = null;
			this.lblDSPNBThreshold.Location = new System.Drawing.Point(8, 24);
			this.lblDSPNBThreshold.Name = "lblDSPNBThreshold";
			this.lblDSPNBThreshold.Size = new System.Drawing.Size(64, 16);
			this.lblDSPNBThreshold.TabIndex = 9;
			this.lblDSPNBThreshold.Text = "Threshold:";
			// 
			// grpDSPCWPitch
			// 
			this.grpDSPCWPitch.Controls.Add(this.lblDSPCWPitchFreq);
			this.grpDSPCWPitch.Controls.Add(this.udDSPCWPitch);
			this.grpDSPCWPitch.Location = new System.Drawing.Point(152, 144);
			this.grpDSPCWPitch.Name = "grpDSPCWPitch";
			this.grpDSPCWPitch.Size = new System.Drawing.Size(96, 56);
			this.grpDSPCWPitch.TabIndex = 11;
			this.grpDSPCWPitch.TabStop = false;
			this.grpDSPCWPitch.Text = "CW Pitch (Hz)";
			// 
			// lblDSPCWPitchFreq
			// 
			this.lblDSPCWPitchFreq.Image = null;
			this.lblDSPCWPitchFreq.Location = new System.Drawing.Point(8, 24);
			this.lblDSPCWPitchFreq.Name = "lblDSPCWPitchFreq";
			this.lblDSPCWPitchFreq.Size = new System.Drawing.Size(32, 16);
			this.lblDSPCWPitchFreq.TabIndex = 8;
			this.lblDSPCWPitchFreq.Text = "Freq:";
			// 
			// udDSPCWPitch
			// 
			this.udDSPCWPitch.Increment = new System.Decimal(new int[] {
																		   10,
																		   0,
																		   0,
																		   0});
			this.udDSPCWPitch.Location = new System.Drawing.Point(40, 24);
			this.udDSPCWPitch.Maximum = new System.Decimal(new int[] {
																		 1200,
																		 0,
																		 0,
																		 0});
			this.udDSPCWPitch.Minimum = new System.Decimal(new int[] {
																		 200,
																		 0,
																		 0,
																		 0});
			this.udDSPCWPitch.Name = "udDSPCWPitch";
			this.udDSPCWPitch.Size = new System.Drawing.Size(48, 20);
			this.udDSPCWPitch.TabIndex = 7;
			this.toolTip1.SetToolTip(this.udDSPCWPitch, "Selects the preferred CW tone frequency.");
			this.udDSPCWPitch.Value = new System.Decimal(new int[] {
																	   600,
																	   0,
																	   0,
																	   0});
			this.udDSPCWPitch.ValueChanged += new System.EventHandler(this.udDSPCWPitch_ValueChanged);
			// 
			// grpDSPNB2
			// 
			this.grpDSPNB2.Controls.Add(this.udDSPMNB);
			this.grpDSPNB2.Controls.Add(this.lblDSPNB2Threshold);
			this.grpDSPNB2.Location = new System.Drawing.Point(368, 208);
			this.grpDSPNB2.Name = "grpDSPNB2";
			this.grpDSPNB2.Size = new System.Drawing.Size(128, 64);
			this.grpDSPNB2.TabIndex = 10;
			this.grpDSPNB2.TabStop = false;
			this.grpDSPNB2.Text = "Noise Blanker 2";
			// 
			// udDSPMNB
			// 
			this.udDSPMNB.Increment = new System.Decimal(new int[] {
																	   1,
																	   0,
																	   0,
																	   0});
			this.udDSPMNB.Location = new System.Drawing.Point(64, 24);
			this.udDSPMNB.Maximum = new System.Decimal(new int[] {
																	 1000,
																	 0,
																	 0,
																	 0});
			this.udDSPMNB.Minimum = new System.Decimal(new int[] {
																	 1,
																	 0,
																	 0,
																	 0});
			this.udDSPMNB.Name = "udDSPMNB";
			this.udDSPMNB.Size = new System.Drawing.Size(48, 20);
			this.udDSPMNB.TabIndex = 7;
			this.toolTip1.SetToolTip(this.udDSPMNB, "Controls the detection threshold for a pulse.  ");
			this.udDSPMNB.Value = new System.Decimal(new int[] {
																   15,
																   0,
																   0,
																   0});
			this.udDSPMNB.ValueChanged += new System.EventHandler(this.udDSPMNB_ValueChanged);
			// 
			// lblDSPNB2Threshold
			// 
			this.lblDSPNB2Threshold.Image = null;
			this.lblDSPNB2Threshold.Location = new System.Drawing.Point(8, 24);
			this.lblDSPNB2Threshold.Name = "lblDSPNB2Threshold";
			this.lblDSPNB2Threshold.Size = new System.Drawing.Size(64, 16);
			this.lblDSPNB2Threshold.TabIndex = 10;
			this.lblDSPNB2Threshold.Text = "Threshold:";
			// 
			// grpDSPLMSNR
			// 
			this.grpDSPLMSNR.Controls.Add(this.lblLMSNRgain);
			this.grpDSPLMSNR.Controls.Add(this.udLMSNRgain);
			this.grpDSPLMSNR.Controls.Add(this.udLMSNRdelay);
			this.grpDSPLMSNR.Controls.Add(this.lblLMSNRdelay);
			this.grpDSPLMSNR.Controls.Add(this.udLMSNRtaps);
			this.grpDSPLMSNR.Controls.Add(this.lblLMSNRtaps);
			this.grpDSPLMSNR.Location = new System.Drawing.Point(136, 8);
			this.grpDSPLMSNR.Name = "grpDSPLMSNR";
			this.grpDSPLMSNR.Size = new System.Drawing.Size(112, 128);
			this.grpDSPLMSNR.TabIndex = 8;
			this.grpDSPLMSNR.TabStop = false;
			this.grpDSPLMSNR.Text = "NR";
			// 
			// lblLMSNRgain
			// 
			this.lblLMSNRgain.Image = null;
			this.lblLMSNRgain.Location = new System.Drawing.Point(8, 72);
			this.lblLMSNRgain.Name = "lblLMSNRgain";
			this.lblLMSNRgain.Size = new System.Drawing.Size(40, 16);
			this.lblLMSNRgain.TabIndex = 9;
			this.lblLMSNRgain.Text = "Gain:";
			// 
			// udLMSNRgain
			// 
			this.udLMSNRgain.Increment = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.udLMSNRgain.Location = new System.Drawing.Point(56, 72);
			this.udLMSNRgain.Maximum = new System.Decimal(new int[] {
																		9999,
																		0,
																		0,
																		0});
			this.udLMSNRgain.Minimum = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udLMSNRgain.Name = "udLMSNRgain";
			this.udLMSNRgain.Size = new System.Drawing.Size(48, 20);
			this.udLMSNRgain.TabIndex = 7;
			this.toolTip1.SetToolTip(this.udLMSNRgain, "Gain determines the adaptation rate of the filter.");
			this.udLMSNRgain.Value = new System.Decimal(new int[] {
																	  50,
																	  0,
																	  0,
																	  0});
			this.udLMSNRgain.Enter += new System.EventHandler(this.udLMSNR_ValueChanged);
			this.udLMSNRgain.ValueChanged += new System.EventHandler(this.udLMSNR_ValueChanged);
			// 
			// udLMSNRdelay
			// 
			this.udLMSNRdelay.Increment = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.udLMSNRdelay.Location = new System.Drawing.Point(56, 48);
			this.udLMSNRdelay.Maximum = new System.Decimal(new int[] {
																		 127,
																		 0,
																		 0,
																		 0});
			this.udLMSNRdelay.Minimum = new System.Decimal(new int[] {
																		 16,
																		 0,
																		 0,
																		 0});
			this.udLMSNRdelay.Name = "udLMSNRdelay";
			this.udLMSNRdelay.Size = new System.Drawing.Size(48, 20);
			this.udLMSNRdelay.TabIndex = 6;
			this.toolTip1.SetToolTip(this.udLMSNRdelay, "Delay determines how far back you look in the signal before you begin to compute " +
				"a coherent signal enhancement filter.  ");
			this.udLMSNRdelay.Value = new System.Decimal(new int[] {
																	   50,
																	   0,
																	   0,
																	   0});
			this.udLMSNRdelay.Enter += new System.EventHandler(this.udLMSNR_ValueChanged);
			this.udLMSNRdelay.ValueChanged += new System.EventHandler(this.udLMSNR_ValueChanged);
			// 
			// lblLMSNRdelay
			// 
			this.lblLMSNRdelay.Image = null;
			this.lblLMSNRdelay.Location = new System.Drawing.Point(8, 48);
			this.lblLMSNRdelay.Name = "lblLMSNRdelay";
			this.lblLMSNRdelay.Size = new System.Drawing.Size(40, 16);
			this.lblLMSNRdelay.TabIndex = 5;
			this.lblLMSNRdelay.Text = "Delay:";
			// 
			// udLMSNRtaps
			// 
			this.udLMSNRtaps.Increment = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.udLMSNRtaps.Location = new System.Drawing.Point(56, 24);
			this.udLMSNRtaps.Maximum = new System.Decimal(new int[] {
																		127,
																		0,
																		0,
																		0});
			this.udLMSNRtaps.Minimum = new System.Decimal(new int[] {
																		31,
																		0,
																		0,
																		0});
			this.udLMSNRtaps.Name = "udLMSNRtaps";
			this.udLMSNRtaps.Size = new System.Drawing.Size(48, 20);
			this.udLMSNRtaps.TabIndex = 5;
			this.toolTip1.SetToolTip(this.udLMSNRtaps, "This determines the length of the computed filter.  ");
			this.udLMSNRtaps.Value = new System.Decimal(new int[] {
																	  65,
																	  0,
																	  0,
																	  0});
			this.udLMSNRtaps.Enter += new System.EventHandler(this.udLMSNR_ValueChanged);
			this.udLMSNRtaps.ValueChanged += new System.EventHandler(this.udLMSNR_ValueChanged);
			// 
			// lblLMSNRtaps
			// 
			this.lblLMSNRtaps.Image = null;
			this.lblLMSNRtaps.Location = new System.Drawing.Point(8, 24);
			this.lblLMSNRtaps.Name = "lblLMSNRtaps";
			this.lblLMSNRtaps.Size = new System.Drawing.Size(40, 16);
			this.lblLMSNRtaps.TabIndex = 3;
			this.lblLMSNRtaps.Text = "Taps:";
			// 
			// grpDSPLMSANF
			// 
			this.grpDSPLMSANF.Controls.Add(this.lblLMSANFgain);
			this.grpDSPLMSANF.Controls.Add(this.udLMSANFgain);
			this.grpDSPLMSANF.Controls.Add(this.lblLMSANFdelay);
			this.grpDSPLMSANF.Controls.Add(this.udLMSANFdelay);
			this.grpDSPLMSANF.Controls.Add(this.lblLMSANFTaps);
			this.grpDSPLMSANF.Controls.Add(this.udLMSANFtaps);
			this.grpDSPLMSANF.Location = new System.Drawing.Point(8, 8);
			this.grpDSPLMSANF.Name = "grpDSPLMSANF";
			this.grpDSPLMSANF.Size = new System.Drawing.Size(120, 128);
			this.grpDSPLMSANF.TabIndex = 7;
			this.grpDSPLMSANF.TabStop = false;
			this.grpDSPLMSANF.Text = "ANF";
			// 
			// lblLMSANFgain
			// 
			this.lblLMSANFgain.Image = null;
			this.lblLMSANFgain.Location = new System.Drawing.Point(8, 72);
			this.lblLMSANFgain.Name = "lblLMSANFgain";
			this.lblLMSANFgain.Size = new System.Drawing.Size(40, 16);
			this.lblLMSANFgain.TabIndex = 6;
			this.lblLMSANFgain.Text = "Gain:";
			// 
			// udLMSANFgain
			// 
			this.udLMSANFgain.Increment = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.udLMSANFgain.Location = new System.Drawing.Point(56, 72);
			this.udLMSANFgain.Maximum = new System.Decimal(new int[] {
																		 9999,
																		 0,
																		 0,
																		 0});
			this.udLMSANFgain.Minimum = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 0});
			this.udLMSANFgain.Name = "udLMSANFgain";
			this.udLMSANFgain.Size = new System.Drawing.Size(48, 20);
			this.udLMSANFgain.TabIndex = 3;
			this.toolTip1.SetToolTip(this.udLMSANFgain, "Gain determines the adaptation rate of the filter.");
			this.udLMSANFgain.Value = new System.Decimal(new int[] {
																	   50,
																	   0,
																	   0,
																	   0});
			this.udLMSANFgain.ValueChanged += new System.EventHandler(this.udLMSANF_ValueChanged);
			// 
			// lblLMSANFdelay
			// 
			this.lblLMSANFdelay.Image = null;
			this.lblLMSANFdelay.Location = new System.Drawing.Point(8, 48);
			this.lblLMSANFdelay.Name = "lblLMSANFdelay";
			this.lblLMSANFdelay.Size = new System.Drawing.Size(40, 16);
			this.lblLMSANFdelay.TabIndex = 4;
			this.lblLMSANFdelay.Text = "Delay:";
			// 
			// udLMSANFdelay
			// 
			this.udLMSANFdelay.Increment = new System.Decimal(new int[] {
																			1,
																			0,
																			0,
																			0});
			this.udLMSANFdelay.Location = new System.Drawing.Point(56, 48);
			this.udLMSANFdelay.Maximum = new System.Decimal(new int[] {
																		  127,
																		  0,
																		  0,
																		  0});
			this.udLMSANFdelay.Minimum = new System.Decimal(new int[] {
																		  16,
																		  0,
																		  0,
																		  0});
			this.udLMSANFdelay.Name = "udLMSANFdelay";
			this.udLMSANFdelay.Size = new System.Drawing.Size(48, 20);
			this.udLMSANFdelay.TabIndex = 2;
			this.toolTip1.SetToolTip(this.udLMSANFdelay, "Delay determines how far back you look in the signal before you begin to compute " +
				"a cancellation filter");
			this.udLMSANFdelay.Value = new System.Decimal(new int[] {
																		50,
																		0,
																		0,
																		0});
			this.udLMSANFdelay.ValueChanged += new System.EventHandler(this.udLMSANF_ValueChanged);
			// 
			// lblLMSANFTaps
			// 
			this.lblLMSANFTaps.Image = null;
			this.lblLMSANFTaps.Location = new System.Drawing.Point(8, 24);
			this.lblLMSANFTaps.Name = "lblLMSANFTaps";
			this.lblLMSANFTaps.Size = new System.Drawing.Size(40, 16);
			this.lblLMSANFTaps.TabIndex = 2;
			this.lblLMSANFTaps.Text = "Taps:";
			// 
			// udLMSANFtaps
			// 
			this.udLMSANFtaps.Increment = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.udLMSANFtaps.Location = new System.Drawing.Point(56, 24);
			this.udLMSANFtaps.Maximum = new System.Decimal(new int[] {
																		 127,
																		 0,
																		 0,
																		 0});
			this.udLMSANFtaps.Minimum = new System.Decimal(new int[] {
																		 31,
																		 0,
																		 0,
																		 0});
			this.udLMSANFtaps.Name = "udLMSANFtaps";
			this.udLMSANFtaps.Size = new System.Drawing.Size(48, 20);
			this.udLMSANFtaps.TabIndex = 1;
			this.toolTip1.SetToolTip(this.udLMSANFtaps, "This determines the length of the computed notch filter.");
			this.udLMSANFtaps.Value = new System.Decimal(new int[] {
																	   65,
																	   0,
																	   0,
																	   0});
			this.udLMSANFtaps.ValueChanged += new System.EventHandler(this.udLMSANF_ValueChanged);
			// 
			// grpDSPImageRejectRX
			// 
			this.grpDSPImageRejectRX.Controls.Add(this.lblDSPGainValRX);
			this.grpDSPImageRejectRX.Controls.Add(this.lblDSPPhaseValRX);
			this.grpDSPImageRejectRX.Controls.Add(this.udDSPImageGainRX);
			this.grpDSPImageRejectRX.Controls.Add(this.udDSPImagePhaseRX);
			this.grpDSPImageRejectRX.Controls.Add(this.lblDSPImageGainRX);
			this.grpDSPImageRejectRX.Controls.Add(this.tbDSPImagePhaseRX);
			this.grpDSPImageRejectRX.Controls.Add(this.lblDSPImagePhaseRX);
			this.grpDSPImageRejectRX.Controls.Add(this.tbDSPImageGainRX);
			this.grpDSPImageRejectRX.Location = new System.Drawing.Point(256, 8);
			this.grpDSPImageRejectRX.Name = "grpDSPImageRejectRX";
			this.grpDSPImageRejectRX.Size = new System.Drawing.Size(240, 128);
			this.grpDSPImageRejectRX.TabIndex = 6;
			this.grpDSPImageRejectRX.TabStop = false;
			this.grpDSPImageRejectRX.Text = "Image Rejection - RX";
			// 
			// lblDSPGainValRX
			// 
			this.lblDSPGainValRX.Image = null;
			this.lblDSPGainValRX.Location = new System.Drawing.Point(72, 104);
			this.lblDSPGainValRX.Name = "lblDSPGainValRX";
			this.lblDSPGainValRX.Size = new System.Drawing.Size(163, 16);
			this.lblDSPGainValRX.TabIndex = 15;
			this.lblDSPGainValRX.Text = "-500    -250       0       250     500";
			// 
			// lblDSPPhaseValRX
			// 
			this.lblDSPPhaseValRX.Image = null;
			this.lblDSPPhaseValRX.Location = new System.Drawing.Point(72, 56);
			this.lblDSPPhaseValRX.Name = "lblDSPPhaseValRX";
			this.lblDSPPhaseValRX.Size = new System.Drawing.Size(163, 16);
			this.lblDSPPhaseValRX.TabIndex = 14;
			this.lblDSPPhaseValRX.Text = "-900               0               900";
			// 
			// udDSPImageGainRX
			// 
			this.udDSPImageGainRX.DecimalPlaces = 2;
			this.udDSPImageGainRX.Increment = new System.Decimal(new int[] {
																			   1,
																			   0,
																			   0,
																			   131072});
			this.udDSPImageGainRX.Location = new System.Drawing.Point(16, 88);
			this.udDSPImageGainRX.Maximum = new System.Decimal(new int[] {
																			 500,
																			 0,
																			 0,
																			 0});
			this.udDSPImageGainRX.Minimum = new System.Decimal(new int[] {
																			 500,
																			 0,
																			 0,
																			 -2147483648});
			this.udDSPImageGainRX.Name = "udDSPImageGainRX";
			this.udDSPImageGainRX.Size = new System.Drawing.Size(56, 20);
			this.udDSPImageGainRX.TabIndex = 8;
			this.toolTip1.SetToolTip(this.udDSPImageGainRX, "Sets the amplitude/gain offset between the I and Q channels.  ");
			this.udDSPImageGainRX.Value = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.udDSPImageGainRX.ValueChanged += new System.EventHandler(this.udDSPImageGainRX_ValueChanged);
			// 
			// udDSPImagePhaseRX
			// 
			this.udDSPImagePhaseRX.DecimalPlaces = 2;
			this.udDSPImagePhaseRX.Increment = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				131072});
			this.udDSPImagePhaseRX.Location = new System.Drawing.Point(16, 40);
			this.udDSPImagePhaseRX.Maximum = new System.Decimal(new int[] {
																			  900,
																			  0,
																			  0,
																			  0});
			this.udDSPImagePhaseRX.Minimum = new System.Decimal(new int[] {
																			  900,
																			  0,
																			  0,
																			  -2147483648});
			this.udDSPImagePhaseRX.Name = "udDSPImagePhaseRX";
			this.udDSPImagePhaseRX.Size = new System.Drawing.Size(56, 20);
			this.udDSPImagePhaseRX.TabIndex = 7;
			this.toolTip1.SetToolTip(this.udDSPImagePhaseRX, "Sets the phase offset between the I and Q channels.  ");
			this.udDSPImagePhaseRX.Value = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
			this.udDSPImagePhaseRX.ValueChanged += new System.EventHandler(this.udDSPImagePhaseRX_ValueChanged);
			// 
			// lblDSPImageGainRX
			// 
			this.lblDSPImageGainRX.Image = null;
			this.lblDSPImageGainRX.Location = new System.Drawing.Point(16, 72);
			this.lblDSPImageGainRX.Name = "lblDSPImageGainRX";
			this.lblDSPImageGainRX.Size = new System.Drawing.Size(48, 16);
			this.lblDSPImageGainRX.TabIndex = 6;
			this.lblDSPImageGainRX.Text = "Gain:";
			// 
			// tbDSPImagePhaseRX
			// 
			this.tbDSPImagePhaseRX.LargeChange = 1;
			this.tbDSPImagePhaseRX.Location = new System.Drawing.Point(72, 24);
			this.tbDSPImagePhaseRX.Maximum = 900;
			this.tbDSPImagePhaseRX.Minimum = -900;
			this.tbDSPImagePhaseRX.Name = "tbDSPImagePhaseRX";
			this.tbDSPImagePhaseRX.Size = new System.Drawing.Size(160, 42);
			this.tbDSPImagePhaseRX.TabIndex = 3;
			this.tbDSPImagePhaseRX.TickFrequency = 50;
			this.toolTip1.SetToolTip(this.tbDSPImagePhaseRX, "Sets the phase offset between the I and Q channels.  ");
			this.tbDSPImagePhaseRX.Scroll += new System.EventHandler(this.tbDSPImagePhaseRX_Scroll);
			// 
			// lblDSPImagePhaseRX
			// 
			this.lblDSPImagePhaseRX.Image = null;
			this.lblDSPImagePhaseRX.Location = new System.Drawing.Point(16, 24);
			this.lblDSPImagePhaseRX.Name = "lblDSPImagePhaseRX";
			this.lblDSPImagePhaseRX.Size = new System.Drawing.Size(48, 16);
			this.lblDSPImagePhaseRX.TabIndex = 5;
			this.lblDSPImagePhaseRX.Text = "Phase:";
			// 
			// tbDSPImageGainRX
			// 
			this.tbDSPImageGainRX.LargeChange = 1;
			this.tbDSPImageGainRX.Location = new System.Drawing.Point(72, 72);
			this.tbDSPImageGainRX.Maximum = 500;
			this.tbDSPImageGainRX.Minimum = -500;
			this.tbDSPImageGainRX.Name = "tbDSPImageGainRX";
			this.tbDSPImageGainRX.Size = new System.Drawing.Size(160, 42);
			this.tbDSPImageGainRX.TabIndex = 4;
			this.tbDSPImageGainRX.TickFrequency = 50;
			this.toolTip1.SetToolTip(this.tbDSPImageGainRX, "Sets the amplitude/gain offset between the I and Q channels.  ");
			this.tbDSPImageGainRX.Scroll += new System.EventHandler(this.tbDSPImageGainRX_Scroll);
			// 
			// grpDSPAGC
			// 
			this.grpDSPAGC.Controls.Add(this.lblDSPAGCMaxGain);
			this.grpDSPAGC.Controls.Add(this.udDSPAGCMaxGaindB);
			this.grpDSPAGC.Controls.Add(this.udDSPAGCFixedGaindB);
			this.grpDSPAGC.Controls.Add(this.lblDSPAGCFixed);
			this.grpDSPAGC.Location = new System.Drawing.Point(8, 144);
			this.grpDSPAGC.Name = "grpDSPAGC";
			this.grpDSPAGC.Size = new System.Drawing.Size(136, 80);
			this.grpDSPAGC.TabIndex = 2;
			this.grpDSPAGC.TabStop = false;
			this.grpDSPAGC.Text = "AGC";
			// 
			// lblDSPAGCMaxGain
			// 
			this.lblDSPAGCMaxGain.Image = null;
			this.lblDSPAGCMaxGain.Location = new System.Drawing.Point(8, 48);
			this.lblDSPAGCMaxGain.Name = "lblDSPAGCMaxGain";
			this.lblDSPAGCMaxGain.Size = new System.Drawing.Size(80, 16);
			this.lblDSPAGCMaxGain.TabIndex = 7;
			this.lblDSPAGCMaxGain.Text = "Max Gain (dB):";
			// 
			// udDSPAGCMaxGaindB
			// 
			this.udDSPAGCMaxGaindB.Increment = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.udDSPAGCMaxGaindB.Location = new System.Drawing.Point(88, 48);
			this.udDSPAGCMaxGaindB.Maximum = new System.Decimal(new int[] {
																			  100,
																			  0,
																			  0,
																			  0});
			this.udDSPAGCMaxGaindB.Minimum = new System.Decimal(new int[] {
																			  20,
																			  0,
																			  0,
																			  -2147483648});
			this.udDSPAGCMaxGaindB.Name = "udDSPAGCMaxGaindB";
			this.udDSPAGCMaxGaindB.Size = new System.Drawing.Size(40, 20);
			this.udDSPAGCMaxGaindB.TabIndex = 6;
			this.toolTip1.SetToolTip(this.udDSPAGCMaxGaindB, "This provides for a threshold AGC.  Irrespective of how weak a signal is, no ga" +
				"in over Max Gain is applied.");
			this.udDSPAGCMaxGaindB.Value = new System.Decimal(new int[] {
																			68,
																			0,
																			0,
																			0});
			this.udDSPAGCMaxGaindB.ValueChanged += new System.EventHandler(this.udDSPAGCMaxGaindB_ValueChanged);
			// 
			// udDSPAGCFixedGaindB
			// 
			this.udDSPAGCFixedGaindB.Increment = new System.Decimal(new int[] {
																				  1,
																				  0,
																				  0,
																				  0});
			this.udDSPAGCFixedGaindB.Location = new System.Drawing.Point(88, 24);
			this.udDSPAGCFixedGaindB.Maximum = new System.Decimal(new int[] {
																				100,
																				0,
																				0,
																				0});
			this.udDSPAGCFixedGaindB.Minimum = new System.Decimal(new int[] {
																				20,
																				0,
																				0,
																				-2147483648});
			this.udDSPAGCFixedGaindB.Name = "udDSPAGCFixedGaindB";
			this.udDSPAGCFixedGaindB.Size = new System.Drawing.Size(40, 20);
			this.udDSPAGCFixedGaindB.TabIndex = 4;
			this.toolTip1.SetToolTip(this.udDSPAGCFixedGaindB, "When you choose Fixed AGC on the front panel, this number is used to multiply the" +
				" signal.");
			this.udDSPAGCFixedGaindB.Value = new System.Decimal(new int[] {
																			  20,
																			  0,
																			  0,
																			  0});
			this.udDSPAGCFixedGaindB.ValueChanged += new System.EventHandler(this.udDSPAGCFixedGaindB_ValueChanged);
			// 
			// lblDSPAGCFixed
			// 
			this.lblDSPAGCFixed.Image = null;
			this.lblDSPAGCFixed.Location = new System.Drawing.Point(8, 24);
			this.lblDSPAGCFixed.Name = "lblDSPAGCFixed";
			this.lblDSPAGCFixed.Size = new System.Drawing.Size(88, 16);
			this.lblDSPAGCFixed.TabIndex = 5;
			this.lblDSPAGCFixed.Text = "Fixed Gain (dB):";
			// 
			// grpDSPWindow
			// 
			this.grpDSPWindow.Controls.Add(this.comboDSPWindow);
			this.grpDSPWindow.Location = new System.Drawing.Point(256, 144);
			this.grpDSPWindow.Name = "grpDSPWindow";
			this.grpDSPWindow.Size = new System.Drawing.Size(104, 56);
			this.grpDSPWindow.TabIndex = 13;
			this.grpDSPWindow.TabStop = false;
			this.grpDSPWindow.Text = "Window";
			// 
			// comboDSPWindow
			// 
			this.comboDSPWindow.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboDSPWindow.DropDownWidth = 88;
			this.comboDSPWindow.Location = new System.Drawing.Point(8, 24);
			this.comboDSPWindow.Name = "comboDSPWindow";
			this.comboDSPWindow.Size = new System.Drawing.Size(88, 21);
			this.comboDSPWindow.TabIndex = 0;
			this.toolTip1.SetToolTip(this.comboDSPWindow, "Selects the DSP windowing function that will be applied to the power spectrum in " +
				"the main display when in Spectrum, Panadapter, and Waterfall modes.   ");
			this.comboDSPWindow.SelectedIndexChanged += new System.EventHandler(this.comboDSPWindow_SelectedIndexChanged);
			// 
			// grpDSPImageRejectTX
			// 
			this.grpDSPImageRejectTX.Controls.Add(this.lblDSPGainValTX);
			this.grpDSPImageRejectTX.Controls.Add(this.lblDSPPhaseValTX);
			this.grpDSPImageRejectTX.Controls.Add(this.udDSPImageGainTX);
			this.grpDSPImageRejectTX.Controls.Add(this.udDSPImagePhaseTX);
			this.grpDSPImageRejectTX.Controls.Add(this.lblDSPImageGainTX);
			this.grpDSPImageRejectTX.Controls.Add(this.tbDSPImagePhaseTX);
			this.grpDSPImageRejectTX.Controls.Add(this.lblDSPImagePhaseTX);
			this.grpDSPImageRejectTX.Controls.Add(this.tbDSPImageGainTX);
			this.grpDSPImageRejectTX.Location = new System.Drawing.Point(256, 8);
			this.grpDSPImageRejectTX.Name = "grpDSPImageRejectTX";
			this.grpDSPImageRejectTX.Size = new System.Drawing.Size(240, 128);
			this.grpDSPImageRejectTX.TabIndex = 16;
			this.grpDSPImageRejectTX.TabStop = false;
			this.grpDSPImageRejectTX.Text = "Image Rejection - TX";
			// 
			// lblDSPGainValTX
			// 
			this.lblDSPGainValTX.Image = null;
			this.lblDSPGainValTX.Location = new System.Drawing.Point(72, 104);
			this.lblDSPGainValTX.Name = "lblDSPGainValTX";
			this.lblDSPGainValTX.Size = new System.Drawing.Size(163, 16);
			this.lblDSPGainValTX.TabIndex = 15;
			this.lblDSPGainValTX.Text = "-500    -250       0       250     500";
			// 
			// lblDSPPhaseValTX
			// 
			this.lblDSPPhaseValTX.Image = null;
			this.lblDSPPhaseValTX.Location = new System.Drawing.Point(72, 56);
			this.lblDSPPhaseValTX.Name = "lblDSPPhaseValTX";
			this.lblDSPPhaseValTX.Size = new System.Drawing.Size(163, 16);
			this.lblDSPPhaseValTX.TabIndex = 14;
			this.lblDSPPhaseValTX.Text = "-400    -200       0       200     400";
			// 
			// udDSPImageGainTX
			// 
			this.udDSPImageGainTX.DecimalPlaces = 2;
			this.udDSPImageGainTX.Increment = new System.Decimal(new int[] {
																			   1,
																			   0,
																			   0,
																			   131072});
			this.udDSPImageGainTX.Location = new System.Drawing.Point(16, 88);
			this.udDSPImageGainTX.Maximum = new System.Decimal(new int[] {
																			 500,
																			 0,
																			 0,
																			 0});
			this.udDSPImageGainTX.Minimum = new System.Decimal(new int[] {
																			 500,
																			 0,
																			 0,
																			 -2147483648});
			this.udDSPImageGainTX.Name = "udDSPImageGainTX";
			this.udDSPImageGainTX.Size = new System.Drawing.Size(56, 20);
			this.udDSPImageGainTX.TabIndex = 8;
			this.toolTip1.SetToolTip(this.udDSPImageGainTX, "Sets the amplitude/gain offset between the I and Q channels.  ");
			this.udDSPImageGainTX.Value = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.udDSPImageGainTX.ValueChanged += new System.EventHandler(this.udDSPImageGainTX_ValueChanged);
			// 
			// udDSPImagePhaseTX
			// 
			this.udDSPImagePhaseTX.DecimalPlaces = 2;
			this.udDSPImagePhaseTX.Increment = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				131072});
			this.udDSPImagePhaseTX.Location = new System.Drawing.Point(16, 40);
			this.udDSPImagePhaseTX.Maximum = new System.Decimal(new int[] {
																			  400,
																			  0,
																			  0,
																			  0});
			this.udDSPImagePhaseTX.Minimum = new System.Decimal(new int[] {
																			  400,
																			  0,
																			  0,
																			  -2147483648});
			this.udDSPImagePhaseTX.Name = "udDSPImagePhaseTX";
			this.udDSPImagePhaseTX.Size = new System.Drawing.Size(56, 20);
			this.udDSPImagePhaseTX.TabIndex = 7;
			this.toolTip1.SetToolTip(this.udDSPImagePhaseTX, "Sets the phase offset between the I and Q channels.  ");
			this.udDSPImagePhaseTX.Value = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
			this.udDSPImagePhaseTX.ValueChanged += new System.EventHandler(this.udDSPImagePhaseTX_ValueChanged);
			// 
			// lblDSPImageGainTX
			// 
			this.lblDSPImageGainTX.Image = null;
			this.lblDSPImageGainTX.Location = new System.Drawing.Point(16, 72);
			this.lblDSPImageGainTX.Name = "lblDSPImageGainTX";
			this.lblDSPImageGainTX.Size = new System.Drawing.Size(48, 16);
			this.lblDSPImageGainTX.TabIndex = 6;
			this.lblDSPImageGainTX.Text = "Gain:";
			// 
			// tbDSPImagePhaseTX
			// 
			this.tbDSPImagePhaseTX.LargeChange = 1;
			this.tbDSPImagePhaseTX.Location = new System.Drawing.Point(72, 24);
			this.tbDSPImagePhaseTX.Maximum = 400;
			this.tbDSPImagePhaseTX.Minimum = -400;
			this.tbDSPImagePhaseTX.Name = "tbDSPImagePhaseTX";
			this.tbDSPImagePhaseTX.Size = new System.Drawing.Size(160, 42);
			this.tbDSPImagePhaseTX.TabIndex = 3;
			this.tbDSPImagePhaseTX.TickFrequency = 50;
			this.toolTip1.SetToolTip(this.tbDSPImagePhaseTX, "Sets the phase offset between the I and Q channels.  ");
			this.tbDSPImagePhaseTX.Scroll += new System.EventHandler(this.tbDSPImagePhaseTX_Scroll);
			// 
			// lblDSPImagePhaseTX
			// 
			this.lblDSPImagePhaseTX.Image = null;
			this.lblDSPImagePhaseTX.Location = new System.Drawing.Point(16, 24);
			this.lblDSPImagePhaseTX.Name = "lblDSPImagePhaseTX";
			this.lblDSPImagePhaseTX.Size = new System.Drawing.Size(48, 16);
			this.lblDSPImagePhaseTX.TabIndex = 5;
			this.lblDSPImagePhaseTX.Text = "Phase:";
			// 
			// tbDSPImageGainTX
			// 
			this.tbDSPImageGainTX.LargeChange = 1;
			this.tbDSPImageGainTX.Location = new System.Drawing.Point(72, 72);
			this.tbDSPImageGainTX.Maximum = 500;
			this.tbDSPImageGainTX.Minimum = -500;
			this.tbDSPImageGainTX.Name = "tbDSPImageGainTX";
			this.tbDSPImageGainTX.Size = new System.Drawing.Size(160, 42);
			this.tbDSPImageGainTX.TabIndex = 4;
			this.tbDSPImageGainTX.TickFrequency = 50;
			this.toolTip1.SetToolTip(this.tbDSPImageGainTX, "Sets the amplitude/gain offset between the I and Q channels.  ");
			this.tbDSPImageGainTX.Scroll += new System.EventHandler(this.tbDSPImageGainTX_Scroll);
			// 
			// tpTransmit
			// 
			this.tpTransmit.Controls.Add(this.grpTXMicPreamp);
			this.tpTransmit.Controls.Add(this.grpPATune);
			this.tpTransmit.Controls.Add(this.grpTXCompression);
			this.tpTransmit.Controls.Add(this.grpTXFilter);
			this.tpTransmit.Controls.Add(this.grpTXEqualizer);
			this.tpTransmit.Location = new System.Drawing.Point(4, 22);
			this.tpTransmit.Name = "tpTransmit";
			this.tpTransmit.Size = new System.Drawing.Size(584, 286);
			this.tpTransmit.TabIndex = 5;
			this.tpTransmit.Text = "Transmit";
			// 
			// grpTXMicPreamp
			// 
			this.grpTXMicPreamp.Controls.Add(this.lblTXMicPreampGain);
			this.grpTXMicPreamp.Controls.Add(this.udTXPreGain);
			this.grpTXMicPreamp.Location = new System.Drawing.Point(240, 200);
			this.grpTXMicPreamp.Name = "grpTXMicPreamp";
			this.grpTXMicPreamp.Size = new System.Drawing.Size(112, 56);
			this.grpTXMicPreamp.TabIndex = 23;
			this.grpTXMicPreamp.TabStop = false;
			this.grpTXMicPreamp.Text = "Mic Preamp (dB)";
			// 
			// lblTXMicPreampGain
			// 
			this.lblTXMicPreampGain.Image = null;
			this.lblTXMicPreampGain.Location = new System.Drawing.Point(8, 24);
			this.lblTXMicPreampGain.Name = "lblTXMicPreampGain";
			this.lblTXMicPreampGain.Size = new System.Drawing.Size(32, 16);
			this.lblTXMicPreampGain.TabIndex = 6;
			this.lblTXMicPreampGain.Text = "Gain:";
			// 
			// udTXPreGain
			// 
			this.udTXPreGain.DecimalPlaces = 1;
			this.udTXPreGain.Increment = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.udTXPreGain.Location = new System.Drawing.Point(40, 24);
			this.udTXPreGain.Maximum = new System.Decimal(new int[] {
																		70,
																		0,
																		0,
																		0});
			this.udTXPreGain.Minimum = new System.Decimal(new int[] {
																		30,
																		0,
																		0,
																		-2147483648});
			this.udTXPreGain.Name = "udTXPreGain";
			this.udTXPreGain.Size = new System.Drawing.Size(48, 20);
			this.udTXPreGain.TabIndex = 0;
			this.toolTip1.SetToolTip(this.udTXPreGain, "For proper voice operation, use this control in TX while speaking in a normal voi" +
				"ce until ALC is just moving.");
			this.udTXPreGain.Value = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udTXPreGain.ValueChanged += new System.EventHandler(this.udTXPreamp_ValueChanged);
			// 
			// grpPATune
			// 
			this.grpPATune.Controls.Add(this.lblTransmitTunePower);
			this.grpPATune.Controls.Add(this.udTXTunePower);
			this.grpPATune.Location = new System.Drawing.Point(144, 200);
			this.grpPATune.Name = "grpPATune";
			this.grpPATune.Size = new System.Drawing.Size(88, 80);
			this.grpPATune.TabIndex = 22;
			this.grpPATune.TabStop = false;
			this.grpPATune.Text = "Tune";
			// 
			// lblTransmitTunePower
			// 
			this.lblTransmitTunePower.Image = null;
			this.lblTransmitTunePower.Location = new System.Drawing.Point(16, 24);
			this.lblTransmitTunePower.Name = "lblTransmitTunePower";
			this.lblTransmitTunePower.Size = new System.Drawing.Size(64, 23);
			this.lblTransmitTunePower.TabIndex = 5;
			this.lblTransmitTunePower.Text = "Power (W):";
			// 
			// udTXTunePower
			// 
			this.udTXTunePower.Increment = new System.Decimal(new int[] {
																			1,
																			0,
																			0,
																			0});
			this.udTXTunePower.Location = new System.Drawing.Point(24, 48);
			this.udTXTunePower.Maximum = new System.Decimal(new int[] {
																		  100,
																		  0,
																		  0,
																		  0});
			this.udTXTunePower.Minimum = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.udTXTunePower.Name = "udTXTunePower";
			this.udTXTunePower.Size = new System.Drawing.Size(48, 20);
			this.udTXTunePower.TabIndex = 4;
			this.toolTip1.SetToolTip(this.udTXTunePower, "Power used when using the TUN button on the front panel.");
			this.udTXTunePower.Value = new System.Decimal(new int[] {
																		10,
																		0,
																		0,
																		0});
			this.udTXTunePower.ValueChanged += new System.EventHandler(this.udTransmitTunePower_ValueChanged);
			// 
			// grpTXCompression
			// 
			this.grpTXCompression.Controls.Add(this.udTXFFCompression);
			this.grpTXCompression.Controls.Add(this.lblTXFFVal);
			this.grpTXCompression.Controls.Add(this.lblTransmitFeedForward);
			this.grpTXCompression.Controls.Add(this.tbTXFFCompression);
			this.grpTXCompression.Location = new System.Drawing.Point(368, 8);
			this.grpTXCompression.Name = "grpTXCompression";
			this.grpTXCompression.Size = new System.Drawing.Size(192, 104);
			this.grpTXCompression.TabIndex = 21;
			this.grpTXCompression.TabStop = false;
			this.grpTXCompression.Text = "Transmit Compression";
			// 
			// udTXFFCompression
			// 
			this.udTXFFCompression.Increment = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.udTXFFCompression.Location = new System.Drawing.Point(104, 24);
			this.udTXFFCompression.Maximum = new System.Decimal(new int[] {
																			  20,
																			  0,
																			  0,
																			  0});
			this.udTXFFCompression.Minimum = new System.Decimal(new int[] {
																			  0,
																			  0,
																			  0,
																			  0});
			this.udTXFFCompression.Name = "udTXFFCompression";
			this.udTXFFCompression.Size = new System.Drawing.Size(48, 20);
			this.udTXFFCompression.TabIndex = 31;
			this.toolTip1.SetToolTip(this.udTXFFCompression, "Sets the compression value allowing more average power without raising the peaks." +
				"");
			this.udTXFFCompression.Value = new System.Decimal(new int[] {
																			3,
																			0,
																			0,
																			0});
			this.udTXFFCompression.ValueChanged += new System.EventHandler(this.udTXFFCompression_ValueChanged);
			// 
			// lblTXFFVal
			// 
			this.lblTXFFVal.Image = null;
			this.lblTXFFVal.Location = new System.Drawing.Point(32, 80);
			this.lblTXFFVal.Name = "lblTXFFVal";
			this.lblTXFFVal.Size = new System.Drawing.Size(152, 16);
			this.lblTXFFVal.TabIndex = 29;
			this.lblTXFFVal.Text = "0dB             10dB            20dB";
			// 
			// lblTransmitFeedForward
			// 
			this.lblTransmitFeedForward.Image = null;
			this.lblTransmitFeedForward.Location = new System.Drawing.Point(16, 24);
			this.lblTransmitFeedForward.Name = "lblTransmitFeedForward";
			this.lblTransmitFeedForward.Size = new System.Drawing.Size(72, 23);
			this.lblTransmitFeedForward.TabIndex = 23;
			this.lblTransmitFeedForward.Text = "FeedForward";
			// 
			// tbTXFFCompression
			// 
			this.tbTXFFCompression.Location = new System.Drawing.Point(24, 48);
			this.tbTXFFCompression.Maximum = 20;
			this.tbTXFFCompression.Name = "tbTXFFCompression";
			this.tbTXFFCompression.Size = new System.Drawing.Size(152, 42);
			this.tbTXFFCompression.TabIndex = 21;
			this.toolTip1.SetToolTip(this.tbTXFFCompression, "Sets the compression value allowing more average power without raising the peaks." +
				"");
			this.tbTXFFCompression.Value = 3;
			this.tbTXFFCompression.Scroll += new System.EventHandler(this.tbTXFFCompression_Scroll);
			// 
			// grpTXFilter
			// 
			this.grpTXFilter.Controls.Add(this.lblTXFilterHigh);
			this.grpTXFilter.Controls.Add(this.udTXFilterLow);
			this.grpTXFilter.Controls.Add(this.lblTXFilterLow);
			this.grpTXFilter.Controls.Add(this.udTXFilterHigh);
			this.grpTXFilter.Location = new System.Drawing.Point(8, 200);
			this.grpTXFilter.Name = "grpTXFilter";
			this.grpTXFilter.Size = new System.Drawing.Size(128, 80);
			this.grpTXFilter.TabIndex = 19;
			this.grpTXFilter.TabStop = false;
			this.grpTXFilter.Text = "Transmit Filter";
			// 
			// lblTXFilterHigh
			// 
			this.lblTXFilterHigh.Image = null;
			this.lblTXFilterHigh.Location = new System.Drawing.Point(16, 24);
			this.lblTXFilterHigh.Name = "lblTXFilterHigh";
			this.lblTXFilterHigh.Size = new System.Drawing.Size(40, 23);
			this.lblTXFilterHigh.TabIndex = 3;
			this.lblTXFilterHigh.Text = "High:";
			// 
			// udTXFilterLow
			// 
			this.udTXFilterLow.Increment = new System.Decimal(new int[] {
																			1,
																			0,
																			0,
																			0});
			this.udTXFilterLow.Location = new System.Drawing.Point(56, 48);
			this.udTXFilterLow.Maximum = new System.Decimal(new int[] {
																		  1000,
																		  0,
																		  0,
																		  0});
			this.udTXFilterLow.Minimum = new System.Decimal(new int[] {
																		  0,
																		  0,
																		  0,
																		  0});
			this.udTXFilterLow.Name = "udTXFilterLow";
			this.udTXFilterLow.Size = new System.Drawing.Size(56, 20);
			this.udTXFilterLow.TabIndex = 2;
			this.toolTip1.SetToolTip(this.udTXFilterLow, "Low Frequency TX Filter Cutoff");
			this.udTXFilterLow.Value = new System.Decimal(new int[] {
																		300,
																		0,
																		0,
																		0});
			this.udTXFilterLow.ValueChanged += new System.EventHandler(this.udTXFilterLow_ValueChanged);
			// 
			// lblTXFilterLow
			// 
			this.lblTXFilterLow.Image = null;
			this.lblTXFilterLow.Location = new System.Drawing.Point(16, 48);
			this.lblTXFilterLow.Name = "lblTXFilterLow";
			this.lblTXFilterLow.Size = new System.Drawing.Size(40, 23);
			this.lblTXFilterLow.TabIndex = 1;
			this.lblTXFilterLow.Text = "Low:";
			// 
			// udTXFilterHigh
			// 
			this.udTXFilterHigh.Increment = new System.Decimal(new int[] {
																			 1,
																			 0,
																			 0,
																			 0});
			this.udTXFilterHigh.Location = new System.Drawing.Point(56, 24);
			this.udTXFilterHigh.Maximum = new System.Decimal(new int[] {
																		   20000,
																		   0,
																		   0,
																		   0});
			this.udTXFilterHigh.Minimum = new System.Decimal(new int[] {
																		   2000,
																		   0,
																		   0,
																		   0});
			this.udTXFilterHigh.Name = "udTXFilterHigh";
			this.udTXFilterHigh.Size = new System.Drawing.Size(56, 20);
			this.udTXFilterHigh.TabIndex = 0;
			this.toolTip1.SetToolTip(this.udTXFilterHigh, "High Frequency TX Filter Cutoff");
			this.udTXFilterHigh.Value = new System.Decimal(new int[] {
																		 3000,
																		 0,
																		 0,
																		 0});
			this.udTXFilterHigh.ValueChanged += new System.EventHandler(this.udTXFilterHigh_ValueChanged);
			// 
			// grpTXEqualizer
			// 
			this.grpTXEqualizer.Controls.Add(this.chkDCBlock);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ3500);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ3500);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ80);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ160);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ80);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ160);
			this.grpTXEqualizer.Controls.Add(this.lblEQ15db);
			this.grpTXEqualizer.Controls.Add(this.btnTXEQReset);
			this.grpTXEqualizer.Controls.Add(this.chkTXEQEnabled);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ2000);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ2300);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ2600);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ3000);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ1600);
			this.grpTXEqualizer.Controls.Add(this.lblEQminus15db);
			this.grpTXEqualizer.Controls.Add(this.lblEQ0dB);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ3000);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ2600);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ2300);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ2000);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ1600);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ1300);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ1000);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ600);
			this.grpTXEqualizer.Controls.Add(this.lblTXEQ300);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ1300);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ1000);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ600);
			this.grpTXEqualizer.Controls.Add(this.tbTXEQ300);
			this.grpTXEqualizer.Location = new System.Drawing.Point(8, 8);
			this.grpTXEqualizer.Name = "grpTXEqualizer";
			this.grpTXEqualizer.Size = new System.Drawing.Size(352, 184);
			this.grpTXEqualizer.TabIndex = 18;
			this.grpTXEqualizer.TabStop = false;
			this.grpTXEqualizer.Text = "Transmit Equalizer (Hz/KHz)";
			// 
			// chkDCBlock
			// 
			this.chkDCBlock.Image = null;
			this.chkDCBlock.Location = new System.Drawing.Point(200, 16);
			this.chkDCBlock.Name = "chkDCBlock";
			this.chkDCBlock.Size = new System.Drawing.Size(104, 16);
			this.chkDCBlock.TabIndex = 48;
			this.chkDCBlock.Text = "DCBlock";
			this.chkDCBlock.CheckedChanged += new System.EventHandler(this.chkDCBlock_CheckedChanged);
			// 
			// lblTXEQ3500
			// 
			this.lblTXEQ3500.Image = null;
			this.lblTXEQ3500.Location = new System.Drawing.Point(277, 160);
			this.lblTXEQ3500.Name = "lblTXEQ3500";
			this.lblTXEQ3500.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ3500.TabIndex = 47;
			this.lblTXEQ3500.Text = "3.5";
			// 
			// tbTXEQ3500
			// 
			this.tbTXEQ3500.AutoSize = false;
			this.tbTXEQ3500.Location = new System.Drawing.Point(280, 40);
			this.tbTXEQ3500.Maximum = 15;
			this.tbTXEQ3500.Minimum = -15;
			this.tbTXEQ3500.Name = "tbTXEQ3500";
			this.tbTXEQ3500.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ3500.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ3500.TabIndex = 46;
			this.tbTXEQ3500.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ3500, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ3500.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// lblTXEQ80
			// 
			this.lblTXEQ80.Image = null;
			this.lblTXEQ80.Location = new System.Drawing.Point(15, 160);
			this.lblTXEQ80.Name = "lblTXEQ80";
			this.lblTXEQ80.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ80.TabIndex = 45;
			this.lblTXEQ80.Text = "80";
			// 
			// lblTXEQ160
			// 
			this.lblTXEQ160.Image = null;
			this.lblTXEQ160.Location = new System.Drawing.Point(35, 160);
			this.lblTXEQ160.Name = "lblTXEQ160";
			this.lblTXEQ160.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ160.TabIndex = 44;
			this.lblTXEQ160.Text = "160";
			// 
			// tbTXEQ80
			// 
			this.tbTXEQ80.AutoSize = false;
			this.tbTXEQ80.Location = new System.Drawing.Point(16, 40);
			this.tbTXEQ80.Maximum = 15;
			this.tbTXEQ80.Minimum = -15;
			this.tbTXEQ80.Name = "tbTXEQ80";
			this.tbTXEQ80.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ80.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ80.TabIndex = 43;
			this.tbTXEQ80.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ80, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ80.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// tbTXEQ160
			// 
			this.tbTXEQ160.AutoSize = false;
			this.tbTXEQ160.Location = new System.Drawing.Point(40, 40);
			this.tbTXEQ160.Maximum = 15;
			this.tbTXEQ160.Minimum = -15;
			this.tbTXEQ160.Name = "tbTXEQ160";
			this.tbTXEQ160.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ160.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ160.TabIndex = 42;
			this.tbTXEQ160.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ160, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ160.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// lblEQ15db
			// 
			this.lblEQ15db.Image = null;
			this.lblEQ15db.Location = new System.Drawing.Point(312, 42);
			this.lblEQ15db.Name = "lblEQ15db";
			this.lblEQ15db.Size = new System.Drawing.Size(32, 16);
			this.lblEQ15db.TabIndex = 22;
			this.lblEQ15db.Text = "15dB";
			this.lblEQ15db.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnTXEQReset
			// 
			this.btnTXEQReset.Image = null;
			this.btnTXEQReset.Location = new System.Drawing.Point(88, 20);
			this.btnTXEQReset.Name = "btnTXEQReset";
			this.btnTXEQReset.Size = new System.Drawing.Size(48, 20);
			this.btnTXEQReset.TabIndex = 41;
			this.btnTXEQReset.Text = "Reset";
			this.toolTip1.SetToolTip(this.btnTXEQReset, "Reset all EQ values to flat (0dB).");
			this.btnTXEQReset.Click += new System.EventHandler(this.btnTXEQReset_Click);
			// 
			// chkTXEQEnabled
			// 
			this.chkTXEQEnabled.Image = null;
			this.chkTXEQEnabled.Location = new System.Drawing.Point(16, 20);
			this.chkTXEQEnabled.Name = "chkTXEQEnabled";
			this.chkTXEQEnabled.Size = new System.Drawing.Size(72, 16);
			this.chkTXEQEnabled.TabIndex = 40;
			this.chkTXEQEnabled.Text = "Enabled";
			this.toolTip1.SetToolTip(this.chkTXEQEnabled, "Enables the equalizer settings below.");
			this.chkTXEQEnabled.CheckedChanged += new System.EventHandler(this.chkTXEQEnabled_CheckedChanged);
			// 
			// lblTXEQ2000
			// 
			this.lblTXEQ2000.Image = null;
			this.lblTXEQ2000.Location = new System.Drawing.Point(181, 160);
			this.lblTXEQ2000.Name = "lblTXEQ2000";
			this.lblTXEQ2000.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ2000.TabIndex = 35;
			this.lblTXEQ2000.Text = "2.0";
			// 
			// lblTXEQ2300
			// 
			this.lblTXEQ2300.Image = null;
			this.lblTXEQ2300.Location = new System.Drawing.Point(205, 160);
			this.lblTXEQ2300.Name = "lblTXEQ2300";
			this.lblTXEQ2300.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ2300.TabIndex = 34;
			this.lblTXEQ2300.Text = "2.3";
			// 
			// lblTXEQ2600
			// 
			this.lblTXEQ2600.Image = null;
			this.lblTXEQ2600.Location = new System.Drawing.Point(229, 160);
			this.lblTXEQ2600.Name = "lblTXEQ2600";
			this.lblTXEQ2600.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ2600.TabIndex = 33;
			this.lblTXEQ2600.Text = "2.6";
			// 
			// lblTXEQ3000
			// 
			this.lblTXEQ3000.Image = null;
			this.lblTXEQ3000.Location = new System.Drawing.Point(253, 160);
			this.lblTXEQ3000.Name = "lblTXEQ3000";
			this.lblTXEQ3000.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ3000.TabIndex = 32;
			this.lblTXEQ3000.Text = "3.0";
			// 
			// lblTXEQ1600
			// 
			this.lblTXEQ1600.Image = null;
			this.lblTXEQ1600.Location = new System.Drawing.Point(157, 160);
			this.lblTXEQ1600.Name = "lblTXEQ1600";
			this.lblTXEQ1600.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ1600.TabIndex = 27;
			this.lblTXEQ1600.Text = "1.6";
			// 
			// lblEQminus15db
			// 
			this.lblEQminus15db.Image = null;
			this.lblEQminus15db.Location = new System.Drawing.Point(312, 150);
			this.lblEQminus15db.Name = "lblEQminus15db";
			this.lblEQminus15db.Size = new System.Drawing.Size(34, 16);
			this.lblEQminus15db.TabIndex = 39;
			this.lblEQminus15db.Text = "-15dB";
			this.lblEQminus15db.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblEQ0dB
			// 
			this.lblEQ0dB.Image = null;
			this.lblEQ0dB.Location = new System.Drawing.Point(312, 97);
			this.lblEQ0dB.Name = "lblEQ0dB";
			this.lblEQ0dB.Size = new System.Drawing.Size(32, 16);
			this.lblEQ0dB.TabIndex = 37;
			this.lblEQ0dB.Text = "  0dB";
			this.lblEQ0dB.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// tbTXEQ3000
			// 
			this.tbTXEQ3000.AutoSize = false;
			this.tbTXEQ3000.Location = new System.Drawing.Point(256, 40);
			this.tbTXEQ3000.Maximum = 15;
			this.tbTXEQ3000.Minimum = -15;
			this.tbTXEQ3000.Name = "tbTXEQ3000";
			this.tbTXEQ3000.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ3000.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ3000.TabIndex = 28;
			this.tbTXEQ3000.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ3000, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ3000.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// tbTXEQ2600
			// 
			this.tbTXEQ2600.AutoSize = false;
			this.tbTXEQ2600.Location = new System.Drawing.Point(232, 40);
			this.tbTXEQ2600.Maximum = 15;
			this.tbTXEQ2600.Minimum = -15;
			this.tbTXEQ2600.Name = "tbTXEQ2600";
			this.tbTXEQ2600.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ2600.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ2600.TabIndex = 29;
			this.tbTXEQ2600.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ2600, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ2600.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// tbTXEQ2300
			// 
			this.tbTXEQ2300.AutoSize = false;
			this.tbTXEQ2300.Location = new System.Drawing.Point(208, 40);
			this.tbTXEQ2300.Maximum = 15;
			this.tbTXEQ2300.Minimum = -15;
			this.tbTXEQ2300.Name = "tbTXEQ2300";
			this.tbTXEQ2300.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ2300.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ2300.TabIndex = 31;
			this.tbTXEQ2300.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ2300, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ2300.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// tbTXEQ2000
			// 
			this.tbTXEQ2000.AutoSize = false;
			this.tbTXEQ2000.Location = new System.Drawing.Point(184, 40);
			this.tbTXEQ2000.Maximum = 15;
			this.tbTXEQ2000.Minimum = -15;
			this.tbTXEQ2000.Name = "tbTXEQ2000";
			this.tbTXEQ2000.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ2000.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ2000.TabIndex = 30;
			this.tbTXEQ2000.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ2000, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ2000.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// tbTXEQ1600
			// 
			this.tbTXEQ1600.AutoSize = false;
			this.tbTXEQ1600.Location = new System.Drawing.Point(160, 40);
			this.tbTXEQ1600.Maximum = 15;
			this.tbTXEQ1600.Minimum = -15;
			this.tbTXEQ1600.Name = "tbTXEQ1600";
			this.tbTXEQ1600.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ1600.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ1600.TabIndex = 21;
			this.tbTXEQ1600.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ1600, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ1600.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// lblTXEQ1300
			// 
			this.lblTXEQ1300.Image = null;
			this.lblTXEQ1300.Location = new System.Drawing.Point(133, 160);
			this.lblTXEQ1300.Name = "lblTXEQ1300";
			this.lblTXEQ1300.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ1300.TabIndex = 26;
			this.lblTXEQ1300.Text = "1.3";
			// 
			// lblTXEQ1000
			// 
			this.lblTXEQ1000.Image = null;
			this.lblTXEQ1000.Location = new System.Drawing.Point(109, 160);
			this.lblTXEQ1000.Name = "lblTXEQ1000";
			this.lblTXEQ1000.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ1000.TabIndex = 25;
			this.lblTXEQ1000.Text = "1.0";
			// 
			// lblTXEQ600
			// 
			this.lblTXEQ600.Image = null;
			this.lblTXEQ600.Location = new System.Drawing.Point(85, 160);
			this.lblTXEQ600.Name = "lblTXEQ600";
			this.lblTXEQ600.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ600.TabIndex = 24;
			this.lblTXEQ600.Text = "0.6";
			// 
			// lblTXEQ300
			// 
			this.lblTXEQ300.Image = null;
			this.lblTXEQ300.Location = new System.Drawing.Point(61, 160);
			this.lblTXEQ300.Name = "lblTXEQ300";
			this.lblTXEQ300.Size = new System.Drawing.Size(24, 16);
			this.lblTXEQ300.TabIndex = 23;
			this.lblTXEQ300.Text = "0.3";
			// 
			// tbTXEQ1300
			// 
			this.tbTXEQ1300.AutoSize = false;
			this.tbTXEQ1300.Location = new System.Drawing.Point(136, 40);
			this.tbTXEQ1300.Maximum = 15;
			this.tbTXEQ1300.Minimum = -15;
			this.tbTXEQ1300.Name = "tbTXEQ1300";
			this.tbTXEQ1300.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ1300.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ1300.TabIndex = 22;
			this.tbTXEQ1300.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ1300, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ1300.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// tbTXEQ1000
			// 
			this.tbTXEQ1000.AutoSize = false;
			this.tbTXEQ1000.Location = new System.Drawing.Point(112, 40);
			this.tbTXEQ1000.Maximum = 15;
			this.tbTXEQ1000.Minimum = -15;
			this.tbTXEQ1000.Name = "tbTXEQ1000";
			this.tbTXEQ1000.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ1000.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ1000.TabIndex = 20;
			this.tbTXEQ1000.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ1000, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ1000.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// tbTXEQ600
			// 
			this.tbTXEQ600.AutoSize = false;
			this.tbTXEQ600.Location = new System.Drawing.Point(88, 40);
			this.tbTXEQ600.Maximum = 15;
			this.tbTXEQ600.Minimum = -15;
			this.tbTXEQ600.Name = "tbTXEQ600";
			this.tbTXEQ600.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ600.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ600.TabIndex = 19;
			this.tbTXEQ600.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ600, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ600.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// tbTXEQ300
			// 
			this.tbTXEQ300.AutoSize = false;
			this.tbTXEQ300.Location = new System.Drawing.Point(64, 40);
			this.tbTXEQ300.Maximum = 15;
			this.tbTXEQ300.Minimum = -15;
			this.tbTXEQ300.Name = "tbTXEQ300";
			this.tbTXEQ300.Orientation = System.Windows.Forms.Orientation.Vertical;
			this.tbTXEQ300.Size = new System.Drawing.Size(20, 128);
			this.tbTXEQ300.TabIndex = 18;
			this.tbTXEQ300.TickFrequency = 3;
			this.toolTip1.SetToolTip(this.tbTXEQ300, "Adjusts specific frequency bands for transmit equalization.");
			this.tbTXEQ300.Scroll += new System.EventHandler(this.tbTXEQ_Scroll);
			// 
			// tpPowerAmplifier
			// 
			this.tpPowerAmplifier.Controls.Add(this.grpPABandOffset);
			this.tpPowerAmplifier.Controls.Add(this.grpPAGainByBand);
			this.tpPowerAmplifier.Location = new System.Drawing.Point(4, 22);
			this.tpPowerAmplifier.Name = "tpPowerAmplifier";
			this.tpPowerAmplifier.Size = new System.Drawing.Size(584, 286);
			this.tpPowerAmplifier.TabIndex = 8;
			this.tpPowerAmplifier.Text = "PA Settings";
			// 
			// grpPABandOffset
			// 
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset10);
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset12);
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset15);
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset17);
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset20);
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset30);
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset40);
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset60);
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset80);
			this.grpPABandOffset.Controls.Add(this.lblPABandOffset160);
			this.grpPABandOffset.Controls.Add(this.udPAADC17);
			this.grpPABandOffset.Controls.Add(this.udPAADC15);
			this.grpPABandOffset.Controls.Add(this.udPAADC20);
			this.grpPABandOffset.Controls.Add(this.udPAADC12);
			this.grpPABandOffset.Controls.Add(this.udPAADC10);
			this.grpPABandOffset.Controls.Add(this.udPAADC160);
			this.grpPABandOffset.Controls.Add(this.udPAADC80);
			this.grpPABandOffset.Controls.Add(this.udPAADC60);
			this.grpPABandOffset.Controls.Add(this.udPAADC40);
			this.grpPABandOffset.Controls.Add(this.udPAADC30);
			this.grpPABandOffset.Location = new System.Drawing.Point(232, 8);
			this.grpPABandOffset.Name = "grpPABandOffset";
			this.grpPABandOffset.Size = new System.Drawing.Size(208, 152);
			this.grpPABandOffset.TabIndex = 81;
			this.grpPABandOffset.TabStop = false;
			this.grpPABandOffset.Text = "ADC Offset (ADC bits)";
			this.grpPABandOffset.Visible = false;
			// 
			// lblPABandOffset10
			// 
			this.lblPABandOffset10.Image = null;
			this.lblPABandOffset10.Location = new System.Drawing.Point(104, 120);
			this.lblPABandOffset10.Name = "lblPABandOffset10";
			this.lblPABandOffset10.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset10.TabIndex = 90;
			this.lblPABandOffset10.Text = "10m:";
			// 
			// lblPABandOffset12
			// 
			this.lblPABandOffset12.Image = null;
			this.lblPABandOffset12.Location = new System.Drawing.Point(104, 96);
			this.lblPABandOffset12.Name = "lblPABandOffset12";
			this.lblPABandOffset12.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset12.TabIndex = 89;
			this.lblPABandOffset12.Text = "12m:";
			// 
			// lblPABandOffset15
			// 
			this.lblPABandOffset15.Image = null;
			this.lblPABandOffset15.Location = new System.Drawing.Point(104, 72);
			this.lblPABandOffset15.Name = "lblPABandOffset15";
			this.lblPABandOffset15.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset15.TabIndex = 88;
			this.lblPABandOffset15.Text = "15m:";
			// 
			// lblPABandOffset17
			// 
			this.lblPABandOffset17.Image = null;
			this.lblPABandOffset17.Location = new System.Drawing.Point(104, 48);
			this.lblPABandOffset17.Name = "lblPABandOffset17";
			this.lblPABandOffset17.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset17.TabIndex = 87;
			this.lblPABandOffset17.Text = "17m:";
			// 
			// lblPABandOffset20
			// 
			this.lblPABandOffset20.Image = null;
			this.lblPABandOffset20.Location = new System.Drawing.Point(104, 24);
			this.lblPABandOffset20.Name = "lblPABandOffset20";
			this.lblPABandOffset20.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset20.TabIndex = 86;
			this.lblPABandOffset20.Text = "20m:";
			// 
			// lblPABandOffset30
			// 
			this.lblPABandOffset30.Image = null;
			this.lblPABandOffset30.Location = new System.Drawing.Point(16, 120);
			this.lblPABandOffset30.Name = "lblPABandOffset30";
			this.lblPABandOffset30.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset30.TabIndex = 85;
			this.lblPABandOffset30.Text = "30m:";
			// 
			// lblPABandOffset40
			// 
			this.lblPABandOffset40.Image = null;
			this.lblPABandOffset40.Location = new System.Drawing.Point(16, 96);
			this.lblPABandOffset40.Name = "lblPABandOffset40";
			this.lblPABandOffset40.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset40.TabIndex = 84;
			this.lblPABandOffset40.Text = "40m:";
			// 
			// lblPABandOffset60
			// 
			this.lblPABandOffset60.Image = null;
			this.lblPABandOffset60.Location = new System.Drawing.Point(16, 72);
			this.lblPABandOffset60.Name = "lblPABandOffset60";
			this.lblPABandOffset60.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset60.TabIndex = 83;
			this.lblPABandOffset60.Text = "60m:";
			// 
			// lblPABandOffset80
			// 
			this.lblPABandOffset80.Image = null;
			this.lblPABandOffset80.Location = new System.Drawing.Point(16, 48);
			this.lblPABandOffset80.Name = "lblPABandOffset80";
			this.lblPABandOffset80.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset80.TabIndex = 82;
			this.lblPABandOffset80.Text = "80m:";
			// 
			// lblPABandOffset160
			// 
			this.lblPABandOffset160.Image = null;
			this.lblPABandOffset160.Location = new System.Drawing.Point(16, 24);
			this.lblPABandOffset160.Name = "lblPABandOffset160";
			this.lblPABandOffset160.Size = new System.Drawing.Size(40, 16);
			this.lblPABandOffset160.TabIndex = 81;
			this.lblPABandOffset160.Text = "160m:";
			// 
			// udPAADC17
			// 
			this.udPAADC17.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udPAADC17.Location = new System.Drawing.Point(144, 48);
			this.udPAADC17.Maximum = new System.Decimal(new int[] {
																	  255,
																	  0,
																	  0,
																	  0});
			this.udPAADC17.Minimum = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udPAADC17.Name = "udPAADC17";
			this.udPAADC17.Size = new System.Drawing.Size(48, 20);
			this.udPAADC17.TabIndex = 77;
			this.udPAADC17.Value = new System.Decimal(new int[] {
																	108,
																	0,
																	0,
																	0});
			// 
			// udPAADC15
			// 
			this.udPAADC15.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udPAADC15.Location = new System.Drawing.Point(144, 72);
			this.udPAADC15.Maximum = new System.Decimal(new int[] {
																	  255,
																	  0,
																	  0,
																	  0});
			this.udPAADC15.Minimum = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udPAADC15.Name = "udPAADC15";
			this.udPAADC15.Size = new System.Drawing.Size(48, 20);
			this.udPAADC15.TabIndex = 78;
			this.udPAADC15.Value = new System.Decimal(new int[] {
																	108,
																	0,
																	0,
																	0});
			// 
			// udPAADC20
			// 
			this.udPAADC20.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udPAADC20.Location = new System.Drawing.Point(144, 24);
			this.udPAADC20.Maximum = new System.Decimal(new int[] {
																	  255,
																	  0,
																	  0,
																	  0});
			this.udPAADC20.Minimum = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udPAADC20.Name = "udPAADC20";
			this.udPAADC20.Size = new System.Drawing.Size(48, 20);
			this.udPAADC20.TabIndex = 76;
			this.udPAADC20.Value = new System.Decimal(new int[] {
																	108,
																	0,
																	0,
																	0});
			// 
			// udPAADC12
			// 
			this.udPAADC12.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udPAADC12.Location = new System.Drawing.Point(144, 96);
			this.udPAADC12.Maximum = new System.Decimal(new int[] {
																	  255,
																	  0,
																	  0,
																	  0});
			this.udPAADC12.Minimum = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udPAADC12.Name = "udPAADC12";
			this.udPAADC12.Size = new System.Drawing.Size(48, 20);
			this.udPAADC12.TabIndex = 79;
			this.udPAADC12.Value = new System.Decimal(new int[] {
																	110,
																	0,
																	0,
																	0});
			// 
			// udPAADC10
			// 
			this.udPAADC10.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udPAADC10.Location = new System.Drawing.Point(144, 120);
			this.udPAADC10.Maximum = new System.Decimal(new int[] {
																	  255,
																	  0,
																	  0,
																	  0});
			this.udPAADC10.Minimum = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udPAADC10.Name = "udPAADC10";
			this.udPAADC10.Size = new System.Drawing.Size(48, 20);
			this.udPAADC10.TabIndex = 80;
			this.udPAADC10.Value = new System.Decimal(new int[] {
																	111,
																	0,
																	0,
																	0});
			// 
			// udPAADC160
			// 
			this.udPAADC160.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 0});
			this.udPAADC160.Location = new System.Drawing.Point(56, 24);
			this.udPAADC160.Maximum = new System.Decimal(new int[] {
																	   255,
																	   0,
																	   0,
																	   0});
			this.udPAADC160.Minimum = new System.Decimal(new int[] {
																	   0,
																	   0,
																	   0,
																	   0});
			this.udPAADC160.Name = "udPAADC160";
			this.udPAADC160.Size = new System.Drawing.Size(48, 20);
			this.udPAADC160.TabIndex = 71;
			this.udPAADC160.Value = new System.Decimal(new int[] {
																	 107,
																	 0,
																	 0,
																	 0});
			// 
			// udPAADC80
			// 
			this.udPAADC80.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udPAADC80.Location = new System.Drawing.Point(56, 48);
			this.udPAADC80.Maximum = new System.Decimal(new int[] {
																	  255,
																	  0,
																	  0,
																	  0});
			this.udPAADC80.Minimum = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udPAADC80.Name = "udPAADC80";
			this.udPAADC80.Size = new System.Drawing.Size(48, 20);
			this.udPAADC80.TabIndex = 72;
			this.udPAADC80.Value = new System.Decimal(new int[] {
																	107,
																	0,
																	0,
																	0});
			// 
			// udPAADC60
			// 
			this.udPAADC60.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udPAADC60.Location = new System.Drawing.Point(56, 72);
			this.udPAADC60.Maximum = new System.Decimal(new int[] {
																	  255,
																	  0,
																	  0,
																	  0});
			this.udPAADC60.Minimum = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udPAADC60.Name = "udPAADC60";
			this.udPAADC60.Size = new System.Drawing.Size(48, 20);
			this.udPAADC60.TabIndex = 73;
			this.udPAADC60.Value = new System.Decimal(new int[] {
																	107,
																	0,
																	0,
																	0});
			// 
			// udPAADC40
			// 
			this.udPAADC40.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udPAADC40.Location = new System.Drawing.Point(56, 96);
			this.udPAADC40.Maximum = new System.Decimal(new int[] {
																	  255,
																	  0,
																	  0,
																	  0});
			this.udPAADC40.Minimum = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udPAADC40.Name = "udPAADC40";
			this.udPAADC40.Size = new System.Drawing.Size(48, 20);
			this.udPAADC40.TabIndex = 74;
			this.udPAADC40.Value = new System.Decimal(new int[] {
																	106,
																	0,
																	0,
																	0});
			// 
			// udPAADC30
			// 
			this.udPAADC30.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udPAADC30.Location = new System.Drawing.Point(56, 120);
			this.udPAADC30.Maximum = new System.Decimal(new int[] {
																	  255,
																	  0,
																	  0,
																	  0});
			this.udPAADC30.Minimum = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.udPAADC30.Name = "udPAADC30";
			this.udPAADC30.Size = new System.Drawing.Size(48, 20);
			this.udPAADC30.TabIndex = 75;
			this.udPAADC30.Value = new System.Decimal(new int[] {
																	108,
																	0,
																	0,
																	0});
			// 
			// grpPAGainByBand
			// 
			this.grpPAGainByBand.Controls.Add(this.lblPACalPower);
			this.grpPAGainByBand.Controls.Add(this.udPACalPower);
			this.grpPAGainByBand.Controls.Add(this.btnPAGainReset);
			this.grpPAGainByBand.Controls.Add(this.btnPAGainCalibration);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand10);
			this.grpPAGainByBand.Controls.Add(this.udPAGain10);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand12);
			this.grpPAGainByBand.Controls.Add(this.udPAGain12);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand15);
			this.grpPAGainByBand.Controls.Add(this.udPAGain15);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand17);
			this.grpPAGainByBand.Controls.Add(this.udPAGain17);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand20);
			this.grpPAGainByBand.Controls.Add(this.udPAGain20);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand30);
			this.grpPAGainByBand.Controls.Add(this.udPAGain30);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand40);
			this.grpPAGainByBand.Controls.Add(this.udPAGain40);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand60);
			this.grpPAGainByBand.Controls.Add(this.udPAGain60);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand80);
			this.grpPAGainByBand.Controls.Add(this.udPAGain80);
			this.grpPAGainByBand.Controls.Add(this.lblPAGainByBand160);
			this.grpPAGainByBand.Controls.Add(this.udPAGain160);
			this.grpPAGainByBand.Location = new System.Drawing.Point(8, 8);
			this.grpPAGainByBand.Name = "grpPAGainByBand";
			this.grpPAGainByBand.Size = new System.Drawing.Size(216, 216);
			this.grpPAGainByBand.TabIndex = 1;
			this.grpPAGainByBand.TabStop = false;
			this.grpPAGainByBand.Text = "Gain By Band (dB)";
			this.grpPAGainByBand.Visible = false;
			// 
			// lblPACalPower
			// 
			this.lblPACalPower.Image = null;
			this.lblPACalPower.Location = new System.Drawing.Point(8, 152);
			this.lblPACalPower.Name = "lblPACalPower";
			this.lblPACalPower.Size = new System.Drawing.Size(64, 32);
			this.lblPACalPower.TabIndex = 23;
			this.lblPACalPower.Text = "Target Power (W):";
			// 
			// udPACalPower
			// 
			this.udPACalPower.Increment = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.udPACalPower.Location = new System.Drawing.Point(80, 152);
			this.udPACalPower.Maximum = new System.Decimal(new int[] {
																		 75,
																		 0,
																		 0,
																		 0});
			this.udPACalPower.Minimum = new System.Decimal(new int[] {
																		 5,
																		 0,
																		 0,
																		 0});
			this.udPACalPower.Name = "udPACalPower";
			this.udPACalPower.Size = new System.Drawing.Size(40, 20);
			this.udPACalPower.TabIndex = 22;
			this.toolTip1.SetToolTip(this.udPACalPower, "The target power used for the PA Calibration.");
			this.udPACalPower.Value = new System.Decimal(new int[] {
																	   60,
																	   0,
																	   0,
																	   0});
			// 
			// btnPAGainReset
			// 
			this.btnPAGainReset.Image = null;
			this.btnPAGainReset.Location = new System.Drawing.Point(72, 184);
			this.btnPAGainReset.Name = "btnPAGainReset";
			this.btnPAGainReset.TabIndex = 21;
			this.btnPAGainReset.Text = "Reset";
			this.toolTip1.SetToolTip(this.btnPAGainReset, "Reset all Gain values to the default 48.0dB");
			this.btnPAGainReset.Click += new System.EventHandler(this.btnPAGainReset_Click);
			// 
			// btnPAGainCalibration
			// 
			this.btnPAGainCalibration.Image = null;
			this.btnPAGainCalibration.Location = new System.Drawing.Point(128, 152);
			this.btnPAGainCalibration.Name = "btnPAGainCalibration";
			this.btnPAGainCalibration.TabIndex = 20;
			this.btnPAGainCalibration.Text = "Calibrate";
			this.btnPAGainCalibration.Click += new System.EventHandler(this.btnPAGainCalibration_Click);
			// 
			// lblPAGainByBand10
			// 
			this.lblPAGainByBand10.Image = null;
			this.lblPAGainByBand10.Location = new System.Drawing.Point(112, 120);
			this.lblPAGainByBand10.Name = "lblPAGainByBand10";
			this.lblPAGainByBand10.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand10.TabIndex = 19;
			this.lblPAGainByBand10.Text = "10m:";
			// 
			// udPAGain10
			// 
			this.udPAGain10.DecimalPlaces = 1;
			this.udPAGain10.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 65536});
			this.udPAGain10.Location = new System.Drawing.Point(152, 120);
			this.udPAGain10.Maximum = new System.Decimal(new int[] {
																	   100,
																	   0,
																	   0,
																	   0});
			this.udPAGain10.Minimum = new System.Decimal(new int[] {
																	   39,
																	   0,
																	   0,
																	   0});
			this.udPAGain10.Name = "udPAGain10";
			this.udPAGain10.Size = new System.Drawing.Size(48, 20);
			this.udPAGain10.TabIndex = 18;
			this.udPAGain10.Value = new System.Decimal(new int[] {
																	 430,
																	 0,
																	 0,
																	 65536});
			this.udPAGain10.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// lblPAGainByBand12
			// 
			this.lblPAGainByBand12.Image = null;
			this.lblPAGainByBand12.Location = new System.Drawing.Point(112, 96);
			this.lblPAGainByBand12.Name = "lblPAGainByBand12";
			this.lblPAGainByBand12.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand12.TabIndex = 17;
			this.lblPAGainByBand12.Text = "12m:";
			// 
			// udPAGain12
			// 
			this.udPAGain12.DecimalPlaces = 1;
			this.udPAGain12.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 65536});
			this.udPAGain12.Location = new System.Drawing.Point(152, 96);
			this.udPAGain12.Maximum = new System.Decimal(new int[] {
																	   100,
																	   0,
																	   0,
																	   0});
			this.udPAGain12.Minimum = new System.Decimal(new int[] {
																	   39,
																	   0,
																	   0,
																	   0});
			this.udPAGain12.Name = "udPAGain12";
			this.udPAGain12.Size = new System.Drawing.Size(48, 20);
			this.udPAGain12.TabIndex = 16;
			this.udPAGain12.Value = new System.Decimal(new int[] {
																	 474,
																	 0,
																	 0,
																	 65536});
			this.udPAGain12.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// lblPAGainByBand15
			// 
			this.lblPAGainByBand15.Image = null;
			this.lblPAGainByBand15.Location = new System.Drawing.Point(112, 72);
			this.lblPAGainByBand15.Name = "lblPAGainByBand15";
			this.lblPAGainByBand15.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand15.TabIndex = 15;
			this.lblPAGainByBand15.Text = "15m:";
			// 
			// udPAGain15
			// 
			this.udPAGain15.DecimalPlaces = 1;
			this.udPAGain15.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 65536});
			this.udPAGain15.Location = new System.Drawing.Point(152, 72);
			this.udPAGain15.Maximum = new System.Decimal(new int[] {
																	   100,
																	   0,
																	   0,
																	   0});
			this.udPAGain15.Minimum = new System.Decimal(new int[] {
																	   39,
																	   0,
																	   0,
																	   0});
			this.udPAGain15.Name = "udPAGain15";
			this.udPAGain15.Size = new System.Drawing.Size(48, 20);
			this.udPAGain15.TabIndex = 14;
			this.udPAGain15.Value = new System.Decimal(new int[] {
																	 481,
																	 0,
																	 0,
																	 65536});
			this.udPAGain15.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// lblPAGainByBand17
			// 
			this.lblPAGainByBand17.Image = null;
			this.lblPAGainByBand17.Location = new System.Drawing.Point(112, 48);
			this.lblPAGainByBand17.Name = "lblPAGainByBand17";
			this.lblPAGainByBand17.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand17.TabIndex = 13;
			this.lblPAGainByBand17.Text = "17m:";
			// 
			// udPAGain17
			// 
			this.udPAGain17.DecimalPlaces = 1;
			this.udPAGain17.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 65536});
			this.udPAGain17.Location = new System.Drawing.Point(152, 48);
			this.udPAGain17.Maximum = new System.Decimal(new int[] {
																	   100,
																	   0,
																	   0,
																	   0});
			this.udPAGain17.Minimum = new System.Decimal(new int[] {
																	   39,
																	   0,
																	   0,
																	   0});
			this.udPAGain17.Name = "udPAGain17";
			this.udPAGain17.Size = new System.Drawing.Size(48, 20);
			this.udPAGain17.TabIndex = 12;
			this.udPAGain17.Value = new System.Decimal(new int[] {
																	 493,
																	 0,
																	 0,
																	 65536});
			this.udPAGain17.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// lblPAGainByBand20
			// 
			this.lblPAGainByBand20.Image = null;
			this.lblPAGainByBand20.Location = new System.Drawing.Point(112, 24);
			this.lblPAGainByBand20.Name = "lblPAGainByBand20";
			this.lblPAGainByBand20.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand20.TabIndex = 11;
			this.lblPAGainByBand20.Text = "20m:";
			// 
			// udPAGain20
			// 
			this.udPAGain20.DecimalPlaces = 1;
			this.udPAGain20.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 65536});
			this.udPAGain20.Location = new System.Drawing.Point(152, 24);
			this.udPAGain20.Maximum = new System.Decimal(new int[] {
																	   100,
																	   0,
																	   0,
																	   0});
			this.udPAGain20.Minimum = new System.Decimal(new int[] {
																	   39,
																	   0,
																	   0,
																	   0});
			this.udPAGain20.Name = "udPAGain20";
			this.udPAGain20.Size = new System.Drawing.Size(48, 20);
			this.udPAGain20.TabIndex = 10;
			this.udPAGain20.Value = new System.Decimal(new int[] {
																	 483,
																	 0,
																	 0,
																	 65536});
			this.udPAGain20.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// lblPAGainByBand30
			// 
			this.lblPAGainByBand30.Image = null;
			this.lblPAGainByBand30.Location = new System.Drawing.Point(16, 120);
			this.lblPAGainByBand30.Name = "lblPAGainByBand30";
			this.lblPAGainByBand30.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand30.TabIndex = 9;
			this.lblPAGainByBand30.Text = "30m:";
			// 
			// udPAGain30
			// 
			this.udPAGain30.DecimalPlaces = 1;
			this.udPAGain30.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 65536});
			this.udPAGain30.Location = new System.Drawing.Point(56, 120);
			this.udPAGain30.Maximum = new System.Decimal(new int[] {
																	   100,
																	   0,
																	   0,
																	   0});
			this.udPAGain30.Minimum = new System.Decimal(new int[] {
																	   39,
																	   0,
																	   0,
																	   0});
			this.udPAGain30.Name = "udPAGain30";
			this.udPAGain30.Size = new System.Drawing.Size(48, 20);
			this.udPAGain30.TabIndex = 8;
			this.udPAGain30.Value = new System.Decimal(new int[] {
																	 489,
																	 0,
																	 0,
																	 65536});
			this.udPAGain30.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// lblPAGainByBand40
			// 
			this.lblPAGainByBand40.Image = null;
			this.lblPAGainByBand40.Location = new System.Drawing.Point(16, 96);
			this.lblPAGainByBand40.Name = "lblPAGainByBand40";
			this.lblPAGainByBand40.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand40.TabIndex = 7;
			this.lblPAGainByBand40.Text = "40m:";
			// 
			// udPAGain40
			// 
			this.udPAGain40.DecimalPlaces = 1;
			this.udPAGain40.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 65536});
			this.udPAGain40.Location = new System.Drawing.Point(56, 96);
			this.udPAGain40.Maximum = new System.Decimal(new int[] {
																	   100,
																	   0,
																	   0,
																	   0});
			this.udPAGain40.Minimum = new System.Decimal(new int[] {
																	   39,
																	   0,
																	   0,
																	   0});
			this.udPAGain40.Name = "udPAGain40";
			this.udPAGain40.Size = new System.Drawing.Size(48, 20);
			this.udPAGain40.TabIndex = 6;
			this.udPAGain40.Value = new System.Decimal(new int[] {
																	 469,
																	 0,
																	 0,
																	 65536});
			this.udPAGain40.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// lblPAGainByBand60
			// 
			this.lblPAGainByBand60.Image = null;
			this.lblPAGainByBand60.Location = new System.Drawing.Point(16, 72);
			this.lblPAGainByBand60.Name = "lblPAGainByBand60";
			this.lblPAGainByBand60.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand60.TabIndex = 5;
			this.lblPAGainByBand60.Text = "60m:";
			// 
			// udPAGain60
			// 
			this.udPAGain60.DecimalPlaces = 1;
			this.udPAGain60.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 65536});
			this.udPAGain60.Location = new System.Drawing.Point(56, 72);
			this.udPAGain60.Maximum = new System.Decimal(new int[] {
																	   100,
																	   0,
																	   0,
																	   0});
			this.udPAGain60.Minimum = new System.Decimal(new int[] {
																	   39,
																	   0,
																	   0,
																	   0});
			this.udPAGain60.Name = "udPAGain60";
			this.udPAGain60.Size = new System.Drawing.Size(48, 20);
			this.udPAGain60.TabIndex = 4;
			this.udPAGain60.Value = new System.Decimal(new int[] {
																	 474,
																	 0,
																	 0,
																	 65536});
			this.udPAGain60.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// lblPAGainByBand80
			// 
			this.lblPAGainByBand80.Image = null;
			this.lblPAGainByBand80.Location = new System.Drawing.Point(16, 48);
			this.lblPAGainByBand80.Name = "lblPAGainByBand80";
			this.lblPAGainByBand80.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand80.TabIndex = 3;
			this.lblPAGainByBand80.Text = "80m:";
			// 
			// udPAGain80
			// 
			this.udPAGain80.DecimalPlaces = 1;
			this.udPAGain80.Increment = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 65536});
			this.udPAGain80.Location = new System.Drawing.Point(56, 48);
			this.udPAGain80.Maximum = new System.Decimal(new int[] {
																	   100,
																	   0,
																	   0,
																	   0});
			this.udPAGain80.Minimum = new System.Decimal(new int[] {
																	   39,
																	   0,
																	   0,
																	   0});
			this.udPAGain80.Name = "udPAGain80";
			this.udPAGain80.Size = new System.Drawing.Size(48, 20);
			this.udPAGain80.TabIndex = 2;
			this.udPAGain80.Value = new System.Decimal(new int[] {
																	 480,
																	 0,
																	 0,
																	 65536});
			this.udPAGain80.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// lblPAGainByBand160
			// 
			this.lblPAGainByBand160.Image = null;
			this.lblPAGainByBand160.Location = new System.Drawing.Point(16, 24);
			this.lblPAGainByBand160.Name = "lblPAGainByBand160";
			this.lblPAGainByBand160.Size = new System.Drawing.Size(40, 16);
			this.lblPAGainByBand160.TabIndex = 1;
			this.lblPAGainByBand160.Text = "160m:";
			// 
			// udPAGain160
			// 
			this.udPAGain160.DecimalPlaces = 1;
			this.udPAGain160.Increment = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  65536});
			this.udPAGain160.Location = new System.Drawing.Point(56, 24);
			this.udPAGain160.Maximum = new System.Decimal(new int[] {
																		100,
																		0,
																		0,
																		0});
			this.udPAGain160.Minimum = new System.Decimal(new int[] {
																		39,
																		0,
																		0,
																		0});
			this.udPAGain160.Name = "udPAGain160";
			this.udPAGain160.Size = new System.Drawing.Size(48, 20);
			this.udPAGain160.TabIndex = 0;
			this.udPAGain160.Value = new System.Decimal(new int[] {
																	  490,
																	  0,
																	  0,
																	  65536});
			this.udPAGain160.ValueChanged += new System.EventHandler(this.udPAGain_ValueChanged);
			// 
			// tpAppearance
			// 
			this.tpAppearance.Controls.Add(this.grpAppearanceGeneral);
			this.tpAppearance.Controls.Add(this.grpAppearanceMeter);
			this.tpAppearance.Controls.Add(this.grpAppearanceDisplay);
			this.tpAppearance.Location = new System.Drawing.Point(4, 22);
			this.tpAppearance.Name = "tpAppearance";
			this.tpAppearance.Size = new System.Drawing.Size(584, 286);
			this.tpAppearance.TabIndex = 6;
			this.tpAppearance.Text = "Appearance";
			// 
			// grpAppearanceGeneral
			// 
			this.grpAppearanceGeneral.Controls.Add(this.clrbtnPeakText);
			this.grpAppearanceGeneral.Controls.Add(this.clrbtnBandLight);
			this.grpAppearanceGeneral.Controls.Add(this.clrbtnBandDark);
			this.grpAppearanceGeneral.Controls.Add(this.clrbtnVFOLight);
			this.grpAppearanceGeneral.Controls.Add(this.clrbtnVFODark);
			this.grpAppearanceGeneral.Controls.Add(this.clrbtnBtnSel);
			this.grpAppearanceGeneral.Controls.Add(this.lblPeakText);
			this.grpAppearanceGeneral.Controls.Add(this.lblBandLight);
			this.grpAppearanceGeneral.Controls.Add(this.lblBandDark);
			this.grpAppearanceGeneral.Controls.Add(this.lblVFOLight);
			this.grpAppearanceGeneral.Controls.Add(this.lblVFODark);
			this.grpAppearanceGeneral.Controls.Add(this.lblAppearanceGenBtnSel);
			this.grpAppearanceGeneral.Location = new System.Drawing.Point(8, 8);
			this.grpAppearanceGeneral.Name = "grpAppearanceGeneral";
			this.grpAppearanceGeneral.Size = new System.Drawing.Size(136, 224);
			this.grpAppearanceGeneral.TabIndex = 39;
			this.grpAppearanceGeneral.TabStop = false;
			this.grpAppearanceGeneral.Text = "General";
			// 
			// clrbtnPeakText
			// 
			this.clrbtnPeakText.Automatic = "Automatic";
			this.clrbtnPeakText.Color = System.Drawing.Color.Transparent;
			this.clrbtnPeakText.Image = null;
			this.clrbtnPeakText.Location = new System.Drawing.Point(80, 184);
			this.clrbtnPeakText.MoreColors = "More Colors...";
			this.clrbtnPeakText.Name = "clrbtnPeakText";
			this.clrbtnPeakText.Size = new System.Drawing.Size(40, 23);
			this.clrbtnPeakText.TabIndex = 71;
			this.clrbtnPeakText.Changed += new System.EventHandler(this.clrbtnPeakText_Changed);
			// 
			// clrbtnBandLight
			// 
			this.clrbtnBandLight.Automatic = "Automatic";
			this.clrbtnBandLight.Color = System.Drawing.Color.Transparent;
			this.clrbtnBandLight.Image = null;
			this.clrbtnBandLight.Location = new System.Drawing.Point(80, 152);
			this.clrbtnBandLight.MoreColors = "More Colors...";
			this.clrbtnBandLight.Name = "clrbtnBandLight";
			this.clrbtnBandLight.Size = new System.Drawing.Size(40, 23);
			this.clrbtnBandLight.TabIndex = 70;
			this.clrbtnBandLight.Changed += new System.EventHandler(this.clrbtnBandLight_Changed);
			// 
			// clrbtnBandDark
			// 
			this.clrbtnBandDark.Automatic = "Automatic";
			this.clrbtnBandDark.Color = System.Drawing.Color.Transparent;
			this.clrbtnBandDark.Image = null;
			this.clrbtnBandDark.Location = new System.Drawing.Point(80, 120);
			this.clrbtnBandDark.MoreColors = "More Colors...";
			this.clrbtnBandDark.Name = "clrbtnBandDark";
			this.clrbtnBandDark.Size = new System.Drawing.Size(40, 23);
			this.clrbtnBandDark.TabIndex = 69;
			this.clrbtnBandDark.Changed += new System.EventHandler(this.clrbtnBandDark_Changed);
			// 
			// clrbtnVFOLight
			// 
			this.clrbtnVFOLight.Automatic = "Automatic";
			this.clrbtnVFOLight.Color = System.Drawing.Color.Transparent;
			this.clrbtnVFOLight.Image = null;
			this.clrbtnVFOLight.Location = new System.Drawing.Point(80, 88);
			this.clrbtnVFOLight.MoreColors = "More Colors...";
			this.clrbtnVFOLight.Name = "clrbtnVFOLight";
			this.clrbtnVFOLight.Size = new System.Drawing.Size(40, 23);
			this.clrbtnVFOLight.TabIndex = 68;
			this.clrbtnVFOLight.Changed += new System.EventHandler(this.clrbtnVFOLight_Changed);
			// 
			// clrbtnVFODark
			// 
			this.clrbtnVFODark.Automatic = "Automatic";
			this.clrbtnVFODark.Color = System.Drawing.Color.Transparent;
			this.clrbtnVFODark.Image = null;
			this.clrbtnVFODark.Location = new System.Drawing.Point(80, 56);
			this.clrbtnVFODark.MoreColors = "More Colors...";
			this.clrbtnVFODark.Name = "clrbtnVFODark";
			this.clrbtnVFODark.Size = new System.Drawing.Size(40, 23);
			this.clrbtnVFODark.TabIndex = 67;
			this.clrbtnVFODark.Changed += new System.EventHandler(this.clrbtnVFODark_Changed);
			// 
			// clrbtnBtnSel
			// 
			this.clrbtnBtnSel.Automatic = "Automatic";
			this.clrbtnBtnSel.Color = System.Drawing.Color.Transparent;
			this.clrbtnBtnSel.Image = null;
			this.clrbtnBtnSel.Location = new System.Drawing.Point(80, 24);
			this.clrbtnBtnSel.MoreColors = "More Colors...";
			this.clrbtnBtnSel.Name = "clrbtnBtnSel";
			this.clrbtnBtnSel.Size = new System.Drawing.Size(40, 23);
			this.clrbtnBtnSel.TabIndex = 66;
			this.clrbtnBtnSel.Changed += new System.EventHandler(this.clrbtnBtnSel_Changed);
			// 
			// lblPeakText
			// 
			this.lblPeakText.Image = null;
			this.lblPeakText.Location = new System.Drawing.Point(8, 184);
			this.lblPeakText.Name = "lblPeakText";
			this.lblPeakText.Size = new System.Drawing.Size(64, 24);
			this.lblPeakText.TabIndex = 65;
			this.lblPeakText.Text = "Peak Text:";
			// 
			// lblBandLight
			// 
			this.lblBandLight.Image = null;
			this.lblBandLight.Location = new System.Drawing.Point(8, 152);
			this.lblBandLight.Name = "lblBandLight";
			this.lblBandLight.Size = new System.Drawing.Size(64, 24);
			this.lblBandLight.TabIndex = 63;
			this.lblBandLight.Text = "Band Light:";
			// 
			// lblBandDark
			// 
			this.lblBandDark.Image = null;
			this.lblBandDark.Location = new System.Drawing.Point(8, 120);
			this.lblBandDark.Name = "lblBandDark";
			this.lblBandDark.Size = new System.Drawing.Size(64, 24);
			this.lblBandDark.TabIndex = 61;
			this.lblBandDark.Text = "Band Dark:";
			// 
			// lblVFOLight
			// 
			this.lblVFOLight.Image = null;
			this.lblVFOLight.Location = new System.Drawing.Point(8, 88);
			this.lblVFOLight.Name = "lblVFOLight";
			this.lblVFOLight.Size = new System.Drawing.Size(64, 24);
			this.lblVFOLight.TabIndex = 59;
			this.lblVFOLight.Text = "VFO Light:";
			// 
			// lblVFODark
			// 
			this.lblVFODark.Image = null;
			this.lblVFODark.Location = new System.Drawing.Point(8, 56);
			this.lblVFODark.Name = "lblVFODark";
			this.lblVFODark.Size = new System.Drawing.Size(64, 24);
			this.lblVFODark.TabIndex = 57;
			this.lblVFODark.Text = "VFO Dark:";
			// 
			// lblAppearanceGenBtnSel
			// 
			this.lblAppearanceGenBtnSel.Image = null;
			this.lblAppearanceGenBtnSel.Location = new System.Drawing.Point(8, 24);
			this.lblAppearanceGenBtnSel.Name = "lblAppearanceGenBtnSel";
			this.lblAppearanceGenBtnSel.Size = new System.Drawing.Size(64, 32);
			this.lblAppearanceGenBtnSel.TabIndex = 55;
			this.lblAppearanceGenBtnSel.Text = "Button Selected:";
			// 
			// grpAppearanceMeter
			// 
			this.grpAppearanceMeter.Controls.Add(this.clrbtnMeterRight);
			this.grpAppearanceMeter.Controls.Add(this.lblAppearanceMeterRight);
			this.grpAppearanceMeter.Controls.Add(this.lblAppearanceMeterLeft);
			this.grpAppearanceMeter.Controls.Add(this.clrbtnMeterLeft);
			this.grpAppearanceMeter.Location = new System.Drawing.Point(416, 8);
			this.grpAppearanceMeter.Name = "grpAppearanceMeter";
			this.grpAppearanceMeter.Size = new System.Drawing.Size(136, 152);
			this.grpAppearanceMeter.TabIndex = 38;
			this.grpAppearanceMeter.TabStop = false;
			this.grpAppearanceMeter.Text = "Meter";
			// 
			// clrbtnMeterRight
			// 
			this.clrbtnMeterRight.Automatic = "Automatic";
			this.clrbtnMeterRight.Color = System.Drawing.Color.Transparent;
			this.clrbtnMeterRight.Image = null;
			this.clrbtnMeterRight.Location = new System.Drawing.Point(80, 56);
			this.clrbtnMeterRight.MoreColors = "More Colors...";
			this.clrbtnMeterRight.Name = "clrbtnMeterRight";
			this.clrbtnMeterRight.Size = new System.Drawing.Size(40, 23);
			this.clrbtnMeterRight.TabIndex = 75;
			this.clrbtnMeterRight.Changed += new System.EventHandler(this.clrbtnMeterRight_Changed);
			// 
			// lblAppearanceMeterRight
			// 
			this.lblAppearanceMeterRight.Image = null;
			this.lblAppearanceMeterRight.Location = new System.Drawing.Point(8, 56);
			this.lblAppearanceMeterRight.Name = "lblAppearanceMeterRight";
			this.lblAppearanceMeterRight.Size = new System.Drawing.Size(72, 24);
			this.lblAppearanceMeterRight.TabIndex = 53;
			this.lblAppearanceMeterRight.Text = "Meter Right:";
			// 
			// lblAppearanceMeterLeft
			// 
			this.lblAppearanceMeterLeft.Image = null;
			this.lblAppearanceMeterLeft.Location = new System.Drawing.Point(8, 24);
			this.lblAppearanceMeterLeft.Name = "lblAppearanceMeterLeft";
			this.lblAppearanceMeterLeft.Size = new System.Drawing.Size(72, 24);
			this.lblAppearanceMeterLeft.TabIndex = 51;
			this.lblAppearanceMeterLeft.Text = "Meter Left:";
			// 
			// clrbtnMeterLeft
			// 
			this.clrbtnMeterLeft.Automatic = "Automatic";
			this.clrbtnMeterLeft.Color = System.Drawing.Color.Transparent;
			this.clrbtnMeterLeft.Image = null;
			this.clrbtnMeterLeft.Location = new System.Drawing.Point(80, 24);
			this.clrbtnMeterLeft.MoreColors = "More Colors...";
			this.clrbtnMeterLeft.Name = "clrbtnMeterLeft";
			this.clrbtnMeterLeft.Size = new System.Drawing.Size(40, 23);
			this.clrbtnMeterLeft.TabIndex = 74;
			this.clrbtnMeterLeft.Changed += new System.EventHandler(this.clrbtnMeterLeft_Changed);
			// 
			// grpAppearanceDisplay
			// 
			this.grpAppearanceDisplay.Controls.Add(this.clrbtnDataLine);
			this.grpAppearanceDisplay.Controls.Add(this.clrbtnText);
			this.grpAppearanceDisplay.Controls.Add(this.clrbtnFilter);
			this.grpAppearanceDisplay.Controls.Add(this.clrbtnZeroLine);
			this.grpAppearanceDisplay.Controls.Add(this.clrbtnGrid);
			this.grpAppearanceDisplay.Controls.Add(this.clrbtnBackground);
			this.grpAppearanceDisplay.Controls.Add(this.lblDisplayFilterColor);
			this.grpAppearanceDisplay.Controls.Add(this.lblDisplayLineWidth);
			this.grpAppearanceDisplay.Controls.Add(this.udDisplayLineWidth);
			this.grpAppearanceDisplay.Controls.Add(this.lblDisplayDataLineColor);
			this.grpAppearanceDisplay.Controls.Add(this.lblDisplayTextColor);
			this.grpAppearanceDisplay.Controls.Add(this.lblDisplayZeroLineColor);
			this.grpAppearanceDisplay.Controls.Add(this.lblDisplayGridColor);
			this.grpAppearanceDisplay.Controls.Add(this.lblDisplayBackgroundColor);
			this.grpAppearanceDisplay.Location = new System.Drawing.Point(152, 8);
			this.grpAppearanceDisplay.Name = "grpAppearanceDisplay";
			this.grpAppearanceDisplay.Size = new System.Drawing.Size(256, 152);
			this.grpAppearanceDisplay.TabIndex = 37;
			this.grpAppearanceDisplay.TabStop = false;
			this.grpAppearanceDisplay.Text = "Display";
			// 
			// clrbtnDataLine
			// 
			this.clrbtnDataLine.Automatic = "Automatic";
			this.clrbtnDataLine.Color = System.Drawing.Color.Transparent;
			this.clrbtnDataLine.Image = null;
			this.clrbtnDataLine.Location = new System.Drawing.Point(200, 56);
			this.clrbtnDataLine.MoreColors = "More Colors...";
			this.clrbtnDataLine.Name = "clrbtnDataLine";
			this.clrbtnDataLine.Size = new System.Drawing.Size(40, 23);
			this.clrbtnDataLine.TabIndex = 73;
			this.clrbtnDataLine.Changed += new System.EventHandler(this.clrbtnDataLine_Changed);
			// 
			// clrbtnText
			// 
			this.clrbtnText.Automatic = "Automatic";
			this.clrbtnText.Color = System.Drawing.Color.Transparent;
			this.clrbtnText.Image = null;
			this.clrbtnText.Location = new System.Drawing.Point(200, 24);
			this.clrbtnText.MoreColors = "More Colors...";
			this.clrbtnText.Name = "clrbtnText";
			this.clrbtnText.Size = new System.Drawing.Size(40, 23);
			this.clrbtnText.TabIndex = 72;
			this.clrbtnText.Changed += new System.EventHandler(this.clrbtnText_Changed);
			// 
			// clrbtnFilter
			// 
			this.clrbtnFilter.Automatic = "Automatic";
			this.clrbtnFilter.Color = System.Drawing.Color.Transparent;
			this.clrbtnFilter.Image = null;
			this.clrbtnFilter.Location = new System.Drawing.Point(80, 120);
			this.clrbtnFilter.MoreColors = "More Colors...";
			this.clrbtnFilter.Name = "clrbtnFilter";
			this.clrbtnFilter.Size = new System.Drawing.Size(40, 23);
			this.clrbtnFilter.TabIndex = 71;
			this.clrbtnFilter.Changed += new System.EventHandler(this.clrbtnFilter_Changed);
			// 
			// clrbtnZeroLine
			// 
			this.clrbtnZeroLine.Automatic = "Automatic";
			this.clrbtnZeroLine.Color = System.Drawing.Color.Transparent;
			this.clrbtnZeroLine.Image = null;
			this.clrbtnZeroLine.Location = new System.Drawing.Point(80, 88);
			this.clrbtnZeroLine.MoreColors = "More Colors...";
			this.clrbtnZeroLine.Name = "clrbtnZeroLine";
			this.clrbtnZeroLine.Size = new System.Drawing.Size(40, 23);
			this.clrbtnZeroLine.TabIndex = 70;
			this.clrbtnZeroLine.Changed += new System.EventHandler(this.clrbtnZeroLine_Changed);
			// 
			// clrbtnGrid
			// 
			this.clrbtnGrid.Automatic = "Automatic";
			this.clrbtnGrid.Color = System.Drawing.Color.Transparent;
			this.clrbtnGrid.Image = null;
			this.clrbtnGrid.Location = new System.Drawing.Point(80, 56);
			this.clrbtnGrid.MoreColors = "More Colors...";
			this.clrbtnGrid.Name = "clrbtnGrid";
			this.clrbtnGrid.Size = new System.Drawing.Size(40, 23);
			this.clrbtnGrid.TabIndex = 69;
			this.clrbtnGrid.Changed += new System.EventHandler(this.clrbtnGrid_Changed);
			// 
			// clrbtnBackground
			// 
			this.clrbtnBackground.Automatic = "Automatic";
			this.clrbtnBackground.Color = System.Drawing.Color.Transparent;
			this.clrbtnBackground.Image = null;
			this.clrbtnBackground.Location = new System.Drawing.Point(80, 24);
			this.clrbtnBackground.MoreColors = "More Colors...";
			this.clrbtnBackground.Name = "clrbtnBackground";
			this.clrbtnBackground.Size = new System.Drawing.Size(40, 23);
			this.clrbtnBackground.TabIndex = 68;
			this.clrbtnBackground.Changed += new System.EventHandler(this.clrbtnBackground_Changed);
			// 
			// lblDisplayFilterColor
			// 
			this.lblDisplayFilterColor.Image = null;
			this.lblDisplayFilterColor.Location = new System.Drawing.Point(8, 120);
			this.lblDisplayFilterColor.Name = "lblDisplayFilterColor";
			this.lblDisplayFilterColor.Size = new System.Drawing.Size(64, 24);
			this.lblDisplayFilterColor.TabIndex = 45;
			this.lblDisplayFilterColor.Text = "Filter Color:";
			// 
			// lblDisplayLineWidth
			// 
			this.lblDisplayLineWidth.Image = null;
			this.lblDisplayLineWidth.Location = new System.Drawing.Point(128, 88);
			this.lblDisplayLineWidth.Name = "lblDisplayLineWidth";
			this.lblDisplayLineWidth.Size = new System.Drawing.Size(64, 24);
			this.lblDisplayLineWidth.TabIndex = 43;
			this.lblDisplayLineWidth.Text = "Line Width:";
			// 
			// udDisplayLineWidth
			// 
			this.udDisplayLineWidth.DecimalPlaces = 1;
			this.udDisplayLineWidth.Increment = new System.Decimal(new int[] {
																				 1,
																				 0,
																				 0,
																				 65536});
			this.udDisplayLineWidth.Location = new System.Drawing.Point(200, 88);
			this.udDisplayLineWidth.Maximum = new System.Decimal(new int[] {
																			   50,
																			   0,
																			   0,
																			   65536});
			this.udDisplayLineWidth.Minimum = new System.Decimal(new int[] {
																			   1,
																			   0,
																			   0,
																			   65536});
			this.udDisplayLineWidth.Name = "udDisplayLineWidth";
			this.udDisplayLineWidth.Size = new System.Drawing.Size(40, 20);
			this.udDisplayLineWidth.TabIndex = 42;
			this.udDisplayLineWidth.Value = new System.Decimal(new int[] {
																			 10,
																			 0,
																			 0,
																			 65536});
			this.udDisplayLineWidth.ValueChanged += new System.EventHandler(this.udDisplayLineWidth_ValueChanged);
			// 
			// lblDisplayDataLineColor
			// 
			this.lblDisplayDataLineColor.Image = null;
			this.lblDisplayDataLineColor.Location = new System.Drawing.Point(128, 56);
			this.lblDisplayDataLineColor.Name = "lblDisplayDataLineColor";
			this.lblDisplayDataLineColor.Size = new System.Drawing.Size(64, 24);
			this.lblDisplayDataLineColor.TabIndex = 41;
			this.lblDisplayDataLineColor.Text = "Data Line:";
			// 
			// lblDisplayTextColor
			// 
			this.lblDisplayTextColor.Image = null;
			this.lblDisplayTextColor.Location = new System.Drawing.Point(128, 24);
			this.lblDisplayTextColor.Name = "lblDisplayTextColor";
			this.lblDisplayTextColor.Size = new System.Drawing.Size(64, 24);
			this.lblDisplayTextColor.TabIndex = 39;
			this.lblDisplayTextColor.Text = "Text:";
			// 
			// lblDisplayZeroLineColor
			// 
			this.lblDisplayZeroLineColor.Image = null;
			this.lblDisplayZeroLineColor.Location = new System.Drawing.Point(8, 88);
			this.lblDisplayZeroLineColor.Name = "lblDisplayZeroLineColor";
			this.lblDisplayZeroLineColor.Size = new System.Drawing.Size(72, 24);
			this.lblDisplayZeroLineColor.TabIndex = 36;
			this.lblDisplayZeroLineColor.Text = "Zero Line:";
			// 
			// lblDisplayGridColor
			// 
			this.lblDisplayGridColor.Image = null;
			this.lblDisplayGridColor.Location = new System.Drawing.Point(8, 56);
			this.lblDisplayGridColor.Name = "lblDisplayGridColor";
			this.lblDisplayGridColor.Size = new System.Drawing.Size(72, 24);
			this.lblDisplayGridColor.TabIndex = 35;
			this.lblDisplayGridColor.Text = "Grid:";
			// 
			// lblDisplayBackgroundColor
			// 
			this.lblDisplayBackgroundColor.Image = null;
			this.lblDisplayBackgroundColor.Location = new System.Drawing.Point(8, 24);
			this.lblDisplayBackgroundColor.Name = "lblDisplayBackgroundColor";
			this.lblDisplayBackgroundColor.Size = new System.Drawing.Size(72, 24);
			this.lblDisplayBackgroundColor.TabIndex = 34;
			this.lblDisplayBackgroundColor.Text = "Background:";
			// 
			// tpKeyboard
			// 
			this.tpKeyboard.Controls.Add(this.grpKBXIT);
			this.tpKeyboard.Controls.Add(this.grpKBRIT);
			this.tpKeyboard.Controls.Add(this.grpKBMode);
			this.tpKeyboard.Controls.Add(this.grpKBBand);
			this.tpKeyboard.Controls.Add(this.grpKBTune);
			this.tpKeyboard.Controls.Add(this.grpKBFilter);
			this.tpKeyboard.Controls.Add(this.grpKBCW);
			this.tpKeyboard.Location = new System.Drawing.Point(4, 22);
			this.tpKeyboard.Name = "tpKeyboard";
			this.tpKeyboard.Size = new System.Drawing.Size(584, 286);
			this.tpKeyboard.TabIndex = 4;
			this.tpKeyboard.Text = "Keyboard";
			// 
			// grpKBXIT
			// 
			this.grpKBXIT.Controls.Add(this.lblKBXITUp);
			this.grpKBXIT.Controls.Add(this.lblKBXITDown);
			this.grpKBXIT.Controls.Add(this.comboKBXITUp);
			this.grpKBXIT.Controls.Add(this.comboKBXITDown);
			this.grpKBXIT.Location = new System.Drawing.Point(264, 192);
			this.grpKBXIT.Name = "grpKBXIT";
			this.grpKBXIT.Size = new System.Drawing.Size(112, 72);
			this.grpKBXIT.TabIndex = 16;
			this.grpKBXIT.TabStop = false;
			this.grpKBXIT.Text = "XIT";
			// 
			// lblKBXITUp
			// 
			this.lblKBXITUp.Image = null;
			this.lblKBXITUp.Location = new System.Drawing.Point(8, 16);
			this.lblKBXITUp.Name = "lblKBXITUp";
			this.lblKBXITUp.Size = new System.Drawing.Size(40, 16);
			this.lblKBXITUp.TabIndex = 10;
			this.lblKBXITUp.Text = "Up:";
			this.lblKBXITUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBXITDown
			// 
			this.lblKBXITDown.Image = null;
			this.lblKBXITDown.Location = new System.Drawing.Point(8, 40);
			this.lblKBXITDown.Name = "lblKBXITDown";
			this.lblKBXITDown.Size = new System.Drawing.Size(40, 16);
			this.lblKBXITDown.TabIndex = 9;
			this.lblKBXITDown.Text = "Down:";
			this.lblKBXITDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// comboKBXITUp
			// 
			this.comboKBXITUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBXITUp.DropDownWidth = 56;
			this.comboKBXITUp.Location = new System.Drawing.Point(48, 16);
			this.comboKBXITUp.Name = "comboKBXITUp";
			this.comboKBXITUp.Size = new System.Drawing.Size(56, 21);
			this.comboKBXITUp.TabIndex = 6;
			this.comboKBXITUp.SelectedIndexChanged += new System.EventHandler(this.comboKBXITUp_SelectedIndexChanged);
			// 
			// comboKBXITDown
			// 
			this.comboKBXITDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBXITDown.DropDownWidth = 56;
			this.comboKBXITDown.Location = new System.Drawing.Point(48, 40);
			this.comboKBXITDown.Name = "comboKBXITDown";
			this.comboKBXITDown.Size = new System.Drawing.Size(56, 21);
			this.comboKBXITDown.TabIndex = 5;
			this.comboKBXITDown.SelectedIndexChanged += new System.EventHandler(this.comboKBXITDown_SelectedIndexChanged);
			// 
			// grpKBRIT
			// 
			this.grpKBRIT.Controls.Add(this.lblKBRitUp);
			this.grpKBRIT.Controls.Add(this.lblKBRITDown);
			this.grpKBRIT.Controls.Add(this.comboKBRITUp);
			this.grpKBRIT.Controls.Add(this.comboKBRITDown);
			this.grpKBRIT.Location = new System.Drawing.Point(136, 192);
			this.grpKBRIT.Name = "grpKBRIT";
			this.grpKBRIT.Size = new System.Drawing.Size(112, 72);
			this.grpKBRIT.TabIndex = 15;
			this.grpKBRIT.TabStop = false;
			this.grpKBRIT.Text = "RIT";
			// 
			// lblKBRitUp
			// 
			this.lblKBRitUp.Image = null;
			this.lblKBRitUp.Location = new System.Drawing.Point(8, 16);
			this.lblKBRitUp.Name = "lblKBRitUp";
			this.lblKBRitUp.Size = new System.Drawing.Size(40, 16);
			this.lblKBRitUp.TabIndex = 10;
			this.lblKBRitUp.Text = "Up:";
			this.lblKBRitUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBRITDown
			// 
			this.lblKBRITDown.Image = null;
			this.lblKBRITDown.Location = new System.Drawing.Point(8, 40);
			this.lblKBRITDown.Name = "lblKBRITDown";
			this.lblKBRITDown.Size = new System.Drawing.Size(40, 16);
			this.lblKBRITDown.TabIndex = 9;
			this.lblKBRITDown.Text = "Down:";
			this.lblKBRITDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// comboKBRITUp
			// 
			this.comboKBRITUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBRITUp.DropDownWidth = 56;
			this.comboKBRITUp.Location = new System.Drawing.Point(48, 16);
			this.comboKBRITUp.Name = "comboKBRITUp";
			this.comboKBRITUp.Size = new System.Drawing.Size(56, 21);
			this.comboKBRITUp.TabIndex = 6;
			this.comboKBRITUp.SelectedIndexChanged += new System.EventHandler(this.comboKBRITUp_SelectedIndexChanged);
			// 
			// comboKBRITDown
			// 
			this.comboKBRITDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBRITDown.DropDownWidth = 56;
			this.comboKBRITDown.Location = new System.Drawing.Point(48, 40);
			this.comboKBRITDown.Name = "comboKBRITDown";
			this.comboKBRITDown.Size = new System.Drawing.Size(56, 21);
			this.comboKBRITDown.TabIndex = 5;
			this.comboKBRITDown.SelectedIndexChanged += new System.EventHandler(this.comboKBRITDown_SelectedIndexChanged);
			// 
			// grpKBMode
			// 
			this.grpKBMode.Controls.Add(this.lblKBModeUp);
			this.grpKBMode.Controls.Add(this.lblKBModeDown);
			this.grpKBMode.Controls.Add(this.comboKBModeUp);
			this.grpKBMode.Controls.Add(this.comboKBModeDown);
			this.grpKBMode.Location = new System.Drawing.Point(264, 112);
			this.grpKBMode.Name = "grpKBMode";
			this.grpKBMode.Size = new System.Drawing.Size(112, 72);
			this.grpKBMode.TabIndex = 14;
			this.grpKBMode.TabStop = false;
			this.grpKBMode.Text = "Mode";
			// 
			// lblKBModeUp
			// 
			this.lblKBModeUp.Image = null;
			this.lblKBModeUp.Location = new System.Drawing.Point(8, 16);
			this.lblKBModeUp.Name = "lblKBModeUp";
			this.lblKBModeUp.Size = new System.Drawing.Size(40, 16);
			this.lblKBModeUp.TabIndex = 10;
			this.lblKBModeUp.Text = "Up:";
			this.lblKBModeUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBModeDown
			// 
			this.lblKBModeDown.Image = null;
			this.lblKBModeDown.Location = new System.Drawing.Point(8, 40);
			this.lblKBModeDown.Name = "lblKBModeDown";
			this.lblKBModeDown.Size = new System.Drawing.Size(40, 16);
			this.lblKBModeDown.TabIndex = 9;
			this.lblKBModeDown.Text = "Down:";
			this.lblKBModeDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// comboKBModeUp
			// 
			this.comboKBModeUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBModeUp.DropDownWidth = 56;
			this.comboKBModeUp.Location = new System.Drawing.Point(48, 16);
			this.comboKBModeUp.Name = "comboKBModeUp";
			this.comboKBModeUp.Size = new System.Drawing.Size(56, 21);
			this.comboKBModeUp.TabIndex = 6;
			this.comboKBModeUp.SelectedIndexChanged += new System.EventHandler(this.comboKBModeUp_SelectedIndexChanged);
			// 
			// comboKBModeDown
			// 
			this.comboKBModeDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBModeDown.DropDownWidth = 56;
			this.comboKBModeDown.Location = new System.Drawing.Point(48, 40);
			this.comboKBModeDown.Name = "comboKBModeDown";
			this.comboKBModeDown.Size = new System.Drawing.Size(56, 21);
			this.comboKBModeDown.TabIndex = 5;
			this.comboKBModeDown.SelectedIndexChanged += new System.EventHandler(this.comboKBModeDown_SelectedIndexChanged);
			// 
			// grpKBBand
			// 
			this.grpKBBand.Controls.Add(this.lblKBBandUp);
			this.grpKBBand.Controls.Add(this.lblKBBandDown);
			this.grpKBBand.Controls.Add(this.comboKBBandUp);
			this.grpKBBand.Controls.Add(this.comboKBBandDown);
			this.grpKBBand.Location = new System.Drawing.Point(8, 112);
			this.grpKBBand.Name = "grpKBBand";
			this.grpKBBand.Size = new System.Drawing.Size(112, 72);
			this.grpKBBand.TabIndex = 12;
			this.grpKBBand.TabStop = false;
			this.grpKBBand.Text = "Band";
			// 
			// lblKBBandUp
			// 
			this.lblKBBandUp.Image = null;
			this.lblKBBandUp.Location = new System.Drawing.Point(8, 16);
			this.lblKBBandUp.Name = "lblKBBandUp";
			this.lblKBBandUp.Size = new System.Drawing.Size(40, 16);
			this.lblKBBandUp.TabIndex = 10;
			this.lblKBBandUp.Text = "Up:";
			this.lblKBBandUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBBandDown
			// 
			this.lblKBBandDown.Image = null;
			this.lblKBBandDown.Location = new System.Drawing.Point(8, 40);
			this.lblKBBandDown.Name = "lblKBBandDown";
			this.lblKBBandDown.Size = new System.Drawing.Size(40, 16);
			this.lblKBBandDown.TabIndex = 9;
			this.lblKBBandDown.Text = "Down:";
			this.lblKBBandDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// comboKBBandUp
			// 
			this.comboKBBandUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBBandUp.DropDownWidth = 56;
			this.comboKBBandUp.Location = new System.Drawing.Point(48, 16);
			this.comboKBBandUp.Name = "comboKBBandUp";
			this.comboKBBandUp.Size = new System.Drawing.Size(56, 21);
			this.comboKBBandUp.TabIndex = 6;
			this.comboKBBandUp.SelectedIndexChanged += new System.EventHandler(this.comboKBBandUp_SelectedIndexChanged);
			// 
			// comboKBBandDown
			// 
			this.comboKBBandDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBBandDown.DropDownWidth = 56;
			this.comboKBBandDown.Location = new System.Drawing.Point(48, 40);
			this.comboKBBandDown.Name = "comboKBBandDown";
			this.comboKBBandDown.Size = new System.Drawing.Size(56, 21);
			this.comboKBBandDown.TabIndex = 5;
			this.comboKBBandDown.SelectedIndexChanged += new System.EventHandler(this.comboKBBandDown_SelectedIndexChanged);
			// 
			// grpKBTune
			// 
			this.grpKBTune.Controls.Add(this.lblKBTuneDigit);
			this.grpKBTune.Controls.Add(this.lblKBTune7);
			this.grpKBTune.Controls.Add(this.lblKBTune6);
			this.grpKBTune.Controls.Add(this.lblKBTune5);
			this.grpKBTune.Controls.Add(this.lblKBTune4);
			this.grpKBTune.Controls.Add(this.lblKBTune3);
			this.grpKBTune.Controls.Add(this.lblKBTune2);
			this.grpKBTune.Controls.Add(this.comboKBTuneUp7);
			this.grpKBTune.Controls.Add(this.comboKBTuneDown7);
			this.grpKBTune.Controls.Add(this.comboKBTuneUp6);
			this.grpKBTune.Controls.Add(this.comboKBTuneDown6);
			this.grpKBTune.Controls.Add(this.comboKBTuneUp5);
			this.grpKBTune.Controls.Add(this.comboKBTuneDown5);
			this.grpKBTune.Controls.Add(this.comboKBTuneUp4);
			this.grpKBTune.Controls.Add(this.comboKBTuneDown4);
			this.grpKBTune.Controls.Add(this.lblKBTune1);
			this.grpKBTune.Controls.Add(this.lblKBTuneUp);
			this.grpKBTune.Controls.Add(this.lblKBTuneDown);
			this.grpKBTune.Controls.Add(this.comboKBTuneUp3);
			this.grpKBTune.Controls.Add(this.comboKBTuneDown3);
			this.grpKBTune.Controls.Add(this.comboKBTuneUp1);
			this.grpKBTune.Controls.Add(this.comboKBTuneUp2);
			this.grpKBTune.Controls.Add(this.comboKBTuneDown1);
			this.grpKBTune.Controls.Add(this.comboKBTuneDown2);
			this.grpKBTune.Location = new System.Drawing.Point(8, 8);
			this.grpKBTune.Name = "grpKBTune";
			this.grpKBTune.Size = new System.Drawing.Size(456, 96);
			this.grpKBTune.TabIndex = 11;
			this.grpKBTune.TabStop = false;
			this.grpKBTune.Text = "Tune";
			// 
			// lblKBTuneDigit
			// 
			this.lblKBTuneDigit.Image = null;
			this.lblKBTuneDigit.Location = new System.Drawing.Point(16, 16);
			this.lblKBTuneDigit.Name = "lblKBTuneDigit";
			this.lblKBTuneDigit.Size = new System.Drawing.Size(32, 16);
			this.lblKBTuneDigit.TabIndex = 26;
			this.lblKBTuneDigit.Text = "Digit";
			// 
			// lblKBTune7
			// 
			this.lblKBTune7.Image = null;
			this.lblKBTune7.Location = new System.Drawing.Point(392, 16);
			this.lblKBTune7.Name = "lblKBTune7";
			this.lblKBTune7.Size = new System.Drawing.Size(56, 16);
			this.lblKBTune7.TabIndex = 25;
			this.lblKBTune7.Text = "0.00000x";
			this.lblKBTune7.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBTune6
			// 
			this.lblKBTune6.Image = null;
			this.lblKBTune6.Location = new System.Drawing.Point(336, 16);
			this.lblKBTune6.Name = "lblKBTune6";
			this.lblKBTune6.Size = new System.Drawing.Size(56, 16);
			this.lblKBTune6.TabIndex = 24;
			this.lblKBTune6.Text = "0.0000x0";
			this.lblKBTune6.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBTune5
			// 
			this.lblKBTune5.Image = null;
			this.lblKBTune5.Location = new System.Drawing.Point(280, 16);
			this.lblKBTune5.Name = "lblKBTune5";
			this.lblKBTune5.Size = new System.Drawing.Size(56, 16);
			this.lblKBTune5.TabIndex = 23;
			this.lblKBTune5.Text = "0.000x00";
			this.lblKBTune5.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBTune4
			// 
			this.lblKBTune4.Image = null;
			this.lblKBTune4.Location = new System.Drawing.Point(224, 16);
			this.lblKBTune4.Name = "lblKBTune4";
			this.lblKBTune4.Size = new System.Drawing.Size(56, 16);
			this.lblKBTune4.TabIndex = 22;
			this.lblKBTune4.Text = "0.00x000";
			this.lblKBTune4.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBTune3
			// 
			this.lblKBTune3.Image = null;
			this.lblKBTune3.Location = new System.Drawing.Point(168, 16);
			this.lblKBTune3.Name = "lblKBTune3";
			this.lblKBTune3.Size = new System.Drawing.Size(56, 16);
			this.lblKBTune3.TabIndex = 21;
			this.lblKBTune3.Text = "0.0x0000";
			this.lblKBTune3.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBTune2
			// 
			this.lblKBTune2.Image = null;
			this.lblKBTune2.Location = new System.Drawing.Point(112, 16);
			this.lblKBTune2.Name = "lblKBTune2";
			this.lblKBTune2.Size = new System.Drawing.Size(56, 16);
			this.lblKBTune2.TabIndex = 20;
			this.lblKBTune2.Text = "0.x00000";
			this.lblKBTune2.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// comboKBTuneUp7
			// 
			this.comboKBTuneUp7.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneUp7.DropDownWidth = 56;
			this.comboKBTuneUp7.Location = new System.Drawing.Point(392, 40);
			this.comboKBTuneUp7.Name = "comboKBTuneUp7";
			this.comboKBTuneUp7.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneUp7.TabIndex = 19;
			this.comboKBTuneUp7.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp7_SelectedIndexChanged);
			// 
			// comboKBTuneDown7
			// 
			this.comboKBTuneDown7.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneDown7.DropDownWidth = 56;
			this.comboKBTuneDown7.Location = new System.Drawing.Point(392, 64);
			this.comboKBTuneDown7.Name = "comboKBTuneDown7";
			this.comboKBTuneDown7.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneDown7.TabIndex = 18;
			this.comboKBTuneDown7.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown7_SelectedIndexChanged);
			// 
			// comboKBTuneUp6
			// 
			this.comboKBTuneUp6.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneUp6.DropDownWidth = 56;
			this.comboKBTuneUp6.Location = new System.Drawing.Point(336, 40);
			this.comboKBTuneUp6.Name = "comboKBTuneUp6";
			this.comboKBTuneUp6.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneUp6.TabIndex = 17;
			this.comboKBTuneUp6.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp6_SelectedIndexChanged);
			// 
			// comboKBTuneDown6
			// 
			this.comboKBTuneDown6.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneDown6.DropDownWidth = 56;
			this.comboKBTuneDown6.Location = new System.Drawing.Point(336, 64);
			this.comboKBTuneDown6.Name = "comboKBTuneDown6";
			this.comboKBTuneDown6.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneDown6.TabIndex = 16;
			this.comboKBTuneDown6.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown6_SelectedIndexChanged);
			// 
			// comboKBTuneUp5
			// 
			this.comboKBTuneUp5.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneUp5.DropDownWidth = 56;
			this.comboKBTuneUp5.Location = new System.Drawing.Point(280, 40);
			this.comboKBTuneUp5.Name = "comboKBTuneUp5";
			this.comboKBTuneUp5.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneUp5.TabIndex = 15;
			this.comboKBTuneUp5.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp5_SelectedIndexChanged);
			// 
			// comboKBTuneDown5
			// 
			this.comboKBTuneDown5.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneDown5.DropDownWidth = 56;
			this.comboKBTuneDown5.Location = new System.Drawing.Point(280, 64);
			this.comboKBTuneDown5.Name = "comboKBTuneDown5";
			this.comboKBTuneDown5.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneDown5.TabIndex = 14;
			this.comboKBTuneDown5.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown5_SelectedIndexChanged);
			// 
			// comboKBTuneUp4
			// 
			this.comboKBTuneUp4.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneUp4.DropDownWidth = 56;
			this.comboKBTuneUp4.Location = new System.Drawing.Point(224, 40);
			this.comboKBTuneUp4.Name = "comboKBTuneUp4";
			this.comboKBTuneUp4.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneUp4.TabIndex = 13;
			this.comboKBTuneUp4.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp4_SelectedIndexChanged);
			// 
			// comboKBTuneDown4
			// 
			this.comboKBTuneDown4.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneDown4.DropDownWidth = 56;
			this.comboKBTuneDown4.Location = new System.Drawing.Point(224, 64);
			this.comboKBTuneDown4.Name = "comboKBTuneDown4";
			this.comboKBTuneDown4.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneDown4.TabIndex = 12;
			this.comboKBTuneDown4.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown4_SelectedIndexChanged);
			// 
			// lblKBTune1
			// 
			this.lblKBTune1.Image = null;
			this.lblKBTune1.Location = new System.Drawing.Point(48, 16);
			this.lblKBTune1.Name = "lblKBTune1";
			this.lblKBTune1.Size = new System.Drawing.Size(56, 16);
			this.lblKBTune1.TabIndex = 11;
			this.lblKBTune1.Text = "x.000000";
			this.lblKBTune1.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBTuneUp
			// 
			this.lblKBTuneUp.Image = null;
			this.lblKBTuneUp.Location = new System.Drawing.Point(8, 40);
			this.lblKBTuneUp.Name = "lblKBTuneUp";
			this.lblKBTuneUp.Size = new System.Drawing.Size(40, 16);
			this.lblKBTuneUp.TabIndex = 8;
			this.lblKBTuneUp.Text = "Up:";
			this.lblKBTuneUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBTuneDown
			// 
			this.lblKBTuneDown.Image = null;
			this.lblKBTuneDown.Location = new System.Drawing.Point(8, 64);
			this.lblKBTuneDown.Name = "lblKBTuneDown";
			this.lblKBTuneDown.Size = new System.Drawing.Size(40, 16);
			this.lblKBTuneDown.TabIndex = 7;
			this.lblKBTuneDown.Text = "Down:";
			this.lblKBTuneDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// comboKBTuneUp3
			// 
			this.comboKBTuneUp3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneUp3.DropDownWidth = 56;
			this.comboKBTuneUp3.Location = new System.Drawing.Point(168, 40);
			this.comboKBTuneUp3.Name = "comboKBTuneUp3";
			this.comboKBTuneUp3.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneUp3.TabIndex = 6;
			this.comboKBTuneUp3.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp3_SelectedIndexChanged);
			// 
			// comboKBTuneDown3
			// 
			this.comboKBTuneDown3.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneDown3.DropDownWidth = 56;
			this.comboKBTuneDown3.Location = new System.Drawing.Point(168, 64);
			this.comboKBTuneDown3.Name = "comboKBTuneDown3";
			this.comboKBTuneDown3.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneDown3.TabIndex = 1;
			this.comboKBTuneDown3.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown3_SelectedIndexChanged);
			// 
			// comboKBTuneUp1
			// 
			this.comboKBTuneUp1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneUp1.DropDownWidth = 56;
			this.comboKBTuneUp1.Location = new System.Drawing.Point(48, 40);
			this.comboKBTuneUp1.Name = "comboKBTuneUp1";
			this.comboKBTuneUp1.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneUp1.TabIndex = 4;
			this.comboKBTuneUp1.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp1_SelectedIndexChanged);
			// 
			// comboKBTuneUp2
			// 
			this.comboKBTuneUp2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneUp2.DropDownWidth = 56;
			this.comboKBTuneUp2.Location = new System.Drawing.Point(112, 40);
			this.comboKBTuneUp2.Name = "comboKBTuneUp2";
			this.comboKBTuneUp2.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneUp2.TabIndex = 5;
			this.comboKBTuneUp2.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneUp2_SelectedIndexChanged);
			// 
			// comboKBTuneDown1
			// 
			this.comboKBTuneDown1.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneDown1.DropDownWidth = 56;
			this.comboKBTuneDown1.Location = new System.Drawing.Point(48, 64);
			this.comboKBTuneDown1.Name = "comboKBTuneDown1";
			this.comboKBTuneDown1.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneDown1.TabIndex = 0;
			this.comboKBTuneDown1.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown1_SelectedIndexChanged);
			// 
			// comboKBTuneDown2
			// 
			this.comboKBTuneDown2.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBTuneDown2.DropDownWidth = 56;
			this.comboKBTuneDown2.Location = new System.Drawing.Point(112, 64);
			this.comboKBTuneDown2.Name = "comboKBTuneDown2";
			this.comboKBTuneDown2.Size = new System.Drawing.Size(56, 21);
			this.comboKBTuneDown2.TabIndex = 2;
			this.comboKBTuneDown2.SelectedIndexChanged += new System.EventHandler(this.comboKBTuneDown2_SelectedIndexChanged);
			// 
			// grpKBFilter
			// 
			this.grpKBFilter.Controls.Add(this.lblKBFilterUp);
			this.grpKBFilter.Controls.Add(this.lblKBFilterDown);
			this.grpKBFilter.Controls.Add(this.comboKBFilterUp);
			this.grpKBFilter.Controls.Add(this.comboKBFilterDown);
			this.grpKBFilter.Location = new System.Drawing.Point(136, 112);
			this.grpKBFilter.Name = "grpKBFilter";
			this.grpKBFilter.Size = new System.Drawing.Size(112, 72);
			this.grpKBFilter.TabIndex = 13;
			this.grpKBFilter.TabStop = false;
			this.grpKBFilter.Text = "Filter";
			// 
			// lblKBFilterUp
			// 
			this.lblKBFilterUp.Image = null;
			this.lblKBFilterUp.Location = new System.Drawing.Point(8, 16);
			this.lblKBFilterUp.Name = "lblKBFilterUp";
			this.lblKBFilterUp.Size = new System.Drawing.Size(40, 16);
			this.lblKBFilterUp.TabIndex = 10;
			this.lblKBFilterUp.Text = "Up:";
			this.lblKBFilterUp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBFilterDown
			// 
			this.lblKBFilterDown.Image = null;
			this.lblKBFilterDown.Location = new System.Drawing.Point(8, 40);
			this.lblKBFilterDown.Name = "lblKBFilterDown";
			this.lblKBFilterDown.Size = new System.Drawing.Size(40, 16);
			this.lblKBFilterDown.TabIndex = 9;
			this.lblKBFilterDown.Text = "Down:";
			this.lblKBFilterDown.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// comboKBFilterUp
			// 
			this.comboKBFilterUp.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBFilterUp.DropDownWidth = 56;
			this.comboKBFilterUp.Location = new System.Drawing.Point(48, 16);
			this.comboKBFilterUp.Name = "comboKBFilterUp";
			this.comboKBFilterUp.Size = new System.Drawing.Size(56, 21);
			this.comboKBFilterUp.TabIndex = 6;
			this.comboKBFilterUp.SelectedIndexChanged += new System.EventHandler(this.comboKBFilterUp_SelectedIndexChanged);
			// 
			// comboKBFilterDown
			// 
			this.comboKBFilterDown.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBFilterDown.DropDownWidth = 56;
			this.comboKBFilterDown.Location = new System.Drawing.Point(48, 40);
			this.comboKBFilterDown.Name = "comboKBFilterDown";
			this.comboKBFilterDown.Size = new System.Drawing.Size(56, 21);
			this.comboKBFilterDown.TabIndex = 5;
			this.comboKBFilterDown.SelectedIndexChanged += new System.EventHandler(this.comboKBFilterDown_SelectedIndexChanged);
			// 
			// grpKBCW
			// 
			this.grpKBCW.Controls.Add(this.lblKBCWDot);
			this.grpKBCW.Controls.Add(this.lblKBCWDash);
			this.grpKBCW.Controls.Add(this.comboKBCWDot);
			this.grpKBCW.Controls.Add(this.comboKBCWDash);
			this.grpKBCW.Location = new System.Drawing.Point(8, 192);
			this.grpKBCW.Name = "grpKBCW";
			this.grpKBCW.Size = new System.Drawing.Size(112, 72);
			this.grpKBCW.TabIndex = 13;
			this.grpKBCW.TabStop = false;
			this.grpKBCW.Text = "CW";
			// 
			// lblKBCWDot
			// 
			this.lblKBCWDot.Image = null;
			this.lblKBCWDot.Location = new System.Drawing.Point(8, 16);
			this.lblKBCWDot.Name = "lblKBCWDot";
			this.lblKBCWDot.Size = new System.Drawing.Size(40, 16);
			this.lblKBCWDot.TabIndex = 10;
			this.lblKBCWDot.Text = "Dot:";
			this.lblKBCWDot.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblKBCWDash
			// 
			this.lblKBCWDash.Image = null;
			this.lblKBCWDash.Location = new System.Drawing.Point(8, 40);
			this.lblKBCWDash.Name = "lblKBCWDash";
			this.lblKBCWDash.Size = new System.Drawing.Size(40, 16);
			this.lblKBCWDash.TabIndex = 9;
			this.lblKBCWDash.Text = "Dash:";
			this.lblKBCWDash.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// comboKBCWDot
			// 
			this.comboKBCWDot.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBCWDot.DropDownWidth = 56;
			this.comboKBCWDot.Location = new System.Drawing.Point(48, 16);
			this.comboKBCWDot.Name = "comboKBCWDot";
			this.comboKBCWDot.Size = new System.Drawing.Size(56, 21);
			this.comboKBCWDot.TabIndex = 6;
			this.comboKBCWDot.SelectedIndexChanged += new System.EventHandler(this.comboKBCWDot_SelectedIndexChanged);
			// 
			// comboKBCWDash
			// 
			this.comboKBCWDash.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboKBCWDash.DropDownWidth = 56;
			this.comboKBCWDash.Location = new System.Drawing.Point(48, 40);
			this.comboKBCWDash.Name = "comboKBCWDash";
			this.comboKBCWDash.Size = new System.Drawing.Size(56, 21);
			this.comboKBCWDash.TabIndex = 5;
			this.comboKBCWDash.SelectedIndexChanged += new System.EventHandler(this.comboKBCWDash_SelectedIndexChanged);
			// 
			// tpCAT
			// 
			this.tpCAT.Controls.Add(this.grpPTTBitBang);
			this.tpCAT.Controls.Add(this.grpCatControlBox);
			this.tpCAT.Location = new System.Drawing.Point(4, 22);
			this.tpCAT.Name = "tpCAT";
			this.tpCAT.Size = new System.Drawing.Size(584, 286);
			this.tpCAT.TabIndex = 10;
			this.tpCAT.Text = "CAT Control";
			// 
			// grpPTTBitBang
			// 
			this.grpPTTBitBang.Controls.Add(this.lblCATPTTPort);
			this.grpPTTBitBang.Controls.Add(this.udCATBitBangPTTPort);
			this.grpPTTBitBang.Controls.Add(this.chkCATPTT_RTS);
			this.grpPTTBitBang.Controls.Add(this.chkCATPTT_DTR);
			this.grpPTTBitBang.Controls.Add(this.chkCATBitBangPTT);
			this.grpPTTBitBang.Location = new System.Drawing.Point(192, 16);
			this.grpPTTBitBang.Name = "grpPTTBitBang";
			this.grpPTTBitBang.Size = new System.Drawing.Size(128, 152);
			this.grpPTTBitBang.TabIndex = 91;
			this.grpPTTBitBang.TabStop = false;
			this.grpPTTBitBang.Text = "PTT Control";
			// 
			// lblCATPTTPort
			// 
			this.lblCATPTTPort.Image = null;
			this.lblCATPTTPort.Location = new System.Drawing.Point(16, 56);
			this.lblCATPTTPort.Name = "lblCATPTTPort";
			this.lblCATPTTPort.Size = new System.Drawing.Size(40, 23);
			this.lblCATPTTPort.TabIndex = 6;
			this.lblCATPTTPort.Text = "COMx:";
			// 
			// udCATBitBangPTTPort
			// 
			this.udCATBitBangPTTPort.Increment = new System.Decimal(new int[] {
																				  1,
																				  0,
																				  0,
																				  0});
			this.udCATBitBangPTTPort.Location = new System.Drawing.Point(56, 56);
			this.udCATBitBangPTTPort.Maximum = new System.Decimal(new int[] {
																				20,
																				0,
																				0,
																				0});
			this.udCATBitBangPTTPort.Minimum = new System.Decimal(new int[] {
																				1,
																				0,
																				0,
																				0});
			this.udCATBitBangPTTPort.Name = "udCATBitBangPTTPort";
			this.udCATBitBangPTTPort.Size = new System.Drawing.Size(48, 20);
			this.udCATBitBangPTTPort.TabIndex = 5;
			this.udCATBitBangPTTPort.Value = new System.Decimal(new int[] {
																			  1,
																			  0,
																			  0,
																			  0});
			this.udCATBitBangPTTPort.ValueChanged += new System.EventHandler(this.udCATBitBangPTTPort_ValueChanged);
			// 
			// chkCATPTT_RTS
			// 
			this.chkCATPTT_RTS.Image = null;
			this.chkCATPTT_RTS.Location = new System.Drawing.Point(40, 88);
			this.chkCATPTT_RTS.Name = "chkCATPTT_RTS";
			this.chkCATPTT_RTS.Size = new System.Drawing.Size(48, 24);
			this.chkCATPTT_RTS.TabIndex = 0;
			this.chkCATPTT_RTS.Text = "RTS";
			this.chkCATPTT_RTS.CheckedChanged += new System.EventHandler(this.chkCATPTT_RTS_CheckedChanged);
			// 
			// chkCATPTT_DTR
			// 
			this.chkCATPTT_DTR.Image = null;
			this.chkCATPTT_DTR.Location = new System.Drawing.Point(40, 120);
			this.chkCATPTT_DTR.Name = "chkCATPTT_DTR";
			this.chkCATPTT_DTR.Size = new System.Drawing.Size(48, 16);
			this.chkCATPTT_DTR.TabIndex = 1;
			this.chkCATPTT_DTR.Text = "DTR";
			this.chkCATPTT_DTR.CheckedChanged += new System.EventHandler(this.chkCATPTT_DTR_CheckedChanged);
			// 
			// chkCATBitBangPTT
			// 
			this.chkCATBitBangPTT.Image = null;
			this.chkCATBitBangPTT.Location = new System.Drawing.Point(8, 16);
			this.chkCATBitBangPTT.Name = "chkCATBitBangPTT";
			this.chkCATBitBangPTT.TabIndex = 4;
			this.chkCATBitBangPTT.Text = "PTT Bit Bang";
			this.chkCATBitBangPTT.CheckedChanged += new System.EventHandler(this.chkCATBitBangPTT_CheckedChanged);
			// 
			// grpCatControlBox
			// 
			this.grpCatControlBox.Controls.Add(this.chkCATMixWVirtual);
			this.grpCatControlBox.Controls.Add(this.comboCATbaud);
			this.grpCatControlBox.Controls.Add(this.lblCATBaud);
			this.grpCatControlBox.Controls.Add(this.lblCATComPort);
			this.grpCatControlBox.Controls.Add(this.udCATPort);
			this.grpCatControlBox.Controls.Add(this.chkCATEnable);
			this.grpCatControlBox.Controls.Add(this.lblCATParity);
			this.grpCatControlBox.Controls.Add(this.lblCATData);
			this.grpCatControlBox.Controls.Add(this.lblCATStop);
			this.grpCatControlBox.Controls.Add(this.comboCATparity);
			this.grpCatControlBox.Controls.Add(this.comboCATdatabits);
			this.grpCatControlBox.Controls.Add(this.comboCATstopbits);
			this.grpCatControlBox.Location = new System.Drawing.Point(16, 16);
			this.grpCatControlBox.Name = "grpCatControlBox";
			this.grpCatControlBox.Size = new System.Drawing.Size(160, 248);
			this.grpCatControlBox.TabIndex = 90;
			this.grpCatControlBox.TabStop = false;
			this.grpCatControlBox.Text = "CAT Control";
			// 
			// chkCATMixWVirtual
			// 
			this.chkCATMixWVirtual.Image = null;
			this.chkCATMixWVirtual.Location = new System.Drawing.Point(24, 216);
			this.chkCATMixWVirtual.Name = "chkCATMixWVirtual";
			this.chkCATMixWVirtual.Size = new System.Drawing.Size(112, 24);
			this.chkCATMixWVirtual.TabIndex = 95;
			this.chkCATMixWVirtual.Text = "MixW Virtual Port";
			this.chkCATMixWVirtual.CheckedChanged += new System.EventHandler(this.chkCATMixWVirtual_CheckedChanged);
			// 
			// comboCATbaud
			// 
			this.comboCATbaud.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboCATbaud.DropDownWidth = 56;
			this.comboCATbaud.Items.AddRange(new object[] {
															  "300",
															  "1200",
															  "2400",
															  "4800",
															  "9600",
															  "19200",
															  "38400",
															  "57600"});
			this.comboCATbaud.Location = new System.Drawing.Point(72, 88);
			this.comboCATbaud.Name = "comboCATbaud";
			this.comboCATbaud.Size = new System.Drawing.Size(56, 21);
			this.comboCATbaud.TabIndex = 93;
			this.comboCATbaud.SelectedIndexChanged += new System.EventHandler(this.comboCATbaud_SelectedIndexChanged);
			// 
			// lblCATBaud
			// 
			this.lblCATBaud.Location = new System.Drawing.Point(24, 88);
			this.lblCATBaud.Name = "lblCATBaud";
			this.lblCATBaud.Size = new System.Drawing.Size(40, 23);
			this.lblCATBaud.TabIndex = 5;
			this.lblCATBaud.Text = "Baud";
			// 
			// lblCATComPort
			// 
			this.lblCATComPort.Image = null;
			this.lblCATComPort.Location = new System.Drawing.Point(24, 48);
			this.lblCATComPort.Name = "lblCATComPort";
			this.lblCATComPort.Size = new System.Drawing.Size(40, 23);
			this.lblCATComPort.TabIndex = 3;
			this.lblCATComPort.Text = "COMx:";
			// 
			// udCATPort
			// 
			this.udCATPort.Increment = new System.Decimal(new int[] {
																		1,
																		0,
																		0,
																		0});
			this.udCATPort.Location = new System.Drawing.Point(80, 48);
			this.udCATPort.Maximum = new System.Decimal(new int[] {
																	  20,
																	  0,
																	  0,
																	  0});
			this.udCATPort.Minimum = new System.Decimal(new int[] {
																	  1,
																	  0,
																	  0,
																	  0});
			this.udCATPort.Name = "udCATPort";
			this.udCATPort.Size = new System.Drawing.Size(48, 20);
			this.udCATPort.TabIndex = 2;
			this.udCATPort.Value = new System.Decimal(new int[] {
																	1,
																	0,
																	0,
																	0});
			this.udCATPort.ValueChanged += new System.EventHandler(this.udCATPort_ValueChanged);
			// 
			// chkCATEnable
			// 
			this.chkCATEnable.Image = null;
			this.chkCATEnable.Location = new System.Drawing.Point(16, 16);
			this.chkCATEnable.Name = "chkCATEnable";
			this.chkCATEnable.TabIndex = 0;
			this.chkCATEnable.Text = "Enable CAT";
			this.chkCATEnable.CheckedChanged += new System.EventHandler(this.chkCATEnable_CheckedChanged);
			// 
			// lblCATParity
			// 
			this.lblCATParity.Location = new System.Drawing.Point(24, 120);
			this.lblCATParity.Name = "lblCATParity";
			this.lblCATParity.Size = new System.Drawing.Size(48, 23);
			this.lblCATParity.TabIndex = 92;
			this.lblCATParity.Text = "Parity";
			// 
			// lblCATData
			// 
			this.lblCATData.Location = new System.Drawing.Point(24, 152);
			this.lblCATData.Name = "lblCATData";
			this.lblCATData.Size = new System.Drawing.Size(40, 23);
			this.lblCATData.TabIndex = 92;
			this.lblCATData.Text = "Data";
			// 
			// lblCATStop
			// 
			this.lblCATStop.Location = new System.Drawing.Point(24, 184);
			this.lblCATStop.Name = "lblCATStop";
			this.lblCATStop.Size = new System.Drawing.Size(40, 23);
			this.lblCATStop.TabIndex = 92;
			this.lblCATStop.Text = "Stop";
			// 
			// comboCATparity
			// 
			this.comboCATparity.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboCATparity.DropDownWidth = 56;
			this.comboCATparity.Items.AddRange(new object[] {
																"none",
																"odd ",
																"even",
																"mark",
																"space"});
			this.comboCATparity.Location = new System.Drawing.Point(72, 120);
			this.comboCATparity.Name = "comboCATparity";
			this.comboCATparity.Size = new System.Drawing.Size(56, 21);
			this.comboCATparity.TabIndex = 92;
			this.comboCATparity.SelectedIndexChanged += new System.EventHandler(this.comboCATparity_SelectedIndexChanged);
			// 
			// comboCATdatabits
			// 
			this.comboCATdatabits.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboCATdatabits.DropDownWidth = 56;
			this.comboCATdatabits.Items.AddRange(new object[] {
																  "8",
																  "7",
																  "6"});
			this.comboCATdatabits.Location = new System.Drawing.Point(72, 152);
			this.comboCATdatabits.Name = "comboCATdatabits";
			this.comboCATdatabits.Size = new System.Drawing.Size(56, 21);
			this.comboCATdatabits.TabIndex = 93;
			this.comboCATdatabits.SelectedIndexChanged += new System.EventHandler(this.comboCATdatabits_SelectedIndexChanged);
			// 
			// comboCATstopbits
			// 
			this.comboCATstopbits.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.comboCATstopbits.DropDownWidth = 56;
			this.comboCATstopbits.Items.AddRange(new object[] {
																  "1",
																  "1.5",
																  "2"});
			this.comboCATstopbits.Location = new System.Drawing.Point(72, 184);
			this.comboCATstopbits.Name = "comboCATstopbits";
			this.comboCATstopbits.Size = new System.Drawing.Size(56, 21);
			this.comboCATstopbits.TabIndex = 94;
			this.comboCATstopbits.SelectedIndexChanged += new System.EventHandler(this.comboCATstopbits_SelectedIndexChanged);
			// 
			// tpTests
			// 
			this.tpTests.Controls.Add(this.dbgClear);
			this.tpTests.Controls.Add(this.dbgCopy);
			this.tpTests.Controls.Add(this.dbgBox);
			this.tpTests.Controls.Add(this.grpKB9YIG_QRP_Rig);
			this.tpTests.Controls.Add(this.grpTestX2);
			this.tpTests.Controls.Add(this.grpTestAudioBalance);
			this.tpTests.Controls.Add(this.grpTestTXIMD);
			this.tpTests.Location = new System.Drawing.Point(4, 22);
			this.tpTests.Name = "tpTests";
			this.tpTests.Size = new System.Drawing.Size(584, 286);
			this.tpTests.TabIndex = 7;
			this.tpTests.Text = "Tests";
			// 
			// dbgClear
			// 
			this.dbgClear.Location = new System.Drawing.Point(520, 120);
			this.dbgClear.Name = "dbgClear";
			this.dbgClear.Size = new System.Drawing.Size(56, 23);
			this.dbgClear.TabIndex = 91;
			this.dbgClear.Text = "Clear";
			this.dbgClear.Click += new System.EventHandler(this.dbgClear_Click);
			// 
			// dbgCopy
			// 
			this.dbgCopy.Location = new System.Drawing.Point(456, 120);
			this.dbgCopy.Name = "dbgCopy";
			this.dbgCopy.Size = new System.Drawing.Size(56, 23);
			this.dbgCopy.TabIndex = 90;
			this.dbgCopy.Text = "Copy";
			this.dbgCopy.Click += new System.EventHandler(this.dbgCopy_Click);
			// 
			// dbgBox
			// 
			this.dbgBox.Location = new System.Drawing.Point(184, 144);
			this.dbgBox.Name = "dbgBox";
			this.dbgBox.ReadOnly = true;
			this.dbgBox.Size = new System.Drawing.Size(392, 136);
			this.dbgBox.TabIndex = 89;
			this.dbgBox.Text = "";
			this.dbgBox.TextChanged += new System.EventHandler(this.dbgBox_TextChanged);
			// 
			// grpKB9YIG_QRP_Rig
			// 
			this.grpKB9YIG_QRP_Rig.Controls.Add(this.chkLeftOnly);
			this.grpKB9YIG_QRP_Rig.Controls.Add(this.textFixedOscFreq);
			this.grpKB9YIG_QRP_Rig.Controls.Add(this.checkBoxKB9YIG_NoDDS);
			this.grpKB9YIG_QRP_Rig.Controls.Add(this.label2);
			this.grpKB9YIG_QRP_Rig.Location = new System.Drawing.Point(176, 16);
			this.grpKB9YIG_QRP_Rig.Name = "grpKB9YIG_QRP_Rig";
			this.grpKB9YIG_QRP_Rig.Size = new System.Drawing.Size(144, 112);
			this.grpKB9YIG_QRP_Rig.TabIndex = 88;
			this.grpKB9YIG_QRP_Rig.TabStop = false;
			this.grpKB9YIG_QRP_Rig.Text = "KB9YIG QRP Radio";
			// 
			// textFixedOscFreq
			// 
			this.textFixedOscFreq.Location = new System.Drawing.Point(48, 80);
			this.textFixedOscFreq.Name = "textFixedOscFreq";
			this.textFixedOscFreq.Size = new System.Drawing.Size(88, 20);
			this.textFixedOscFreq.TabIndex = 13;
			this.textFixedOscFreq.Text = "";
			// 
			// checkBoxKB9YIG_NoDDS
			// 
			this.checkBoxKB9YIG_NoDDS.Image = null;
			this.checkBoxKB9YIG_NoDDS.Location = new System.Drawing.Point(16, 24);
			this.checkBoxKB9YIG_NoDDS.Name = "checkBoxKB9YIG_NoDDS";
			this.checkBoxKB9YIG_NoDDS.Size = new System.Drawing.Size(104, 16);
			this.checkBoxKB9YIG_NoDDS.TabIndex = 12;
			this.checkBoxKB9YIG_NoDDS.Text = "Fixed HW Osc";
			this.toolTip1.SetToolTip(this.checkBoxKB9YIG_NoDDS, "HW has no DDS");
			this.checkBoxKB9YIG_NoDDS.CheckedChanged += new System.EventHandler(this.checkBoxKB9YIG_NoDDS_CheckedChanged);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 72);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(40, 32);
			this.label2.TabIndex = 14;
			this.label2.Text = "Freq (MHz)";
			// 
			// grpTestX2
			// 
			this.grpTestX2.Controls.Add(this.lblTestX2);
			this.grpTestX2.Controls.Add(this.chkTestX2Pin6);
			this.grpTestX2.Controls.Add(this.chkTestX2Pin5);
			this.grpTestX2.Controls.Add(this.chkTestX2Pin4);
			this.grpTestX2.Controls.Add(this.chkTestX2Pin3);
			this.grpTestX2.Controls.Add(this.chkTestX2Pin2);
			this.grpTestX2.Controls.Add(this.chkTestX2Pin1);
			this.grpTestX2.Location = new System.Drawing.Point(8, 160);
			this.grpTestX2.Name = "grpTestX2";
			this.grpTestX2.Size = new System.Drawing.Size(160, 72);
			this.grpTestX2.TabIndex = 87;
			this.grpTestX2.TabStop = false;
			this.grpTestX2.Text = "X2";
			// 
			// lblTestX2
			// 
			this.lblTestX2.Image = null;
			this.lblTestX2.Location = new System.Drawing.Point(16, 48);
			this.lblTestX2.Name = "lblTestX2";
			this.lblTestX2.Size = new System.Drawing.Size(136, 16);
			this.lblTestX2.TabIndex = 6;
			this.lblTestX2.Text = "1      2      3      4      5      6";
			// 
			// chkTestX2Pin6
			// 
			this.chkTestX2Pin6.Image = null;
			this.chkTestX2Pin6.Location = new System.Drawing.Point(136, 24);
			this.chkTestX2Pin6.Name = "chkTestX2Pin6";
			this.chkTestX2Pin6.Size = new System.Drawing.Size(16, 24);
			this.chkTestX2Pin6.TabIndex = 5;
			this.chkTestX2Pin6.Text = "checkBox6";
			this.chkTestX2Pin6.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
			// 
			// chkTestX2Pin5
			// 
			this.chkTestX2Pin5.Image = null;
			this.chkTestX2Pin5.Location = new System.Drawing.Point(112, 24);
			this.chkTestX2Pin5.Name = "chkTestX2Pin5";
			this.chkTestX2Pin5.Size = new System.Drawing.Size(16, 24);
			this.chkTestX2Pin5.TabIndex = 4;
			this.chkTestX2Pin5.Text = "checkBox5";
			this.chkTestX2Pin5.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
			// 
			// chkTestX2Pin4
			// 
			this.chkTestX2Pin4.Image = null;
			this.chkTestX2Pin4.Location = new System.Drawing.Point(88, 24);
			this.chkTestX2Pin4.Name = "chkTestX2Pin4";
			this.chkTestX2Pin4.Size = new System.Drawing.Size(16, 24);
			this.chkTestX2Pin4.TabIndex = 3;
			this.chkTestX2Pin4.Text = "checkBox4";
			this.chkTestX2Pin4.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
			// 
			// chkTestX2Pin3
			// 
			this.chkTestX2Pin3.Image = null;
			this.chkTestX2Pin3.Location = new System.Drawing.Point(64, 24);
			this.chkTestX2Pin3.Name = "chkTestX2Pin3";
			this.chkTestX2Pin3.Size = new System.Drawing.Size(16, 24);
			this.chkTestX2Pin3.TabIndex = 2;
			this.chkTestX2Pin3.Text = "checkBox3";
			this.chkTestX2Pin3.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
			// 
			// chkTestX2Pin2
			// 
			this.chkTestX2Pin2.Image = null;
			this.chkTestX2Pin2.Location = new System.Drawing.Point(40, 24);
			this.chkTestX2Pin2.Name = "chkTestX2Pin2";
			this.chkTestX2Pin2.Size = new System.Drawing.Size(16, 24);
			this.chkTestX2Pin2.TabIndex = 1;
			this.chkTestX2Pin2.Text = "checkBox2";
			this.chkTestX2Pin2.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
			// 
			// chkTestX2Pin1
			// 
			this.chkTestX2Pin1.Image = null;
			this.chkTestX2Pin1.Location = new System.Drawing.Point(16, 24);
			this.chkTestX2Pin1.Name = "chkTestX2Pin1";
			this.chkTestX2Pin1.Size = new System.Drawing.Size(16, 24);
			this.chkTestX2Pin1.TabIndex = 0;
			this.chkTestX2Pin1.Text = "checkBox1";
			this.chkTestX2Pin1.CheckedChanged += new System.EventHandler(this.chkTestX2_CheckedChanged);
			// 
			// grpTestAudioBalance
			// 
			this.grpTestAudioBalance.Controls.Add(this.btnTestAudioBalStart);
			this.grpTestAudioBalance.Location = new System.Drawing.Point(344, 8);
			this.grpTestAudioBalance.Name = "grpTestAudioBalance";
			this.grpTestAudioBalance.Size = new System.Drawing.Size(120, 64);
			this.grpTestAudioBalance.TabIndex = 86;
			this.grpTestAudioBalance.TabStop = false;
			this.grpTestAudioBalance.Text = "Audio Balance Test";
			// 
			// btnTestAudioBalStart
			// 
			this.btnTestAudioBalStart.Image = null;
			this.btnTestAudioBalStart.Location = new System.Drawing.Point(24, 24);
			this.btnTestAudioBalStart.Name = "btnTestAudioBalStart";
			this.btnTestAudioBalStart.TabIndex = 0;
			this.btnTestAudioBalStart.Text = "Start";
			this.btnTestAudioBalStart.Click += new System.EventHandler(this.btnTestAudioBalStart_Click);
			// 
			// grpTestTXIMD
			// 
			this.grpTestTXIMD.Controls.Add(this.lblTestToneFreq2);
			this.grpTestTXIMD.Controls.Add(this.udTestIMDFreq2);
			this.grpTestTXIMD.Controls.Add(this.lblTestIMDPower);
			this.grpTestTXIMD.Controls.Add(this.udTestIMDPower);
			this.grpTestTXIMD.Controls.Add(this.chkTestIMD);
			this.grpTestTXIMD.Controls.Add(this.lblTestToneFreq1);
			this.grpTestTXIMD.Controls.Add(this.udTestIMDFreq1);
			this.grpTestTXIMD.Location = new System.Drawing.Point(8, 8);
			this.grpTestTXIMD.Name = "grpTestTXIMD";
			this.grpTestTXIMD.Size = new System.Drawing.Size(152, 144);
			this.grpTestTXIMD.TabIndex = 83;
			this.grpTestTXIMD.TabStop = false;
			this.grpTestTXIMD.Text = "TX IMD Test";
			// 
			// lblTestToneFreq2
			// 
			this.lblTestToneFreq2.Image = null;
			this.lblTestToneFreq2.Location = new System.Drawing.Point(16, 48);
			this.lblTestToneFreq2.Name = "lblTestToneFreq2";
			this.lblTestToneFreq2.Size = new System.Drawing.Size(64, 16);
			this.lblTestToneFreq2.TabIndex = 88;
			this.lblTestToneFreq2.Text = "Freq #2:";
			// 
			// udTestIMDFreq2
			// 
			this.udTestIMDFreq2.Increment = new System.Decimal(new int[] {
																			 1,
																			 0,
																			 0,
																			 0});
			this.udTestIMDFreq2.Location = new System.Drawing.Point(80, 48);
			this.udTestIMDFreq2.Maximum = new System.Decimal(new int[] {
																		   20000,
																		   0,
																		   0,
																		   0});
			this.udTestIMDFreq2.Minimum = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.udTestIMDFreq2.Name = "udTestIMDFreq2";
			this.udTestIMDFreq2.Size = new System.Drawing.Size(56, 20);
			this.udTestIMDFreq2.TabIndex = 87;
			this.udTestIMDFreq2.Value = new System.Decimal(new int[] {
																		 19000,
																		 0,
																		 0,
																		 65536});
			// 
			// lblTestIMDPower
			// 
			this.lblTestIMDPower.Image = null;
			this.lblTestIMDPower.Location = new System.Drawing.Point(16, 72);
			this.lblTestIMDPower.Name = "lblTestIMDPower";
			this.lblTestIMDPower.Size = new System.Drawing.Size(64, 16);
			this.lblTestIMDPower.TabIndex = 86;
			this.lblTestIMDPower.Text = "Power:";
			// 
			// udTestIMDPower
			// 
			this.udTestIMDPower.Increment = new System.Decimal(new int[] {
																			 1,
																			 0,
																			 0,
																			 0});
			this.udTestIMDPower.Location = new System.Drawing.Point(80, 72);
			this.udTestIMDPower.Maximum = new System.Decimal(new int[] {
																		   100,
																		   0,
																		   0,
																		   0});
			this.udTestIMDPower.Minimum = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.udTestIMDPower.Name = "udTestIMDPower";
			this.udTestIMDPower.Size = new System.Drawing.Size(56, 20);
			this.udTestIMDPower.TabIndex = 85;
			this.udTestIMDPower.Value = new System.Decimal(new int[] {
																		 50,
																		 0,
																		 0,
																		 0});
			// 
			// chkTestIMD
			// 
			this.chkTestIMD.Appearance = System.Windows.Forms.Appearance.Button;
			this.chkTestIMD.Image = null;
			this.chkTestIMD.Location = new System.Drawing.Point(48, 104);
			this.chkTestIMD.Name = "chkTestIMD";
			this.chkTestIMD.Size = new System.Drawing.Size(64, 24);
			this.chkTestIMD.TabIndex = 84;
			this.chkTestIMD.Text = "Start";
			this.chkTestIMD.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			this.chkTestIMD.CheckedChanged += new System.EventHandler(this.chkTestIMD_CheckedChanged);
			// 
			// lblTestToneFreq1
			// 
			this.lblTestToneFreq1.Image = null;
			this.lblTestToneFreq1.Location = new System.Drawing.Point(16, 24);
			this.lblTestToneFreq1.Name = "lblTestToneFreq1";
			this.lblTestToneFreq1.Size = new System.Drawing.Size(64, 16);
			this.lblTestToneFreq1.TabIndex = 83;
			this.lblTestToneFreq1.Text = "Freq #1:";
			// 
			// udTestIMDFreq1
			// 
			this.udTestIMDFreq1.Increment = new System.Decimal(new int[] {
																			 1,
																			 0,
																			 0,
																			 0});
			this.udTestIMDFreq1.Location = new System.Drawing.Point(80, 24);
			this.udTestIMDFreq1.Maximum = new System.Decimal(new int[] {
																		   20000,
																		   0,
																		   0,
																		   0});
			this.udTestIMDFreq1.Minimum = new System.Decimal(new int[] {
																		   0,
																		   0,
																		   0,
																		   0});
			this.udTestIMDFreq1.Name = "udTestIMDFreq1";
			this.udTestIMDFreq1.Size = new System.Drawing.Size(56, 20);
			this.udTestIMDFreq1.TabIndex = 82;
			this.udTestIMDFreq1.Value = new System.Decimal(new int[] {
																		 7000,
																		 0,
																		 0,
																		 65536});
			// 
			// btnOK
			// 
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(328, 328);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 17;
			this.btnOK.Text = "OK";
			this.toolTip1.SetToolTip(this.btnOK, "Keep current settings and close form.");
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Image = null;
			this.btnCancel.Location = new System.Drawing.Point(416, 328);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 18;
			this.btnCancel.Text = "Cancel";
			this.toolTip1.SetToolTip(this.btnCancel, "Load settings from database and close form.");
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnApply
			// 
			this.btnApply.Image = null;
			this.btnApply.Location = new System.Drawing.Point(504, 328);
			this.btnApply.Name = "btnApply";
			this.btnApply.TabIndex = 19;
			this.btnApply.Text = "Apply";
			this.toolTip1.SetToolTip(this.btnApply, "Save current settings to the database.");
			this.btnApply.Click += new System.EventHandler(this.btnApply_Click);
			// 
			// btnResetAll
			// 
			this.btnResetAll.Image = null;
			this.btnResetAll.Location = new System.Drawing.Point(24, 328);
			this.btnResetAll.Name = "btnResetAll";
			this.btnResetAll.TabIndex = 20;
			this.btnResetAll.Text = "Reset All";
			this.toolTip1.SetToolTip(this.btnResetAll, "Reset values to defaults.");
			this.btnResetAll.Click += new System.EventHandler(this.btnResetAll_Click);
			// 
			// btnImportDB
			// 
			this.btnImportDB.Image = null;
			this.btnImportDB.Location = new System.Drawing.Point(136, 328);
			this.btnImportDB.Name = "btnImportDB";
			this.btnImportDB.TabIndex = 21;
			this.btnImportDB.Text = "Import DB...";
			this.toolTip1.SetToolTip(this.btnImportDB, "Import a saved PowerSDR Database file.");
			this.btnImportDB.Click += new System.EventHandler(this.btnImportDB_Click);
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.InitialDirectory = "\"../\"+Application.StartupPath";
			this.openFileDialog1.FileOk += new System.ComponentModel.CancelEventHandler(this.openFileDialog1_FileOk);
			// 
			// chkLeftOnly
			// 
			this.chkLeftOnly.Image = null;
			this.chkLeftOnly.Location = new System.Drawing.Point(20, 48);
			this.chkLeftOnly.Name = "chkLeftOnly";
			this.chkLeftOnly.Size = new System.Drawing.Size(104, 16);
			this.chkLeftOnly.TabIndex = 15;
			this.chkLeftOnly.Text = "Left Audio Only";
			this.toolTip1.SetToolTip(this.chkLeftOnly, "Audio only on Left Side - needed for Sampler");
			this.chkLeftOnly.CheckedChanged += new System.EventHandler(this.chkLeftOnly_CheckedChanged);
			// 
			// Setup
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(616, 357);
			this.Controls.Add(this.btnImportDB);
			this.Controls.Add(this.btnResetAll);
			this.Controls.Add(this.btnApply);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.tcSetup);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "Setup";
			this.Text = "PowerSDR Setup";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Setup_Closing);
			this.tcSetup.ResumeLayout(false);
			this.tpGeneral.ResumeLayout(false);
			this.grpGeneralUpdates.ResumeLayout(false);
			this.grpGeneralProcessPriority.ResumeLayout(false);
			this.grpGeneralOptions.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udGeneralX2Delay)).EndInit();
			this.grpGeneralCalibration.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udGeneralCalLevel)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udGeneralCalFreq)).EndInit();
			this.grpGeneralDDS.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDDSCorrection)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDDSIFFreq)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDDSPLLMult)).EndInit();
			this.grpGeneralHardwareSetup.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udGeneralLPTDelay)).EndInit();
			this.tpAudio.ResumeLayout(false);
			this.grpAudioLineInGain.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udAudioLineIn2)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udAudioLineIn1)).EndInit();
			this.grpAudioVoltage.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udAudioVoltage2)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udAudioVoltage1)).EndInit();
			this.grpAudioDetails1.ResumeLayout(false);
			this.grpAudioLatency.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udAudioLatency2)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udAudioLatency1)).EndInit();
			this.grpAudioDetails2.ResumeLayout(false);
			this.grpAudioCard.ResumeLayout(false);
			this.grpAudioBufferSize.ResumeLayout(false);
			this.grpAudioSampleRate.ResumeLayout(false);
			this.tpDisplay.ResumeLayout(false);
			this.grpDisplayMultimeter.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDisplayMultiTextHoldTime)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayMultiPeakHoldTime)).EndInit();
			this.grpDisplayWaterfall.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallLowLevel)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayWaterfallHighLevel)).EndInit();
			this.grpDisplayRefreshRates.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDisplayCPUMeter)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayPeakText)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayMeterDelay)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayFPS)).EndInit();
			this.grpDisplayAverage.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDisplayAVGTime)).EndInit();
			this.grpDisplayPhase.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDisplayPhasePts)).EndInit();
			this.grpDisplaySpectrumGrid.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDisplayGridStep)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayGridMin)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDisplayGridMax)).EndInit();
			this.tpDSP.ResumeLayout(false);
			this.grpDSPNB.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDSPNB)).EndInit();
			this.grpDSPCWPitch.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDSPCWPitch)).EndInit();
			this.grpDSPNB2.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDSPMNB)).EndInit();
			this.grpDSPLMSNR.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udLMSNRgain)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udLMSNRdelay)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udLMSNRtaps)).EndInit();
			this.grpDSPLMSANF.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udLMSANFgain)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udLMSANFdelay)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udLMSANFtaps)).EndInit();
			this.grpDSPImageRejectRX.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDSPImageGainRX)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDSPImagePhaseRX)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbDSPImagePhaseRX)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbDSPImageGainRX)).EndInit();
			this.grpDSPAGC.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDSPAGCMaxGaindB)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDSPAGCFixedGaindB)).EndInit();
			this.grpDSPWindow.ResumeLayout(false);
			this.grpDSPImageRejectTX.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDSPImageGainTX)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udDSPImagePhaseTX)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbDSPImagePhaseTX)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbDSPImageGainTX)).EndInit();
			this.tpTransmit.ResumeLayout(false);
			this.grpTXMicPreamp.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udTXPreGain)).EndInit();
			this.grpPATune.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udTXTunePower)).EndInit();
			this.grpTXCompression.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udTXFFCompression)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXFFCompression)).EndInit();
			this.grpTXFilter.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udTXFilterLow)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udTXFilterHigh)).EndInit();
			this.grpTXEqualizer.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ3500)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ80)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ160)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ3000)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ2600)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ2300)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ2000)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ1600)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ1300)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ1000)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ600)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.tbTXEQ300)).EndInit();
			this.tpPowerAmplifier.ResumeLayout(false);
			this.grpPABandOffset.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udPAADC17)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC15)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC20)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC12)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC10)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC160)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC80)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC60)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC40)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAADC30)).EndInit();
			this.grpPAGainByBand.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udPACalPower)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain10)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain12)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain15)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain17)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain20)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain30)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain40)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain60)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain80)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udPAGain160)).EndInit();
			this.tpAppearance.ResumeLayout(false);
			this.grpAppearanceGeneral.ResumeLayout(false);
			this.grpAppearanceMeter.ResumeLayout(false);
			this.grpAppearanceDisplay.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udDisplayLineWidth)).EndInit();
			this.tpKeyboard.ResumeLayout(false);
			this.grpKBXIT.ResumeLayout(false);
			this.grpKBRIT.ResumeLayout(false);
			this.grpKBMode.ResumeLayout(false);
			this.grpKBBand.ResumeLayout(false);
			this.grpKBTune.ResumeLayout(false);
			this.grpKBFilter.ResumeLayout(false);
			this.grpKBCW.ResumeLayout(false);
			this.tpCAT.ResumeLayout(false);
			this.grpPTTBitBang.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udCATBitBangPTTPort)).EndInit();
			this.grpCatControlBox.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udCATPort)).EndInit();
			this.tpTests.ResumeLayout(false);
			this.grpKB9YIG_QRP_Rig.ResumeLayout(false);
			this.grpTestX2.ResumeLayout(false);
			this.grpTestAudioBalance.ResumeLayout(false);
			this.grpTestTXIMD.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.udTestIMDFreq2)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udTestIMDPower)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.udTestIMDFreq1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		#region Init Routines
		// ======================================================
		// Init Routines
		// ======================================================

		private void InitGeneralTab()
		{
			comboGeneralLPTAddr.Text = Convert.ToString(console.hw.LPTAddr, 16);
			udGeneralLPTDelay.Value = console.LatchDelay;
			chkGeneralRXOnly.Checked = console.RXOnly;
			chkGeneralUSBPresent.Checked = console.USBPresent;
			chkGeneralRFEPresent.Checked = console.RFEPresent;
			chkGeneralPAPresent.Checked = console.PAPresent;
			chkGeneralXVTRPresent.Checked = console.XVTRPresent;
			comboGeneralXVTR.SelectedItem = (int)console.CurrentXVTRTRMode;
			chkGeneralSpurRed.Checked = true;
			chkGeneralDisablePTT.Checked = console.DisablePTT;
			chkGeneralSoftwareGainCorr.Checked = console.NoHardwareOffset;
			chkGeneralEnableX2.Checked = console.X2Enabled;
			chkGeneralCustomFilter.Checked = console.EnableLPF0;
			chkGeneralUpdateRelease.Checked = console.NotifyOnRelease;
			chkGeneralUpdateBeta.Checked = console.NotifyOnBeta;
		}

		private void InitAudioTab()
		{
			// set driver type
			if(comboAudioDriver1.SelectedIndex < 0 &&
				comboAudioDriver1.Items.Count > 0)
			{
				if(comboAudioDriver1.Items.Count == 3)
					comboAudioDriver1.SelectedIndex = 2;
				else if(comboAudioDriver1.Items.Count == 2)
					comboAudioDriver1.SelectedIndex = 1;
				else comboAudioDriver1.SelectedIndex = 0;
			}

			// set Input device
			if(comboAudioInput1.Items.Count > 0)
				comboAudioInput1.SelectedIndex = console.AudioInputIndex1;

			// set Output device
			if(comboAudioDriver1.SelectedIndex < 2)
				comboAudioOutput1.SelectedIndex = console.AudioOutputIndex1 - comboAudioInput1.Items.Count;
			else
				comboAudioOutput1.SelectedIndex = console.AudioOutputIndex1;
			
			// set sample rate
			// setup sample rate here

			if(comboAudioReceive1.Enabled == true)
			{
				for(int i=0; i<comboAudioReceive1.Items.Count; i++)
				{
					if(((string)comboAudioReceive1.Items[i]).StartsWith("Line"))
					{
						comboAudioReceive1.SelectedIndex = i;
						i = comboAudioReceive1.Items.Count;
					}
				}
			}

			if(comboAudioTransmit1.Enabled == true)
			{
				for(int i=0; i<comboAudioTransmit1.Items.Count; i++)
				{
					if(((string)comboAudioTransmit1.Items[i]).StartsWith("Mic"))
					{
						comboAudioTransmit1.SelectedIndex = i;
						i = comboAudioTransmit1.Items.Count;
					}
				}
			}

			comboAudioBuffer1.Text = "2048";
			udAudioLatency1.Value = console.AudioLatency1;
		}

		private void InitDisplayTab()
		{
			udDisplayGridMax.Value = console.SpectrumGridMax;
			udDisplayGridMin.Value = console.SpectrumGridMin;
			udDisplayGridStep.Value = console.SpectrumGridStep;
			udDisplayFPS.Value = console.DisplayFPS;
			clrbtnWaterfallLow.Color = console.WaterfallLowColor;
			clrbtnWaterfallMid.Color = console.WaterfallMidColor;
			clrbtnWaterfallHigh.Color = console.WaterfallHighColor;
			udDisplayWaterfallLowLevel.Value = (decimal)console.WaterfallLowThreshold;
			udDisplayWaterfallHighLevel.Value = (decimal)console.WaterfallHighThreshold;
			udDisplayMeterDelay.Value = console.MeterDelay;
			udDisplayPeakText.Value = console.PeakTextDelay;
			udDisplayCPUMeter.Value = console.CPUMeterDelay;
			udDisplayPhasePts.Value = console.PhaseNumPts;
			udDisplayMultiPeakHoldTime.Value = console.MultimeterPeakHoldTime;
			udDisplayMultiTextHoldTime.Value = console.MultimeterTextPeakTime;
		}

		private void InitDSPTab()
		{
			udDSPCWPitch.Value = console.CWPitch;
			comboDSPWindow.SelectedIndex = (int)DttSP.CurrentWindow;
		}

		private void InitKeyboardTab()
		{
			// set tune keys
			comboKBTuneUp1.Text = console.KeyTuneUp1.ToString();
			comboKBTuneUp2.Text = console.KeyTuneUp2.ToString();
			comboKBTuneUp3.Text = console.KeyTuneUp3.ToString();
			comboKBTuneUp4.Text = console.KeyTuneUp4.ToString();
			comboKBTuneUp5.Text = console.KeyTuneUp5.ToString();
			comboKBTuneUp6.Text = console.KeyTuneUp6.ToString();
			comboKBTuneUp7.Text = console.KeyTuneUp7.ToString();
			comboKBTuneDown1.Text = console.KeyTuneDown1.ToString();
			comboKBTuneDown2.Text = console.KeyTuneDown2.ToString();
			comboKBTuneDown3.Text = console.KeyTuneDown3.ToString();
			comboKBTuneDown4.Text = console.KeyTuneDown4.ToString();
			comboKBTuneDown5.Text = console.KeyTuneDown5.ToString();
			comboKBTuneDown6.Text = console.KeyTuneDown6.ToString();
			comboKBTuneDown7.Text = console.KeyTuneDown7.ToString();

			// set band keys
			comboKBBandDown.Text = console.KeyBandDown.ToString();
			comboKBBandUp.Text = console.KeyBandUp.ToString();			

			// set filter keys
			comboKBFilterDown.Text = console.KeyFilterDown.ToString();
			comboKBFilterUp.Text = console.KeyFilterUp.ToString();			

			// set mode keys
			comboKBModeDown.Text = console.KeyModeDown.ToString();
			comboKBModeUp.Text = console.KeyModeUp.ToString();

			// set RIT keys
			comboKBRITDown.Text = console.KeyRITDown.ToString();
			comboKBRITUp.Text = console.KeyRITUp.ToString();

			// set XIT keys
			comboKBXITDown.Text = console.KeyXITDown.ToString();
			comboKBXITUp.Text = console.KeyXITUp.ToString();
		}

		private void InitAppearanceTab()
		{
			clrbtnBackground.Color = console.DisplayBackgroundColor;
			clrbtnGrid.Color = console.GridColor;
			clrbtnZeroLine.Color = console.GridZeroColor;
			clrbtnText.Color = console.GridTextColor;
			clrbtnDataLine.Color = console.DataLineColor;
			clrbtnFilter.Color = console.DisplayFilterColor;
			clrbtnMeterLeft.Color = console.MeterLeftColor;
			clrbtnMeterRight.Color = console.MeterRightColor;
			clrbtnBtnSel.Color = console.ButtonSelectedColor;
			clrbtnVFODark.Color = console.VFOTextDarkColor;
			clrbtnVFOLight.Color = console.VFOTextLightColor;
			clrbtnBandDark.Color = console.BandTextDarkColor;
			clrbtnBandLight.Color = console.BandTextLightColor;
			clrbtnPeakText.Color = console.PeakTextColor;
		}

		#endregion

		#region Misc Routines
		// ======================================================
		// Misc Routines
		// ======================================================

		private void InitWindowTypes()
		{
			for(DttSP.Window w = DttSP.Window.FIRST+1; w<DttSP.Window.LAST; w++)
			{
				string s = w.ToString().ToLower();
				s = s.Substring(0, 1).ToUpper() + s.Substring(1, s.Length-1);
				comboDSPWindow.Items.Add(s);
			}
		}
		private class PADeviceInfo
		{
			private string 	_HostName;
			private int		_Index;
			public string HostName
			{
				get
				{
					return _HostName;
				}
			}
			public int Index
			{
				get
				{
					return _Index;
				}
			}
			public PADeviceInfo(String argHostName, int argIndex)
			{
				_HostName = argHostName;
				_Index = argIndex;
			}
			public override string ToString()
			{
				return _HostName;
			}
		}
		private void GetHosts()
		{
			comboAudioDriver1.Items.Clear();
			comboAudioDriver2.Items.Clear();
			int PAHostOrd = 0;
			foreach(string PAHostName in Audio.GetPAHosts())
			{
				if (
					(Audio.GetPAInputDevices(PAHostOrd).Count > 0) ||
					(Audio.GetPAOutputDevices(PAHostOrd).Count > 0)
					)
				{
					comboAudioDriver1.Items.Add(
						new PADeviceInfo(PAHostName, PAHostOrd)
						);
					if (PAHostName != "ASIO")
					{
						comboAudioDriver2.Items.Add(
							new PADeviceInfo(PAHostName, PAHostOrd)
							);
					}
						
				}
				PAHostOrd++; //Increment hardware host ordinal	
			}	
		}
		//		private void GetHosts()
		//		{
		//			comboAudioDriver1.Items.Clear();
		//			comboAudioDriver2.Items.Clear();
		//			ArrayList a = Audio.GetPAHosts();
		//			foreach(string s in a)
		//			{
		//				comboAudioDriver1.Items.Add(s);
		//				comboAudioDriver2.Items.Add(s);
		//			}
		//
		//			if(comboAudioDriver2.Items.Contains("ASIO"))	// remove ASIO from sound card 2 list
		//				comboAudioDriver2.Items.Remove("ASIO");		// since you can only run 1 card with ASIO
		//															
		//			for(int i=0; i<comboAudioDriver1.Items.Count; i++)
		//			{
		//				a = Audio.GetPAInputDevices(i);
		//				ArrayList b = Audio.GetPAOutputDevices(i);
		//				if(a.Count == 0 && b.Count == 0)
		//				{
		//					comboAudioDriver1.Items.RemoveAt(i);
		//					comboAudioDriver2.Items.RemoveAt(i);
		//				}
		//			}
		//		}

		private void GetDevices1()
		{
			comboAudioInput1.Items.Clear();
			comboAudioOutput1.Items.Clear();
			int PAHostOrd = ((PADeviceInfo)comboAudioDriver1.SelectedItem).Index;
			ArrayList a = Audio.GetPAInputDevices(PAHostOrd);
			foreach(string s in a)
				comboAudioInput1.Items.Add(s);

			a = Audio.GetPAOutputDevices(PAHostOrd);
			foreach(string s in a)
				comboAudioOutput1.Items.Add(s);
		}

		private void GetDevices2()
		{
			comboAudioInput2.Items.Clear();
			comboAudioOutput2.Items.Clear();
			int PAHostOrd = ((PADeviceInfo)comboAudioDriver2.SelectedItem).Index;
			ArrayList a = Audio.GetPAInputDevices(PAHostOrd);
			foreach(string s in a)
				comboAudioInput2.Items.Add(s);

			a = Audio.GetPAOutputDevices(PAHostOrd);
			foreach(string s in a)
				comboAudioOutput2.Items.Add(s);
		}

		public void SaveOptions()
		{
			// Automatically saves all control settings to the database in the tab
			// pages on this form of the following types: CheckBox, ComboBox,
			// NumericUpDown, RadioButton, TextBox, and TrackBar (slider)

			ArrayList a = new ArrayList();
			ArrayList temp = new ArrayList();

			foreach(TabPage tp in tcSetup.TabPages)
				temp.AddRange(tp.Controls);			// add controls from each tab

			foreach(Control c in temp)				// For each control
			{
				if(c.GetType() == typeof(GroupBoxTS))		// if it is a groupbox, check for sub controls
				{
					foreach(Control c2 in ((GroupBoxTS)c).Controls)	// for each sub-control
					{	// check to see if it is a value type we need to save
						if(c2.GetType() == typeof(CheckBoxTS))
							a.Add(c2.Name+"/"+((CheckBoxTS)c2).Checked.ToString());
						else if(c2.GetType() == typeof(ComboBoxTS))
							a.Add(c2.Name+"/"+((ComboBoxTS)c2).Text);
						else if(c2.GetType() == typeof(NumericUpDownTS))
							a.Add(c2.Name+"/"+((NumericUpDownTS)c2).Value.ToString());
						else if(c2.GetType() == typeof(RadioButtonTS))
							a.Add(c2.Name+"/"+((RadioButtonTS)c2).Checked.ToString());
						else if(c2.GetType() == typeof(TextBoxTS))
							a.Add(c2.Name+"/"+((TextBoxTS)c2).Text);
						else if(c2.GetType() == typeof(TrackBarTS))
							a.Add(c2.Name+"/"+((TrackBarTS)c2).Value.ToString());
						else if(c2.GetType() == typeof(ColorButton))
						{
							Color clr = ((ColorButton)c2).Color;
							a.Add(c2.Name+"/"+clr.R+"."+clr.G+"."+clr.B+"."+clr.A);
						}
#if(DEBUG)
						else if(c2.GetType() == typeof(GroupBox) ||
							c2.GetType() == typeof(CheckBox) ||
							c2.GetType() == typeof(ComboBox) ||
							c2.GetType() == typeof(NumericUpDown) ||
							c2.GetType() == typeof(RadioButton) ||
							c2.GetType() == typeof(TextBox) ||
							c2.GetType() == typeof(TrackBar))
							Debug.WriteLine(c2.Name+" needs to be converterd to a Thread Safe control.");
#endif
					}						
				}
				else // it is not a group box
				{	// check to see if it is a value type we need to save
					if(c.GetType() == typeof(CheckBoxTS))
						a.Add(c.Name+"/"+((CheckBoxTS)c).Checked.ToString());
					else if(c.GetType() == typeof(ComboBoxTS))
					{
						//if(((ComboBox)c).SelectedIndex >= 0)
						a.Add(c.Name+"/"+((ComboBoxTS)c).Text);
					}
					else if(c.GetType() == typeof(NumericUpDownTS))
						a.Add(c.Name+"/"+((NumericUpDownTS)c).Value.ToString());
					else if(c.GetType() == typeof(RadioButtonTS))
						a.Add(c.Name+"/"+((RadioButtonTS)c).Checked.ToString());
					else if(c.GetType() == typeof(TextBoxTS))
						a.Add(c.Name+"/"+((TextBoxTS)c).Text);
					else if(c.GetType() == typeof(TrackBarTS))
						a.Add(c.Name+"/"+((TrackBarTS)c).Value.ToString());
					else if(c.GetType() == typeof(ColorButton))
					{
						Color clr = ((ColorButton)c).Color;
						a.Add(c.Name+"/"+clr.R+"."+clr.G+"."+clr.B+"."+clr.A);
					}
#if(DEBUG)
					else if(c.GetType() == typeof(GroupBox) ||
						c.GetType() == typeof(CheckBox) ||
						c.GetType() == typeof(ComboBox) ||
						c.GetType() == typeof(NumericUpDown) ||
						c.GetType() == typeof(RadioButton) ||
						c.GetType() == typeof(TextBox) ||
						c.GetType() == typeof(TrackBar))
						Debug.WriteLine(c.Name+" needs to be converterd to a Thread Safe control.");
#endif
				}
			}

			DB.SaveOptions(ref a);		// save the values to the DB
		}

		public void GetOptions()
		{
			// Automatically restores all controls from the database in the
			// tab pages on this form of the following types: CheckBox, ComboBox,
			// NumericUpDown, RadioButton, TextBox, and TrackBar (slider)

			// get list of live controls
			ArrayList temp = new ArrayList();		// list of all first level controls
			foreach(TabPage tp in tcSetup.TabPages)
				temp.AddRange(tp.Controls);			// add controls from each tab

			ArrayList checkbox_list = new ArrayList();
			ArrayList combobox_list = new ArrayList();
			ArrayList numericupdown_list = new ArrayList();
			ArrayList radiobutton_list = new ArrayList();
			ArrayList textbox_list = new ArrayList();
			ArrayList trackbar_list = new ArrayList();
			ArrayList colorbutton_list = new ArrayList();

			//ArrayList controls = new ArrayList();	// list of controls to restore
			foreach(Control c in temp)
			{
				if(c.GetType() == typeof(GroupBoxTS))	// if control is a groupbox, retrieve all subcontrols
				{
					foreach(Control c2 in ((GroupBoxTS)c).Controls)
					{
						if(c2.GetType() == typeof(CheckBoxTS))			// the control is a CheckBox
							checkbox_list.Add(c2);
						else if(c2.GetType() == typeof(ComboBoxTS))		// the control is a ComboBox
							combobox_list.Add(c2);
						else if(c2.GetType() == typeof(NumericUpDownTS))	// the control is a NumericUpDown
							numericupdown_list.Add(c2);
						else if(c2.GetType() == typeof(RadioButtonTS))	// the control is a RadioButton
							radiobutton_list.Add(c2);
						else if(c2.GetType() == typeof(TextBoxTS))		// the control is a TextBox
							textbox_list.Add(c2);
						else if(c2.GetType() == typeof(TrackBarTS))		// the control is a TrackBar (slider)
							trackbar_list.Add(c2);
						else if(c2.GetType() == typeof(ColorButton))
							colorbutton_list.Add(c2);
					}						
				}
				else
				{
					if(c.GetType() == typeof(CheckBoxTS))				// the control is a CheckBox
						checkbox_list.Add(c);
					else if(c.GetType() == typeof(ComboBoxTS))		// the control is a ComboBox
						combobox_list.Add(c);
					else if(c.GetType() == typeof(NumericUpDownTS))	// the control is a NumericUpDown
						numericupdown_list.Add(c);
					else if(c.GetType() == typeof(RadioButtonTS))		// the control is a RadioButton
						radiobutton_list.Add(c);
					else if(c.GetType() == typeof(TextBoxTS))			// the control is a TextBox
						textbox_list.Add(c);
					else if(c.GetType() == typeof(TrackBarTS))		// the control is a TrackBar (slider)
						trackbar_list.Add(c);
					else if(c.GetType() == typeof(ColorButton))
						colorbutton_list.Add(c);
					
				}
			}
			temp.Clear();	// now that we have the controls we want, delete first list 

			ArrayList a = DB.GetOptions();						// Get the saved list of controls
			a.Sort();
			int num_controls = checkbox_list.Count + combobox_list.Count +
				numericupdown_list.Count + radiobutton_list.Count +
				textbox_list.Count + trackbar_list.Count +
				colorbutton_list.Count;

			if(a.Count < num_controls)		// some control values are not in the database
			{								// so set all of them to the defaults
				InitGeneralTab();
				InitAudioTab();
				InitDSPTab();
				InitDisplayTab();
				InitKeyboardTab();
				InitAppearanceTab();
			}
			
			// restore saved values to the controls
			foreach(string s in a)				// string is in the format "name,value"
			{
				string[] vals = s.Split('/');
				if(vals.Length > 2)
				{
					for(int i=2; i<vals.Length; i++)
						vals[1] += "/"+vals[i];
				}

				string name = vals[0];
				string val = vals[1];

				if(s.StartsWith("chk"))			// control is a CheckBox
				{
					for(int i=0; i<checkbox_list.Count; i++)
					{	// look through each control to find the matching name
						CheckBoxTS c = (CheckBoxTS)checkbox_list[i];
						if(c.Name.Equals(name))		// name found
						{
							c.Checked = bool.Parse(val);	// restore value
							i = checkbox_list.Count+1;
						}
						if(i == checkbox_list.Count)
							MessageBox.Show("Control not found: "+name);
					}
				}
				else if(s.StartsWith("combo"))	// control is a ComboBox
				{
					for(int i=0; i<combobox_list.Count; i++)
					{	// look through each control to find the matching name
						ComboBoxTS c = (ComboBoxTS)combobox_list[i];
						if(c.Name.Equals(name))		// name found
						{
							c.Text = val;	// restore value
							i = combobox_list.Count+1;
						}
						if(i == combobox_list.Count)
							MessageBox.Show("Control not found: "+name);
					}
				}
				else if(s.StartsWith("ud"))
				{
					for(int i=0; i<numericupdown_list.Count; i++)
					{	// look through each control to find the matching name
						NumericUpDownTS c = (NumericUpDownTS)numericupdown_list[i];
						if(c.Name.Equals(name))		// name found
						{
							decimal num = decimal.Parse(val);

							if(num > c.Maximum) num = c.Maximum;		// check endpoints
							else if(num < c.Minimum) num = c.Minimum;
							c.Value = num;			// restore value
							i = numericupdown_list.Count+1;
						}
						if(i == numericupdown_list.Count)
							MessageBox.Show("Control not found: "+name);	
					}
				}
				else if(s.StartsWith("rad"))
				{	// look through each control to find the matching name
					for(int i=0; i<radiobutton_list.Count; i++)
					{
						RadioButtonTS c = (RadioButtonTS)radiobutton_list[i];
						if(c.Name.Equals(name))		// name found
						{
							if(!val.ToLower().Equals("true") && !val.ToLower().Equals("false"))
								val = "True";
							c.Checked = bool.Parse(val);	// restore value
							i = radiobutton_list.Count+1;
						}
						if(i == radiobutton_list.Count)
							MessageBox.Show("Control not found: "+name);
					}
				}
				else if(s.StartsWith("txt"))
				{	// look through each control to find the matching name
					for(int i=0; i<textbox_list.Count; i++)
					{
						TextBoxTS c = (TextBoxTS)textbox_list[i];
						if(c.Name.Equals(name))		// name found
						{
							c.Text = val;	// restore value
							i = textbox_list.Count+1;
						}
						if(i == textbox_list.Count)
							MessageBox.Show("Control not found: "+name);
					}
				}
				else if(s.StartsWith("tb"))
				{
					// look through each control to find the matching name
					for(int i=0; i<trackbar_list.Count; i++)
					{
						TrackBarTS c = (TrackBarTS)trackbar_list[i];
						if(c.Name.Equals(name))		// name found
						{
							c.Value = Int32.Parse(val);
							i = trackbar_list.Count+1;
						}
						if(i == trackbar_list.Count)
							MessageBox.Show("Control not found: "+name);
					}
				}
				else if(s.StartsWith("clrbtn"))
				{
					string[] colors = val.Split('.');
					if(colors.Length == 4)
					{
						int R,G,B,A;
						R = Int32.Parse(colors[0]);
						G = Int32.Parse(colors[1]);
						B = Int32.Parse(colors[2]);
						A = Int32.Parse(colors[3]);

						for(int i=0; i<colorbutton_list.Count; i++)
						{
							ColorButton c = (ColorButton)colorbutton_list[i];
							if(c.Name.Equals(name))		// name found
							{
								c.Color = Color.FromArgb(A, R, G, B);
								i = colorbutton_list.Count+1;
							}
							if(i == colorbutton_list.Count)
								MessageBox.Show("Control not found: "+name);
						}
					}
				}
			}
		}

		private string KeyToString(Keys k)
		{
			string s = "";
			switch(k)
			{
				case Keys.OemOpenBrackets:
					s = "[";
					break;
				case Keys.OemCloseBrackets:
					s = "]";
					break;
			}
			return s;
		}

		private void SetupKeyMap()
		{
			KeyList.Add(Keys.None);
			KeyList.Add(Keys.A);
			KeyList.Add(Keys.B);
			KeyList.Add(Keys.C);
			KeyList.Add(Keys.D);
			KeyList.Add(Keys.E);
			KeyList.Add(Keys.F);
			KeyList.Add(Keys.G);
			KeyList.Add(Keys.H);
			KeyList.Add(Keys.I);
			KeyList.Add(Keys.J);
			KeyList.Add(Keys.K);
			KeyList.Add(Keys.L);
			KeyList.Add(Keys.M);
			KeyList.Add(Keys.N);
			KeyList.Add(Keys.O);
			KeyList.Add(Keys.P);
			KeyList.Add(Keys.Q);
			KeyList.Add(Keys.R);
			KeyList.Add(Keys.S);
			KeyList.Add(Keys.T);
			KeyList.Add(Keys.U);
			KeyList.Add(Keys.V);
			KeyList.Add(Keys.W);
			KeyList.Add(Keys.X);
			KeyList.Add(Keys.Y);
			KeyList.Add(Keys.Z);
			KeyList.Add(Keys.F1);
			KeyList.Add(Keys.F2);
			KeyList.Add(Keys.F3);
			KeyList.Add(Keys.F4);
			KeyList.Add(Keys.F5);
			KeyList.Add(Keys.F6);
			KeyList.Add(Keys.F7);
			KeyList.Add(Keys.F8);
			KeyList.Add(Keys.F9);
			KeyList.Add(Keys.F10);
			KeyList.Add(Keys.Insert);
			KeyList.Add(Keys.Delete);
			KeyList.Add(Keys.Home);
			KeyList.Add(Keys.End);
			KeyList.Add(Keys.PageUp);
			KeyList.Add(Keys.PageDown);
			KeyList.Add(Keys.Up);
			KeyList.Add(Keys.Down);
			KeyList.Add(Keys.Left);
			KeyList.Add(Keys.Right);
			KeyList.Add(Keys.OemOpenBrackets);
			KeyList.Add(Keys.OemCloseBrackets);
			//			KeyList.Add(Keys.OemSemicolon);
			//			KeyList.Add(Keys.OemQuotes);
			//			KeyList.Add(Keys.Oemcomma);
			//			KeyList.Add(Keys.OemPeriod);
			//			KeyList.Add(Keys.OemBackslash);
			//			KeyList.Add(Keys.OemQuestion);

			foreach(Control c in tpKeyboard.Controls)
			{
				if(c.GetType() == typeof(GroupBoxTS))
				{
					foreach(Control c2 in c.Controls)
					{
						if(c2.GetType() == typeof(ComboBoxTS))
						{
							ComboBoxTS combo = (ComboBoxTS)c2;
							combo.Items.Clear();
							foreach(Keys k in KeyList)
							{
								if(k.ToString().StartsWith("Oem"))
									combo.Items.Add(KeyToString(k));
								else
									combo.Items.Add(k.ToString());
							}
						}
					}
				}
				else if(c.GetType() == typeof(ComboBoxTS))
				{
					ComboBoxTS combo = (ComboBoxTS)c;
					combo.Items.Clear();
					foreach(Keys k in KeyList)
						combo.Items.Add(k.ToString());
				}
			}
		}

		private void UpdateMixerControls1()
		{
			if(comboAudioMixer1.SelectedIndex >= 0 &&
				comboAudioMixer1.Items.Count > 0)
			{
				int i = -1;

				i = Mixer.GetMux(comboAudioMixer1.SelectedIndex);
				if(i < 0 || i >= Mixer.MIXERR_BASE)
				{
					comboAudioReceive1.Enabled = false;
					comboAudioReceive1.Items.Clear();
					comboAudioTransmit1.Enabled = false;
					comboAudioTransmit1.Items.Clear();
				}
				else
				{
					comboAudioReceive1.Enabled = true;
					comboAudioTransmit1.Enabled = true;
					GetMuxLineNames1();
					for(int j=0; j<comboAudioReceive1.Items.Count; j++)
					{
						if(((string)comboAudioReceive1.Items[j]).StartsWith("Line"))
						{
							comboAudioReceive1.SelectedIndex = j;
							j = comboAudioReceive1.Items.Count;
						}							
					}

					if(comboAudioReceive1.SelectedIndex < 0)
					{
						for(int j=0; j<comboAudioReceive1.Items.Count; j++)
						{
							if(((string)comboAudioReceive1.Items[j]).StartsWith("Analog"))
							{
								comboAudioReceive1.SelectedIndex = j;
								j = comboAudioReceive1.Items.Count;
							}							
						}
					}

					for(int j=0; j<comboAudioTransmit1.Items.Count; j++)
					{
						if(((string)comboAudioTransmit1.Items[j]).StartsWith("Mic"))
						{
							comboAudioTransmit1.SelectedIndex = j;
							j = comboAudioTransmit1.Items.Count;
						}
					}
				}				
			}
		}

		private void UpdateMixerControls2()
		{
			if(comboAudioMixer2.SelectedIndex >= 0 &&
				comboAudioMixer2.Items.Count > 0)
			{
				int i = -1;

				i = Mixer.GetMux(comboAudioMixer2.SelectedIndex);
				if(i < 0 || i >= Mixer.MIXERR_BASE)
				{
					comboAudioReceive2.Enabled = false;
					comboAudioReceive2.Items.Clear();
					comboAudioTransmit2.Enabled = false;
					comboAudioTransmit2.Items.Clear();
					//console.NoMixer = true;
				}
				else
				{
					if(chkAudioEnableSoundCard2.Checked)
					{
						comboAudioReceive2.Enabled = true;
						comboAudioTransmit2.Enabled = true;
					}
					//console.NoMixer = false;
					GetMuxLineNames2();
					for(int j=0; j<comboAudioReceive2.Items.Count; j++)
					{
						if(((string)comboAudioReceive2.Items[j]).StartsWith("Line"))
						{
							comboAudioReceive2.SelectedIndex = j;
							j = comboAudioReceive2.Items.Count;
						}							
					}

					if(comboAudioReceive2.SelectedIndex < 0)
					{
						for(int j=0; j<comboAudioReceive2.Items.Count; j++)
						{
							if(((string)comboAudioReceive2.Items[j]).StartsWith("Analog"))
							{
								comboAudioReceive2.SelectedIndex = j;
								j = comboAudioReceive2.Items.Count;
							}							
						}
					}

					for(int j=0; j<comboAudioTransmit2.Items.Count; j++)
					{
						if(((string)comboAudioTransmit2.Items[j]).StartsWith("Mic"))
						{
							comboAudioTransmit2.SelectedIndex = j;
							j = comboAudioTransmit2.Items.Count;
						}
					}
				}				
			}
		}

		private void GetMixerDevices()
		{
			comboAudioMixer1.Items.Clear();
			comboAudioMixer2.Items.Clear();
			int num = Mixer.mixerGetNumDevs();
			for(int i=0; i<num; i++)
			{
				comboAudioMixer1.Items.Add(Mixer.GetDevName(i));
				comboAudioMixer2.Items.Add(Mixer.GetDevName(i));
			}
			comboAudioMixer1.Items.Add("None");
			comboAudioMixer2.Items.Add("None");
		}

		private void GetMuxLineNames1()
		{
			if(comboAudioMixer1.SelectedIndex >= 0 &&
				comboAudioMixer1.Items.Count > 0)
			{
				comboAudioReceive1.Items.Clear();
				comboAudioTransmit1.Items.Clear();

				ArrayList a;
				bool good = Mixer.GetMuxLineNames(comboAudioMixer1.SelectedIndex, out a);
				if(good)
				{					
					foreach(string s in a)
					{
						comboAudioReceive1.Items.Add(s);
						comboAudioTransmit1.Items.Add(s);
					}
				}
			}
		}

		private void GetMuxLineNames2()
		{
			if(comboAudioMixer2.SelectedIndex >= 0 &&
				comboAudioMixer2.Items.Count > 0)
			{
				comboAudioReceive2.Items.Clear();
				comboAudioTransmit2.Items.Clear();

				ArrayList a;
				bool good = Mixer.GetMuxLineNames(comboAudioMixer2.SelectedIndex, out a);
				if(good)
				{					
					foreach(string s in a)
					{
						comboAudioReceive2.Items.Add(s);
						comboAudioTransmit2.Items.Add(s);
					}
				}
			}
		}

		private void ForceAllEvents()
		{
			EventArgs e = EventArgs.Empty;

			// General Tab
			comboGeneralLPTAddr_SelectedIndexChanged(this, e);
			udGeneralLPTDelay_ValueChanged(this, e);
			chkGeneralRXOnly_CheckedChanged(this, e);
			chkGeneralUSBPresent_CheckedChanged(this, e);
			chkGeneralRFEPresent_CheckedChanged(this, e);
			chkGeneralPAPresent_CheckedChanged(this, e);
			chkGeneralATUPresent_CheckedChanged(this, e);
			chkXVTRPresent_CheckedChanged(this, e);
			comboGeneralXVTR_SelectedIndexChanged(this, e);
			udDDSCorrection_ValueChanged(this, e);
			udDDSPLLMult_ValueChanged(this, e);
			udDDSIFFreq_ValueChanged(this, e);
			chkGeneralSpurRed_CheckedChanged(this, e);
			chkGeneralDisablePTT_CheckedChanged(this, e);
			chkGeneralSoftwareGainCorr_CheckedChanged(this, e);
			chkGeneralEnableX2_CheckedChanged(this, e);
			udGeneralX2Delay_ValueChanged(this, e);
			chkGeneralCustomFilter_CheckedChanged(this, e);
			comboGeneralProcessPriority_SelectedIndexChanged(this, e);
			chkGeneralUpdateRelease_CheckedChanged(this, e);
			chkGeneralUpdateBeta_CheckedChanged(this, e);

			// Audio Tab
			comboAudioCard_SelectedIndexChanged(this, e);
			comboAudioDriver1_SelectedIndexChanged(this, e);
			comboAudioInput1_SelectedIndexChanged(this, e);
			comboAudioOutput1_SelectedIndexChanged(this, e);
			comboAudioMixer1_SelectedIndexChanged(this, e);
			comboAudioReceive1_SelectedIndexChanged(this, e);
			comboAudioTransmit1_SelectedIndexChanged(this, e);
			//			comboAudioDriver2_SelectedIndexChanged(this, e);
			//			comboAudioInput2_SelectedIndexChanged(this, e);
			//			comboAudioOutput2_SelectedIndexChanged(this, e);
			//			comboAudioMixer2_SelectedIndexChanged(this, e);
			//			comboAudioReceive2_SelectedIndexChanged(this, e);
			//			comboAudioTransmit2_SelectedIndexChanged(this, e);
			comboAudioBuffer1_SelectedIndexChanged(this, e);
			comboAudioBuffer2_SelectedIndexChanged(this, e);
			comboAudioSampleRate1_SelectedIndexChanged(this, e);
			comboAudioSampleRate2_SelectedIndexChanged(this, e);
			udAudioLatency1_ValueChanged(this, e);
			udAudioLatency2_ValueChanged(this, e);
			udAudioLineIn1_ValueChanged(this, e);
			udAudioLineIn2_ValueChanged(this, e);
			udAudioVoltage1_ValueChanged(this, e);
			udAudioVoltage2_ValueChanged(this, e);
			chkAudioEnableSoundCard2_CheckedChanged(this, e);
			comboAudioDetailSel_SelectedIndexChanged(this, e);
			chkAudioLatencyManual_CheckedChanged(this, e);

			// Display Tab
			udDisplayGridMax_ValueChanged(this, e);
			udDisplayGridMin_ValueChanged(this, e);
			udDisplayGridStep_ValueChanged(this, e);
			udDisplayFPS_ValueChanged(this, e);
			udDisplayMeterDelay_ValueChanged(this, e);
			udDisplayPeakText_ValueChanged(this, e);
			udDisplayCPUMeter_ValueChanged(this, e);
			udDisplayPhasePts_ValueChanged(this, e);
			udDisplayAVGTime_ValueChanged(this, e);
			udDisplayWaterfallLowLevel_ValueChanged(this, e);
			udDisplayWaterfallHighLevel_ValueChanged(this, e);
			clrbtnWaterfallLow_Changed(this, e);
			clrbtnWaterfallMid_Changed(this, e);
			clrbtnWaterfallHigh_Changed(this, e);
			udDisplayMultiPeakHoldTime_ValueChanged(this, e);
			udDisplayMultiTextHoldTime_ValueChanged(this, e);

			// DSP Tab
			udLMSANF_ValueChanged(this, e);
			udLMSNR_ValueChanged(this, e);
			udDSPImagePhaseRX_ValueChanged(this, e);
			udDSPImageGainRX_ValueChanged(this, e);
			udDSPImagePhaseTX_ValueChanged(this, e);
			udDSPImageGainTX_ValueChanged(this, e);
			udDSPAGCFixedGaindB_ValueChanged(this, e);
			udDSPAGCMaxGaindB_ValueChanged(this, e);
			udDSPCWPitch_ValueChanged(this, e);
			comboDSPWindow_SelectedIndexChanged(this, e);
			udDSPNB_ValueChanged(this, e);
			udDSPMNB_ValueChanged(this, e);

			// Transmit Tab
			tbTXEQ_Scroll(this, e);
			udTXFFCompression_ValueChanged(this, e);
			udTXFilterHigh_ValueChanged(this, e);
			udTXFilterLow_ValueChanged(this, e);
			udTransmitTunePower_ValueChanged(this, e);
			udTXPreamp_ValueChanged(this, e);
			udPAGain_ValueChanged(this, e);

			// Keyboard Tab
			comboKBTuneUp1_SelectedIndexChanged(this, e);
			comboKBTuneUp2_SelectedIndexChanged(this, e);
			comboKBTuneUp3_SelectedIndexChanged(this, e);
			comboKBTuneUp4_SelectedIndexChanged(this, e);
			comboKBTuneUp5_SelectedIndexChanged(this, e);
			comboKBTuneUp6_SelectedIndexChanged(this, e);
			comboKBTuneDown1_SelectedIndexChanged(this, e);
			comboKBTuneDown2_SelectedIndexChanged(this, e);
			comboKBTuneDown3_SelectedIndexChanged(this, e);
			comboKBTuneDown4_SelectedIndexChanged(this, e);
			comboKBTuneDown5_SelectedIndexChanged(this, e);
			comboKBTuneDown6_SelectedIndexChanged(this, e);
			comboKBBandUp_SelectedIndexChanged(this, e);
			comboKBBandDown_SelectedIndexChanged(this, e);
			comboKBFilterUp_SelectedIndexChanged(this, e);
			comboKBFilterDown_SelectedIndexChanged(this, e);
			comboKBModeUp_SelectedIndexChanged(this, e);
			comboKBModeDown_SelectedIndexChanged(this, e);
            
			// Appearance Tab
			clrbtnBtnSel_Changed(this, e);
			clrbtnVFODark_Changed(this, e);
			clrbtnVFOLight_Changed(this, e);
			clrbtnBandDark_Changed(this, e);
			clrbtnBandLight_Changed(this, e);
			clrbtnPeakText_Changed(this, e);
			clrbtnBackground_Changed(this, e);
			clrbtnGrid_Changed(this, e);
			clrbtnZeroLine_Changed(this, e);
			clrbtnFilter_Changed(this, e);
			clrbtnText_Changed(this, e);
			clrbtnDataLine_Changed(this, e);
			udDisplayLineWidth_ValueChanged(this, e);
			clrbtnMeterLeft_Changed(this, e);
			clrbtnMeterRight_Changed(this, e);
		}

		#endregion

		#region Properties

		private bool mox;
		public bool MOX
		{
			get { return mox; }
			set
			{
				mox = value;
				grpGeneralHardwareSetup.Enabled = !mox;
				tpAudio.Enabled = !mox;
				grpTestAudioBalance.Enabled = !mox;
				if(mox && !chkTestIMD.Focused || !mox && !chkGeneralRXOnly.Checked)
					grpTestTXIMD.Enabled = !mox;
			}
		}
			
		public int AudioReceiveMux1
		{
			get { return comboAudioReceive1.SelectedIndex; }
			set
			{
				comboAudioReceive1.SelectedIndex = value;
				comboAudioReceive1_SelectedIndexChanged(this, EventArgs.Empty);
			}
		}

		public bool RFEPresent
		{
			get { return chkGeneralRFEPresent.Checked; }
			set
			{
				chkGeneralRFEPresent.Checked = value;
			}
		}

		public bool USBPresent
		{
			get { return chkGeneralUSBPresent.Checked; }
			set
			{
				chkGeneralUSBPresent.Checked = value;
			}
		}

		public bool XVTRPresent
		{
			get { return chkGeneralXVTRPresent.Checked; }
			set
			{
				chkGeneralXVTRPresent.Checked = value;
			}
		}

		public int XVTRSelection
		{
			get { return comboGeneralXVTR.SelectedIndex; }
			set
			{
				comboGeneralXVTR.SelectedIndex = value;
			}
		}

		public bool PAPresent
		{
			get { return chkGeneralPAPresent.Checked; }
			set 
			{ 
				chkGeneralPAPresent.Checked = value;
			}
		}

		public bool ATUPresent
		{
			get { return chkGeneralATUPresent.Checked; }
			set
			{
				chkGeneralATUPresent.Checked = value;
			}
		}

		public bool SpurRedEnabled
		{
			get { return chkGeneralSpurRed.Enabled; }
			set
			{
				chkGeneralSpurRed.Enabled = value;
			}
		}

		public int PllMult
		{
			get { return (int)udDDSPLLMult.Value; }
			set
			{
				udDDSPLLMult.Value = value;
			}
		}

		public int ClockOffset
		{
			get { return (int)udDDSCorrection.Value; }
			set
			{
				udDDSCorrection.Value = value;
			}
		}

		public int SoundCardIndex
		{
			get { return comboAudioSoundCard.SelectedIndex; }
			set
			{
				comboAudioSoundCard.SelectedIndex = value;
			}
		}

		public double ImageGainRX
		{
			get { return (double)udDSPImageGainRX.Value; }
			set
			{
				udDSPImageGainRX.Value = (decimal)value;
			}
		}

		public double ImagePhaseRX
		{
			get { return (double)udDSPImagePhaseRX.Value; }
			set
			{
				udDSPImagePhaseRX.Value = (decimal)value;
			}
		}

		public double ImageGainTX
		{
			get { return (double)udDSPImageGainTX.Value; }
			set
			{
				udDSPImageGainTX.Value = (decimal)value;
			}
		}

		public double ImagePhaseTX
		{
			get { return (double)udDSPImagePhaseTX.Value; }
			set
			{
				udDSPImagePhaseTX.Value = (decimal)value;
			}
		}

		public float PAGain160
		{
			get { return (float)udPAGain160.Value; }
			set
			{
				udPAGain160.Value = (decimal)value;
			}
		}

		public float PAGain80
		{
			get { return (float)udPAGain80.Value; }
			set
			{
				udPAGain80.Value = (decimal)value;
			}
		}

		public float PAGain60
		{
			get { return (float)udPAGain60.Value; }
			set
			{
				udPAGain60.Value = (decimal)value;
			}
		}

		public float PAGain40
		{
			get { return (float)udPAGain40.Value; }
			set
			{
				udPAGain40.Value = (decimal)value;
			}
		}

		public float PAGain30
		{
			get { return (float)udPAGain30.Value; }
			set
			{
				udPAGain30.Value = (decimal)value;
			}
		}

		public float PAGain20
		{
			get { return (float)udPAGain20.Value; }
			set
			{
				udPAGain20.Value = (decimal)value;
			}
		}

		public float PAGain17
		{
			get { return (float)udPAGain17.Value; }
			set
			{
				udPAGain17.Value = (decimal)value;
			}
		}

		public float PAGain15
		{
			get { return (float)udPAGain15.Value; }
			set
			{
				udPAGain15.Value = (decimal)value;
			}
		}

		public float PAGain12
		{
			get { return (float)udPAGain12.Value; }
			set
			{
				udPAGain12.Value = (decimal)value;
			}
		}

		public float PAGain10
		{
			get { return (float)udPAGain10.Value; }
			set
			{
				udPAGain10.Value = (decimal)value;
			}
		}

		public float PAADC160
		{
			get { return (float)udPAADC160.Value; }
			set
			{
				udPAADC160.Value = (decimal)value;
			}
		}

		public float PAADC80
		{
			get { return (float)udPAADC80.Value; }
			set
			{
				udPAADC80.Value = (decimal)value;
			}
		}

		public float PAADC60
		{
			get { return (float)udPAADC60.Value; }
			set
			{
				udPAADC60.Value = (decimal)value;
			}
		}

		public float PAADC40
		{
			get { return (float)udPAADC40.Value; }
			set
			{
				udPAADC40.Value = (decimal)value;
			}
		}

		public float PAADC30
		{
			get { return (float)udPAADC30.Value; }
			set
			{
				udPAADC30.Value = (decimal)value;
			}
		}

		public float PAADC20
		{
			get { return (float)udPAADC20.Value; }
			set
			{
				udPAADC20.Value = (decimal)value;
			}
		}

		public float PAADC17
		{
			get { return (float)udPAADC17.Value; }
			set
			{
				udPAADC17.Value = (decimal)value;
			}
		}

		public float PAADC15
		{
			get { return (float)udPAADC15.Value; }
			set
			{
				udPAADC15.Value = (decimal)value;
			}
		}

		public float PAADC12
		{
			get { return (float)udPAADC12.Value; }
			set
			{
				udPAADC12.Value = (decimal)value;
			}
		}

		public float PAADC10
		{
			get { return (float)udPAADC10.Value; }
			set
			{
				udPAADC10.Value = (decimal)value;
			}
		}

		public int TunePower
		{
			get { return (int)udTXTunePower.Value; }
			set
			{
				udTXTunePower.Value = (decimal)value;
			}
		}

		#endregion

		#region General Tab Event Handlers
		// ======================================================
		// General Tab Event Handlers
		// ======================================================

		private void comboGeneralLPTAddr_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(comboGeneralLPTAddr.Text == "")
				return;
			console.hw.LPTAddr = Convert.ToUInt16(comboGeneralLPTAddr.Text, 16);
		}

		private void comboGeneralLPTAddr_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if(e.KeyData == Keys.Enter)
			{
				if(comboGeneralLPTAddr.Text.Length > 4)
				{
					MessageBox.Show("Invalid Parallel Port Address ("+comboGeneralLPTAddr.Text+")");
					comboGeneralLPTAddr.Text = "378";
					return;
				}

				foreach(Char c in comboGeneralLPTAddr.Text)
				{
					if(!Char.IsDigit(c) &&
						Char.ToLower(c) < 'a' &&
						Char.ToLower(c) > 'f')
					{
						MessageBox.Show("Invalid Parallel Port Address ("+comboGeneralLPTAddr.Text+")");
						comboGeneralLPTAddr.Text = "378";
						return;
					}
				}

				console.hw.LPTAddr = Convert.ToUInt16(comboGeneralLPTAddr.Text, 16);
			}
					
		}

		private void comboGeneralLPTAddr_LostFocus(object sender, System.EventArgs e)
		{
			comboGeneralLPTAddr_KeyDown(sender, new KeyEventArgs(Keys.Enter));
		}
		
		private void chkGeneralRXOnly_CheckedChanged(object sender, System.EventArgs e)
		{
			console.RXOnly = chkGeneralRXOnly.Checked;
			tpTransmit.Enabled = !chkGeneralRXOnly.Checked;
			tpPowerAmplifier.Enabled = !chkGeneralRXOnly.Checked;
			grpTestTXIMD.Enabled = !chkGeneralRXOnly.Checked;
		}	

		private void chkGeneralRFEPresent_CheckedChanged(object sender, System.EventArgs e)
		{
			chkGeneralXVTRPresent.Visible = chkGeneralRFEPresent.Checked;
			chkGeneralPAPresent.Visible = chkGeneralRFEPresent.Checked;
			console.RFEPresent = chkGeneralRFEPresent.Checked;
			if(chkGeneralRFEPresent.Checked == false)
			{
				chkGeneralXVTRPresent.Checked = false;
				chkGeneralPAPresent.Checked = false;
			}

			if(chkGeneralUSBPresent.Checked)
			{
				chkGeneralUSBPresent.Checked = false;
				chkGeneralUSBPresent.Checked = true;
			}
		}

		private void chkGeneralPAPresent_CheckedChanged(object sender, System.EventArgs e)
		{
			console.PAPresent = chkGeneralPAPresent.Checked;
			chkGeneralATUPresent.Visible = chkGeneralPAPresent.Checked;
			grpPAGainByBand.Visible = chkGeneralPAPresent.Checked;

			if(!chkGeneralPAPresent.Checked)
				chkGeneralATUPresent.Checked = false;
			else if(console.PowerOn)
			{
				console.PowerOn = false;
				Thread.Sleep(100);
				console.PowerOn = true;
			}

			if(chkGeneralUSBPresent.Checked)
			{
				chkGeneralUSBPresent.Checked = false;
				chkGeneralUSBPresent.Checked = true;
			}
		}

		private void chkGeneralATUPresent_CheckedChanged(object sender, System.EventArgs e)
		{
			console.ATUPresent = chkGeneralATUPresent.Checked;
		}

		private void chkXVTRPresent_CheckedChanged(object sender, System.EventArgs e)
		{
			console.XVTRPresent = chkGeneralXVTRPresent.Checked;
			comboGeneralXVTR.Visible = chkGeneralXVTRPresent.Checked;
			if(comboGeneralXVTR.SelectedIndex == 0)
				comboGeneralXVTR_SelectedIndexChanged(this, EventArgs.Empty);
			else
				comboGeneralXVTR.SelectedIndex = 0;
		}

		private void chkGeneralSpurRed_CheckedChanged(object sender, System.EventArgs e)
		{
			console.SpurReduction = chkGeneralSpurRed.Checked;
		}

		private void udDDSCorrection_ValueChanged(object sender, System.EventArgs e)
		{
			console.DDSClockCorrection = (double)(udDDSCorrection.Value / 1000000);
		}

		private void udDDSPLLMult_ValueChanged(object sender, System.EventArgs e)
		{
			console.hw.PLLMult = (int)udDDSPLLMult.Value;
		}

		private void udDDSIFFreq_ValueChanged(object sender, System.EventArgs e)
		{
			console.IFFreq = (double)udDDSIFFreq.Value / 1000000;
		}

		private void btnGeneralCalFreqStart_Click(object sender, System.EventArgs e)
		{
			Thread t = new Thread(new ThreadStart(CalibrateFreq));
			t.Name = "Freq Calibration Thread";
			t.IsBackground = true;
			t.Priority = ThreadPriority.AboveNormal;
			t.Start();
		}

		private void btnGeneralCalLevelStart_Click(object sender, System.EventArgs e)
		{
			Thread t = new Thread(new ThreadStart(CalibrateLevel));
			t.Name = "Level Calibration Thread";
			t.IsBackground = true;
			t.Priority = ThreadPriority.AboveNormal;
			t.Start();
		}

		private void btnGeneralCalImageStart_Click(object sender, System.EventArgs e)
		{
			progress = new Progress("Calibrate Image Rejection");

			Thread t = new Thread(new ThreadStart(CalibrateImage));
			t.Name = "Image Calibration Thread";
			t.IsBackground = true;
			t.Priority = ThreadPriority.AboveNormal;
			t.Start();

			if(console.PowerOn)
				progress.Show();
		}

		private void CalibrateFreq()
		{
			bool done = console.CalibrateFreq((float)udGeneralCalFreq.Value);
			if(done) MessageBox.Show("Frequency Calibration complete.");
		}

		private void CalibrateLevel()
		{
			bool done = console.CalibrateLevel((float)udGeneralCalLevel.Value);
			if(done) MessageBox.Show("Level Calibration complete.");
		}

		private void CalibrateImage()
		{
			bool done = console.CalibrateImage((float)udGeneralCalFreq.Value, (float)udGeneralCalLevel.Value, progress);
			if(done) MessageBox.Show("Image Rejection Calibration complete.");
		}

		private void chkGeneralDisablePTT_CheckedChanged(object sender, System.EventArgs e)
		{
			console.DisablePTT = chkGeneralDisablePTT.Checked;
		}

		private void comboGeneralXVTR_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(comboGeneralXVTR.SelectedIndex == 0)			// Model DEMI144-28FRS (Negative Logic)
			{
				console.CurrentXVTRTRMode = XVTRTRMode.NEGATIVE;
			}
			else if(comboGeneralXVTR.SelectedIndex == 1)	// Model DEMI144-28 25W Model (Positive Logic)
			{
				console.CurrentXVTRTRMode = XVTRTRMode.POSITIVE;

				if(this.Focused)
				{
					MessageBox.Show("Transverter default selection is DEMI144-28FRS sold by FlexRadio Systems.\n"+
						"Do NOT use other selections without first consulting FlexRadio Systems.", "Warning");
				}
			}
			else if(comboGeneralXVTR.SelectedIndex == 2)
			{
				console.CurrentXVTRTRMode = XVTRTRMode.NONE;
			}
		}

		private void chkGeneralSoftwareGainCorr_CheckedChanged(object sender, System.EventArgs e)
		{
			console.NoHardwareOffset = chkGeneralSoftwareGainCorr.Checked;
		}

		private void chkGeneralEnableX2_CheckedChanged(object sender, System.EventArgs e)
		{
			console.X2Enabled = chkGeneralEnableX2.Checked;
			udGeneralX2Delay.Enabled = chkGeneralEnableX2.Checked;
		}

		private void udGeneralX2Delay_ValueChanged(object sender, System.EventArgs e)
		{
			console.X2Delay = (int)udGeneralX2Delay.Value;
		}

		private void comboGeneralProcessPriority_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Process p = Process.GetCurrentProcess();

			if(comboGeneralProcessPriority.SelectedIndex == 3 &&
				comboGeneralProcessPriority.Focused)
			{
				DialogResult dr = MessageBox.Show(
					"Setting the Process Priority to Realtime can cause the system to become unresponsive.\n"+
					"This setting is not recommended.\n"+
					"Are you sure you want to change to Realtime?",
					"Warning: Realtime Not Recommended",
					MessageBoxButtons.YesNo,
					MessageBoxIcon.Warning);
				if(dr == DialogResult.No)
				{
					switch(p.PriorityClass)
					{
						case ProcessPriorityClass.Normal:
							comboGeneralProcessPriority.SelectedIndex = 0;
							break;
						case ProcessPriorityClass.AboveNormal:
							comboGeneralProcessPriority.SelectedIndex = 1;
							break;
						case ProcessPriorityClass.High:
							comboGeneralProcessPriority.SelectedIndex = 2;
							break;
					}
					return;
				}
			}
			
			switch(comboGeneralProcessPriority.SelectedIndex)
			{
				case 0:	// normal
					p.PriorityClass = ProcessPriorityClass.Normal;
					break;
				case 1:
					p.PriorityClass = ProcessPriorityClass.AboveNormal;
					break;
				case 2:
					p.PriorityClass = ProcessPriorityClass.High;
					break;
				case 3:
					p.PriorityClass = ProcessPriorityClass.RealTime;
					break;
			}
		}

		private void chkGeneralCustomFilter_CheckedChanged(object sender, System.EventArgs e)
		{
			console.EnableLPF0 = chkGeneralCustomFilter.Checked;
		}

		private void chkGeneralUSBPresent_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				console.USBPresent = chkGeneralUSBPresent.Checked;
				if(chkGeneralUSBPresent.Checked)
				{
					if(!USB.Init(chkGeneralRFEPresent.Checked, chkGeneralPAPresent.Checked))
						chkGeneralUSBPresent.Checked = false;
				}
				else
					USB.Exit();
				
				if(console.PowerOn)
				{
					console.PowerOn = false;
					Thread.Sleep(100);
					console.PowerOn = true;
				}				
			}
			catch(Exception)
			{
				MessageBox.Show("A required DLL was not found (Sdr1kUsb.dll).  Please download the\n"+
					"installer from the FlexRadio private download page and try again.",
					"Error: Missing DLL",
					MessageBoxButtons.OK,
					MessageBoxIcon.Error);
				chkGeneralUSBPresent.Checked = false;
			}
		}

		private void chkGeneralUpdateRelease_CheckedChanged(object sender, System.EventArgs e)
		{
			console.NotifyOnRelease = chkGeneralUpdateRelease.Checked;
		}

		private void chkGeneralUpdateBeta_CheckedChanged(object sender, System.EventArgs e)
		{
			console.NotifyOnBeta = chkGeneralUpdateBeta.Checked;
		}

		#endregion

		#region Audio Tab Event Handlers
		// ======================================================
		// Audio Tab Event Handlers
		// ======================================================

		private void comboAudioDriver1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.AudioDriverIndex1 = ((PADeviceInfo)comboAudioDriver1.SelectedItem).Index;
			GetDevices1();
			if(comboAudioInput1.Items.Count != 0)
				comboAudioInput1.SelectedIndex = 0;
			if(comboAudioOutput1.Items.Count != 0)
				comboAudioOutput1.SelectedIndex = 0;
		}

		private void comboAudioInput1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.AudioInputIndex1 = comboAudioInput1.SelectedIndex;
			if(comboAudioInput1.SelectedIndex == 0 &&
				comboAudioDriver1.SelectedIndex < 2)
				comboAudioMixer1.SelectedIndex = 0;
			else
			{
				for(int i=0; i<comboAudioMixer1.Items.Count; i++)
				{
					string s = (string)comboAudioMixer1.Items[i];
					if(s.StartsWith(comboAudioInput1.Text.Substring(0, 5)))
						comboAudioMixer1.Text = s;
				}
				comboAudioMixer1.Text = comboAudioInput1.Text;
			}
		}

		private void comboAudioOutput1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(comboAudioDriver1.SelectedIndex < 2)				// MME, DS
				console.AudioOutputIndex1 = comboAudioOutput1.SelectedIndex + comboAudioInput1.Items.Count;
			else console.AudioOutputIndex1 = comboAudioOutput1.SelectedIndex;	// ASIO
		}

		private void comboAudioMixer1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateMixerControls1();
			console.MixerID1 = comboAudioMixer1.SelectedIndex;
		}	

		private void comboAudioReceive1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.MixerRXMuxID1 = comboAudioReceive1.SelectedIndex;
			if(!initializing && console.PowerOn)
				Mixer.SetMux(comboAudioMixer1.SelectedIndex, comboAudioReceive1.SelectedIndex);
		}

		private void comboAudioTransmit1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.MixerTXMuxID1 = comboAudioTransmit1.SelectedIndex;
		}

		private void chkAudioEnableSoundCard2_CheckedChanged(object sender, System.EventArgs e)
		{
			bool val = chkAudioEnableSoundCard2.Checked;
			console.SecondSoundCardEnabled = val;
			comboAudioDriver2.Enabled = val;
			comboAudioInput2.Enabled = val;
			comboAudioOutput2.Enabled = val;
			comboAudioMixer2.Enabled = val;
			comboAudioReceive2.Enabled = val;
			comboAudioTransmit2.Enabled = val;
			comboAudioBuffer2.Enabled = val;
			comboAudioDetailSel.Enabled = val;
			udAudioVoltage2.Enabled = val;
			btnAudioVoltTest2.Enabled = val;
			lblAudioLineIn2.Enabled = val;
			udAudioLineIn2.Enabled = val;
			btnAudioCalSecondSoundCard.Enabled = val;

			udAudioLatency2.Enabled = val && chkAudioLatencyManual.Checked;

			if(!val)
				comboAudioDetailSel.SelectedIndex = 0;
			else
			{
				if(comboAudioDriver2.SelectedIndex < 0 && 
					comboAudioDriver2.Items.Count > 0)
					comboAudioDriver2.SelectedIndex = 0;
				DttSP.TXVolume = 1.0;
			}

			if(console.PowerOn)
			{
				console.PowerOn = false;
				Thread.Sleep(100);
				console.PowerOn = true;
			}
		}

		private void comboAudioDriver2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.AudioDriverIndex2 = ((PADeviceInfo)comboAudioDriver2.SelectedItem).Index;
			GetDevices2();
			if(comboAudioInput2.Items.Count != 0)
				comboAudioInput2.SelectedIndex = 0;
			if(comboAudioOutput2.Items.Count != 0)
				comboAudioOutput2.SelectedIndex = 0;
		}

		private void comboAudioInput2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.AudioInputIndex2 = comboAudioInput2.SelectedIndex;
			if(comboAudioInput2.SelectedIndex == 0 &&
				comboAudioDriver2.SelectedIndex < 2)
				comboAudioMixer2.SelectedIndex = 0;
			else
			{
				for(int i=0; i<comboAudioMixer2.Items.Count; i++)
				{
					string s = (string)comboAudioMixer2.Items[i];
					if(s.StartsWith(comboAudioInput2.Text.Substring(0, 5)))
						comboAudioMixer2.Text = s;
				}
				comboAudioMixer2.Text = comboAudioInput2.Text;
			}
		}

		private void comboAudioOutput2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(comboAudioDriver2.SelectedIndex < 2)				// MME, DS
				console.AudioOutputIndex2 = comboAudioOutput2.SelectedIndex + comboAudioInput2.Items.Count;
			else console.AudioOutputIndex2 = comboAudioOutput2.SelectedIndex;	// ASIO
		}

		private void comboAudioReceive2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.MixerRXMuxID2 = comboAudioReceive2.SelectedIndex;
			if(!initializing && console.PowerOn)
				Mixer.SetMux(comboAudioMixer2.SelectedIndex, comboAudioReceive2.SelectedIndex);
		}

		private void comboAudioTransmit2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.MixerTXMuxID2 = comboAudioTransmit2.SelectedIndex;
		}

		private void comboAudioMixer2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateMixerControls2();
			console.MixerID2 = comboAudioMixer2.SelectedIndex;
			if(chkAudioEnableSoundCard2.Checked)
			{
				//Mixer.InitSoundCard2(comboAudioMixer2.SelectedIndex);
			}
		}

		private void comboAudioSampleRate1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.SampleRate1 = Int32.Parse(comboAudioSampleRate1.Text);
		}

		private void comboAudioSampleRate2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.SampleRate2 = Int32.Parse(comboAudioSampleRate2.Text);
		}
	
		private void comboAudioBuffer1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.BlockSize1 = Int32.Parse(comboAudioBuffer1.Text);
			if(console.PowerOn)
			{
				console.PowerOn = false;
				Thread.Sleep(100);
				DttSP.ResizeSDR(console.BlockSize1);
				console.PowerOn = true;
			} 
			else DttSP.ResizeSDR(console.BlockSize1);
		}

		private void comboAudioBuffer2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.BlockSize2 = Int32.Parse(comboAudioBuffer2.Text);
			if(console.PowerOn && chkAudioEnableSoundCard2.Checked)
			{
				console.PowerOn = false;
				Thread.Sleep(100);
				console.PowerOn = true;
			}
		}

		private void udAudioLatency1_ValueChanged(object sender, System.EventArgs e)
		{
			console.AudioLatency1 = (int)udAudioLatency1.Value;
			if(console.PowerOn)
			{
				console.PowerOn = false;
				Thread.Sleep(100);
				console.PowerOn = true;
			}
		}

		private void udAudioLatency2_ValueChanged(object sender, System.EventArgs e)
		{
			console.AudioLatency2 = (int)udAudioLatency2.Value;
			if(console.PowerOn)
			{
				console.PowerOn = false;
				Thread.Sleep(100);
				console.PowerOn = true;
			}
		}

		private void udAudioVoltage1_ValueChanged(object sender, System.EventArgs e)
		{
			if(udAudioVoltage1.Focused &&
				comboAudioSoundCard.SelectedIndex > 0 &&
				(SoundCard)comboAudioSoundCard.SelectedIndex != SoundCard.UNSUPPORTED_CARD)
			{
				DialogResult dr = MessageBox.Show("Are you sure you want to change the Max RMS Voltage for this \n"+
					"supported sound card?  The largest measured difference in supported cards \n"+
					"was 0.04 volts.",
					"Change Voltage?",
					MessageBoxButtons.YesNo,
					MessageBoxIcon.Warning);
				if(dr == DialogResult.No)
				{
					udAudioVoltage1.Value = (decimal)console.AudioVolts1;
					return;
				}
			}
			console.AudioVolts1 = (double)udAudioVoltage1.Value;
		}

		private void udAudioVoltage2_ValueChanged(object sender, System.EventArgs e)
		{
			console.AudioVolts2 = (double)udAudioVoltage2.Value;
		}

		private void udAudioLineIn1_ValueChanged(object sender, System.EventArgs e)
		{
			Mixer.SetLineInRecordVolume(comboAudioMixer1.SelectedIndex, (int)udAudioLineIn1.Value);
		}

		private void udAudioLineIn2_ValueChanged(object sender, System.EventArgs e)
		{
			Mixer.SetLineInRecordVolume(comboAudioMixer2.SelectedIndex, (int)udAudioLineIn2.Value);
		}

		private void chkAudioLatencyManual_CheckedChanged(object sender, System.EventArgs e)
		{
			udAudioLatency1.Enabled = chkAudioLatencyManual.Checked;
			if(chkAudioEnableSoundCard2.Checked)
				udAudioLatency2.Enabled = chkAudioLatencyManual.Checked;

			if(!chkAudioLatencyManual.Checked)
				console.AudioLatency1 = 0;

			if(console.PowerOn)
			{
				console.PowerOn = false;
				Thread.Sleep(100);
				console.PowerOn = true;
			}
		}

		private void btnAudioVoltTest1_Click(object sender, System.EventArgs e)
		{
			DialogResult dr = MessageBox.Show("Please disconnect the line out audio cable from the SDR-1000. \n" +
				"Failure to disconnect the output could result in damaging the amplifier. \n" +
				"Do you want to proceed with the Sound Card Output Test?",
				"Warning: Disconnect Line Out",
				MessageBoxButtons.YesNo,
				MessageBoxIcon.Warning);

			if(dr == DialogResult.No)
				return;

			sound_card = 1;

			progress = new Progress("Calibrate Sound Card");
			if(console.PowerOn)
				progress.Show();

			Thread t = new Thread(new ThreadStart(CalibrateSoundCard));
			t.Name = "Sound Card Calibration Thread";
			t.IsBackground = true;
			t.Priority = ThreadPriority.AboveNormal;
			t.Start();
		}

		private void btnAudioVoltTest2_Click(object sender, System.EventArgs e)
		{
			DialogResult dr = MessageBox.Show("Please disconnect the line out audio cable from the SDR-1000. \n" +
				"Failure to disconnect the output could result in damaging the amplifier. \n" +
				"Do you want to proceed with the Sound Card Output Test?",
				"Warning: Disconnect Line Out",
				MessageBoxButtons.YesNo,
				MessageBoxIcon.Warning);

			if(dr == DialogResult.No)
				return;

			sound_card = 2;

			progress = new Progress("Calibrate Sound Card");
			if(console.PowerOn)
				progress.Show();

			Thread t = new Thread(new ThreadStart(CalibrateSoundCard));
			t.Name = "Sound Card Calibration Thread";
			t.IsBackground = true;
			t.Priority = ThreadPriority.AboveNormal;
			t.Start();
		}

		private void CalibrateSoundCard()
		{
			bool done = console.CalibrateSoundCard(progress, sound_card);
			if(done) MessageBox.Show("Sound Card Calibration complete.");
		}

		private void btnAudioCalSecondSoundCard_Click(object sender, System.EventArgs e)
		{
			progress = new Progress("Calibrate Sound Card 2");
			if(console.PowerOn)
				progress.Show();

			Thread t = new Thread(new ThreadStart(CalibrateSecondSoundCard));
			t.Name = "Sound Card Calibration Thread";
			t.IsBackground = true;
			t.Priority = ThreadPriority.AboveNormal;
			t.Start();
		}

		private void CalibrateSecondSoundCard()
		{
			bool done = console.CalibrateSecondSoundCard(progress);
			if(done) MessageBox.Show("Sound Card Calibration complete.");
		}

		private void comboAudioCard_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			switch((SoundCard)comboAudioSoundCard.SelectedIndex)
			{
				case SoundCard.SANTA_CRUZ:
					if(comboAudioDriver1.Items.Contains("ASIO"))
						comboAudioDriver1.Text = "ASIO";

					if(comboAudioInput1.Items.Contains("Wuschel's ASIO4ALL"))
					{
						comboAudioInput1.Text = "Wuschel's ASIO4ALL";
						comboAudioOutput1.Text = "Wuschel's ASIO4ALL";
					}
					else if(comboAudioInput1.Items.Contains("ASIO4ALL v2"))
					{
						comboAudioInput1.Text = "ASIO4ALL v2";
						comboAudioOutput1.Text = "ASIO4ALL v2";
					}
					comboAudioMixer1.Text = "Santa Cruz(tm)";
					comboAudioReceive1.Text = "Line In";
					
					for(int i=0; i<comboAudioTransmit1.Items.Count; i++)
					{
						if(((string)comboAudioTransmit1.Items[i]).StartsWith("Mi"))
						{
							comboAudioTransmit1.SelectedIndex = i;
							break;
						}
					}

					grpAudioDetails1.Enabled = false;
					udAudioVoltage1.Value = 1.274M;
					udAudioLineIn1.Value = 20;

					if(comboAudioMixer1.SelectedIndex < 0 || 
						(string)comboAudioMixer1.SelectedItem != "Santa Cruz(tm)")
					{
						MessageBox.Show(comboAudioSoundCard.Text+" not found.\n "+
							"Please verify that this specific sound card is installed " +
							"and functioning and try again.  \nIf your sound card is not " +
							"a "+comboAudioSoundCard.Text+" and your card is not in the "+
							"list, use the Unsupported Card selection.  \nFor more support, "+
							"email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(!Mixer.InitSantaCruz(console.MixerID1))
					{
						MessageBox.Show("The "+comboAudioSoundCard.Text+" mixer initialization "+
							"failed.  Please install the latest drivers from www.turtlebeach.com " +
							" and try again.  For more support, email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Mixer Initialization Failed",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(comboAudioInput1.Text != "ASIO4ALL v2" &&
						comboAudioInput1.Text != "Wuschel's ASIO4ALL")
					{
						MessageBox.Show("ASIO4ALL driver not found.  Please visit " +
							"www.asio4all.com, download and install the driver, "+
							"and try again.  Alternatively, you can use the Unsupported "+
							"Card selection and setup the sound interface manually.  For "+
							"more support, email eric@flex-radio.com.",
							"ASIO4ALL Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else console.PowerEnabled = true;
					chkAudioEnableSoundCard2.Enabled = true;
					break;
				case SoundCard.AUDIGY:
				case SoundCard.AUDIGY_2:
					if(comboAudioDriver1.Items.Contains("ASIO"))
						comboAudioDriver1.Text = "ASIO";
					
					if(comboAudioInput1.Items.Contains("Wuschel's ASIO4ALL"))
					{
						comboAudioInput1.Text = "Wuschel's ASIO4ALL";
						comboAudioOutput1.Text = "Wuschel's ASIO4ALL";
					}
					else if(comboAudioInput1.Items.Contains("ASIO4ALL v2"))
					{
						comboAudioInput1.Text = "ASIO4ALL v2";
						comboAudioOutput1.Text = "ASIO4ALL v2";
					}
					
					udAudioVoltage1.Value = 2.23M;
					udAudioLineIn1.Value = 1;

					for(int i=0; i<comboAudioMixer1.Items.Count; i++)
					{
						if(((string)comboAudioMixer1.Items[i]).StartsWith("SB Audigy"))
						{
							comboAudioMixer1.SelectedIndex = i;
							break;
						}
					}

					for(int i=0; i<comboAudioReceive1.Items.Count; i++)
					{
						if(((string)comboAudioReceive1.Items[i]).StartsWith("Analog"))
						{
							comboAudioReceive1.SelectedIndex = i;
							break;
						}
					}

					if(comboAudioReceive1.SelectedIndex < 0 ||
						!comboAudioReceive1.Text.StartsWith("Analog"))
					{
						for(int i=0; i<comboAudioReceive1.Items.Count; i++)
						{
							if(((string)comboAudioReceive1.Items[i]).StartsWith("Mix ana"))
							{
								comboAudioReceive1.SelectedIndex = i;
								break;
							}
						}
					}

					for(int i=0; i<comboAudioTransmit1.Items.Count; i++)
					{
						if(((string)comboAudioTransmit1.Items[i]).StartsWith("Mi"))
						{
							comboAudioTransmit1.SelectedIndex = i;
							break;
						}
					}

					grpAudioDetails1.Enabled = false;

					if(comboAudioMixer1.SelectedIndex < 0 ||
						!((string)comboAudioMixer1.SelectedItem).StartsWith("SB Audigy"))
					{
						MessageBox.Show(comboAudioSoundCard.Text+" not found.\n "+
							"Please verify that this specific sound card is installed " +
							"and functioning and try again.  \nIf your sound card is not " +
							"a "+comboAudioSoundCard.Text+" and your card is not in the "+
							"list, use the Unsupported Card selection.  \nFor more support, "+
							"email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(!Mixer.InitAudigy2(console.MixerID1))
					{
						MessageBox.Show("The "+comboAudioSoundCard.Text+" mixer initialization "+
							"failed.  Please install the latest drivers from www.creativelabs.com " +
							" and try again.  For more support, email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Mixer Initialization Failed",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(comboAudioInput1.Text != "ASIO4ALL v2" &&
						comboAudioInput1.Text != "Wuschel's ASIO4ALL")
					{
						MessageBox.Show("ASIO4ALL driver not found.  Please visit " +
							"www.asio4all.com, download and install the driver, "+
							"and try again.  Alternatively, you can use the Unsupported "+
							"Card selection and setup the sound interface manually.  For "+
							"more support, email eric@flex-radio.com.",
							"ASIO4ALL Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else 
					{
						console.PowerEnabled = true;
						chkAudioEnableSoundCard2.Enabled = true;
					}
					break;
				case SoundCard.AUDIGY_2_ZS:
					if(comboAudioDriver1.Items.Contains("ASIO"))
						comboAudioDriver1.Text = "ASIO";
					
					if(comboAudioInput1.Items.Contains("Wuschel's ASIO4ALL"))
					{
						comboAudioInput1.Text = "Wuschel's ASIO4ALL";
						comboAudioOutput1.Text = "Wuschel's ASIO4ALL";
					}
					else if(comboAudioInput1.Items.Contains("ASIO4ALL v2"))
					{
						comboAudioInput1.Text = "ASIO4ALL v2";
						comboAudioOutput1.Text = "ASIO4ALL v2";
					}
					
					udAudioVoltage1.Value = 2.23M;
					udAudioLineIn1.Value = 1;

					for(int i=0; i<comboAudioMixer1.Items.Count; i++)
					{
						if(((string)comboAudioMixer1.Items[i]).StartsWith("SB Audigy"))
						{
							comboAudioMixer1.SelectedIndex = i;
							break;
						}
					}

					for(int i=0; i<comboAudioReceive1.Items.Count; i++)
					{
						if(((string)comboAudioReceive1.Items[i]).StartsWith("Analog"))
						{
							comboAudioReceive1.SelectedIndex = i;
							break;
						}
					}

					if(comboAudioReceive1.SelectedIndex < 0 ||
						!comboAudioReceive1.Text.StartsWith("Analog"))
					{
						for(int i=0; i<comboAudioReceive1.Items.Count; i++)
						{
							if(((string)comboAudioReceive1.Items[i]).StartsWith("Mix ana"))
							{
								comboAudioReceive1.SelectedIndex = i;
								break;
							}
						}
					}

					for(int i=0; i<comboAudioTransmit1.Items.Count; i++)
					{
						if(((string)comboAudioTransmit1.Items[i]).StartsWith("Mi"))
						{
							comboAudioTransmit1.SelectedIndex = i;
							break;
						}
					}
					
					grpAudioDetails1.Enabled = false;

					if(comboAudioMixer1.SelectedIndex < 0 || 
						!((string)comboAudioMixer1.SelectedItem).StartsWith("SB Audigy"))
					{
						MessageBox.Show(comboAudioSoundCard.Text+" not found.\n "+
							"Please verify that this specific sound card is installed " +
							"and functioning and try again.  \nIf your sound card is not " +
							"a "+comboAudioSoundCard.Text+" and your card is not in the "+
							"list, use the Unsupported Card selection.  \nFor more support, "+
							"email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(!Mixer.InitAudigy2ZS(console.MixerID1))
					{
						MessageBox.Show("The "+comboAudioSoundCard.Text+" mixer initialization "+
							"failed.  Please install the latest drivers from www.creativelabs.com " +
							" and try again.  For more support, email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Mixer Initialization Failed",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(comboAudioInput1.Text != "ASIO4ALL v2" &&
						comboAudioInput1.Text != "Wuschel's ASIO4ALL")
					{
						MessageBox.Show("ASIO4ALL driver not found.  Please visit " +
							"www.asio4all.com, download and install the driver, "+
							"and try again.  Alternatively, you can use the Unsupported "+
							"Card selection and setup the sound interface manually.  For "+
							"more support, email eric@flex-radio.com.",
							"ASIO4ALL Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else 
					{
						console.PowerEnabled = true;
						chkAudioEnableSoundCard2.Enabled = true;
					}
					break;
				case SoundCard.EXTIGY:
					if(comboAudioDriver1.Items.Contains("ASIO"))
						comboAudioDriver1.Text = "ASIO";
					
					if(comboAudioInput1.Items.Contains("Wuschel's ASIO4ALL"))
					{
						comboAudioInput1.Text = "Wuschel's ASIO4ALL";
						comboAudioOutput1.Text = "Wuschel's ASIO4ALL";
					}
					else if(comboAudioInput1.Items.Contains("ASIO4ALL v2"))
					{
						comboAudioInput1.Text = "ASIO4ALL v2";
						comboAudioOutput1.Text = "ASIO4ALL v2";
					}
					
					udAudioVoltage1.Value = 1.83M;
					udAudioLineIn1.Value = 20;

					for(int i=0; i<comboAudioMixer1.Items.Count; i++)
					{
						if(((string)comboAudioMixer1.Items[i]).StartsWith("Creative SB Extigy"))
						{
							comboAudioMixer1.SelectedIndex = i;
							break;
						}
					}

					comboAudioReceive1.Text = "Line In";
					comboAudioTransmit1.Text = "Microphone";
					grpAudioDetails1.Enabled = false;

					if(comboAudioMixer1.SelectedIndex < 0 ||
						(string)comboAudioMixer1.SelectedItem != "Creative SB Extigy")
					{
						MessageBox.Show(comboAudioSoundCard.Text+" not found.\n "+
							"Please verify that this specific sound card is installed " +
							"and functioning and try again.  \nIf your sound card is not " +
							"a "+comboAudioSoundCard.Text+" and your card is not in the "+
							"list, use the Unsupported Card selection.  \nFor more support, "+
							"email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(!Mixer.InitExtigy(console.MixerID1))
					{
						MessageBox.Show("The "+comboAudioSoundCard.Text+" mixer initialization "+
							"failed.  Please install the latest drivers from www.creativelabs.com " +
							" and try again.  For more support, email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Mixer Initialization Failed",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(comboAudioInput1.Text != "ASIO4ALL v2" &&
						comboAudioInput1.Text != "Wuschel's ASIO4ALL")
					{
						MessageBox.Show("ASIO4ALL driver not found.  Please visit " +
							"www.asio4all.com, download and install the driver, "+
							"and try again.  Alternatively, you can use the Unsupported "+
							"Card selection and setup the sound interface manually.  For "+
							"more support, email eric@flex-radio.com.",
							"ASIO4ALL Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else
					{
						console.PowerEnabled = true;
						chkAudioEnableSoundCard2.Enabled = true;
					}
					break;
				case SoundCard.MP3_PLUS:
					if(comboAudioDriver1.Items.Contains("ASIO"))
						comboAudioDriver1.Text = "ASIO";

					for(int i=0; i<comboAudioMixer1.Items.Count; i++)
					{
						if(((string)comboAudioMixer1.Items[i]).StartsWith("Sound Blaster"))
						{
							comboAudioMixer1.SelectedIndex = i;
							break;
						}
					}

					if(comboAudioMixer1.SelectedIndex < 0 ||
						(string)comboAudioMixer1.SelectedItem != "Sound Blaster")
					{
						for(int i=0; i<comboAudioMixer1.Items.Count; i++)
						{
							if(((string)comboAudioMixer1.Items[i]).StartsWith("USB Audio"))
							{
								comboAudioMixer1.SelectedIndex = i;
								break;
							}
						}
					}

					if(comboAudioInput1.Items.Contains("Wuschel's ASIO4ALL"))
					{
						comboAudioInput1.Text = "Wuschel's ASIO4ALL";
						comboAudioOutput1.Text = "Wuschel's ASIO4ALL";
					}
					else if(comboAudioInput1.Items.Contains("ASIO4ALL v2") && 
						(string)comboAudioMixer1.SelectedItem == "USB Audio")
					{
						comboAudioInput1.Text = "ASIO4ALL v2";
						comboAudioOutput1.Text = "ASIO4ALL v2";
					}
					

					udAudioVoltage1.Value = 0.982M;
					udAudioLineIn1.Value = 6;

					comboAudioReceive1.Text = "Line In";
					
					for(int i=0; i<comboAudioTransmit1.Items.Count; i++)
					{
						if(((string)comboAudioTransmit1.Items[i]).StartsWith("Mi"))
						{
							comboAudioTransmit1.SelectedIndex = i;
							break;
						}
					}

					grpAudioDetails1.Enabled = false;

					if(comboAudioMixer1.SelectedIndex < 0 ||
						((string)comboAudioMixer1.SelectedItem != "Sound Blaster" &&
						(string)comboAudioMixer1.SelectedItem != "USB Audio"))
					{
						MessageBox.Show(comboAudioSoundCard.Text+" not found.\n "+
							"Please verify that this specific sound card is installed " +
							"and functioning and try again.  \nIf your sound card is not " +
							"a "+comboAudioSoundCard.Text+" and your card is not in the "+
							"list, use the Unsupported Card selection.  \nFor more support, "+
							"email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(!Mixer.InitMP3Plus(console.MixerID1))
					{
						MessageBox.Show("The "+comboAudioSoundCard.Text+" mixer initialization "+
							"failed.  Please install the latest drivers from www.creativelabs.com " +
							" and try again.  For more support, email eric@flex-radio.com.",
							comboAudioSoundCard.Text+" Mixer Initialization Failed",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else if(comboAudioInput1.Text != "ASIO4ALL v2" &&
						comboAudioInput1.Text != "Wuschel's ASIO4ALL")
					{
						MessageBox.Show("ASIO4ALL driver not found.  Please visit " +
							"www.asio4all.com, download and install the driver, "+
							"and try again.  Alternatively, you can use the Unsupported "+
							"Card selection and setup the sound interface manually.  For "+
							"more support, email eric@flex-radio.com.",
							"ASIO4ALL Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else 
					{
						console.PowerEnabled = true;
						chkAudioEnableSoundCard2.Enabled = true;
					}
					break;
				case SoundCard.DELTA_44:
					if(comboAudioDriver1.Items.Contains("ASIO"))
						comboAudioDriver1.Text = "ASIO";

					if(comboAudioInput1.Items.Contains("M-Audio Delta ASIO"))
					{
						comboAudioInput1.Text = "M-Audio Delta ASIO";
						comboAudioOutput1.Text = "M-Audio Delta ASIO";
					}
					
					comboAudioMixer1.Text = "None";

					grpAudioDetails1.Enabled = false;
					udAudioVoltage1.Value = 0.98M;

					if(comboAudioInput1.Text != "M-Audio Delta ASIO")
					{
						MessageBox.Show("M-Audio Delta ASIO driver not found.  Please visit " +
							"www.m-audio.com, download and install the latest driver, "+
							"and try again.  For more support, email eric@flex-radio.com.",
							"Delta 44 Driver Not Found",
							MessageBoxButtons.OK,
							MessageBoxIcon.Exclamation);
						console.PowerEnabled = false;
					}
					else 
					{
						chkAudioEnableSoundCard2.Enabled = false;
						console.PowerEnabled = true;
						DttSP.TXVolume = 1.0;
						DttSP.RXVolume = 1.0;
					}
					break;
				case SoundCard.UNSUPPORTED_CARD:
					grpAudioDetails1.Enabled = true;
					chkAudioEnableSoundCard2.Enabled = true;
					console.PowerEnabled = true;
					break;
			}

			console.PWR = console.PWR;
			console.AF = console.AF;
		}

		#endregion

		#region Display Tab Event Handlers
		// ======================================================
		// Display Tab Event Handlers
		// ======================================================

		private void udDisplayGridMax_LostFocus(object sender, System.EventArgs e)
		{
			console.SpectrumGridMax = (int)udDisplayGridMax.Value;
		}

		private void udDisplayGridMax_Click(object sender, System.EventArgs e)
		{
			udDisplayGridMax_LostFocus(sender, e);
		}

		private void udDisplayGridMax_MouseWheel(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			udDisplayGridMax_LostFocus(sender, new System.EventArgs());
		}

		private void udDisplayFPS_ValueChanged(object sender, System.EventArgs e)
		{
			console.DisplayFPS = (int)udDisplayFPS.Value;
		}

		private void udDisplayGridMax_ValueChanged(object sender, System.EventArgs e)
		{
			if(udDisplayGridMax.Value <= udDisplayGridMin.Value)
				udDisplayGridMax.Value = udDisplayGridMin.Value + 10;
			console.SpectrumGridMax = (int)udDisplayGridMax.Value;
		}

		private void udDisplayGridMin_ValueChanged(object sender, System.EventArgs e)
		{
			if(udDisplayGridMin.Value >= udDisplayGridMax.Value)
				udDisplayGridMin.Value = udDisplayGridMax.Value - 10;
			console.SpectrumGridMin = (int)udDisplayGridMin.Value;
		}

		private void udDisplayGridStep_ValueChanged(object sender, System.EventArgs e)
		{
			console.SpectrumGridStep = (int)udDisplayGridStep.Value;
		}

		private void comboDisplaydBAlign_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			switch(comboDisplaydBAlign.Text)
			{
				case "Left":
					console.SpectrumdBAlign = HorizontalAlignment.Left;
					break;
				case "Cntr":
					console.SpectrumdBAlign = HorizontalAlignment.Center;
					break;
				case "Right":
					console.SpectrumdBAlign = HorizontalAlignment.Right;
					break;
				default:
					console.SpectrumdBAlign = HorizontalAlignment.Center;
					break;
			}
		}

		private void udDisplayPhasePts_ValueChanged(object sender, System.EventArgs e)
		{
			console.PhaseNumPts = (int)udDisplayPhasePts.Value;
		}

		private void udDisplayAVGTime_ValueChanged(object sender, System.EventArgs e)
		{
			double buffer_time = 2048.0 / (double)console.SampleRate1;
			int buffersToAvg = (int)((float)udDisplayAVGTime.Value * 0.001 / buffer_time);
			buffersToAvg = Math.Max(2, buffersToAvg);
			console.AverageSamples = buffersToAvg;
		}

		private void udDisplayMeterDelay_ValueChanged(object sender, System.EventArgs e)
		{
			console.MeterDelay = (int)udDisplayMeterDelay.Value;
		}

		private void udDisplayPeakText_ValueChanged(object sender, System.EventArgs e)
		{
			console.PeakTextDelay = (int)udDisplayPeakText.Value;
		}

		private void udDisplayCPUMeter_ValueChanged(object sender, System.EventArgs e)
		{
			console.CPUMeterDelay = (int)udDisplayCPUMeter.Value;
		}

		private void clrbtnWaterfallLow_Changed(object sender, System.EventArgs e)
		{
			console.WaterfallLowColor = clrbtnWaterfallLow.Color;
		}

		private void clrbtnWaterfallHigh_Changed(object sender, System.EventArgs e)
		{
			console.WaterfallHighColor = clrbtnWaterfallHigh.Color;
		}

		private void clrbtnWaterfallMid_Changed(object sender, System.EventArgs e)
		{
			console.WaterfallMidColor = clrbtnWaterfallMid.Color;
		}

		private void udDisplayWaterfallLowLevel_ValueChanged(object sender, System.EventArgs e)
		{
			console.WaterfallLowThreshold = (float)udDisplayWaterfallLowLevel.Value;
		}

		private void udDisplayWaterfallHighLevel_ValueChanged(object sender, System.EventArgs e)
		{
			console.WaterfallHighThreshold = (float)udDisplayWaterfallHighLevel.Value;
		}

		private void udDisplayMultiPeakHoldTime_ValueChanged(object sender, System.EventArgs e)
		{
			console.MultimeterPeakHoldTime = (int)udDisplayMultiPeakHoldTime.Value;
		}

		private void udDisplayMultiTextHoldTime_ValueChanged(object sender, System.EventArgs e)
		{
			console.MultimeterTextPeakTime = (int)udDisplayMultiTextHoldTime.Value;
		}

		#endregion

		#region DSP Tab Event Handlers
		// ======================================================
		// DSP Tab Event Handlers
		// ======================================================

		private void udDSPCWPitch_ValueChanged(object sender, System.EventArgs e)
		{
			console.CWPitch = (int)udDSPCWPitch.Value;
		}

		private void comboImageReject_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(comboImageReject.SelectedIndex >= 0)
			{
				if(comboImageReject.Text == "RX")
				{
					grpDSPImageRejectRX.Visible = true;
					grpDSPImageRejectTX.Visible = false;
				}
				else if(comboImageReject.Text == "TX")
				{
					grpDSPImageRejectRX.Visible = false;
					grpDSPImageRejectTX.Visible = true;
				}
			}
		}

		private void tbDSPImagePhaseRX_Scroll(object sender, System.EventArgs e)
		{
			udDSPImagePhaseRX.Value = tbDSPImagePhaseRX.Value;
		}

		private void udDSPImagePhaseRX_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeIQphase((double)udDSPImagePhaseRX.Value);
			if(tbDSPImagePhaseRX.Value != (int)udDSPImagePhaseRX.Value)
				tbDSPImagePhaseRX.Value = (int)udDSPImagePhaseRX.Value;
		}

		private void tbDSPImageGainRX_Scroll(object sender, System.EventArgs e)
		{
			udDSPImageGainRX.Value = tbDSPImageGainRX.Value;
		}

		private void udDSPImageGainRX_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeIQgain((double)udDSPImageGainRX.Value);
			if(tbDSPImageGainRX.Value != (int)udDSPImageGainRX.Value)
				tbDSPImageGainRX.Value = (int)udDSPImageGainRX.Value;
		}





		private void udDSPImagePhaseTX_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeTXIQphase((double)udDSPImagePhaseTX.Value);
			if(tbDSPImagePhaseTX.Value != (int)udDSPImagePhaseTX.Value)
				tbDSPImagePhaseTX.Value = (int)udDSPImagePhaseTX.Value;
		
		}

		private void tbDSPImagePhaseTX_Scroll(object sender, System.EventArgs e)
		{
			udDSPImagePhaseTX.Value = tbDSPImagePhaseTX.Value;
		
		}

		private void udDSPImageGainTX_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeTXIQgain((double)udDSPImageGainTX.Value);
			if(tbDSPImageGainTX.Value != (int)udDSPImageGainTX.Value)
				tbDSPImageGainTX.Value = (int)udDSPImageGainTX.Value;
		
		}

		private void tbDSPImageGainTX_Scroll(object sender, System.EventArgs e)
		{
			udDSPImageGainTX.Value = tbDSPImageGainTX.Value;
		}
		
		private void udLMSANF_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeANFvals((int)udLMSANFtaps.Value,(int)udLMSANFdelay.Value,
				0.00001*(double)udLMSANFgain.Value,0.00005);
		}

		private void udLMSNR_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeNRvals((int)udLMSNRtaps.Value,(int)udLMSNRdelay.Value,
				0.00001*(double)udLMSNRgain.Value,0.00005);
		}

		private void udDSPNB_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeNBvals(0.165*(double)(udDSPNB.Value));
		}

		private void comboDSPWindow_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			DttSP.CurrentWindow = (DttSP.Window)comboDSPWindow.SelectedIndex;
		}

		private void udDSPAGCFixedGaindB_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeFixedAGC((double)udDSPAGCFixedGaindB.Value);
		}

		private void udDSPAGCMaxGaindB_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeAGCMaxGain((double)udDSPAGCMaxGaindB.Value);
		}

		#endregion

		#region Transmit Tab Event Handlers

		public void UpdateEQ()
		{
			if(chkTXEQEnabled.Checked)
				tbTXEQ_Scroll(this, EventArgs.Empty);
		}

		private void tbTXEQ_Scroll(object sender, System.EventArgs e)
		{
			if(chkTXEQEnabled.Checked)
			{
				int[] txeq = new int[12];
				txeq[0] = tbTXEQ80.Value;
				txeq[1] = tbTXEQ160.Value;
				txeq[2] = tbTXEQ300.Value;
				txeq[3] = tbTXEQ600.Value;
				txeq[4] = tbTXEQ1000.Value;
				txeq[5] = tbTXEQ1300.Value;
				txeq[6] = tbTXEQ1600.Value;
				txeq[7] = tbTXEQ2000.Value;
				txeq[8] = tbTXEQ2300.Value;
				txeq[9] = tbTXEQ2600.Value;
				txeq[10] = tbTXEQ3000.Value;
				txeq[11] = tbTXEQ3500.Value;

				DttSP.SetTXEQ(txeq);
			}
		}

		private void udTXFilterHigh_ValueChanged(object sender, System.EventArgs e)
		{
			if(udTXFilterHigh.Focused &&
				udTXFilterHigh.Value > 3000 && console.TXFilterHigh <= 3000)
			{
				MessageBox.Show("The transmit bandwidth is being increased beyond 3KHz.\n\n"+
					"As the control operator, you are responsible for compliance with current "+
					"rules and good operating practice.",
					"Warning: Transmit Bandwidth",
					MessageBoxButtons.OK,
					MessageBoxIcon.Warning);
			}
			console.TXFilterHigh = (int)udTXFilterHigh.Value;
			if(chkTXEQEnabled.Checked) 
				tbTXEQ_Scroll(this, EventArgs.Empty);
		}

		private void udTXFilterLow_ValueChanged(object sender, System.EventArgs e)
		{
			console.TXFilterLow = (int)udTXFilterLow.Value;
			if(chkTXEQEnabled.Checked) 
				tbTXEQ_Scroll(this, EventArgs.Empty);
		}

		private void tbTXFFCompression_Scroll(object sender, System.EventArgs e)
		{
			DttSP.ChangeTXAGCFFCompression((double)tbTXFFCompression.Value);
			udTXFFCompression.Value = tbTXFFCompression.Value;
		}

		private void udTXFFCompression_ValueChanged(object sender, System.EventArgs e)
		{
			tbTXFFCompression.Value = (int)udTXFFCompression.Value;
			tbTXFFCompression_Scroll(this, EventArgs.Empty);
		}

		private void chkTXEQEnabled_CheckedChanged(object sender, System.EventArgs e)
		{
			if(chkTXEQEnabled.Checked)
			{
				tbTXEQ_Scroll(this, EventArgs.Empty);
			}
			else
			{
				int[] eq = new int[12];
				for(int i=0; i<12; i++)
					eq[i] = 0;

				DttSP.SetTXEQ(eq);
			}
		}

		private void btnTXEQReset_Click(object sender, System.EventArgs e)
		{
			tbTXEQ80.Value = 0;
			tbTXEQ160.Value = 0;
			tbTXEQ300.Value = 0;
			tbTXEQ600.Value = 0;
			tbTXEQ1000.Value = 0;
			tbTXEQ1300.Value = 0;
			tbTXEQ1600.Value = 0;
			tbTXEQ2000.Value = 0;
			tbTXEQ2300.Value = 0;
			tbTXEQ2600.Value = 0;
			tbTXEQ3000.Value = 0;
			tbTXEQ3500.Value = 0;

			tbTXEQ_Scroll(this, EventArgs.Empty);
		}

		private void udTransmitTunePower_ValueChanged(object sender, System.EventArgs e)
		{
			console.TunePower = (int)udTXTunePower.Value;
		}

		private void udTXPreamp_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.SetTXPreGain((double)udTXPreGain.Value);
		}

		#endregion

		#region PA Settings Tab Event Handlers

		private void btnPAGainCalibration_Click(object sender, System.EventArgs e)
		{
			DialogResult dr = MessageBox.Show("Is a 50 Ohm dummy load connected to the amplifier?\n" +
				"Failure to use a dummy load with this routine could cause damage to the amplifier.",
				"Warning: Is dummy load connected?",
				MessageBoxButtons.YesNo,
				MessageBoxIcon.Warning);

			if(dr == DialogResult.No)
				return;

			progress = new Progress("Calibrate PA Gain");

			Thread t = new Thread(new ThreadStart(CalibratePAGain));
			t.Name = "PA Gain Calibration Thread";
			t.IsBackground = true;
			t.Priority = ThreadPriority.AboveNormal;
			t.Start();

			if(console.PowerOn)
				progress.Show();
		}

		private void CalibratePAGain()
		{
			bool[] run = new bool[10];
			for(int i=0; i<10; i++) run[i] = true;
			bool done = console.CalibratePAGain(progress, run, (int)udPACalPower.Value);
			if(done) MessageBox.Show("PA Gain Calibration complete.");
		}

		private void udPAGain_ValueChanged(object sender, System.EventArgs e)
		{
			console.PWR = console.PWR;
		}

		private void btnPAGainReset_Click(object sender, System.EventArgs e)
		{
			udPAGain160.Value = 48.0M;
			udPAGain80.Value = 48.0M;
			udPAGain60.Value = 48.0M;
			udPAGain40.Value = 48.0M;
			udPAGain30.Value = 48.0M;
			udPAGain20.Value = 48.0M;
			udPAGain17.Value = 48.0M;
			udPAGain15.Value = 48.0M;
			udPAGain12.Value = 48.0M;
			udPAGain10.Value = 48.0M;
		}

		#endregion

		#region Appearance Tab Event Handlers

		private void clrbtnBackground_Changed(object sender, System.EventArgs e)
		{
			console.DisplayBackgroundColor = clrbtnBackground.Color;
		}

		private void clrbtnGrid_Changed(object sender, System.EventArgs e)
		{
			console.GridColor = clrbtnGrid.Color;
		}

		private void clrbtnZeroLine_Changed(object sender, System.EventArgs e)
		{
			console.GridZeroColor = clrbtnZeroLine.Color;
		}

		private void clrbtnText_Changed(object sender, System.EventArgs e)
		{
			console.GridTextColor = clrbtnText.Color;
		}

		private void clrbtnDataLine_Changed(object sender, System.EventArgs e)
		{
			console.DataLineColor = clrbtnDataLine.Color;
		}

		private void clrbtnFilter_Changed(object sender, System.EventArgs e)
		{
			console.DisplayFilterColor = clrbtnFilter.Color;
		}

		private void udDisplayLineWidth_ValueChanged(object sender, System.EventArgs e)
		{
			console.DisplayLineWidth = (float)udDisplayLineWidth.Value;
		}

		private void clrbtnMeterLeft_Changed(object sender, System.EventArgs e)
		{
			console.MeterLeftColor = clrbtnMeterLeft.Color;
		}

		private void clrbtnMeterRight_Changed(object sender, System.EventArgs e)
		{
			console.MeterRightColor = clrbtnMeterRight.Color;
		}

		private void clrbtnBtnSel_Changed(object sender, System.EventArgs e)
		{
			console.ButtonSelectedColor = clrbtnBtnSel.Color;
		}

		private void clrbtnVFODark_Changed(object sender, System.EventArgs e)
		{
			console.VFOTextDarkColor = clrbtnVFODark.Color;
		}

		private void clrbtnVFOLight_Changed(object sender, System.EventArgs e)
		{
			console.VFOTextLightColor = clrbtnVFOLight.Color;
		}

		private void clrbtnBandDark_Changed(object sender, System.EventArgs e)
		{
			console.BandTextDarkColor = clrbtnBandDark.Color;
		}

		private void clrbtnBandLight_Changed(object sender, System.EventArgs e)
		{
			console.BandTextLightColor = clrbtnBandLight.Color;
		}

		private void clrbtnPeakText_Changed(object sender, System.EventArgs e)
		{
			console.PeakTextColor = clrbtnPeakText.Color;
		}

		#endregion

		#region Keyboard Tab Event Handlers

		private void comboKBTuneUp1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneUp1 = (Keys)KeyList[comboKBTuneUp1.SelectedIndex];
		}

		private void comboKBTuneDown1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneDown1 = (Keys)KeyList[comboKBTuneDown1.SelectedIndex];
		}

		private void comboKBTuneUp2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneUp2 = (Keys)KeyList[comboKBTuneUp2.SelectedIndex];
		}

		private void comboKBTuneDown2_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneDown2 = (Keys)KeyList[comboKBTuneDown2.SelectedIndex];
		}

		private void comboKBTuneUp3_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneUp3 = (Keys)KeyList[comboKBTuneUp3.SelectedIndex];
		}

		private void comboKBTuneDown3_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneDown3 = (Keys)KeyList[comboKBTuneDown3.SelectedIndex];
		}

		private void comboKBTuneUp4_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneUp4 = (Keys)KeyList[comboKBTuneUp4.SelectedIndex];
		}

		private void comboKBTuneDown4_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneDown4 = (Keys)KeyList[comboKBTuneDown4.SelectedIndex];
		}

		private void comboKBTuneUp5_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneUp5 = (Keys)KeyList[comboKBTuneUp5.SelectedIndex];
		}

		private void comboKBTuneDown5_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneDown5 = (Keys)KeyList[comboKBTuneDown5.SelectedIndex];
		}

		private void comboKBTuneUp6_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneUp6 = (Keys)KeyList[comboKBTuneUp6.SelectedIndex];
		}

		private void comboKBTuneDown6_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneDown6 = (Keys)KeyList[comboKBTuneDown6.SelectedIndex];
		}

		private void comboKBTuneUp7_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneUp7 = (Keys)KeyList[comboKBTuneUp7.SelectedIndex];
		}

		private void comboKBTuneDown7_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyTuneDown7 = (Keys)KeyList[comboKBTuneDown7.SelectedIndex];
		}

		private void comboKBBandUp_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyBandUp = (Keys)KeyList[comboKBBandUp.SelectedIndex];
		}

		private void comboKBBandDown_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyBandDown = (Keys)KeyList[comboKBBandDown.SelectedIndex];
		}

		private void comboKBFilterUp_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyFilterUp = (Keys)KeyList[comboKBFilterUp.SelectedIndex];
		}

		private void comboKBFilterDown_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyFilterDown = (Keys)KeyList[comboKBFilterDown.SelectedIndex];
		}

		private void comboKBModeUp_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyModeUp = (Keys)KeyList[comboKBModeUp.SelectedIndex];
		}

		private void comboKBModeDown_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyModeDown = (Keys)KeyList[comboKBModeDown.SelectedIndex];
		}

		private void comboKBCWDot_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyCWDot = (Keys)KeyList[comboKBCWDot.SelectedIndex];
		}

		private void comboKBCWDash_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyCWDash = (Keys)KeyList[comboKBCWDash.SelectedIndex];
		}

		private void comboKBRITUp_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyRITUp = (Keys)KeyList[comboKBRITUp.SelectedIndex];
		}

		private void comboKBRITDown_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyRITDown = (Keys)KeyList[comboKBRITDown.SelectedIndex];
		}

		private void comboKBXITUp_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyXITUp = (Keys)KeyList[comboKBXITUp.SelectedIndex];
		}

		private void comboKBXITDown_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			console.KeyXITDown = (Keys)KeyList[comboKBXITDown.SelectedIndex];
		}

		#endregion

		#region CAT Setup event handlers 

		public void initCATandPTTprops() 
		{ 
			console.CATEnabled = chkCATEnable.Checked;
			console.CATPort = (int)udCATPort.Value;		
			console.CATPTTRTS = chkCATPTT_RTS.Checked; 
			console.CATPTTDTR = chkCATPTT_DTR.Checked; 
			console.PTTBitBangEnabled = chkCATBitBangPTT.Checked; 
			console.PTTBitBangPort = (int)udCATBitBangPTTPort.Value; 
			console.CATBaudRate = Convert.ToInt32((string)comboCATbaud.SelectedItem, 10); 
			console.CATParity = SDRSerialPort.stringToParity((string)comboCATparity.SelectedItem);
			console.CATDataBits = SDRSerialPort.stringToDataBits((string)comboCATdatabits.SelectedItem); 
			console.CATStopBits = SDRSerialPort.stringToStopBits((string)comboCATstopbits.SelectedItem); 
			console.CATisMixWVirtPort = chkCATMixWVirtual.Checked;

			// make sure the enabled state of bitbang ptt is correct 
			if ( chkCATPTT_RTS.Checked || chkCATPTT_DTR.Checked ) 
			{
				chkCATBitBangPTT.Enabled = true; 
			}
			else 
			{
				chkCATBitBangPTT.Enabled = false; 
				chkCATBitBangPTT.Checked = false; 
			}
		} 

		// called in error cases to set the dialiog vars from 
		// the console properties -- sort of ugly, we should only have 1 copy 
		// of this stuff 
		public void copyCATPropsToDialogVars() 
		{ 
			chkCATEnable.Checked = console.CATEnabled; 
			udCATPort.Value = console.CATPort; 
			chkCATPTT_RTS.Checked = console.CATPTTRTS;
			chkCATPTT_DTR.Checked = console.CATPTTDTR; 
			chkCATBitBangPTT.Checked = console.PTTBitBangEnabled; 
			udCATBitBangPTTPort.Value = console.PTTBitBangPort; 
			chkCATMixWVirtual.Checked = console.CATisMixWVirtPort; 


			// wjt fixme -- need to hand baudrate, parity, data, stop -- see initCATandPTTprops 
		}


		private void chkCATEnable_CheckedChanged(object sender, System.EventArgs e) 
		{
			// make sure we're not using the same comm port as the bit banger 
			// 
			if ( chkCATEnable.Checked && console.PTTBitBangEnabled && 
				( (int)udCATPort.Value == console.PTTBitBangPort ) )
			{					
				MessageBox.Show("CAT port cannot be the same as Bit Bang Port", "Port Selection Error",
					MessageBoxButtons.OK, MessageBoxIcon.Error);
				chkCATEnable.Checked = false; 
			}
			
			// if enabled, disable changing of serial port 
			bool enable_sub_fields = !chkCATEnable.Checked; 
			udCATPort.Enabled = enable_sub_fields; 
			chkCATMixWVirtual.Enabled = enable_sub_fields; 			
			if ( enable_sub_fields && !chkCATMixWVirtual.Checked ) 
			{ 
				enableCAT_HardwareFields(true); 
			}
			else 
			{
				enableCAT_HardwareFields(false); 
			}

			if ( chkCATEnable.Checked ) 
			{ 
				try 
				{ 
					console.CATEnabled = true; 
				}
				catch ( Exception ex ) 
				{
					console.CATEnabled = false; 
					chkCATEnable.Checked = false; 
					MessageBox.Show("Could not initialize CAT control.  Exception was:\n\n " + ex.Message + 
						"\n\nCAT control has been disabled.", "Error Initializing CAT control", 
						MessageBoxButtons.OK, MessageBoxIcon.Error);
				}
			}
			else 
			{ 
				console.CATEnabled = false; 
			}			
		}

		private void enableCAT_HardwareFields(bool enable) 
		{ 
			comboCATbaud.Enabled = enable;
			comboCATparity.Enabled = enable;
			comboCATdatabits.Enabled = enable;
			comboCATstopbits.Enabled = enable;
		} 

		private void udCATPort_ValueChanged(object sender, System.EventArgs e)
		{
			console.CATPort = (int)udCATPort.Value;		
		}

		private void doEnablementOnBitBangEnable() 
		{
			if ( console.CATPTTRTS || console.CATPTTDTR )  // if RTS or DTR is selectment, enable is ok 
			{
				chkCATBitBangPTT.Enabled = true; 
			}
			else 
			{
				chkCATBitBangPTT.Enabled = false; 
				chkCATBitBangPTT.Checked = false; // make sure it is not checked 
			}				 				    
		}

		private void chkCATPTT_RTS_CheckedChanged(object sender, System.EventArgs e)
		{
			console.CATPTTRTS = chkCATPTT_RTS.Checked; 
			doEnablementOnBitBangEnable(); 
		}

		private void chkCATPTT_DTR_CheckedChanged(object sender, System.EventArgs e)
		{
			console.CATPTTDTR = chkCATPTT_DTR.Checked; 		
			doEnablementOnBitBangEnable(); 
		}

		private void chkCATBitBangPTT_CheckedChanged(object sender, System.EventArgs e)
		{
			bool enable_sub_fields; 

			if ( chkCATBitBangPTT.Checked && console.CATEnabled && 
				(int)udCATBitBangPTTPort.Value == console.CATPort )  
			{
				MessageBox.Show("CAT port cannot be the same as Bit Bang Port", "Port Seelection Error",
					MessageBoxButtons.OK, MessageBoxIcon.Error);
				chkCATBitBangPTT.Checked = false; 
			}

			console.PTTBitBangEnabled = chkCATBitBangPTT.Checked; 	
			if ( chkCATBitBangPTT.Checked ) // if it's enabled don't allow changing settings on port 
			{ 
				enable_sub_fields = false; 
			}
			else 
			{ 
				enable_sub_fields = true; 
			} 
			chkCATPTT_RTS.Enabled = enable_sub_fields; 
			chkCATPTT_DTR.Enabled = enable_sub_fields; 
			udCATBitBangPTTPort.Enabled = enable_sub_fields; 
		}					

		private void udCATBitBangPTTPort_ValueChanged(object sender, System.EventArgs e)
		{
			console.PTTBitBangPort = (int)udCATBitBangPTTPort.Value; 
		}

		private void comboCATparity_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			string selection = comboCATparity.SelectedText; 
			if ( selection != null ) 
			{ 
				SDRSerialPort.Parity p = SDRSerialPort.stringToParity(selection); 
				console.CATParity = p; 
			}			
		}

		private void comboCATbaud_SelectedIndexChanged(object sender, System.EventArgs e)
		{			
			if ( comboCATbaud.SelectedIndex >= 0 ) 
				console.CATBaudRate =  Int32.Parse(comboCATbaud.Text); 			
		}

		private void comboCATdatabits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if ( comboCATdatabits.SelectedIndex >= 0 )
				console.CATDataBits = SDRSerialPort.stringToDataBits(comboCATdatabits.Text); 
		}

		private void comboCATstopbits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if ( comboCATstopbits.SelectedIndex >= 0 ) 
				console.CATStopBits = SDRSerialPort.stringToStopBits(comboCATstopbits.Text); 
		}

		private void chkCATMixWVirtual_CheckedChanged(object sender, System.EventArgs e)
		{
			console.CATisMixWVirtPort = chkCATMixWVirtual.Checked;
			if ( chkCATMixWVirtual.Checked ) // if mixw virt is on, no hardware settings 
			{
				enableCAT_HardwareFields(false); 
			}			
			else 
			{ 
				enableCAT_HardwareFields(true); 
			}		
		}

		#endregion

		#region Test Tab Event Handlers

		private void chkTestIMD_CheckedChanged(object sender, System.EventArgs e)
		{
			if(chkTestIMD.Checked)
			{
				if(!console.PowerOn)
				{
					MessageBox.Show("Power must be on to run this test.",
						"Power is off",
						MessageBoxButtons.OK,
						MessageBoxIcon.Hand);
					chkTestIMD.Checked = false;
					return;
				}
				console.PreviousPWR = console.PWR;
				console.PWR = (int)udTestIMDPower.Value;
				console.MOX = true;
				if(!console.MOX)
				{
					chkTestIMD.Checked = false;
					return;
				}

				chkTestIMD.BackColor = console.ButtonSelectedColor;
				Audio.SineFreq1 = (double)udTestIMDFreq1.Value;
				Audio.SineFreq2 = (double)udTestIMDFreq2.Value;
				Audio.two_tone = true;
				Audio.CurrentAudioState1 = Audio.AudioState.SINL_COSR;
			}
			else
			{
				udTestIMDPower.Value = console.PWR;
				console.PWR = console.PreviousPWR;
				Audio.CurrentAudioState1 = Audio.AudioState.DTTSP;
				console.MOX = false;
				Audio.SineFreq1 = (double)udDSPCWPitch.Value;
				Audio.two_tone = false;
				chkTestIMD.BackColor = SystemColors.Control;
			}
		}

		private void chkTestX2_CheckedChanged(object sender, System.EventArgs e)
		{
			int val = 0;
			if(chkTestX2Pin1.Checked) val += 1<<0;
			if(chkTestX2Pin2.Checked) val += 1<<1;
			if(chkTestX2Pin3.Checked) val += 1<<2;
			if(chkTestX2Pin4.Checked) val += 1<<3;
			if(chkTestX2Pin5.Checked) val += 1<<4;
			if(chkTestX2Pin6.Checked) val += 1<<5;

			console.hw.X2 = val;
		}

		private void comboAudioDetailSel_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			bool card1 = (comboAudioDetailSel.SelectedIndex == 0);
			grpAudioDetails1.Visible = card1;
			grpAudioDetails2.Visible = !card1;
			comboAudioSoundCard.Enabled = card1;
		}

		private void btnTestAudioBalStart_Click(object sender, System.EventArgs e)
		{
			if(!console.PowerOn)
			{
				MessageBox.Show("Power must be on to run this test.",
					"Power is off",
					MessageBoxButtons.OK,
					MessageBoxIcon.Hand);
				return;
			}

			DialogResult dr = MessageBox.Show("Is the SDR-1000 hardware powered off?\n"+
				"Failure to turn off the hardware power could result in damage to the unit while running this test.",
				"SDR-1000 Powered Off?",
				MessageBoxButtons.YesNo,
				MessageBoxIcon.Warning);
			
			if(dr == DialogResult.No)
				return;

			dr = DialogResult.No;
			Audio.two_tone = false;
			Audio.SineFreq1 = 600.0;

			do
			{
				Audio.CurrentAudioState1 = Audio.AudioState.SINL_NOR;
				dr = MessageBox.Show("Do you hear a tone in the left channel?",
					"Tone in left channel?",
					MessageBoxButtons.YesNoCancel,
					MessageBoxIcon.Question);

				Audio.CurrentAudioState1 = Audio.AudioState.DTTSP;

				if(dr == DialogResult.No)
				{
					DialogResult dr2 = MessageBox.Show("Please double check cable and speaker connections.\n"+
						"Click OK to try again (cancel to abort).",
						"Check connections",
						MessageBoxButtons.OKCancel,
						MessageBoxIcon.Asterisk);
					if(dr2 == DialogResult.Cancel)
					{
						MessageBox.Show("Test Failed",
							"Failed",
							MessageBoxButtons.OK,
							MessageBoxIcon.Stop);
						btnTestAudioBalStart.BackColor = Color.Red;
						return;
					}
				}
				else if(dr == DialogResult.Cancel)
				{
					MessageBox.Show("Test Failed",
						"Failed",
						MessageBoxButtons.OK,
						MessageBoxIcon.Stop);
					btnTestAudioBalStart.BackColor = Color.Red;
					return;
				}
			} while(dr != DialogResult.Yes);

			do
			{
				Audio.CurrentAudioState1 = Audio.AudioState.NOL_SINR;
				dr = MessageBox.Show("Do you hear a tone in the right channel?",
					"Tone in right channel?",
					MessageBoxButtons.YesNoCancel,
					MessageBoxIcon.Question);

				Audio.CurrentAudioState1 = Audio.AudioState.DTTSP;

				if(dr == DialogResult.No)
				{
					DialogResult dr2 = MessageBox.Show("Please double check cable and speaker connections.\n"+
						"Click OK to try again (cancel to abort).",
						"Check connections",
						MessageBoxButtons.OKCancel,
						MessageBoxIcon.Asterisk);
					if(dr2 == DialogResult.Cancel)
					{
						MessageBox.Show("Test Failed",
							"Failed",
							MessageBoxButtons.OK,
							MessageBoxIcon.Stop);
						btnTestAudioBalStart.BackColor = Color.Red;
						return;
					}
				}
				else if(dr == DialogResult.Cancel)
				{
					MessageBox.Show("Test Failed",
						"Failed",
						MessageBoxButtons.OK,
						MessageBoxIcon.Stop);
					btnTestAudioBalStart.BackColor = Color.Red;
					return;
				}
			} while(dr != DialogResult.Yes);

			MessageBox.Show("Test was successful.",
				"Success",
				MessageBoxButtons.OK,
				MessageBoxIcon.Information);

			btnTestAudioBalStart.BackColor = Color.Green;
		}

		#endregion

		#region Other Event Handlers
		// ======================================================
		// Display Tab Event Handlers
		// ======================================================

		private void btnResetAll_Click(object sender, System.EventArgs e)
		{
			DialogResult dr = MessageBox.Show("This will reset all the settings in the Setup form to their \n" +
				"default values.  Are you sure you want to do this?",
				"Warning: Complete Setup Reset?",
				MessageBoxButtons.YesNo,
				MessageBoxIcon.Warning);
			if(dr == DialogResult.No)
				return;

			if(console.PowerOn)
				console.PowerOn = false;

			// general tab
			//comboGeneralLPTAddr.Text = "378";
			udGeneralLPTDelay.Value = 0;
			//chkGeneralRXOnly.Checked = false;
			//chkGeneralUSBPresent.Checked = false;
			//chkGeneralRFEPresent.Checked = true;
			//chkGeneralXVTRPresent.Checked = false;
			//chkGeneralPAPresent.Checked = false;
			//chkGeneralATUPresent.Checked = false;
			chkGeneralSpurRed.Checked = true;
			chkGeneralDisablePTT.Checked = false;
			udDDSCorrection.Value = 0;
			udDDSPLLMult.Value = 1;
			udDDSIFFreq.Value = 11025;
			udGeneralCalFreq.Value = 7;
			udGeneralCalLevel.Value = -70;
			chkGeneralSoftwareGainCorr.Checked = false;
			chkGeneralEnableX2.Checked = false;
			udGeneralX2Delay.Value = 500;
			comboGeneralProcessPriority.Text = "Normal";
			chkGeneralUpdateRelease.Checked = true;
			chkGeneralUpdateBeta.Checked = true;
            
			// audio tab
			comboAudioSoundCard.SelectedIndex = 0;
			//			if(comboAudioDriver.Items.Count > 2)
			//				comboAudioDriver.SelectedIndex = 2;
			//			else comboAudioDriver.SelectedIndex = 0;
			//			comboAudioInput.SelectedIndex = 0;
			//			comboAudioOutput.SelectedIndex = 0;
			//			comboAudioBufferSamples.SelectedIndex = 2;
			udAudioLatency1.Value = 120;
			chkAudioLatencyManual.Checked = false;

			// display tab
			udDisplayGridMax.Value		= 0;
			udDisplayGridMin.Value		= -150;
			udDisplayGridStep.Value		= 10;
			udDisplayFPS.Value			= 15;
			udDisplayMeterDelay.Value	= 100;
			udDisplayPeakText.Value		= 500;
			udDisplayCPUMeter.Value		= 1000;
			udDisplayPhasePts.Value		= 100;
			udDisplayAVGTime.Value		= 350;	
			udDisplayWaterfallLowLevel.Value = -130;
			udDisplayWaterfallHighLevel.Value = -80;
			clrbtnWaterfallLow.Color = Color.Blue;
			clrbtnWaterfallMid.Color = Color.Red;
			clrbtnWaterfallHigh.Color = Color.Yellow;
			udDisplayMultiPeakHoldTime.Value = 1000;
			udDisplayMultiTextHoldTime.Value = 500;

			// dsp tab
			udLMSANFtaps.Value = 65;
			udLMSANFdelay.Value = 50;
			udLMSANFgain.Value = 50;
			udLMSNRtaps.Value = 65;
			udLMSNRdelay.Value = 50;
			udLMSNRgain.Value = 50;
			udDSPAGCFixedGaindB.Value = 20;
			udDSPAGCMaxGaindB.Value = 68;
			udDSPNB.Value = 20;
			udDSPMNB.Value = 15;
			udDSPCWPitch.Value = 600;
			udDSPImagePhaseRX.Value = 0;
			udDSPImageGainRX.Value = 0;
			udDSPImagePhaseTX.Value = 0;
			udDSPImageGainTX.Value = 0;
			comboDSPWindow.SelectedIndex = (int)DttSP.Window.HANNING;

			// transmit tab
			udTXFilterHigh.Value = 3000;
			udTXFilterLow.Value = 300;
			udTXFFCompression.Value = 3;
			tbTXEQ80.Value = 0;
			tbTXEQ160.Value = 0;
			tbTXEQ300.Value = 0;
			tbTXEQ600.Value = 0;
			tbTXEQ1000.Value = 0;
			tbTXEQ1300.Value = 0;
			tbTXEQ1600.Value = 0;
			tbTXEQ2000.Value = 0;
			tbTXEQ2300.Value = 0;
			tbTXEQ2600.Value = 0;
			tbTXEQ3000.Value = 0;
			tbTXEQ3500.Value = 0;
			tbTXEQ_Scroll(this, EventArgs.Empty);

			// pa settings tab
			udPAGain160.Value = 49.0M;
			udPAGain80.Value = 48.0M;
			udPAGain60.Value = 47.4M;
			udPAGain40.Value = 46.9M;
			udPAGain30.Value = 48.9M;
			udPAGain20.Value = 48.3M;
			udPAGain17.Value = 49.3M;
			udPAGain15.Value = 48.1M;
			udPAGain12.Value = 47.4M;
			udPAGain10.Value = 43.0M;
			udAudioVoltage1.Value = 2.23M;
			udPAADC160.Value = 107;
			udPAADC80.Value = 107;
			udPAADC60.Value = 107;
			udPAADC40.Value = 106;
			udPAADC30.Value = 108;
			udPAADC20.Value = 108;
			udPAADC17.Value = 108;
			udPAADC15.Value = 108;
			udPAADC12.Value = 110;
			udPAADC10.Value = 111;

			// keyboard tab
			comboKBTuneUp1.Text		= "q";
			comboKBTuneUp2.Text		= "w";
			comboKBTuneUp3.Text		= "e";
			comboKBTuneUp4.Text		= "r";
			comboKBTuneUp5.Text		= "t";
			comboKBTuneUp6.Text		= "y";
			comboKBTuneUp7.Text		= "u";
			comboKBTuneDown1.Text	= "a";
			comboKBTuneDown2.Text	= "s";
			comboKBTuneDown3.Text	= "d";
			comboKBTuneDown4.Text	= "f";
			comboKBTuneDown5.Text	= "g";
			comboKBTuneDown6.Text	= "h";
			comboKBTuneDown7.Text	= "j";
			comboKBBandUp.Text		= "m";
			comboKBBandDown.Text	= "n";
			comboKBFilterUp.Text	= "b";
			comboKBFilterDown.Text	= "v";
			comboKBModeUp.Text		= "x";
			comboKBModeDown.Text	= "z";
			comboKBRITUp.Text		= "o";
			comboKBRITDown.Text		= "i";
			comboKBXITUp.Text		= "[";
			comboKBXITDown.Text		= "p";

			// appearance tab
			clrbtnBtnSel.Color			= Color.Yellow;
			clrbtnVFODark.Color			= Color.Olive;
			clrbtnVFOLight.Color		= Color.Yellow;
			clrbtnBandDark.Color		= Color.Green;
			clrbtnBandLight.Color		= Color.Lime;
			clrbtnPeakText.Color		= Color.DodgerBlue;
			clrbtnBackground.Color		= Color.Black;
			clrbtnGrid.Color			= Color.Purple;
			clrbtnZeroLine.Color		= Color.Red;
			clrbtnText.Color			= Color.Yellow;
			clrbtnDataLine.Color		= Color.LightGreen;
			clrbtnFilter.Color			= Color.Green;
			udDisplayLineWidth.Value	= 1;
			clrbtnMeterLeft.Color		= Color.Green;
			clrbtnMeterRight.Color		= Color.Lime;
			clrbtnVFODark.Color			= Color.Olive;
			clrbtnVFOLight.Color		= Color.Yellow;
			clrbtnBandDark.Color		= Color.Green;
			clrbtnBandLight.Color		= Color.Lime;
			clrbtnPeakText.Color		= Color.DodgerBlue;

			// tests tab
			udTestIMDFreq1.Value = 700;
			udTestIMDFreq2.Value = 1900;
			udTestIMDPower.Value = 50;
		}

		private void btnWizard_Click(object sender, System.EventArgs e)
		{
			SetupWizard w = new SetupWizard(console, SoundCardIndex);
			w.Show();
			w.Focus();
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			SaveOptions();
			this.Hide();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			GetOptions();
			this.Hide();
		}

		private void btnApply_Click(object sender, System.EventArgs e)
		{
			SaveOptions();
			DB.Exit();
		}

		private void udGeneralLPTDelay_ValueChanged(object sender, System.EventArgs e)
		{
			console.LatchDelay = (int)udGeneralLPTDelay.Value;
		}

		private void Setup_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			this.Hide();
			e.Cancel = true;
		}

		private void btnImportDB_Click(object sender, System.EventArgs e)
		{
			openFileDialog1.InitialDirectory = Application.StartupPath;
			openFileDialog1.ShowDialog();
		}

		private void openFileDialog1_FileOk(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if(DB.ImportDatabase(openFileDialog1.FileName))
				MessageBox.Show("Database Imported Successfully");

			GetOptions();					// load all database values
			console.GetState();				
			console.CWForm.GetCWOptions();

			SaveOptions();					// save all database values
			console.SaveState();
			console.CWForm.SaveCWOptions();

			udTransmitTunePower_ValueChanged(this, EventArgs.Empty);
		}

		private void udDSPMNB_ValueChanged(object sender, System.EventArgs e)
		{
			DttSP.ChangeSDROMvals(0.165*(double)(udDSPMNB.Value));
		}

		#endregion				

		private void chkDCBlock_CheckedChanged(object sender, System.EventArgs e)
		{
			if(chkDCBlock.Checked)
				DttSP.ChangeDCBlock(1);
			else DttSP.ChangeDCBlock(0);

		}
		
		private void checkBoxKB9YIG_NoDDS_CheckedChanged(object sender, System.EventArgs e)
		{

			double fixed_freq_in_mhz = 0.0; 
			if ( checkBoxKB9YIG_NoDDS.Checked ) // turn on fix freq mode -- 1st see if we have a valid freq 
			{ 				
				try 
				{ 
					fixed_freq_in_mhz =  double.Parse(textFixedOscFreq.Text); 
				}
				catch ( Exception ex ) 
				{ 
					System.Console.WriteLine("caught: " + ex); 
					 MessageBox.Show("A valid freq must be entered to enter this mode.", "Error",
						MessageBoxButtons.OK,
						MessageBoxIcon.Error);
					checkBoxKB9YIG_NoDDS.Checked = false; 						
				} 
			}
			if ( checkBoxKB9YIG_NoDDS.Checked && fixed_freq_in_mhz != 0.0 )  // ok we have looking freq 
			{ 
				if ( chkLeftOnly.Checked ) 
				{ 
					DttSP.ChangePosition(0.0); // signals all on left channel - hack for Tony's board, should be a seperate setting 
				}
				console.RXOnly = checkBoxKB9YIG_NoDDS.Checked;
				console.FixedHWFreq = fixed_freq_in_mhz; 
				textFixedOscFreq.Enabled = false; 
				chkLeftOnly.Enabled = false;
			}
			else  // we're not doing the fixed freq thing 
			{
				console.FixedHWFreq = 0.0; 
				DttSP.ChangePosition(0.5); 
				textFixedOscFreq.Enabled = true; 
				chkLeftOnly.Enabled = true; 
			}						
		}

		private void dbgBox_TextChanged(object sender, System.EventArgs e)
		{
		
		}

		private void dbgCopy_Click(object sender, System.EventArgs e)
		{
			dbgBox.SelectAll(); 
			dbgBox.Copy(); 
			dbgBox.Select(0,0); // clear selection 
		}

		private void dbgClear_Click(object sender, System.EventArgs e)
		{
			dbgBox.Clear(); 
		}

		private void chkLeftOnly_CheckedChanged(object sender, System.EventArgs e)
		{
		
		}
	} 
}
